/*
 * Decompiled with CFR 0.152.
 */
package org.encog.engine.opencl.kernels;

import org.encog.engine.opencl.EncogCLDevice;
import org.encog.engine.opencl.EncogCLQueue;
import org.encog.engine.opencl.kernels.EncogKernel;
import org.jocl.cl_mem;

public class KernelVectorAdd
extends EncogKernel {
    private final float[] arrayA;
    private final float[] arrayB;
    private final float[] targetArray;
    private final cl_mem bufferArrayA;
    private final cl_mem bufferArrayB;
    private final cl_mem bufferTargetArray;

    public KernelVectorAdd(EncogCLDevice encogCLDevice, int n) {
        super(encogCLDevice, "org/encog/engine/resources/KernelVectorAdd.txt", "VectorAdd");
        this.arrayA = new float[n];
        this.arrayB = new float[n];
        this.targetArray = new float[n];
        this.bufferArrayA = this.createArrayReadOnly(this.arrayA);
        this.bufferArrayB = this.createArrayReadOnly(this.arrayB);
        this.bufferTargetArray = this.createFloatArrayWriteOnly(this.targetArray.length);
        this.setGlobalWork(n);
        this.setLocalWork(1);
    }

    public double[] add(EncogCLDevice encogCLDevice, double[] dArray, double[] dArray2) {
        for (int i = 0; i < dArray.length; ++i) {
            this.arrayA[i] = (float)dArray[i];
            this.arrayB[i] = (float)dArray2[i];
        }
        this.setArg(0, this.bufferArrayA);
        this.setArg(1, this.bufferArrayB);
        this.setArg(2, this.bufferTargetArray);
        EncogCLQueue encogCLQueue = this.getDevice().getQueue();
        encogCLQueue.array2Buffer(this.arrayA, this.bufferArrayA);
        encogCLQueue.array2Buffer(this.arrayB, this.bufferArrayB);
        encogCLQueue.execute(this);
        encogCLQueue.buffer2Array(this.bufferTargetArray, this.targetArray);
        double[] dArray3 = new double[this.targetArray.length];
        for (int i = 0; i < this.targetArray.length; ++i) {
            dArray3[i] = this.targetArray[i];
        }
        return dArray3;
    }
}

