/*
 * Decompiled with CFR 0.152.
 */
package org.encog.engine.data;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.encog.engine.data.BasicEngineData;
import org.encog.engine.data.EngineData;
import org.encog.engine.data.EngineIndexableSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasicEngineDataSet
implements Serializable,
EngineIndexableSet {
    private static final long serialVersionUID = -2279722928570071183L;
    private List<EngineData> data = new ArrayList<EngineData>();

    public BasicEngineDataSet() {
    }

    public BasicEngineDataSet(double[][] dArray, double[][] dArray2) {
        if (dArray2 != null) {
            for (int i = 0; i < dArray.length; ++i) {
                double[] dArray3 = dArray[i];
                double[] dArray4 = dArray2[i];
                this.add(dArray3, dArray4);
            }
        } else {
            double[][] dArray5 = dArray;
            int n = dArray5.length;
            for (int i = 0; i < n; ++i) {
                double[] dArray6;
                double[] dArray7 = dArray6 = dArray5[i];
                this.add(dArray7);
            }
        }
    }

    public BasicEngineDataSet(List<EngineData> list) {
        this.data = list;
    }

    public void add(double[] dArray) {
        this.data.add(new BasicEngineData(dArray));
    }

    public void add(double[] dArray, double[] dArray2) {
        BasicEngineData basicEngineData = new BasicEngineData(dArray, dArray2);
        this.data.add(basicEngineData);
    }

    public void add(EngineData engineData) {
        this.data.add(engineData);
    }

    public List<EngineData> getData() {
        return this.data;
    }

    @Override
    public int getIdealSize() {
        if (this.data.isEmpty()) {
            return 0;
        }
        EngineData engineData = this.data.get(0);
        if (engineData.getIdealArray() == null) {
            return 0;
        }
        return engineData.getIdealArray().length;
    }

    @Override
    public int getInputSize() {
        if (this.data.isEmpty()) {
            return 0;
        }
        EngineData engineData = this.data.get(0);
        return engineData.getInputArray().length;
    }

    @Override
    public void getRecord(long l, EngineData engineData) {
        EngineData engineData2 = this.data.get((int)l);
        engineData.setInputArray(engineData2.getInputArray());
        if (engineData.getIdealArray() != null) {
            engineData.setIdealArray(engineData2.getIdealArray());
        }
    }

    @Override
    public long getRecordCount() {
        return this.data.size();
    }

    @Override
    public boolean isSupervised() {
        if (this.data.size() == 0) {
            return false;
        }
        return this.data.get(0).isSupervised();
    }

    @Override
    public EngineIndexableSet openAdditional() {
        return new BasicEngineDataSet(this.data);
    }

    public void setData(List<EngineData> list) {
        this.data = list;
    }
}

