/*
 * Decompiled with CFR 0.152.
 */
package org.encog.engine.concurrency.calc;

import java.util.ArrayList;
import java.util.List;
import org.encog.engine.EncogEngine;
import org.encog.engine.concurrency.calc.CalcOpenCLDevice;
import org.encog.engine.concurrency.calc.CalculationResult;
import org.encog.engine.data.EngineIndexableSet;
import org.encog.engine.network.flat.FlatNetwork;
import org.encog.engine.opencl.EncogCLDevice;

public final class ConcurrentCalculate {
    private static ConcurrentCalculate instance;
    private FlatNetwork network;
    private EngineIndexableSet trainingData;
    private final List<CalcOpenCLDevice> devices = new ArrayList<CalcOpenCLDevice>();
    private boolean useOpenCL;

    public static ConcurrentCalculate getInstance() {
        if (instance == null) {
            instance = new ConcurrentCalculate();
        }
        return instance;
    }

    private ConcurrentCalculate() {
    }

    public double calculateError() {
        if (this.useOpenCL) {
            for (CalcOpenCLDevice calcOpenCLDevice : this.devices) {
                CalculationResult calculationResult = calcOpenCLDevice.calculateError();
                if (!calculationResult.isExecuted()) continue;
                return calculationResult.getError();
            }
        }
        return this.network.calculateError(this.trainingData);
    }

    public FlatNetwork getNetwork() {
        return this.network;
    }

    public EngineIndexableSet getTrainingData() {
        return this.trainingData;
    }

    public void initCL() {
        this.devices.clear();
        for (EncogCLDevice encogCLDevice : EncogEngine.getInstance().getCL().getEnabledDevices()) {
            CalcOpenCLDevice calcOpenCLDevice = new CalcOpenCLDevice(encogCLDevice, this);
            this.devices.add(calcOpenCLDevice);
            if (this.network != null) {
                calcOpenCLDevice.setNetwork(this.network);
            }
            if (this.trainingData == null) continue;
            calcOpenCLDevice.setTraining(this.trainingData);
        }
        this.useOpenCL = true;
    }

    public boolean isUseOpenCL() {
        return this.useOpenCL;
    }

    public void setNetwork(FlatNetwork flatNetwork) {
        this.network = flatNetwork;
        for (CalcOpenCLDevice calcOpenCLDevice : this.devices) {
            calcOpenCLDevice.setTraining(this.trainingData);
        }
    }

    public void setTrainingData(EngineIndexableSet engineIndexableSet) {
        this.trainingData = engineIndexableSet;
        for (CalcOpenCLDevice calcOpenCLDevice : this.devices) {
            calcOpenCLDevice.setTraining(engineIndexableSet);
        }
    }

    public void setUseOpenCL(boolean bl) {
        this.useOpenCL = bl;
    }
}

