/*
 * Decompiled with CFR 0.152.
 */
package optas.tools;

import com.keypoint.PngEncoder;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.Toolkit;
import java.awt.event.ActionListener;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.print.Printable;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;
import org.apache.xmlgraphics.java2d.GraphicContext;
import org.apache.xmlgraphics.java2d.ps.EPSDocumentGraphics2D;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.annotations.XYTitleAnnotation;
import org.jfree.chart.event.ChartChangeListener;
import org.jfree.chart.event.ChartProgressListener;
import org.jfree.chart.event.OverlayChangeListener;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.title.LegendTitle;
import org.jfree.ui.ExtensionFileFilter;
import org.jfree.ui.RectangleInsets;

public class PatchedChartPanel
extends ChartPanel
implements ChartChangeListener,
ChartProgressListener,
ActionListener,
MouseListener,
MouseMotionListener,
OverlayChangeListener,
Printable,
Serializable {
    public static final int DEFAULT_DPI = 300;

    public PatchedChartPanel(JFreeChart chart) {
        super(chart);
    }

    public PatchedChartPanel(JFreeChart chart, boolean useBuffer) {
        super(chart, useBuffer);
    }

    public PatchedChartPanel(JFreeChart chart, boolean properties, boolean save, boolean print, boolean zoom, boolean tooltips) {
        super(chart, properties, save, print, zoom, tooltips);
    }

    public PatchedChartPanel(JFreeChart chart, int width, int height, int minimumDrawWidth, int minimumDrawHeight, int maximumDrawWidth, int maximumDrawHeight, boolean useBuffer, boolean properties, boolean save, boolean print, boolean zoom, boolean tooltips) {
        super(chart, width, height, minimumDrawWidth, minimumDrawHeight, maximumDrawWidth, maximumDrawHeight, useBuffer, properties, true, save, print, zoom, tooltips);
    }

    public PatchedChartPanel(JFreeChart chart, int width, int height, int minimumDrawWidth, int minimumDrawHeight, int maximumDrawWidth, int maximumDrawHeight, boolean useBuffer, boolean properties, boolean copy, boolean save, boolean print, boolean zoom, boolean tooltips) {
        super(chart, width, height, minimumDrawWidth, minimumDrawHeight, maximumDrawWidth, maximumDrawHeight, useBuffer, properties, copy, save, print, zoom, tooltips);
    }

    public void doSaveAs() throws IOException {
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.setCurrentDirectory(this.getDefaultDirectoryForSaveAs());
        ExtensionFileFilter filterPng = new ExtensionFileFilter(localizationResources.getString("PNG_Image_Files"), ".png");
        ExtensionFileFilter filterEps = new ExtensionFileFilter("EPS Image Files", ".eps");
        fileChooser.addChoosableFileFilter((FileFilter)filterPng);
        fileChooser.addChoosableFileFilter((FileFilter)filterEps);
        int option = fileChooser.showSaveDialog((Component)((Object)this));
        if (option == 0) {
            String filename = fileChooser.getSelectedFile().getPath();
            if (this.isEnforceFileExtensions()) {
                if (fileChooser.getFileFilter() == filterPng) {
                    if (!filename.endsWith(".png")) {
                        filename = filename + ".png";
                    }
                } else if (fileChooser.getFileFilter() == filterPng && !filename.endsWith(".eps")) {
                    filename = filename + ".eps";
                }
            }
            String results = JOptionPane.showInputDialog("specify width, height of image", (Object)(this.getWidth() + "," + this.getHeight()));
            String[] result = results.split(",");
            int width = 0;
            int height = 0;
            if (result.length == 2) {
                try {
                    width = Integer.parseInt(result[0]);
                    height = Integer.parseInt(result[1]);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (fileChooser.getFileFilter() == filterPng) {
                BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(new File(filename)));
                PngEncoder encoder = null;
                encoder = width == 0 || height == 0 ? new PngEncoder((Image)this.getHighResChartImage(300), false, 0, 9) : new PngEncoder((Image)this.getHighResChartImage(width, height), false, 0, 9);
                encoder.setDpi(300, 300);
                byte[] pngData = encoder.pngEncode();
                ((OutputStream)out).write(pngData);
                ((OutputStream)out).close();
            } else {
                try {
                    FileOutputStream out = new FileOutputStream(new File(filename));
                    EPSDocumentGraphics2D g2d = new EPSDocumentGraphics2D(false);
                    g2d.setGraphicContext(new GraphicContext());
                    g2d.setupDocument((OutputStream)out, width, height);
                    this.getChart().draw((Graphics2D)g2d, (Rectangle2D)new Rectangle(width, height));
                    g2d.finish();
                    out.flush();
                    ((OutputStream)out).close();
                }
                catch (IOException fnfe) {
                    fnfe.printStackTrace();
                }
            }
        }
    }

    private BufferedImage getHighResChartImage() {
        return this.getHighResChartImage(300);
    }

    private BufferedImage getHighResChartImage(int resolution) {
        int screenResolution = Toolkit.getDefaultToolkit().getScreenResolution();
        double scaleRatio = resolution / screenResolution;
        int rasterWidth = (int)((double)this.getWidth() * scaleRatio);
        int rasterHeight = (int)((double)this.getHeight() * scaleRatio);
        BufferedImage image = new BufferedImage(rasterWidth, rasterHeight, 1);
        Graphics2D g2 = image.createGraphics();
        g2.transform(AffineTransform.getScaleInstance(scaleRatio, scaleRatio));
        this.getChart().draw(g2, (Rectangle2D)new Rectangle2D.Double(0.0, 0.0, this.getWidth(), this.getHeight()), null);
        g2.dispose();
        return image;
    }

    private BufferedImage getHighResChartImage(int rasterWidth, int rasterHeight) {
        BufferedImage image = new BufferedImage(rasterWidth, rasterHeight, 1);
        Graphics2D g2 = image.createGraphics();
        float scaleFactor = (float)Math.max((double)rasterWidth / (double)this.getWidth(), (double)rasterHeight / (double)this.getHeight());
        g2.transform(AffineTransform.getScaleInstance((double)rasterWidth / (double)this.getWidth(), (double)rasterHeight / (double)this.getHeight()));
        if (this.getChart().getPlot() instanceof XYPlot) {
            XYPlot p = this.getChart().getXYPlot();
            Font f1 = p.getDomainAxis().getTickLabelFont();
            Font f2 = p.getRangeAxis().getTickLabelFont();
            Font f3 = p.getDomainAxis().getLabelFont();
            Font f4 = p.getRangeAxis().getLabelFont();
            Font f5 = null;
            if (this.getChart().getLegend() != null) {
                f5 = this.getChart().getLegend().getItemFont();
            }
            Font f6 = this.getChart().getTitle().getFont();
            BasicStroke stroke1 = null;
            BasicStroke stroke2 = null;
            BasicStroke stroke3 = null;
            BasicStroke stroke4 = null;
            if (p.getDomainGridlineStroke() instanceof BasicStroke) {
                stroke1 = (BasicStroke)p.getDomainGridlineStroke();
                this.getChart().getXYPlot().setDomainGridlineStroke((Stroke)new BasicStroke(stroke1.getLineWidth() * scaleFactor));
            }
            if (p.getDomainMinorGridlineStroke() instanceof BasicStroke) {
                stroke3 = (BasicStroke)p.getDomainMinorGridlineStroke();
                p.setDomainMinorGridlineStroke((Stroke)new BasicStroke(stroke3.getLineWidth() * scaleFactor));
            }
            if (p.getRangeGridlineStroke() instanceof BasicStroke) {
                stroke2 = (BasicStroke)p.getRangeGridlineStroke();
                p.setRangeGridlineStroke((Stroke)new BasicStroke(stroke2.getLineWidth() * scaleFactor));
            }
            if (p.getRangeGridlineStroke() instanceof BasicStroke) {
                stroke4 = (BasicStroke)p.getRangeMinorGridlineStroke();
                p.setRangeMinorGridlineStroke((Stroke)new BasicStroke(stroke4.getLineWidth() * scaleFactor));
            }
            ArrayList<BasicStroke> list = new ArrayList<BasicStroke>();
            for (int i = 0; i < p.getDatasetCount(); ++i) {
                XYItemRenderer r = p.getRendererForDataset(p.getDataset(i));
                if (r == null) continue;
                for (int j = 0; j < p.getDataset(i).getSeriesCount(); ++j) {
                    if (!(r.getSeriesStroke(j) instanceof BasicStroke)) continue;
                    BasicStroke s = (BasicStroke)r.getSeriesStroke(j);
                    r.setSeriesStroke(j, (Stroke)new BasicStroke(s.getLineWidth() * scaleFactor));
                    list.add(s);
                }
            }
            for (Object o : p.getAnnotations()) {
                XYTitleAnnotation annotation;
                if (!(o instanceof XYTitleAnnotation) || !((annotation = (XYTitleAnnotation)o).getTitle() instanceof LegendTitle)) continue;
                LegendTitle l = (LegendTitle)annotation.getTitle();
                Font f = l.getItemFont();
                l.setItemFont(f.deriveFont((float)f1.getSize() * scaleFactor));
                RectangleInsets insets = l.getItemLabelPadding();
                l.setItemLabelPadding(new RectangleInsets(2.0 * insets.getTop() * (double)scaleFactor, 2.0 * insets.getLeft() * (double)scaleFactor, 2.0 * insets.getBottom() * (double)scaleFactor, 2.0 * insets.getRight() * (double)scaleFactor));
            }
            p.getDomainAxis().setTickLabelFont(f1.deriveFont((float)f1.getSize() * scaleFactor));
            p.getRangeAxis().setTickLabelFont(f2.deriveFont((float)f2.getSize() * scaleFactor));
            p.getDomainAxis().setLabelFont(f3.deriveFont((float)f3.getSize() * scaleFactor));
            p.getRangeAxis().setLabelFont(f4.deriveFont((float)f4.getSize() * scaleFactor));
            if (f5 != null) {
                this.getChart().getLegend().setItemFont(f5.deriveFont((float)f5.getSize() * scaleFactor));
            }
            this.getChart().setBackgroundPaint((Paint)Color.white);
            RectangleInsets insets = null;
            if (this.getChart().getLegend() != null) {
                insets = this.getChart().getLegend().getItemLabelPadding();
                this.getChart().getLegend().setItemLabelPadding(new RectangleInsets(2.0 * insets.getTop() * (double)scaleFactor, 2.0 * insets.getLeft() * (double)scaleFactor, 2.0 * insets.getBottom() * (double)scaleFactor, 2.0 * insets.getRight() * (double)scaleFactor));
            }
            this.getChart().getTitle().setFont(f6.deriveFont((float)f6.getSize() * scaleFactor));
            BufferedImage img = this.getChart().createBufferedImage(rasterWidth, rasterHeight);
            this.getChart().getXYPlot().getDomainAxis().setTickLabelFont(f1);
            this.getChart().getXYPlot().getRangeAxis().setTickLabelFont(f2);
            this.getChart().getXYPlot().getDomainAxis().setLabelFont(f3);
            this.getChart().getXYPlot().getRangeAxis().setLabelFont(f4);
            if (f5 != null) {
                this.getChart().getLegend().setItemFont(f5);
            }
            this.getChart().getTitle().setFont(f6);
            if (insets != null) {
                this.getChart().getLegend().setItemLabelPadding(insets);
            }
            int counter = 0;
            for (int i = 0; i < p.getDatasetCount(); ++i) {
                XYItemRenderer r = p.getRendererForDataset(p.getDataset(i));
                if (r == null) continue;
                for (int j = 0; j < p.getDataset(i).getSeriesCount(); ++j) {
                    if (!(r.getSeriesStroke(j) instanceof BasicStroke)) continue;
                    r.setSeriesStroke(j, (Stroke)list.get(counter++));
                }
            }
            if (stroke1 != null) {
                this.getChart().getXYPlot().setDomainGridlineStroke((Stroke)stroke1);
            }
            if (stroke2 != null) {
                this.getChart().getXYPlot().setDomainMinorGridlineStroke((Stroke)stroke2);
            }
            if (stroke3 != null) {
                this.getChart().getXYPlot().setRangeGridlineStroke((Stroke)stroke3);
            }
            if (stroke4 != null) {
                this.getChart().getXYPlot().setRangeMinorGridlineStroke((Stroke)stroke4);
            }
            return img;
        }
        BufferedImage img = this.getChart().createBufferedImage(rasterWidth, rasterHeight);
        return img;
    }
}

