/*
 * Decompiled with CFR 0.152.
 */
package optas.test;

public class HymodVrugt {
    public double precip;
    public double pet;
    public double cmax;
    public double bexp;
    public double alpha;
    public double nq;
    public double kq;
    public double ks;
    public double xcuz;
    public double xq;
    public double xs;
    public double mxhuz;
    public double mxcuz;
    public double[] mxq;
    public double mxs;
    public double met;
    public double mov;
    public double mqq;
    public double mqs;
    public double mq;
    final int indexUT1 = 0;
    final int indexUT2 = 1;
    final int indexXn = 2;
    final int indexXslow = 0;
    final int indexOutflow = 1;
    double x_loss = 0.0;
    double x_slow = 0.0;
    double[] x_quick = null;
    double convFactor = 22.3;
    double outflow = 0.0;
    int n = 0;

    public void init() {
        this.x_loss = 0.0;
        this.x_slow = 2.3503 / (this.ks * this.convFactor);
        this.n = (int)this.nq;
        if (this.n <= 1) {
            this.n = 1;
        }
        this.x_quick = new double[this.n];
        for (int i = 0; i < this.n; ++i) {
            this.x_quick[i] = 0.0;
        }
        this.outflow = 0.0;
    }

    public void run() {
        double out;
        double US;
        double precip = this.precip;
        double pet = this.pet;
        double[] tmp1 = this.excess(this.x_loss, this.cmax, this.bexp, precip, pet);
        double UT1 = tmp1[0];
        double UT2 = tmp1[1];
        this.x_loss = tmp1[2];
        double UQ = this.alpha * UT2 + UT1;
        double inflow = US = (1.0 - this.alpha) * UT2;
        double[] tmp2 = this.linres(this.x_slow, inflow, this.outflow, this.ks);
        this.x_slow = tmp2[0];
        double QS = this.outflow = tmp2[1];
        inflow = UQ;
        for (int i = 0; i < this.n; ++i) {
            double[] tmp3 = this.linres(this.x_quick[i], inflow, this.outflow, this.kq);
            this.x_quick[i] = tmp3[0];
            inflow = this.outflow = tmp3[1];
        }
        this.mq = out = (QS + this.outflow) * this.convFactor;
    }

    public double[] excess(double x_loss, double cmax, double bexp, double Pval, double PETval) {
        double[] result = new double[3];
        double xn_prev = x_loss;
        double ct_prev = cmax * (1.0 - Math.pow(1.0 - (bexp + 1.0) * xn_prev / cmax, 1.0 / (bexp + 1.0)));
        result[0] = Math.max(Pval - cmax + ct_prev, 0.0);
        double dummy = Math.min((ct_prev + (Pval -= result[0])) / cmax, 1.0);
        double xn = cmax / (bexp + 1.0) * (1.0 - Math.pow(1.0 - dummy, bexp + 1.0));
        result[1] = Math.max(Pval - (xn - xn_prev), 0.0);
        double evap = Math.min(xn, PETval);
        result[2] = xn -= evap;
        return result;
    }

    double[] linres(double x_slow, double inflow, double outflow, double Rs) {
        double[] result = new double[2];
        x_slow = (1.0 - Rs) * x_slow + (1.0 - Rs) * inflow;
        result[1] = Rs / (1.0 - Rs) * x_slow;
        result[0] = x_slow;
        return result;
    }
}

