/*
 * Decompiled with CFR 0.152.
 */
package optas.test;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.StringTokenizer;

public class DataReader {
    public String fileName;
    public double precip;
    public double pet;
    public double obsRunoff;
    private String[] md;
    BufferedReader reader;
    public HashMap dataMap = new HashMap();

    public void init() {
        try {
            this.reader = new BufferedReader(new FileReader(new File(this.fileName)));
            String line = this.reader.readLine();
            StringTokenizer strTok = new StringTokenizer(line, "\t");
            String desc = strTok.nextToken();
            String start = strTok.nextToken();
            Calendar startTime = this.parseTime(start);
            line = this.reader.readLine();
            strTok = new StringTokenizer(line, "\t");
            desc = strTok.nextToken();
            String end = strTok.nextToken();
            Calendar endTime = this.parseTime(end);
            line = this.reader.readLine();
            strTok = new StringTokenizer(line, "\t");
            int cols = strTok.countTokens() - 1;
            this.md = new String[cols];
            strTok.nextToken();
            for (int i = 0; i < cols; ++i) {
                this.md[i] = strTok.nextToken();
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    public void run() {
        int i;
        String line = null;
        try {
            line = this.reader.readLine();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            return;
        }
        String[] tokens = line.split("\t");
        Double[] vals = new Double[this.md.length];
        for (i = 0; i < this.md.length; ++i) {
            try {
                vals[i] = Double.parseDouble(tokens[i + 2]);
                continue;
            }
            catch (NumberFormatException nfe) {
                vals[i] = 0.0;
            }
        }
        for (i = 0; i < this.md.length; ++i) {
            this.dataMap.put(this.md[i], vals[i]);
        }
        this.precip = (Double)this.dataMap.get("precip");
        this.pet = (Double)this.dataMap.get("pet");
        this.obsRunoff = (Double)this.dataMap.get("runoff");
    }

    public void cleanup() {
        try {
            this.reader.close();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    private Calendar parseTime(String timeString) {
        String[] timeArray = new String[]{"1", "1", "0"};
        StringTokenizer st = new StringTokenizer(timeString, ".-/ :");
        int n = st.countTokens();
        for (int i = 0; i < n; ++i) {
            timeArray[i] = st.nextToken();
        }
        GregorianCalendar cal = new GregorianCalendar();
        try {
            cal.set(Integer.parseInt(timeArray[2]), Integer.parseInt(timeArray[1]), Integer.parseInt(timeArray[0]));
        }
        catch (NumberFormatException pe) {
            cal.set(1, 1, 1);
        }
        return cal;
    }
}

