/*
 * Decompiled with CFR 0.152.
 */
package optas.sampler;

import jams.model.JAMSComponentDescription;
import java.util.Arrays;
import optas.core.ObjectiveAchievedException;
import optas.core.SampleLimitException;
import optas.optimizer.Optimizer;
import optas.optimizer.OptimizerLibrary;
import optas.optimizer.management.OptimizerDescription;

@JAMSComponentDescription(title="Random Sampler", author="Christian Fischer", description="Performs a random search")
public class MultiPointRandomSampler
extends Optimizer {
    private double k;
    private int pfd;
    private static final long serialVersionUID = -41284433223496L;

    @Override
    public OptimizerDescription getDescription() {
        return OptimizerLibrary.getDefaultOptimizerDescription(MultiPointRandomSampler.class.getSimpleName(), MultiPointRandomSampler.class.getName(), 500, true);
    }

    @Override
    public void procedure() throws SampleLimitException, ObjectiveAchievedException {
        double[] d = new double[this.n];
        for (int j = 0; j < this.n; ++j) {
            d[j] = this.upBound[j] - this.lowBound[j];
        }
        int iterations = this.getMaximumIterationCount() / (this.n * this.pfd + 1);
        block5: for (int j = 0; j < iterations; ++j) {
            double[] set = this.randomSampler();
            try {
                this.getSample(set);
            }
            catch (SampleLimitException sle) {
                break;
            }
            double[] nextPoint = Arrays.copyOf(set, set.length);
            for (int i = 0; i < this.n * this.pfd; ++i) {
                for (int l = 0; l < this.n; ++l) {
                    double p = set[l];
                    nextPoint[l] = generator.nextBoolean() ? p + (this.upBound[l] - this.lowBound[l]) * this.getK() : p - (this.upBound[l] - this.lowBound[l]) * this.getK();
                }
                try {
                    this.getSample(nextPoint);
                    continue;
                }
                catch (SampleLimitException sle) {
                    continue block5;
                }
            }
        }
        this.log("*********************************************************");
        this.log("Maximum_number_of_iterations_reached_finished_optimization");
        this.log("*********************************************************");
    }

    public double getK() {
        return this.k;
    }

    public void setK(double k) {
        this.k = k;
    }

    public double getPfd() {
        return this.pfd;
    }

    public void setPfd(double pfd) {
        this.pfd = (int)pfd;
    }
}

