/*
 * Decompiled with CFR 0.152.
 */
package optas.sampler;

import jams.JAMS;
import jams.io.BufferedFileReader;
import jams.io.SerializableBufferedWriter;
import jams.model.JAMSComponentDescription;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import optas.core.ObjectiveAchievedException;
import optas.core.SampleLimitException;
import optas.data.DataCollection;
import optas.optimizer.Optimizer;
import optas.optimizer.OptimizerLibrary;
import optas.optimizer.management.BooleanOptimizerParameter;
import optas.optimizer.management.NumericOptimizerParameter;
import optas.optimizer.management.OptimizerDescription;
import optas.optimizer.management.SampleFactory;
import optas.optimizer.management.StringOptimizerParameter;
import optas.optimizer.parallel.ParallelSequence;
import optas.sampler.RandomSampler;

@JAMSComponentDescription(title="File List Sampler", author="Sven Kralisch", description="Takes samples from a file")
public class FileListSampler
extends Optimizer {
    SerializableBufferedWriter writer = null;
    public String excludeFiles = "";
    public double threadCount = 12.0;
    public boolean parallelExecution = false;
    public String fileName = "";
    public String startIndicator = "@start";
    public String endIndicator = "@end";
    public SampleFactory.Sample[] initialSimplex = null;
    ParallelSequence pSeq = null;
    transient DataCollection collection = null;

    @Override
    public OptimizerDescription getDescription() {
        OptimizerDescription desc = OptimizerLibrary.getDefaultOptimizerDescription(RandomSampler.class.getSimpleName(), RandomSampler.class.getName(), 500, false);
        desc.addParameter(new StringOptimizerParameter("fileName", "fileName", ""));
        desc.addParameter(new BooleanOptimizerParameter("parallelExecution", "parallelExecution", false));
        desc.addParameter(new StringOptimizerParameter("excludeFiles", "excludeFiles", "(.*\\.cache)|(.*\\.jam)|(.*\\.ser)|(.*\\.svn)|(.*output.*\\.dat)|.*\\.cdat|.*\\.log"));
        desc.addParameter(new NumericOptimizerParameter("threadCount", "threadCount", 8.0, 2.0, 100.0));
        return desc;
    }

    @Override
    public boolean init() {
        if (!super.init()) {
            return false;
        }
        if (this.parallelExecution) {
            this.pSeq = new ParallelSequence(this);
            this.pSeq.setExcludeFiles(this.excludeFiles);
            this.pSeq.setThreadCount((int)this.threadCount);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void procedure() throws SampleLimitException, ObjectiveAchievedException {
        ArrayList<double[]> set = new ArrayList<double[]>();
        int count = 0;
        try {
            String line;
            BufferedFileReader fileReader = new BufferedFileReader(new FileInputStream(new File(this.getWorkspace(), this.fileName)), JAMS.getCharset());
            while ((line = fileReader.readLine()) != null && !line.startsWith(this.startIndicator)) {
            }
            while ((line = fileReader.readLine()) != null && !line.startsWith(this.endIndicator)) {
                String[] s = line.split("\\s+");
                double[] d = new double[s.length - 1];
                for (int i = 1; i < s.length; ++i) {
                    d[i - 1] = Double.parseDouble(s[i]);
                }
                set.add(d);
                ++count;
            }
            fileReader.close();
        }
        catch (IOException ex) {
            Logger.getLogger(FileListSampler.class.getName()).log(Level.SEVERE, null, ex);
        }
        this.setMaxn(count);
        int samplesPerIteration2 = (int)(this.threadCount * 6.0);
        if (samplesPerIteration2 == 0) {
            samplesPerIteration2 = 100;
        }
        int i = 0;
        while ((double)i < this.maxn) {
            int j;
            int sampleCount = (int)Math.min((double)samplesPerIteration2, this.maxn - (double)i);
            double[][] x = new double[sampleCount][];
            for (j = 0; j < sampleCount; ++j) {
                x[j] = (double[])set.remove(0);
                ++i;
            }
            if (this.parallelExecution) {
                ParallelSequence.OutputData result = this.pSeq.procedure(x);
                if (this.collection == null) {
                    this.collection = result.dc;
                } else {
                    DataCollection dataCollection = this.collection;
                    synchronized (dataCollection) {
                        if (result.dc != null) {
                            this.collection.mergeDataCollections(result.dc);
                        }
                    }
                }
                if (result.list != null) {
                    this.injectSamples(result.list);
                }
                if (this.collection == null) continue;
                this.collection.dump(this.getModel().getWorkspace().getOutputDataDirectory(), true);
                continue;
            }
            for (j = 0; j < x.length; ++j) {
                this.getSample(x[j]);
            }
        }
        if (this.collection != null) {
            this.collection.dump(this.getModel().getWorkspace().getOutputDataDirectory(), false);
        }
    }
}

