/*
 * Decompiled with CFR 0.152.
 */
package optas.regression;

import optas.data.SimpleEnsemble;
import optas.data.TimeSerie;
import optas.data.TimeSerieEnsemble;
import optas.regression.Interpolation;

public abstract class TimeSeriesInterpolation
extends Interpolation {
    private TimeSerieEnsemble yTS;
    protected int n;
    protected int m;
    TimeSerie yMin;
    TimeSerie yMax;
    double[] yRange;

    @Override
    public int getN() {
        return this.n;
    }

    @Override
    public int getM() {
        return this.m;
    }

    public void setData(SimpleEnsemble[] x, TimeSerieEnsemble y) {
        int i;
        this.x = x;
        this.yTS = y;
        if (x.length == 0) {
            return;
        }
        this.n = x.length;
        this.m = y.getTimesteps();
        this.yMin = this.yTS.getMin();
        this.yMax = this.yTS.getMax();
        this.L = x[0].getSize();
        this.yRange = new double[this.m];
        for (i = 0; i < this.m; ++i) {
            this.yRange[i] = this.yMax.getValue(i) - this.yMin.getValue(i) != 0.0 ? 1.0 / (this.yMax.getValue(i) - this.yMin.getValue(i)) : 0.0;
        }
        this.xRange = new double[this.n];
        this.xMin = new double[this.n];
        for (i = 0; i < this.n; ++i) {
            double min = x[i].getMin();
            double max = x[i].getMax();
            this.xRange[i] = 1.0 / (max - min);
            this.xMin[i] = min;
        }
        this.initSuccessful = true;
    }

    @Override
    public double getYData(int id, int time) {
        return this.yTS.get(time, id);
    }

    @Override
    protected double[] normalizeX(double[] u) {
        double[] normalizedU = new double[u.length];
        for (int i = 0; i < normalizedU.length; ++i) {
            normalizedU[i] = (u[i] - this.xMin[i]) * this.xRange[i] * 2.0 - 1.0;
        }
        return normalizedU;
    }

    @Override
    protected double[] normalizeY(double[] y) {
        double[] normalizedY = new double[this.m];
        for (int i = 0; i < this.m; ++i) {
            normalizedY[i] = (y[i] - this.yMin.getValue(i)) * this.yRange[i] * 2.0 - 1.0;
        }
        return normalizedY;
    }

    @Override
    protected double[] denormalizeX(double[] u) {
        double[] denormalizedU = new double[u.length];
        for (int i = 0; i < denormalizedU.length; ++i) {
            denormalizedU[i] = (u[i] + 1.0) / (2.0 * this.xRange[i]) + this.xMin[i];
        }
        return denormalizedU;
    }

    @Override
    protected double[] denormalizeY(double[] y) {
        double[] denormalizedY = new double[this.m];
        for (int i = 0; i < this.m; ++i) {
            denormalizedY[i] = this.yRange[i] != 0.0 ? (y[i] + 1.0) / (2.0 * this.yRange[i]) + this.yMin.getValue(i) : this.yMin.getValue(i);
        }
        return denormalizedY;
    }
}

