/*
 * Decompiled with CFR 0.152.
 */
package optas.regression;

import java.util.Map;
import java.util.TreeMap;
import optas.data.SimpleEnsemble;
import optas.regression.Interpolation;

public abstract class SimpleInterpolation
extends Interpolation {
    protected SimpleEnsemble[] y;
    protected int n;
    protected int m;
    double[] yRange;
    double[] yMin;
    TreeMap<Double, Double>[] xHistorgramm = null;
    TreeMap<Double, Double>[] yHistorgramm = null;
    TreeMap<Double, Double>[] xInvHistorgramm = null;
    TreeMap<Double, Double>[] yInvHistorgramm = null;
    private NormalizationMethod xNormalizationMethod = NormalizationMethod.Linear;
    private NormalizationMethod yNormalizationMethod = NormalizationMethod.Linear;
    boolean histogrammValid = false;

    public NormalizationMethod getxNormalizationMethod() {
        return this.xNormalizationMethod;
    }

    public void setxNormalizationMethod(NormalizationMethod xNormalizationMethod) {
        this.xNormalizationMethod = xNormalizationMethod;
    }

    public NormalizationMethod getyNormalizationMethod() {
        return this.yNormalizationMethod;
    }

    public void setyNormalizationMethod(NormalizationMethod yNormalizationMethod) {
        this.yNormalizationMethod = yNormalizationMethod;
    }

    @Override
    public int getN() {
        return this.n;
    }

    @Override
    public int getM() {
        return this.m;
    }

    public void setData(SimpleEnsemble[] x, SimpleEnsemble y) {
        this.setData(x, new SimpleEnsemble[]{y});
    }

    public void setData(SimpleEnsemble[] x, SimpleEnsemble[] y) {
        int i;
        this.x = x;
        this.y = y;
        if (x.length == 0) {
            return;
        }
        this.n = x.length;
        this.m = y.length;
        this.L = x[0].getSize();
        this.yRange = new double[this.m];
        this.yMin = new double[this.m];
        for (i = 0; i < this.m; ++i) {
            if (y[i].getSize() != this.L) {
                return;
            }
            this.yRange[i] = y[i].getMax() - y[i].getMin() != 0.0 ? 1.0 / (y[i].getMax() - y[i].getMin()) : 0.0;
            this.yMin[i] = y[i].getMin();
        }
        this.xRange = new double[this.n];
        this.xMin = new double[this.n];
        for (i = 0; i < this.n; ++i) {
            double min = x[i].getMin();
            double max = x[i].getMax();
            this.xRange[i] = 1.0 / (max - min);
            this.xMin[i] = min;
        }
        this.initSuccessful = true;
    }

    @Override
    public double getYData(int id, int index) {
        return this.y[index].getValue(id);
    }

    private void buildHistogramm() {
        double v;
        int j;
        double delta;
        double sum;
        Integer[] sortedMap;
        TreeMap<Double, Double> histInv;
        TreeMap<Double, Double> hist;
        int i;
        this.xHistorgramm = new TreeMap[this.n];
        this.yHistorgramm = new TreeMap[this.m];
        this.xInvHistorgramm = new TreeMap[this.n];
        this.yInvHistorgramm = new TreeMap[this.m];
        for (i = 0; i < this.n; ++i) {
            hist = new TreeMap<Double, Double>();
            histInv = new TreeMap<Double, Double>();
            sortedMap = this.x[i].sort(true);
            sum = -1.0;
            delta = 2.0 / (double)sortedMap.length;
            for (j = 0; j < sortedMap.length; ++j) {
                v = this.x[i].getValue(sortedMap[j]);
                hist.put(v, sum);
                histInv.put(sum, v);
                sum += delta;
            }
            this.xHistorgramm[i] = hist;
            this.xInvHistorgramm[i] = histInv;
        }
        for (i = 0; i < this.m; ++i) {
            hist = new TreeMap();
            histInv = new TreeMap();
            sortedMap = this.y[i].sort(true);
            sum = -1.0;
            delta = 2.0 / (double)sortedMap.length;
            for (j = 0; j < sortedMap.length; ++j) {
                v = this.y[i].getValue(sortedMap[j]);
                hist.put(v, sum);
                histInv.put(sum, v);
                sum += delta;
            }
            this.yHistorgramm[i] = hist;
            this.yInvHistorgramm[i] = histInv;
        }
        this.histogrammValid = true;
    }

    private double histogrammNormalization(double u, TreeMap<Double, Double> histogramm) {
        Map.Entry<Double, Double> upper = histogramm.ceilingEntry(u);
        Map.Entry<Double, Double> lower = histogramm.floorEntry(u);
        double normalizedU = 0.0;
        if (upper == null) {
            normalizedU = histogramm.lastEntry().getValue();
        } else if (lower == null) {
            normalizedU = histogramm.firstEntry().getValue();
        } else {
            double w2;
            double w1 = u - lower.getKey();
            if (w1 + (w2 = upper.getKey() - u) == 0.0) {
                w1 = 1.0;
                w2 = 0.0;
            }
            double r = w1 / (w1 + w2);
            double s = w2 / (w1 + w2);
            normalizedU = s * lower.getValue() + r * upper.getValue();
        }
        return normalizedU;
    }

    @Override
    protected double[] normalizeX(double[] u) {
        double[] normalizedU = new double[u.length];
        for (int i = 0; i < normalizedU.length; ++i) {
            if (this.getxNormalizationMethod() == NormalizationMethod.Linear) {
                normalizedU[i] = (u[i] - this.xMin[i]) * this.xRange[i] * 2.0 - 1.0;
                continue;
            }
            if (this.getxNormalizationMethod() != NormalizationMethod.Histogramm) continue;
            if (!this.histogrammValid) {
                this.buildHistogramm();
            }
            normalizedU[i] = this.histogrammNormalization(u[i], this.xHistorgramm[i]);
        }
        return normalizedU;
    }

    @Override
    protected double[] normalizeY(double[] y) {
        double[] normalizedY;
        block4: {
            block3: {
                normalizedY = new double[this.m];
                if (this.getyNormalizationMethod() != NormalizationMethod.Linear) break block3;
                for (int i = 0; i < this.m; ++i) {
                    normalizedY[i] = (y[i] - this.yMin[i]) * this.yRange[i] * 2.0 - 1.0;
                }
                break block4;
            }
            if (this.getyNormalizationMethod() != NormalizationMethod.Histogramm) break block4;
            if (!this.histogrammValid) {
                this.buildHistogramm();
            }
            for (int i = 0; i < this.m; ++i) {
                normalizedY[i] = this.histogrammNormalization(y[i], this.yHistorgramm[i]);
            }
        }
        return normalizedY;
    }

    @Override
    protected double[] denormalizeX(double[] u) {
        double[] denormalizedU = new double[u.length];
        for (int i = 0; i < denormalizedU.length; ++i) {
            if (this.getxNormalizationMethod() == NormalizationMethod.Linear) {
                denormalizedU[i] = (u[i] + 1.0) / (2.0 * this.xRange[i]) + this.xMin[i];
                continue;
            }
            if (this.getxNormalizationMethod() != NormalizationMethod.Histogramm) continue;
            if (!this.histogrammValid) {
                this.buildHistogramm();
            }
            denormalizedU[i] = this.histogrammNormalization(u[i], this.xInvHistorgramm[i]);
        }
        return denormalizedU;
    }

    @Override
    protected double[] denormalizeY(double[] y) {
        double[] denormalizedY = new double[this.m];
        for (int i = 0; i < this.m; ++i) {
            if (this.getxNormalizationMethod() == NormalizationMethod.Linear) {
                if (this.yRange[i] != 0.0) {
                    denormalizedY[i] = (y[i] + 1.0) / (2.0 * this.yRange[i]) + this.yMin[i];
                    continue;
                }
                denormalizedY[i] = this.yMin[i];
                continue;
            }
            if (this.getxNormalizationMethod() != NormalizationMethod.Histogramm) continue;
            if (!this.histogrammValid) {
                this.buildHistogramm();
            }
            denormalizedY[i] = this.histogrammNormalization(y[i], this.yInvHistorgramm[i]);
        }
        return denormalizedY;
    }

    public static enum NormalizationMethod {
        Linear,
        Histogramm;

    }
}

