/*
 * Decompiled with CFR 0.152.
 */
package optas.regression;

import java.util.TreeSet;
import optas.regression.SimpleInterpolation;

public class IDW
extends SimpleInterpolation {
    int R = 3;
    double[] expWeights;
    int[][] nearestNeighbours;
    double[][] distanceToNeighbour;

    public void setR(int R) {
        this.R = R;
    }

    public int getR(int R) {
        return R;
    }

    private double d(double[] a, double[] b) {
        double d = 0.0;
        for (int i = 0; i < this.n; ++i) {
            double di = a[i] - b[i];
            d += this.expWeights[i] * di * di;
        }
        return d;
    }

    @Override
    protected void calculate() {
        this.nearestNeighbours = new int[this.L][this.R];
        this.distanceToNeighbour = new double[this.L][this.R];
        int worstIndex = 0;
        double[] x_i = new double[this.n];
        double[] x_j = new double[this.n];
        for (int j = 0; j < this.L; ++j) {
            int k;
            int id_j = this.x[0].getId(j);
            for (k = 0; k < this.n; ++k) {
                x_j[k] = this.x[k].getValue(id_j);
            }
            for (k = 0; k < this.R; ++k) {
                this.nearestNeighbours[j][k] = -1;
                this.distanceToNeighbour[j][k] = Double.MAX_VALUE;
            }
            for (int i = 0; i < this.L; ++i) {
                if (i == j) continue;
                int id_i = this.x[0].getId(i);
                for (int k2 = 0; k2 < this.n; ++k2) {
                    x_i[k2] = this.x[k2].getValue(id_i);
                }
                double dist = this.d(x_j, x_i);
                if (!(dist < this.distanceToNeighbour[j][worstIndex])) continue;
                this.distanceToNeighbour[j][worstIndex] = dist;
                this.nearestNeighbours[j][worstIndex] = id_i;
                for (int k3 = 0; k3 < this.R; ++k3) {
                    if (!(this.distanceToNeighbour[j][worstIndex] < this.distanceToNeighbour[j][k3])) continue;
                    worstIndex = k3;
                }
            }
        }
    }

    @Override
    protected double[][] getInterpolatedValue(TreeSet<Integer> validationSet) {
        int counter = 0;
        double[][] ystar = new double[validationSet.size()][this.m];
        for (Integer id : validationSet) {
            int[] nearestNeighbours = new int[this.R];
            double[] distanceToNeighbour = new double[this.R];
            int worstIndex = 0;
            for (int i = 0; i < this.R; ++i) {
                nearestNeighbours[i] = -1;
                distanceToNeighbour[i] = Double.MAX_VALUE;
            }
            double[] x_i = new double[this.n];
            for (int i = 0; i < this.L; ++i) {
                int id_i = this.x[0].getId(i);
                for (int j = 0; j < this.n; ++j) {
                    x_i[j] = this.x[j].getValue(id_i);
                }
                double dist = this.d(this.getX(id), x_i);
                if (!(dist < distanceToNeighbour[worstIndex])) continue;
                distanceToNeighbour[worstIndex] = dist;
                nearestNeighbours[worstIndex] = id_i;
                for (int j = 0; j < this.R; ++j) {
                    if (!(distanceToNeighbour[worstIndex] < distanceToNeighbour[j])) continue;
                    worstIndex = j;
                }
            }
            double sum = 0.0;
            for (int i = 0; i < this.R; ++i) {
                if (nearestNeighbours[i] == -1) {
                    return null;
                }
                sum += 1.0 / distanceToNeighbour[i];
            }
            for (int j = 0; j < this.m; ++j) {
                for (int i = 0; i < this.R; ++i) {
                    if (distanceToNeighbour[i] < 1.0E-7) {
                        ystar[counter][j] = this.y[j].getValue(nearestNeighbours[i]);
                        continue;
                    }
                    double[] dArray = ystar[counter];
                    int n = j;
                    dArray[n] = dArray[n] + 1.0 / distanceToNeighbour[i] / sum * this.y[j].getValue(nearestNeighbours[i]);
                }
                ++counter;
            }
        }
        return ystar;
    }

    @Override
    public double[] getInterpolatedValue(double[] u) {
        int[] nearestNeighbours = new int[this.R];
        double[] distanceToNeighbour = new double[this.R];
        int worstIndex = 0;
        for (int i = 0; i < this.R; ++i) {
            nearestNeighbours[i] = -1;
            distanceToNeighbour[i] = Double.MAX_VALUE;
        }
        double[] x_i = new double[this.n];
        for (int i = 0; i < this.L; ++i) {
            int id_i = this.x[0].getId(i);
            for (int j = 0; j < this.n; ++j) {
                x_i[j] = this.x[j].getValue(id_i);
            }
            double dist = this.d(u, x_i);
            if (!(dist < distanceToNeighbour[worstIndex])) continue;
            distanceToNeighbour[worstIndex] = dist;
            nearestNeighbours[worstIndex] = id_i;
            for (int j = 0; j < this.R; ++j) {
                if (!(distanceToNeighbour[worstIndex] < distanceToNeighbour[j])) continue;
                worstIndex = j;
            }
        }
        double sum = 0.0;
        for (int i = 0; i < this.R; ++i) {
            if (nearestNeighbours[i] == -1) {
                return null;
            }
            sum += 1.0 / distanceToNeighbour[i];
        }
        double[] ystar = new double[this.m];
        for (int j = 0; j < this.m; ++j) {
            for (int i = 0; i < this.R; ++i) {
                if (distanceToNeighbour[i] < 1.0E-7) {
                    ystar[j] = this.y[j].getValue(nearestNeighbours[i]);
                    continue;
                }
                int n = j;
                ystar[n] = ystar[n] + 1.0 / distanceToNeighbour[i] / sum * this.y[j].getValue(nearestNeighbours[i]);
            }
        }
        return ystar;
    }
}

