/*
 * Decompiled with CFR 0.152.
 */
package optas.optimizer.management;

import jams.math.distributions.CDF_Normal;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import optas.data.EfficiencyEnsemble;
import optas.data.SimpleEnsemble;
import optas.optimizer.management.SampleFactory;
import optas.regression.Interpolation;
import optas.regression.SimpleInterpolation;
import optas.regression.SimpleNeuralNetwork;

public class Statistics
implements Serializable {
    ArrayList<SampleFactory.Sample> sampleList;
    ArrayList<SampleFactory.Sample> bestSampleList = new ArrayList();
    transient ArrayList<SimpleInterpolation> I = null;

    public Statistics(ArrayList<SampleFactory.Sample> sampleList) {
        this.sampleList = sampleList;
    }

    public void fireChangeEvent() {
        this.bestSampleList.clear();
    }

    public double[][] getParameterSpace(int start, int end, int index, double percentil) {
        double mean = this.calcMean(start, end, index);
        double var = this.calcVariance(start, start, index);
        int n = this.n();
        double[] min = new double[n];
        double[] max = new double[n];
        for (int i = 0; i < n; ++i) {
            min[i] = Double.POSITIVE_INFINITY;
            max[i] = Double.NEGATIVE_INFINITY;
        }
        double omega = CDF_Normal.xnormi((double)percentil);
        for (int i = start; i < end; ++i) {
            SampleFactory.Sample s = this.sampleList.get(i);
            if (!(s.F()[index] < mean + omega * var)) continue;
            for (int j = 0; j < n; ++j) {
                min[j] = Math.min(s.getParameter()[j], min[j]);
                max[j] = Math.max(s.getParameter()[j], max[j]);
            }
        }
        return new double[][]{min, max};
    }

    public double calcVariance(int index) {
        return this.calcVariance(0, this.size(), index);
    }

    public double calcVariance(int start, int last, int index) {
        start = this.checkBounds(start, last)[0];
        last = this.checkBounds(start, last)[1];
        double var = 0.0;
        double mean = this.calcMean(start, last, index);
        for (int i = start; i < last; ++i) {
            double v = this.sampleList.get(i).F()[index] - mean;
            var += v * v;
        }
        return Math.sqrt(var / (double)(last - start - 1));
    }

    public double calcMean(int index) {
        return this.calcMean(0, this.size(), index);
    }

    public double calcMean(int start, int last, int index) {
        start = this.checkBounds(start, last)[0];
        last = this.checkBounds(start, last)[1];
        double mean = 0.0;
        for (int i = start; i < last; ++i) {
            mean += this.sampleList.get(i).F()[index];
        }
        return mean / (double)(last - start);
    }

    public double calcGeometricRange(int last) {
        return this.calcGeometricRange(0, this.sampleList.size() - last);
    }

    public double calcGeometricRange(int start, int last) {
        start = this.checkBounds(start, last)[0];
        last = this.checkBounds(start, last)[1];
        double[] range = new double[this.n()];
        double sum = 0.0;
        for (int j = 0; j < this.n(); ++j) {
            range[j] = this.calcGeometricRange(start, last, j);
            sum += range[j] * range[j];
        }
        return Math.sqrt(sum);
    }

    public double calcGeometricRange(int start, int last, int index) {
        start = this.checkBounds(start, last)[0];
        last = this.checkBounds(start, last)[1];
        double min = Double.POSITIVE_INFINITY;
        double max = Double.NEGATIVE_INFINITY;
        for (int i = start; i < last; ++i) {
            min = Math.min(min, this.sampleList.get(i).getParameter()[index]);
            max = Math.max(max, this.sampleList.get(i).getParameter()[index]);
        }
        return max - min;
    }

    public double calcImprovement(int last, int index) {
        int start = Math.max(0, this.size() - last);
        double v1 = 0.0;
        double v2 = 0.0;
        v1 = start != 0 ? this.getMinimumInRange(0, start, index).F()[index] : Double.POSITIVE_INFINITY;
        v2 = start + 1 < this.size() ? this.getMinimumInRange(start + 1, this.size(), index).F()[index] : Double.POSITIVE_INFINITY;
        return 1.0 - v2 / v1;
    }

    public SampleFactory.Sample getMin(int index) {
        return this.getMinimumInRange(0, this.size(), index);
    }

    public SampleFactory.Sample getMax(int index) {
        return this.getMaximumInRange(0, this.size(), index);
    }

    public SampleFactory.Sample getMinimumInRange(int start, int last, int index) {
        start = this.checkBounds(start, last)[0];
        last = this.checkBounds(start, last)[1];
        double min = Double.POSITIVE_INFINITY;
        SampleFactory.Sample argMin = null;
        for (int i = start; i < last; ++i) {
            SampleFactory.Sample s = this.sampleList.get(i);
            if (!(min >= s.F()[index])) continue;
            min = s.F()[index];
            argMin = s;
        }
        return argMin;
    }

    public SampleFactory.Sample getMaximumInRange(int start, int last, int index) {
        start = this.checkBounds(start, last)[0];
        last = this.checkBounds(start, last)[1];
        double max = Double.NEGATIVE_INFINITY;
        SampleFactory.Sample argMax = null;
        for (int i = start; i < last; ++i) {
            SampleFactory.Sample s = this.sampleList.get(i);
            if (!(max <= s.F()[index])) continue;
            max = s.F()[index];
            argMax = s;
        }
        return argMax;
    }

    private int[] checkBounds(int t1, int t2) {
        if (t1 < 0) {
            t1 = 0;
        }
        if (t2 < 0) {
            t2 = 0;
        }
        if (t1 >= this.size()) {
            t1 = this.size() - 1;
        }
        if (t2 > this.size()) {
            t2 = this.size();
        }
        if (t1 > t2) {
            t1 = t2;
        }
        return new int[]{t1, t2};
    }

    public int size() {
        return this.sampleList.size();
    }

    public int n() {
        if (this.sampleList.isEmpty()) {
            return 0;
        }
        return this.sampleList.get(0).getParameter().length;
    }

    public int m() {
        if (this.sampleList.isEmpty()) {
            return 0;
        }
        return this.sampleList.get(0).F().length;
    }

    public ArrayList<SampleFactory.Sample> getSamplesByRank(int rk) {
        return null;
    }

    public ArrayList<SampleFactory.Sample> getParetoSubset(boolean[] subset) {
        if (subset.length != this.m()) {
            return null;
        }
        this.bestSampleList.clear();
        if (this.m() == 1) {
            if (!subset[0]) {
                return new ArrayList<SampleFactory.Sample>();
            }
            SampleFactory.SampleComperator comparer = new SampleFactory.SampleComperator(true, subset);
            SampleFactory.Sample best = null;
            for (SampleFactory.Sample rivale : this.sampleList) {
                if (best == null) {
                    best = rivale;
                    continue;
                }
                if (comparer.compare(best, rivale) >= 0) continue;
                best = rivale;
            }
            this.bestSampleList.add(best);
            return this.bestSampleList;
        }
        SampleFactory.SampleComperator comparer = new SampleFactory.SampleComperator(true, subset);
        for (SampleFactory.Sample candidate : this.sampleList) {
            boolean isDominated = false;
            for (SampleFactory.Sample rivale : this.sampleList) {
                if (candidate == rivale || comparer.compare(candidate, rivale) >= 0) continue;
                isDominated = true;
                break;
            }
            if (isDominated) continue;
            this.bestSampleList.add(candidate);
        }
        return this.bestSampleList;
    }

    public ArrayList<SampleFactory.Sample> getParetoFront() {
        boolean[] subsetFilter = new boolean[this.m()];
        Arrays.fill(subsetFilter, true);
        return this.getParetoSubset(subsetFilter);
    }

    public void optimizeInterpolation() {
        for (SimpleInterpolation idw : this.I) {
            idw.init();
        }
    }

    public double getMinimalParameter(int index) {
        double min = Double.POSITIVE_INFINITY;
        for (SampleFactory.Sample s : this.sampleList) {
            min = Math.min(min, s.x[index]);
        }
        return min;
    }

    public double getMaximalParameter(int index) {
        double max = Double.NEGATIVE_INFINITY;
        for (SampleFactory.Sample s : this.sampleList) {
            max = Math.max(max, s.x[index]);
        }
        return max;
    }

    public double calcQuality() {
        int L = this.sampleList.size();
        int Ls = (int)((double)L * 0.9);
        int m = this.sampleList.get((int)0).fx.length;
        if (this.I == null) {
            this.I = new ArrayList();
            for (int i = 0; i < m; ++i) {
                SimpleNeuralNetwork nn = new SimpleNeuralNetwork();
                this.I.add(nn);
            }
        }
        SimpleEnsemble[] ensemble = new SimpleEnsemble[this.n()];
        if (this.sampleList.isEmpty()) {
            return 0.0;
        }
        double errorLOO = Double.POSITIVE_INFINITY;
        for (int i = 0; i < m; ++i) {
            ArrayList<Double> valueList = new ArrayList<Double>();
            for (int j = 0; j < L; ++j) {
                valueList.add(j, this.sampleList.get((int)j).fx[i]);
            }
            Collections.sort(valueList);
            double threshold = (Double)valueList.get(Ls);
            SimpleEnsemble[] y = new SimpleEnsemble[m];
            double rmin = (Double)valueList.get(L - Ls);
            double rmax = (Double)valueList.get(Ls);
            rmin -= (rmax - rmin) * 0.2;
            rmax += (rmax - rmin) * 0.2;
            y[i] = new EfficiencyEnsemble("test", L, false, rmin, rmax);
            for (int k = 0; k < this.n(); ++k) {
                ensemble[k] = new SimpleEnsemble("test", L);
            }
            int counter = 0;
            for (int j = 0; j < L; ++j) {
                for (int k = 0; k < this.n(); ++k) {
                    ensemble[k].add(counter, this.sampleList.get((int)j).x[k]);
                }
                y[i].add(counter, Math.min(this.sampleList.get((int)j).fx[i], threshold));
                ++counter;
            }
            SimpleInterpolation nn = this.I.get(i);
            nn.setData(ensemble, y[i]);
            double[] error = nn.estimateCrossValidationError(5, Interpolation.ErrorMethod.E2);
            for (int j = 0; j < error.length; ++j) {
                errorLOO = Math.min(error[j], errorLOO);
            }
        }
        return errorLOO;
    }
}

