/*
 * Decompiled with CFR 0.152.
 */
package optas.optimizer.management;

import jams.data.Attribute;
import jams.model.JAMSVarDescription;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Serializable;
import optas.core.AbstractFunction;
import optas.core.ObjectiveAchievedException;
import optas.core.SampleLimitException;
import optas.gui.wizard.Objective;
import optas.gui.wizard.Optimization;
import optas.gui.wizard.Parameter;
import optas.optimizer.Optimizer;
import optas.optimizer.OptimizerLibrary;
import optas.optimizer.management.OptimizerParameter;
import optas.optimizer.management.OptimizerWrapper;
import optas.optimizer.management.SampleFactory;

public abstract class OptimizationController
extends OptimizerWrapper {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description="parameter for relaxation control", defaultValue="-1.0")
    public Attribute.Double relaxationParameter;
    private static int id = 0;
    File logFile = null;
    transient BufferedWriter writer = null;

    protected void log(String msg) {
        if (this.writer != null) {
            try {
                this.writer.write(msg);
                this.getModel().getRuntime().println(msg);
                this.writer.newLine();
            }
            catch (IOException iOException) {}
        } else {
            this.getModel().getRuntime().println(msg);
        }
    }

    @Override
    public void init() {
        super.init();
        if (this.logFile == null) {
            this.log("Warning: output file was not setup! Set to optimization.log");
            this.logFile = new File(this.getModel().getWorkspacePath() + "/optimization.log");
        }
        try {
            this.writer = new BufferedWriter(new FileWriter(this.logFile));
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    @Override
    public void cleanup() {
        try {
            if (this.writer != null) {
                this.writer.close();
                this.writer = null;
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            System.out.println(ioe);
        }
    }

    @Override
    public abstract void procedure();

    public class OptimizationConfiguration
    implements Serializable {
        protected Optimization o;
        protected AbstractFunction evaluate = null;
        protected double[] lowerBound;
        protected double[] upperBound;
        protected double[][] startValue_transposed;
        private String[] parameterNames;
        private String[] objectiveNames;
        private int n;
        private int m;

        protected OptimizationConfiguration(Optimization o) {
            this.o = o;
            this.n = o.getParameter().size();
            this.m = o.getObjective().size();
            this.startValue_transposed = new double[o.getParameter().size()][];
            this.parameterNames = new String[this.n];
            this.lowerBound = new double[this.n];
            this.upperBound = new double[this.n];
            int i = 0;
            for (Parameter p : o.getParameter()) {
                this.lowerBound[i] = p.getLowerBound();
                this.upperBound[i] = p.getUpperBound();
                this.startValue_transposed[i] = p.getStartValue();
                this.parameterNames[i] = p.getAttributeName();
                ++i;
            }
            this.m = o.getObjective().size();
            this.objectiveNames = new String[this.m];
            i = 0;
            for (Objective obj : o.getObjective()) {
                this.objectiveNames[i++] = obj.toString();
            }
        }

        public void log(String msg) {
            if (this.evaluate != null) {
                this.evaluate.log(msg);
            }
        }

        public double[] evaluate(double[] x) throws ObjectiveAchievedException, SampleLimitException {
            return this.evaluate.evaluate(x);
        }

        public double[] getLowerBound() {
            return this.lowerBound;
        }

        public double[] getUpperBound() {
            return this.upperBound;
        }

        public boolean getLocalSearchDuringRelaxation() {
            return this.o.getOptimizerDescription().getLocalSearchDuringRelaxation().isValue();
        }

        public boolean getAdaptiveRelaxation() {
            return this.o.getOptimizerDescription().getAdaptiveRelaxation().isValue();
        }

        public int n() {
            return this.n;
        }

        public int m() {
            return this.m;
        }

        protected void setOptimizerParameter(Optimizer optimizer, Optimization o) {
            optimizer.setWorkspace(OptimizationController.this.getModel().getWorkspace().getDirectory());
            int id_cpy = id;
            String counter = "";
            for (int c = 100000; c > 0; c /= 10) {
                counter = counter + id_cpy / c;
            }
            optimizer.setOutputFile("optimization_" + counter);
            if (this.startValue_transposed.length > 0) {
                double[][] startValue = new double[this.startValue_transposed[0].length][this.startValue_transposed.length];
                for (int i = 0; i < startValue.length; ++i) {
                    for (int j = 0; j < startValue[i].length; ++j) {
                        startValue[i][j] = this.startValue_transposed[j][i];
                    }
                }
                optimizer.setStartValue(startValue);
            }
            optimizer.setDebugMode(OptimizationController.this.debugMode.getValue());
            for (OptimizerParameter key : o.getOptimizerDescription().getPropertyMap().values()) {
                optimizer.setSetup(key);
            }
            this.evaluate = new AbstractFunction(){

                @Override
                public void log(String msg) {
                    OptimizationController.this.getModel().getRuntime().println(msg);
                }

                @Override
                public String[] getOutputFactorNames() {
                    return OptimizationConfiguration.this.objectiveNames;
                }

                @Override
                public String[] getInputFactorNames() {
                    return OptimizationConfiguration.this.parameterNames;
                }

                @Override
                public int getInputDimension() {
                    return OptimizationConfiguration.this.n;
                }

                @Override
                public int getOutputDimension() {
                    return OptimizationConfiguration.this.m;
                }

                @Override
                public double[][] getRange() {
                    double[][] range = new double[OptimizationConfiguration.this.n][2];
                    for (int i = 0; i < OptimizationConfiguration.this.n; ++i) {
                        range[i][0] = OptimizationController.this.lowBound[i];
                        range[i][1] = OptimizationController.this.upBound[i];
                    }
                    return range;
                }

                @Override
                public double[] evaluate(double[] x) throws SampleLimitException, ObjectiveAchievedException {
                    SampleFactory.Sample s = OptimizationController.this.getSample(x);
                    return s.F();
                }
            };
            optimizer.setFunction(this.evaluate);
        }

        public Optimizer loadOptimizer(String className) {
            this.log("Load optimizer: Class: " + this.o.getOptimizerDescription().getOptimizerClassName());
            if (className == null) {
                Optimizer optimizer = OptimizerLibrary.loadOptimizer(OptimizationController.this.getModel().getRuntime(), this.o.getOptimizerDescription().getOptimizerClassName());
                this.setOptimizerParameter(optimizer, this.o);
                optimizer.setModel(OptimizationController.this.getModel());
                return optimizer;
            }
            Optimizer optimizer = OptimizerLibrary.loadOptimizer(OptimizationController.this.getModel().getRuntime(), className);
            this.setOptimizerParameter(optimizer, this.o);
            optimizer.setModel(OptimizationController.this.getModel());
            return optimizer;
        }

        public int getIterationCount() {
            return OptimizationController.this.getIterationCount();
        }
    }
}

