/*
 * Decompiled with CFR 0.152.
 */
package optas.optimizer.experimental;

import jams.data.JAMSDouble;
import jams.data.JAMSInteger;
import jams.model.JAMSComponent;
import jams.model.JAMSComponentDescription;
import jams.model.JAMSVarDescription;

@JAMSComponentDescription(title="PostProcessor", author="Christian Fischer", description="transforms efficiency ")
public class PostProcessor
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description="function y")
    public JAMSDouble yVal;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="transform type")
    public JAMSInteger type;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="transform type")
    public JAMSDouble shift;

    public void cleanup() {
        if (this.shift != null) {
            this.yVal.setValue(this.yVal.getValue() + this.shift.getValue());
        }
        if (this.type.getValue() == 1) {
            double y = this.yVal.getValue();
            boolean negative = false;
            if (y < 0.0) {
                y = -y;
                negative = true;
            }
            y = Math.log(y);
            this.yVal.setValue(y);
        }
        if (this.type.getValue() == 2) {
            boolean negative = false;
            double y = this.yVal.getValue();
            if (y < 0.0) {
                y = -y;
                negative = true;
            }
            y = Math.sqrt(y);
            if (negative) {
                y = -y;
            }
            this.yVal.setValue(y);
        }
    }
}

