/*
 * Decompiled with CFR 0.152.
 */
package optas.optimizer.experimental;

import jams.model.JAMSComponentDescription;
import jams.model.JAMSModel;
import jams.runtime.StandardRuntime;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import optas.core.ObjectiveAchievedException;
import optas.core.SampleLimitException;
import optas.data.DataCollection;
import optas.io.ImportMonteCarloData;
import optas.io.ImportMonteCarloException;
import optas.optimizer.Optimizer;
import optas.optimizer.OptimizerLibrary;
import optas.optimizer.management.OptimizerDescription;
import optas.optimizer.management.SampleFactory;
import optas.optimizer.parallel.ParallelExecution;
import optas.optimizer.parallel.ParallelJob;
import optas.optimizer.parallel.ParallelTask;

@JAMSComponentDescription(title="Random Sampler", author="Christian Fischer", description="Performs a random search")
public class ParallelPostSampling
extends Optimizer {
    final int COUNT = 8;
    public String excludeFiles = "";
    public double threshold = 0.1;
    public double[][] range;

    public double[][] getRange() {
        return this.range;
    }

    public String getExcludeFiles() {
        return this.excludeFiles;
    }

    public void setExcludeFiles(String excludeFiles) {
        this.excludeFiles = excludeFiles;
    }

    @Override
    public OptimizerDescription getDescription() {
        OptimizerDescription desc = OptimizerLibrary.getDefaultOptimizerDescription(ParallelPostSampling.class.getSimpleName(), ParallelPostSampling.class.getName(), 500, false);
        return desc;
    }

    public void setThreshold(double threshold) {
        this.threshold = threshold;
    }

    public double getThreshold() {
        return this.threshold;
    }

    @Override
    public boolean init() {
        if (!super.init()) {
            return false;
        }
        String[] libs = null;
        if (this.getModel().getRuntime() instanceof StandardRuntime) {
            libs = ((StandardRuntime)this.getModel().getRuntime()).getLibs();
        }
        if (libs != null) {
            for (int i = 0; i < libs.length; ++i) {
                String lib = libs[i];
                File fileToLib = new File(lib);
                if (!fileToLib.exists()) continue;
                ParallelExecution.addJarsToClassPath(ClassLoader.getSystemClassLoader(), fileToLib);
            }
        } else {
            this.log("Warning: no libary path was specified");
        }
        return true;
    }

    @Override
    public void procedure() throws SampleLimitException, ObjectiveAchievedException {
        EstimateBoundsOutputData result = null;
        Object collection = null;
        ParallelExecution<EstimateBoundsInputData, EstimateBoundsOutputData> executor = new ParallelExecution<EstimateBoundsInputData, EstimateBoundsOutputData>(this.getWorkspace(), this.excludeFiles);
        EstimateBoundsInputData param = new EstimateBoundsInputData(this, -1);
        result = executor.execute(param, new ParallelEstimateBoundsTask(), this.n);
        this.range = new double[][]{result.minBound, result.maxBound};
        this.injectSamples(result.list);
    }

    private double[] transform(double[] x) {
        double[] y = new double[this.n];
        for (int i = 0; i < this.n; ++i) {
            y[i] = this.lowBound[i] + x[i] * (this.upBound[i] - this.lowBound[i]);
        }
        return y;
    }

    private double[] reTransform(double[] y) {
        double[] x = new double[this.n];
        for (int i = 0; i < this.n; ++i) {
            x[i] = this.upBound[i] - this.lowBound[i] > 0.0 ? (y[i] - this.lowBound[i]) / (this.upBound[i] - this.lowBound[i]) : y[i] - this.lowBound[i];
        }
        return x;
    }

    public void procedure2(int index) throws SampleLimitException, ObjectiveAchievedException {
        double minBound = 0.0;
        double maxBound = 0.0;
        try {
            SampleFactory.Sample y0 = this.getSample(this.x0[0]);
            double lplus = 0.5;
            double lminus = 0.5;
            for (int k = 0; k < 8; ++k) {
                double[] xiplus = new double[this.n];
                double[] ximinus = new double[this.n];
                xiplus = this.reTransform(Arrays.copyOf(this.x0[0], this.n));
                ximinus = this.reTransform(Arrays.copyOf(this.x0[0], this.n));
                xiplus[index] = this.reTransform(this.x0[0])[index] + lplus * (1.0 - this.reTransform(this.x0[0])[index]);
                ximinus[index] = this.reTransform(this.x0[0])[index] - lminus * this.reTransform(this.x0[0])[index];
                SampleFactory.Sample sPlus = this.getSample(this.transform(xiplus));
                SampleFactory.Sample sMinus = this.getSample(this.transform(ximinus));
                System.out.println(Arrays.toString(ximinus));
                boolean isValidPlus = true;
                boolean isValidMinus = true;
                for (int j = 0; j < this.m; ++j) {
                    if (!(sPlus.F()[j] < (1.0 + this.threshold) * y0.F()[j])) {
                        isValidPlus = false;
                    }
                    if (sMinus.F()[j] < (1.0 + this.threshold) * y0.F()[j]) continue;
                    isValidMinus = false;
                }
                if (isValidPlus) {
                    lplus += Math.pow(2.0, -k - 2);
                    maxBound = this.transform(xiplus)[index];
                } else {
                    lplus -= Math.pow(2.0, -k - 2);
                }
                if (isValidMinus) {
                    lminus += Math.pow(2.0, -k - 2);
                    minBound = this.transform(ximinus)[index];
                    continue;
                }
                lminus -= Math.pow(2.0, -k - 2);
            }
        }
        catch (SampleLimitException sle) {
            sle.printStackTrace();
        }
        catch (Throwable sle) {
            sle.printStackTrace();
        }
        this.range = new double[2][this.n];
        this.range[0][index] = minBound;
        this.range[1][index] = maxBound;
    }

    public static EstimateBoundsOutputData parallelExecute(EstimateBoundsInputData in) {
        in.context.maxn = 100.0;
        try {
            in.context.procedure2(in.index);
        }
        catch (SampleLimitException sampleLimitException) {
        }
        catch (ObjectiveAchievedException objectiveAchievedException) {
            // empty catch block
        }
        in.context.log("finished myjob");
        try {
            in.context.getModel().cleanup();
            in.context.getModel().getWorkspace().close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        EstimateBoundsOutputData data = new EstimateBoundsOutputData(in.context.factory.getSampleList(), in.index, in.context.getRange()[0], in.context.getRange()[1]);
        File outputDataDir = in.context.getModel().getWorkspace().getOutputDataDirectory();
        File[] list = outputDataDir.listFiles();
        if (list != null) {
            for (int i = 0; i < list.length; ++i) {
                if (!list[i].getName().endsWith("dat")) continue;
                data.add(list[i].getName(), list[i]);
            }
        }
        return data;
    }

    public static class ParallelEstimateBoundsTask
    extends ParallelTask<EstimateBoundsInputData, EstimateBoundsOutputData>
    implements Serializable {
        @Override
        public ArrayList<ParallelJob> split(EstimateBoundsInputData taskArgument, int gridSize) {
            int i;
            ArrayList<ParallelJob> jobs = new ArrayList<ParallelJob>(gridSize);
            EstimateBoundsInputData[] jobsData = new EstimateBoundsInputData[taskArgument.context.n];
            for (i = 0; i < taskArgument.context.n; ++i) {
                jobsData[i] = new EstimateBoundsInputData(taskArgument.context, i);
            }
            for (i = 0; i < jobsData.length; ++i) {
                jobs.add(new ParallelJob<EstimateBoundsInputData, EstimateBoundsOutputData>(jobsData[i]){

                    @Override
                    public void moveWorkspace(File newWorkspace) {
                        ((JAMSModel)((EstimateBoundsInputData)this.arg).context.getModel()).moveWorkspaceDirectory(newWorkspace.getAbsolutePath());
                    }

                    @Override
                    public EstimateBoundsOutputData execute() {
                        EstimateBoundsOutputData result = ParallelPostSampling.parallelExecute((EstimateBoundsInputData)this.arg);
                        return result;
                    }
                });
            }
            return jobs;
        }

        @Override
        public EstimateBoundsOutputData reduce(ArrayList<EstimateBoundsOutputData> results) {
            System.out.println("reduce_function_started_");
            if (results.isEmpty()) {
                return new EstimateBoundsOutputData(new ArrayList<SampleFactory.Sample>(), -1, null, null);
            }
            EstimateBoundsOutputData merged = new EstimateBoundsOutputData(new ArrayList<SampleFactory.Sample>(), -1, new double[results.size()], new double[results.size()]);
            for (int i = 0; i < results.size(); ++i) {
                EstimateBoundsOutputData result = results.get(i);
                if (merged.dc == null) {
                    merged.dc = result.dc;
                } else {
                    merged.dc.mergeDataCollections(result.dc);
                }
                merged.list.addAll(results.get((int)i).list);
                merged.minBound[result.index] = result.minBound[result.index];
                merged.maxBound[result.index] = result.maxBound[result.index];
            }
            System.out.println("reduce_function_finished");
            return merged;
        }
    }

    public static class EstimateBoundsOutputData
    implements Serializable {
        public DataCollection dc = null;
        public ArrayList<SampleFactory.Sample> list;
        public double[] minBound;
        public double[] maxBound;
        public int index;

        public EstimateBoundsOutputData(ArrayList<SampleFactory.Sample> list, int index, double[] minBound, double[] maxBound) {
            this.list = list;
            this.minBound = minBound;
            this.maxBound = maxBound;
            this.index = index;
        }

        public void add(String context, File dataStore) {
            ImportMonteCarloData importer = new ImportMonteCarloData();
            try {
                importer.addFile(dataStore);
                if (this.dc == null) {
                    this.dc = importer.getEnsemble();
                } else {
                    this.dc.unifyDataCollections(importer.getEnsemble());
                }
            }
            catch (ImportMonteCarloException imce) {
                imce.printStackTrace();
                System.out.println(imce);
            }
        }
    }

    public static class EstimateBoundsInputData
    implements Serializable {
        public ParallelPostSampling context;
        public int index;

        public EstimateBoundsInputData(ParallelPostSampling context, int index) {
            this.context = context;
            this.index = index;
        }
    }
}

