/*
 * Decompiled with CFR 0.152.
 */
package optas.optimizer.experimental;

import jams.JAMS;
import jams.data.Attribute;
import jams.model.JAMSComponent;
import jams.model.JAMSVarDescription;
import java.util.ArrayList;
import java.util.StringTokenizer;
import optas.optimizer.management.Tools;

public class DistanceToRect
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="file name of optimization process description")
    public Attribute.String regionsLowBounds;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="file name of optimization process description")
    public Attribute.String regionsUpBounds;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="file name of optimization process description")
    public Attribute.String boundaries;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="file name of optimization process description")
    public Attribute.Double[] x;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description="file name of optimization process description")
    public Attribute.Double d;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description="file name of optimization process description")
    public Attribute.Double d_normalized;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="file name of optimization process description")
    public Attribute.Double threshold;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="file name of optimization process description")
    public Attribute.Double y;
    Tools.Rectangle[] rects;
    int n = -1;
    double[] lowBound = null;
    double[] upBound = null;

    public void init() {
        int counter = 0;
        StringTokenizer tokStartValueLB = new StringTokenizer(this.regionsLowBounds.getValue(), ";");
        StringTokenizer tokStartValueUB = new StringTokenizer(this.regionsUpBounds.getValue(), ";");
        ArrayList<double[]> lowBoundList = new ArrayList<double[]>();
        ArrayList<double[]> upBoundList = new ArrayList<double[]>();
        while (tokStartValueLB.hasMoreTokens()) {
            String paramLB = tokStartValueLB.nextToken();
            String paramUB = tokStartValueUB.nextToken();
            paramLB = paramLB.replace("[", "");
            paramLB = paramLB.replace("]", "");
            paramUB = paramUB.replace("[", "");
            paramUB = paramUB.replace("]", "");
            StringTokenizer subTokenizerLB = new StringTokenizer(paramLB, ",");
            StringTokenizer subTokenizerUB = new StringTokenizer(paramUB, ",");
            double[] LBi = new double[subTokenizerLB.countTokens()];
            double[] UBi = new double[subTokenizerUB.countTokens()];
            if (this.n != -1) {
                if (LBi.length != this.n || UBi.length != this.n) {
                    this.getModel().getRuntime().sendHalt("error different lengths .. ");
                    return;
                }
            } else {
                this.n = subTokenizerLB.countTokens();
            }
            int subCounter = 0;
            while (subTokenizerLB.hasMoreTokens()) {
                try {
                    LBi[subCounter] = Double.valueOf(subTokenizerLB.nextToken());
                    UBi[subCounter] = Double.valueOf(subTokenizerUB.nextToken());
                    ++subCounter;
                }
                catch (NumberFormatException e) {
                    this.getModel().getRuntime().sendHalt(JAMS.i18n((String)"Component") + " " + this.getInstanceName() + ": " + JAMS.i18n((String)"unparseable_number"));
                }
            }
            lowBoundList.add(LBi);
            upBoundList.add(UBi);
            ++counter;
            this.rects = new Tools.Rectangle[lowBoundList.size()];
            for (int j = 0; j < lowBoundList.size(); ++j) {
                this.rects[j] = new Tools.Rectangle();
                this.rects[j].lb = new double[this.n];
                this.rects[j].ub = new double[this.n];
                for (int k = 0; k < this.n; ++k) {
                    this.rects[j].lb[k] = ((double[])lowBoundList.get(j))[k];
                    this.rects[j].ub[k] = ((double[])upBoundList.get(j))[k];
                }
            }
        }
        this.lowBound = new double[this.n];
        this.upBound = new double[this.n];
        StringTokenizer tok = new StringTokenizer(this.boundaries.getValue(), ";");
        int i = 0;
        while (tok.hasMoreTokens()) {
            if (i >= this.n) {
                this.getModel().getRuntime().sendHalt(JAMS.i18n((String)"too_many_boundaries"));
                return;
            }
            String key = tok.nextToken();
            key = key.substring(1, key.length() - 1);
            StringTokenizer boundTok = new StringTokenizer(key, ">");
            try {
                this.lowBound[i] = Double.parseDouble(boundTok.nextToken());
                this.upBound[i] = Double.parseDouble(boundTok.nextToken());
            }
            catch (NumberFormatException e) {
                this.getModel().getRuntime().sendHalt(JAMS.i18n((String)"unsupported_number_format_found_for_lower_or_upper_bound"));
                return;
            }
            if (this.upBound[i] <= this.lowBound[i]) {
                this.getModel().getRuntime().sendHalt(JAMS.i18n((String)"Component") + " " + this.getInstanceName() + ": " + JAMS.i18n((String)"upBound_must_be_higher_than_lowBound"));
                return;
            }
            ++i;
        }
    }

    public void run() {
        double d = Double.POSITIVE_INFINITY;
        double[] point = new double[this.n];
        for (int i = 0; i < this.n; ++i) {
            point[i] = this.x[i].getValue();
        }
        for (Tools.Rectangle r : this.rects) {
            d = Math.min(d, Tools.dist(Tools.clamp(r, point), point, this.lowBound, this.upBound));
        }
        if (this.threshold.getValue() < this.y.getValue()) {
            d = d * Math.exp(this.threshold.getValue() / this.y.getValue()) / Math.exp(1.0);
        }
        this.d.setValue(d);
        this.d_normalized.setValue(-d);
    }
}

