/*
 * Decompiled with CFR 0.152.
 */
package optas.optimizer.directsearch;

import Jama.Matrix;
import java.util.Arrays;
import java.util.Random;
import java.util.Vector;
import optas.core.ObjectiveAchievedException;
import optas.core.SampleLimitException;
import optas.optimizer.LinearConstraintDirectPatternSearch;
import optas.optimizer.Optimizer;
import optas.optimizer.directsearch.PatternSearch;
import optas.optimizer.management.SampleFactory;

public class NelderMead
extends PatternSearch {
    @Override
    public SampleFactory.SampleSO step(Optimizer context, SampleFactory.SampleSO[] Simplex, Matrix LinearConstraintMatrixA, Matrix LinearConstraintVectorb, double[] lowBound, double[] upBound) throws SampleLimitException, ObjectiveAchievedException {
        Arrays.sort(Simplex, new SampleFactory.SampleSOComperator(false));
        int n = Simplex.length;
        int m = Simplex[0].x.length;
        double alpha = 1.0;
        double beta = 0.5;
        double[] sb = new double[m];
        double[] sw = new double[m];
        double fb = Simplex[0].f();
        double fw = Simplex[n - 1].f();
        for (int i = 0; i < m; ++i) {
            sb[i] = Simplex[0].x[i];
            sw[i] = Simplex[n - 1].x[i];
        }
        double[] ce = new double[m];
        int i = 0;
        while (i < m) {
            ce[i] = 0.0;
            for (int j = 0; j < n - 1; ++j) {
                int n2 = i;
                ce[n2] = ce[n2] + Simplex[j].x[i];
            }
            int n3 = i++;
            ce[n3] = ce[n3] / (double)(n - 1);
        }
        double[] snew1 = new double[m];
        for (int i2 = 0; i2 < m; ++i2) {
            snew1[i2] = ce[i2] + alpha * (ce[i2] - sw[i2]);
        }
        double[] snew2 = new double[m];
        for (int i3 = 0; i3 < m; ++i3) {
            snew2[i3] = sw[i3] + beta * (ce[i3] - sw[i3]);
        }
        LinearConstraintDirectPatternSearch LCDPS = new LinearConstraintDirectPatternSearch();
        LCDPS.SetLinearConstraints(LinearConstraintMatrixA, LinearConstraintVectorb);
        Matrix P = new Matrix(m, 2);
        for (int i4 = 0; i4 < m; ++i4) {
            P.set(i4, 0, snew1[i4] - Simplex[0].x[i4]);
            P.set(i4, 1, snew2[i4] - Simplex[0].x[i4]);
        }
        Vector<Matrix> P_i = LCDPS.UpdateDirections(Simplex[0], P, 1.0);
        SampleFactory.SampleSO next = super.step(context, Simplex[0], Simplex[n - 1], P_i);
        if (next != null) {
            return next;
        }
        boolean feasible = false;
        if (Generator == null) {
            Generator = new Random();
        }
        double[] x = new double[m];
        int iterCounter = 0;
        while (!feasible) {
            if (iterCounter++ > 10000) {
                return null;
            }
            for (int i5 = 0; i5 < m; ++i5) {
                x[i5] = lowBound[i5] + Generator.nextDouble() * (upBound[i5] - lowBound[i5]);
            }
            feasible = LCDPS.FeasibleDirection(new Matrix(x, m), new Matrix(x, m), 0.0);
        }
        return context.getSampleSO(x);
    }

    @Override
    public SampleFactory.SampleSO search(Optimizer f, Matrix LinearConstraintMatrixA, Matrix LinearConstraintVectorb) {
        return null;
    }
}

