/*
 * Decompiled with CFR 0.152.
 */
package optas.optimizer;

import jams.JAMS;
import jams.data.Attribute;
import jams.data.DefaultDataFactory;
import jams.data.JAMSDouble;
import jams.model.JAMSComponentDescription;
import java.util.Arrays;
import java.util.Vector;
import optas.core.ObjectiveAchievedException;
import optas.core.SampleLimitException;
import optas.optimizer.ArrayColumnComparator;
import optas.optimizer.Optimizer;
import optas.optimizer.OptimizerLibrary;
import optas.optimizer.management.NumericOptimizerParameter;
import optas.optimizer.management.OptimizerDescription;

@JAMSComponentDescription(title="MOCOM Optimization Component", author="Christian Fischer", description="performs multi objective optimization")
public class MOCOM
extends Optimizer {
    public int populationSize = 250;
    int currentCount;
    int s;
    int icall = 0;
    int MaxIter;
    boolean continuousOutput = false;
    long start;
    long end = 0L;
    String[] effNames;

    @Override
    public OptimizerDescription getDescription() {
        OptimizerDescription desc = OptimizerLibrary.getDefaultOptimizerDescription(MOCOM.class.getSimpleName(), MOCOM.class.getName(), 500, false);
        desc.addParameter(new NumericOptimizerParameter("populationSize", JAMS.i18n((String)"size_of_population"), 500.0, 0.0, 100000.0));
        return desc;
    }

    public int getPopulationSize() {
        return this.populationSize;
    }

    public void setPopulationSize(int populationSize) {
        this.populationSize = populationSize;
    }

    public double customRand() {
        return generator.nextDouble();
    }

    private boolean isSampleValid(double[] sample) {
        JAMSDouble[] conv_sample = new JAMSDouble[sample.length];
        for (int i = 0; i < sample.length; ++i) {
            conv_sample[i] = DefaultDataFactory.getDataFactory().createDouble();
            conv_sample[i].setValue(sample[i]);
        }
        return this.isSampleValid((Attribute.Double[])conv_sample);
    }

    private boolean isSampleValid(Attribute.Double[] sample) {
        for (int i = 0; i < this.n; ++i) {
            if (!(sample[i].getValue() < this.lowBound[i]) && !(sample[i].getValue() > this.upBound[i])) continue;
            return false;
        }
        return true;
    }

    public void sort(double[][] x, int col) {
        ArrayColumnComparator comparator = new ArrayColumnComparator(col, false);
        Arrays.sort(x, comparator);
    }

    public int[] randperm(int upto) {
        int i;
        int[] perm = new int[upto];
        int[] freenums = new int[upto];
        for (i = 0; i < upto; ++i) {
            freenums[i] = i + 1;
        }
        for (i = 1; i <= upto; ++i) {
            int num = (int)Math.floor(this.customRand() * (double)(upto + 1 - i) + 1.0);
            perm[i - 1] = freenums[num - 1];
            freenums[num - 1] = freenums[upto - i];
        }
        return perm;
    }

    public double[][] lhsu(double[] xmin, double[] xmax, int nsample) {
        int nvar = xmin.length;
        double[][] s = new double[nsample][nvar];
        for (int j = 0; j < nvar; ++j) {
            int[] idx = this.randperm(nsample);
            for (int i = 0; i < nsample; ++i) {
                double P = ((double)idx[i] - this.customRand()) / (double)nsample;
                s[i][j] = xmin[j] + P * (xmax[j] - xmin[j]);
            }
        }
        return s;
    }

    public double[][] compf(double[][] D) throws SampleLimitException, ObjectiveAchievedException {
        int s = D.length;
        int r = 0;
        if (s == 0) {
            return null;
        }
        r = D[0].length;
        double[][] F = new double[s][];
        for (int i = 0; i < s; ++i) {
            F[i] = this.getSample(D[i]).F();
        }
        return F;
    }

    public int IntMax(int[] R) {
        int RMax = Integer.MIN_VALUE;
        for (int i = 0; i < R.length; ++i) {
            if (RMax >= R[i]) continue;
            RMax = R[i];
        }
        return RMax;
    }

    public Object[] parrank(double[][] ObjVals, int nmbOfObjs) {
        int i;
        int nmbOfIndivs = ObjVals.length;
        Vector[] Dominated = new Vector[nmbOfIndivs];
        Vector Front = new Vector();
        int[] NmbOfFront = new int[nmbOfIndivs];
        int[] NmbOfDominating = new int[nmbOfIndivs];
        for (i = 0; i < nmbOfIndivs; ++i) {
            NmbOfFront[i] = 0;
            NmbOfDominating[i] = 0;
            Dominated[i] = new Vector();
        }
        for (int p = 0; p < nmbOfIndivs; ++p) {
            for (int q = 0; q < nmbOfIndivs; ++q) {
                int k;
                int sumA1 = 0;
                int sumA2 = 0;
                int sumB1 = 0;
                int sumB2 = 0;
                for (k = 0; k < nmbOfObjs; ++k) {
                    if (ObjVals[p][k] <= ObjVals[q][k]) {
                        ++sumA1;
                    }
                    if (!(ObjVals[p][k] < ObjVals[q][k])) continue;
                    ++sumA2;
                }
                for (k = 0; k < nmbOfObjs; ++k) {
                    if (ObjVals[q][k] <= ObjVals[p][k]) {
                        ++sumB1;
                    }
                    if (!(ObjVals[q][k] < ObjVals[p][k])) continue;
                    ++sumB2;
                }
                if (sumA1 == nmbOfObjs && sumA2 > 0) {
                    Dominated[p].addElement(new Integer(q));
                    continue;
                }
                if (sumB1 != nmbOfObjs || sumB2 <= 0) continue;
                int n = p;
                NmbOfDominating[n] = NmbOfDominating[n] + 1;
            }
            if (NmbOfDominating[p] != 0) continue;
            NmbOfFront[p] = 1;
            if (Front.size() == 0) {
                Front.add(new Vector());
            }
            ((Vector)Front.get(0)).add(new Integer(p));
        }
        i = 0;
        while (((Vector)Front.get(i)).size() != 0) {
            Vector<Integer> NextFront = new Vector<Integer>();
            for (int k = 0; k < ((Vector)Front.get(i)).size(); ++k) {
                int p = (Integer)((Vector)Front.get(i)).get(k);
                for (int l = 0; l < Dominated[p].size(); ++l) {
                    int q;
                    int n = q = ((Integer)Dominated[p].get(l)).intValue();
                    NmbOfDominating[n] = NmbOfDominating[n] - 1;
                    if (NmbOfDominating[q] != 0) continue;
                    NmbOfFront[q] = i + 2;
                    NextFront.add(new Integer(q));
                }
            }
            ++i;
            Front.add(NextFront);
        }
        Integer RMax = this.IntMax(NmbOfFront);
        return new Object[]{NmbOfFront, RMax};
    }

    public double[] asswght(int[] R, int RMax, int s) {
        int i;
        double[] P = new double[s];
        double sum = 0.0;
        for (i = 0; i < R.length; ++i) {
            sum += (double)R[i];
        }
        for (i = 0; i < s; ++i) {
            P[i] = (double)(RMax - R[i] + 1) / ((double)(RMax + 1) * (double)s - sum);
        }
        return P;
    }

    public Object[] worst(double[][] D, int n, int[] R, int Rmax) {
        Vector<Integer> Ltmp = new Vector<Integer>();
        for (int i = 0; i < R.length; ++i) {
            if (R[i] != Rmax) continue;
            Ltmp.add(new Integer(i));
        }
        int[] L = new int[Ltmp.size()];
        for (int i = 0; i < Ltmp.size(); ++i) {
            L[i] = (Integer)Ltmp.get(i);
        }
        int nA = L.length;
        double[][] A = new double[nA][n];
        for (int i = 0; i < L.length; ++i) {
            for (int j = 0; j < n; ++j) {
                A[i][j] = D[L[i]][j];
            }
        }
        return new Object[]{A, L, new Integer(nA)};
    }

    public Object[] choose(double[] P, double[][] D, double[][] F, int[] Rank, int n) {
        double[] sP = new double[P.length];
        double sum = 0.0;
        int counter = 0;
        int[] Selected = new int[n];
        double[][] S1 = new double[n][D[0].length];
        double[][] F1 = new double[n][F[0].length];
        int[] R1 = new int[n];
        for (int i = 0; i < P.length; ++i) {
            sP[i] = sum += P[i];
        }
        while (counter < n) {
            int j;
            int R = -1;
            boolean multipleOccurrences = false;
            block2: do {
                int i;
                multipleOccurrences = false;
                double U = this.customRand();
                for (i = 0; i < P.length; ++i) {
                    if (!(U < sP[i])) continue;
                    R = i;
                    break;
                }
                for (i = 0; i < counter; ++i) {
                    if (Selected[i] != R) continue;
                    multipleOccurrences = true;
                    continue block2;
                }
            } while (multipleOccurrences);
            Selected[counter] = R;
            for (j = 0; j < D[0].length; ++j) {
                S1[counter][j] = D[R][j];
            }
            for (j = 0; j < F[0].length; ++j) {
                F1[counter][j] = F[R][j];
            }
            R1[counter] = Rank[R];
            ++counter;
        }
        return new Object[]{S1, F1, R1};
    }

    public Object[] mosim(double[][] S, double[][] SF, int[] SR, double[] minn, double[] maxn) throws SampleLimitException, ObjectiveAchievedException {
        int i;
        double[] Fnew;
        double[] Snew;
        int lenS = S[0].length;
        int lenSF = SF[0].length;
        int e = S.length;
        int r = lenS + lenSF + 1;
        double[][] Simplex = new double[S.length][lenS + lenSF + 1];
        for (int i2 = 0; i2 < S.length; ++i2) {
            int j;
            for (j = 0; j < lenS; ++j) {
                Simplex[i2][j] = S[i2][j];
            }
            for (j = 0; j < lenSF; ++j) {
                Simplex[i2][lenS + j] = SF[i2][j];
            }
            Simplex[i2][lenS + lenSF] = SR[i2];
        }
        this.sort(Simplex, r - 1);
        double[] Fw = new double[lenSF];
        for (int i3 = 0; i3 < lenSF; ++i3) {
            Fw[i3] = Simplex[Simplex.length - 1][this.n + i3];
        }
        double[] Sw = new double[this.n];
        for (int i4 = 0; i4 < this.n; ++i4) {
            Sw[i4] = Simplex[Simplex.length - 1][i4];
        }
        double[] Sg = new double[this.n];
        int i5 = 0;
        while (i5 < this.n) {
            Sg[i5] = 0.0;
            for (int j = 0; j < Simplex.length - 1; ++j) {
                int n = i5;
                Sg[n] = Sg[n] + Simplex[j][i5];
            }
            int n = i5++;
            Sg[n] = Sg[n] / (double)(Simplex.length - 1);
        }
        double[] Sref = new double[this.n];
        for (int i6 = 0; i6 < this.n; ++i6) {
            Sref[i6] = 2.0 * Sg[i6] - Sw[i6];
        }
        boolean accept = this.isSampleValid(Sref);
        if (!accept) {
            double[] Scon = new double[this.n];
            for (int i7 = 0; i7 < this.n; ++i7) {
                Scon[i7] = 0.5 * Sg[i7] + 0.5 * Sw[i7];
            }
            accept = this.isSampleValid(Scon);
            while (!accept) {
                double[][] newpar = this.lhsu(this.lowBound, this.upBound, 1);
                Scon = newpar[0];
                accept = this.isSampleValid(Scon);
            }
            double[] Fcon = this.getSample(Scon).F();
            Snew = Scon;
            Fnew = Fcon;
        } else {
            double[] Fref = this.getSample(Sref).F();
            double[][] SimplexTmp = new double[Simplex.length][lenSF];
            for (int j = 0; j < lenSF; ++j) {
                for (int i8 = 0; i8 < Simplex.length - 1; ++i8) {
                    SimplexTmp[i8][j] = Simplex[i8][this.n + j];
                }
                SimplexTmp[Simplex.length - 1][j] = Fref[j];
            }
            Object[] ret = this.parrank(SimplexTmp, this.m);
            int[] Rref = (int[])ret[0];
            int Rrefmax = Integer.MIN_VALUE;
            for (int i9 = 0; i9 < Rref.length - 1; ++i9) {
                if (Rref[i9] <= Rrefmax) continue;
                Rrefmax = Rref[i9];
            }
            if (Rref[Rref.length - 1] <= Rrefmax) {
                Snew = Sref;
                Fnew = Fref;
            } else {
                double[] Scon = new double[this.n];
                for (int i10 = 0; i10 < this.n; ++i10) {
                    Scon[i10] = 0.5 * Sg[i10] + 0.5 * Sw[i10];
                }
                accept = this.isSampleValid(Scon);
                while (!accept) {
                    double[][] newpar = this.lhsu(this.lowBound, this.upBound, 1);
                    Scon = newpar[0];
                    accept = this.isSampleValid(Scon);
                }
                double[] Fcon = this.getSample(Scon).F();
                Snew = Scon;
                Fnew = Fcon;
            }
        }
        for (i = 0; i < this.n; ++i) {
            S[S.length - 1][i] = Snew[i];
        }
        for (i = 0; i < SF[0].length; ++i) {
            SF[SF.length - 1][i] = Fnew[i];
        }
        return new Object[]{S, SF};
    }

    public Object[] update(double[][] D, int[] L, double[][] A, int n, int nA, double[][] F, double[][] FA) {
        for (int i = 0; i < nA; ++i) {
            int j;
            for (j = 0; j < n; ++j) {
                D[L[i]][j] = A[i][j];
            }
            for (j = 0; j < FA[0].length; ++j) {
                F[L[i]][j] = FA[i][j];
            }
        }
        return new Object[]{D, F};
    }

    public Object[] mocom(int s, double[] minn, double[] maxn, int MaxIter) throws SampleLimitException, ObjectiveAchievedException {
        double[][] D = this.lhsu(minn, maxn, s);
        double[][] F = this.compf(D);
        int nobj = F[0].length;
        Object[] ret = this.parrank(F, nobj);
        int[] R = (int[])ret[0];
        int Rmax = (Integer)ret[1];
        int loopcounter = 1;
        while (Rmax > 1) {
            int i;
            int c;
            double[] P = this.asswght(R, Rmax, s);
            ret = this.worst(D, this.n, R, Rmax);
            double[][] A = (double[][])ret[0];
            int[] L = (int[])ret[1];
            int nA = (Integer)ret[2];
            ret = this.choose(P, D, F, R, this.n);
            double[][] S1 = (double[][])ret[0];
            double[][] F1 = (double[][])ret[1];
            int[] R1 = (int[])ret[2];
            double[][] FA = new double[nA][F[0].length];
            for (int j = 0; j < nA; ++j) {
                int c1;
                int c12;
                if (S1.length != F1.length || F1.length != R1.length) {
                    this.log(JAMS.i18n((String)"interner_Fehler"));
                }
                double[][] S = new double[S1.length + 1][S1[0].length];
                double[][] SF = new double[F1.length + 1][F1[0].length];
                int[] SR = new int[R1.length + 1];
                for (c12 = 0; c12 < S1.length; ++c12) {
                    int c2;
                    for (c2 = 0; c2 < S1[0].length; ++c2) {
                        S[c12][c2] = S1[c12][c2];
                    }
                    for (c2 = 0; c2 < F1[0].length; ++c2) {
                        SF[c12][c2] = F1[c12][c2];
                    }
                    SR[c12] = R1[c12];
                }
                for (c12 = 0; c12 < S1[0].length; ++c12) {
                    S[S1.length][c12] = A[j][c12];
                }
                for (c12 = 0; c12 < F1[0].length; ++c12) {
                    SF[F1.length][c12] = F[L[j]][c12];
                }
                SR[R1.length] = R[L[j]];
                Object[] res = this.mosim(S, SF, SR, minn, maxn);
                S = (double[][])res[0];
                SF = (double[][])res[1];
                for (c1 = 0; c1 < this.n; ++c1) {
                    A[j][c1] = S[S.length - 1][c1];
                }
                for (c1 = 0; c1 < FA[j].length; ++c1) {
                    FA[j][c1] = SF[SF.length - 1][c1];
                }
            }
            ret = this.update(D, L, A, this.n, nA, F, FA);
            D = (double[][])ret[0];
            F = (double[][])ret[1];
            ret = this.parrank(F, nobj);
            R = (int[])ret[0];
            Rmax = (Integer)ret[1];
            double[][] currentResult = new double[s][this.n + this.m + 1];
            for (int i2 = 0; i2 < s; ++i2) {
                int j;
                for (j = 0; j < this.n; ++j) {
                    currentResult[i2][j] = D[i2][j];
                }
                for (j = 0; j < this.m; ++j) {
                    currentResult[i2][this.n + j] = F[i2][j];
                }
                currentResult[i2][this.n + this.m] = R[i2];
            }
            this.sort(currentResult, this.n + this.m);
            if (this.continuousOutput) {
                for (c = 0; c < s && loopcounter % 10 == 0; ++c) {
                    int i3;
                    String out = "";
                    out = out + "" + currentResult[c][this.n + this.m] + "\t";
                    for (i3 = 0; i3 < this.n; ++i3) {
                        out = out + "" + currentResult[c][i3] + "\t";
                    }
                    for (i3 = 0; i3 < this.m; ++i3) {
                        out = out + "" + currentResult[c][this.n + i3] + "\t";
                    }
                    this.log(out);
                }
            }
            if (MaxIter < ++loopcounter) {
                int i4;
                this.log("********************************************");
                this.log("---------->OPTIMIZATION STOP<---------------");
                this.log(JAMS.i18n((String)"MAXIMUM_NUMBER_OF_LOOPS_HAS_REACHED"));
                this.log("********************************************");
                c = 0;
                String out = JAMS.i18n((String)"Rank") + "\t";
                for (i4 = 0; i4 < this.n; ++i4) {
                }
                for (i4 = 0; i4 < this.m; ++i4) {
                }
                this.log(out);
                while (c < s) {
                    out = "" + currentResult[c][this.n + this.m] + "\t";
                    for (i4 = 0; i4 < this.n; ++i4) {
                        out = out + "" + currentResult[c][i4] + "\t";
                    }
                    for (i4 = 0; i4 < this.m; ++i4) {
                        out = out + "" + currentResult[c][this.n + i4] + "\t";
                    }
                    this.log(out);
                    ++c;
                }
                c = 0;
                this.log(JAMS.i18n((String)"Number of model runs: ") + this.icall);
                out = JAMS.i18n((String)"Rank") + "\t";
                for (i4 = 0; i4 < this.n; ++i4) {
                }
                for (i4 = 0; i4 < this.m; ++i4) {
                    out = out + this.effNames[i4] + "\t";
                }
                this.log(out);
                while (c < s) {
                    out = "" + currentResult[c][this.n + this.m] + "\t";
                    for (i4 = 0; i4 < this.n; ++i4) {
                        out = out + "" + currentResult[c][i4] + "\t";
                    }
                    for (i4 = 0; i4 < this.m; ++i4) {
                        out = out + "" + currentResult[c][this.n + i4] + "\t";
                    }
                    this.log(out);
                    ++c;
                }
                break;
            }
            if (Rmax > 1) continue;
            System.out.println("********************************************");
            System.out.println("---------->OPTIMIZATION STOP<---------------");
            this.log(JAMS.i18n((String)"SUCCESSFUL"));
            System.out.println("********************************************");
            c = 0;
            String out = JAMS.i18n((String)"Rank") + "\t";
            for (i = 0; i < this.n; ++i) {
            }
            for (i = 0; i < this.m; ++i) {
                out = out + this.effNames[i] + "\t";
            }
            this.log(out);
            try {
                while (c < s) {
                    out = "" + currentResult[c][this.n + this.m] + "\t";
                    for (i = 0; i < this.n; ++i) {
                        out = out + "" + currentResult[c][i] + "\t";
                    }
                    for (i = 0; i < this.m; ++i) {
                        out = out + "" + currentResult[c][this.n + i] + "\t";
                    }
                    this.log(out);
                    ++c;
                }
                c = 0;
                this.log(JAMS.i18n((String)"Number of model runs: ") + this.icall);
                out = JAMS.i18n((String)"Rank") + "\t";
                for (i = 0; i < this.n; ++i) {
                }
                for (i = 0; i < this.m; ++i) {
                    out = out + this.effNames[i] + "\t";
                }
                this.log(out);
                while (c < s) {
                    out = "" + currentResult[c][this.n + this.m] + "\t";
                    for (i = 0; i < this.n; ++i) {
                        out = out + "" + currentResult[c][i] + "\t";
                    }
                    for (i = 0; i < this.m; ++i) {
                        out = out + "" + currentResult[c][this.n + i] + "\t";
                    }
                    ++c;
                    this.log(out);
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        return new Object[]{D, F, R, new Integer(Rmax)};
    }

    @Override
    public void procedure() throws SampleLimitException, ObjectiveAchievedException {
        this.s = this.populationSize;
        if (this.s <= 0) {
            this.log(JAMS.i18n((String)"Component") + " " + JAMS.i18n((String)"populationsize_is_zero"));
        }
        Object[] ret = this.mocom(this.s, this.lowBound, this.upBound, (int)this.getMaxn());
        this.log(JAMS.i18n((String)"Mocom_has_finished"));
    }
}

