/*
 * Decompiled with CFR 0.152.
 */
package optas.optimizer;

import Jama.Matrix;
import java.util.Vector;
import optas.optimizer.management.SampleFactory;

public class LinearConstraintDirectPatternSearch {
    Matrix A;
    Matrix b;
    int n;

    public void SetLinearConstraints(Matrix A, Matrix b) {
        this.A = A;
        this.b = b;
        this.n = A.getColumnDimension();
    }

    public boolean FeasibleDirection(Matrix x, Matrix d, double delta) {
        Matrix b_star = this.A.times(x.plus(d.times(delta)));
        for (int k = 0; k < this.A.getRowDimension(); ++k) {
            if (!(b_star.get(k, 0) > this.b.get(k, 0))) continue;
            return false;
        }
        return true;
    }

    public Vector<Matrix> UpdateDirections(SampleFactory.SampleSO x, Matrix P, double delta) {
        Vector<Matrix> P_k = new Vector<Matrix>();
        Matrix mx = new Matrix(x.x, x.x.length);
        for (int i = 0; i < P.getColumnDimension(); ++i) {
            boolean isFeasible = true;
            Matrix P_i = P.getMatrix(0, P.getRowDimension() - 1, i, i);
            if (!this.FeasibleDirection(mx, P_i, delta)) continue;
            P_k.add(P_i.times(delta));
        }
        return P_k;
    }

    public void search(SampleFactory.SampleSO Iterate) {
        SampleFactory.SampleSO nextIterate = Iterate;
        boolean successSearch = false;
    }
}

