/*
 * Decompiled with CFR 0.152.
 */
package optas.optimizer;

import jams.JAMS;
import java.util.ArrayList;
import java.util.Arrays;
import optas.core.ObjectiveAchievedException;
import optas.core.SampleLimitException;
import optas.optimizer.ArrayColumnComparator;
import optas.optimizer.Optimizer;
import optas.optimizer.OptimizerLibrary;
import optas.optimizer.management.OptimizerDescription;
import optas.optimizer.management.SampleFactory;

public class Direct
extends Optimizer {
    ArrayList<SampleFactory.SampleSO> Q = new ArrayList();
    int[][] lengths = null;
    double[] fc = null;
    double[][] c = null;
    double[] szes = null;
    double[] l_thirds = null;
    int maxdeep = 100;
    double ep = 1.0E-4;

    @Override
    public OptimizerDescription getDescription() {
        return OptimizerLibrary.getDefaultOptimizerDescription(Direct.class.getSimpleName(), Direct.class.getName(), 500, false);
    }

    private double[] reTransform(double[] in) {
        double[] x = new double[this.n];
        for (int j = 0; j < this.n; ++j) {
            x[j] = in[j] * (this.upBound[j] - this.lowBound[j]) + this.lowBound[j];
        }
        return x;
    }

    @Override
    protected boolean checkConfiguration() {
        return super.checkConfiguration();
    }

    @Override
    public boolean init() {
        int i;
        this.log("Initialise DIRECT Optimization Routing!");
        if (!super.init()) {
            return false;
        }
        if (this.x0 != null) {
            this.log(JAMS.i18n((String)"start_value_not_supported_by_branch_and_bound"));
        }
        int K = this.getMaximumIterationCount();
        this.lengths = new int[2 * K][this.n];
        this.c = new double[2 * K][this.n];
        this.fc = new double[2 * K];
        this.szes = new double[2 * K];
        this.Q.clear();
        this.l_thirds = new double[this.maxdeep];
        this.l_thirds[0] = 0.3333333333333333;
        for (i = 1; i < this.maxdeep; ++i) {
            this.l_thirds[i] = this.l_thirds[i - 1] / 3.0;
        }
        for (i = 0; i < this.n; ++i) {
            this.lengths[0][i] = 0;
            this.c[0][i] = 0.5;
        }
        this.szes[0] = 1.0;
        return true;
    }

    @Override
    protected void procedure() throws SampleLimitException, ObjectiveAchievedException {
        this.log("Starting DIRECT Optimization Routing!");
        SampleFactory.SampleSO s = this.getSampleSO(this.reTransform(this.c[0]));
        this.fc[0] = s.f();
        this.Q.add(s);
        double minval = this.fc[0];
        double[] xatmin = new double[this.n];
        xatmin = this.reTransform(this.c[0]);
        int iter = 0;
        while ((double)this.Q.size() < this.maxn) {
            int i;
            ArrayList<Integer> final_pos = this.find_po(minval);
            if (final_pos.isEmpty()) {
                this.log("Error: no dividing position!");
            }
            for (i = 0; i < final_pos.size(); ++i) {
                this.DIRDivide(final_pos.get(i));
            }
            for (i = 0; i < this.Q.size(); ++i) {
                if (!(this.fc[i] < minval)) continue;
                minval = this.fc[i];
                xatmin = this.reTransform(this.c[i]);
            }
            this.log("Iter:\t" + iter++);
            this.log("\tfmin:\t" + minval);
            this.log("\tfn_evals:\t" + this.Q.size());
            this.log("\tmin_pos:\t[");
            for (int j = 0; j < this.n; ++j) {
                this.log(xatmin[j] + ",");
            }
            this.log("]");
        }
        this.log("Finished DIRECT Optimization Routing!");
    }

    ArrayList<Integer> find_po(double minval) {
        int i;
        ArrayList<Integer> hull = new ArrayList<Integer>();
        int[] sum_lengths = new int[this.Q.size()];
        int tmp_max = Integer.MIN_VALUE;
        for (i = 0; i < this.Q.size(); ++i) {
            for (int j = 0; j < this.n; ++j) {
                int n = i;
                sum_lengths[n] = sum_lengths[n] + this.lengths[i][j];
            }
            tmp_max = Math.max(sum_lengths[i], tmp_max);
        }
        for (i = 1; i <= tmp_max + 1; ++i) {
            int k;
            double tmp_n = Double.MAX_VALUE;
            int min_index = -1;
            for (k = 0; k < sum_lengths.length; ++k) {
                if (sum_lengths[k] != i - 1 || !(this.fc[k] < tmp_n)) continue;
                tmp_n = this.fc[k];
                min_index = k;
            }
            if (min_index == -1) continue;
            hull.add(min_index);
            for (k = 0; k < sum_lengths.length; ++k) {
                if (sum_lengths[k] != i - 1 || !(this.fc[k] <= tmp_n + 1.0E-13) || k == min_index) continue;
                hull.add(k);
            }
        }
        double[][] bounds = this.calc_bounds(hull);
        ArrayList<Integer> final_pos = new ArrayList<Integer>();
        for (int i2 = 0; i2 < bounds.length; ++i2) {
            if (bounds[i2][0] - bounds[i2][1] > 0.0) continue;
            if (minval != 0.0) {
                if (!((minval - this.fc[hull.get(i2)]) / Math.abs(minval) + this.szes[hull.get(i2)] * bounds[i2][1] / Math.abs(minval) >= this.ep)) continue;
                final_pos.add(hull.get(i2));
                continue;
            }
            if (!(this.fc[hull.get(i2)] + this.szes[hull.get(i2)] * bounds[i2][1] <= 0.0)) continue;
            final_pos.add(hull.get(i2));
        }
        return final_pos;
    }

    double[][] calc_bounds(ArrayList<Integer> hull) {
        double[][] bound = new double[hull.size()][2];
        for (int i = 0; i < hull.size(); ++i) {
            double[] sum1 = new double[hull.size()];
            double sum2 = 0.0;
            bound[i][0] = Double.MIN_VALUE;
            bound[i][1] = Double.MAX_VALUE;
            for (int k = 0; k < this.n; ++k) {
                for (int j = 0; j < hull.size(); ++j) {
                    int n = j;
                    sum1[n] = sum1[n] + (double)this.lengths[hull.get(j)][k];
                }
                sum2 += (double)this.lengths[hull.get(i)][k];
            }
            for (int j = 0; j < sum1.length; ++j) {
                double tmp_f = this.fc[hull.get(j)];
                double tmp_szes = this.szes[hull.get(j)];
                if (sum1[j] > sum2) {
                    bound[i][0] = Math.max((this.fc[hull.get(i)] - tmp_f) / (this.szes[hull.get(i)] - tmp_szes), bound[i][0]);
                }
                if (!(sum1[j] < sum2)) continue;
                bound[i][1] = Math.min((this.fc[hull.get(i)] - tmp_f) / (this.szes[hull.get(i)] - tmp_szes), bound[i][1]);
            }
        }
        return bound;
    }

    void DIRDivide(int index) throws SampleLimitException, ObjectiveAchievedException {
        int i;
        int[] li = this.lengths[index];
        double[] oldc = this.c[index];
        int oldfcncounter = this.Q.size();
        int biggy = Integer.MAX_VALUE;
        ArrayList<Integer> ls = new ArrayList<Integer>();
        for (int i2 = 0; i2 < li.length; ++i2) {
            if (li[i2] < biggy) {
                biggy = li[i2];
                ls.clear();
                ls.add(new Integer(i2));
                continue;
            }
            if (li[i2] != biggy) continue;
            ls.add(new Integer(i2));
        }
        double delta = this.l_thirds[biggy];
        double[][] newc_left = new double[ls.size()][oldc.length];
        double[][] newc_right = new double[ls.size()][oldc.length];
        double[] f_left = new double[ls.size()];
        double[] f_right = new double[ls.size()];
        for (i = 0; i < oldc.length; ++i) {
            for (int j = 0; j < ls.size(); ++j) {
                newc_left[j][i] = oldc[i];
                newc_right[j][i] = oldc[i];
                f_left[j] = 0.0;
                f_right[j] = 0.0;
            }
        }
        for (i = 0; i < ls.size(); ++i) {
            int lsi = (Integer)ls.get(i);
            double[] dArray = newc_left[i];
            int n = lsi;
            dArray[n] = dArray[n] - delta;
            double[] dArray2 = newc_right[i];
            int n2 = lsi;
            dArray2[n2] = dArray2[n2] + delta;
            double[] x1 = new double[this.n];
            double[] x2 = new double[this.n];
            x1 = this.reTransform(newc_left[i]);
            x2 = this.reTransform(newc_right[i]);
            SampleFactory.SampleSO s1 = this.getSampleSO(x1);
            SampleFactory.SampleSO s2 = this.getSampleSO(x2);
            f_left[i] = s1.f();
            f_right[i] = s2.f();
            this.Q.add(s1);
            this.Q.add(s2);
        }
        double[][] w = new double[ls.size()][3];
        for (int i3 = 0; i3 < ls.size(); ++i3) {
            w[i3][0] = Math.min(f_left[i3], f_right[i3]);
            w[i3][1] = ((Integer)ls.get(i3)).intValue();
            w[i3][2] = i3;
        }
        ArrayColumnComparator comparator = new ArrayColumnComparator(0, false);
        Arrays.sort(w, comparator);
        for (int i4 = 0; i4 < ls.size(); ++i4) {
            int j;
            int newleftindex = oldfcncounter + 2 * i4;
            int newrightindex = oldfcncounter + 2 * i4 + 1;
            int[] oldrect = this.lengths[index];
            for (j = 0; j < this.n; ++j) {
                this.lengths[newleftindex][j] = oldrect[j];
                this.lengths[newrightindex][j] = oldrect[j];
            }
            this.lengths[newleftindex][((Integer)ls.get((int)((int)w[i4][2]))).intValue()] = this.lengths[index][(Integer)ls.get((int)w[i4][2])] + 1;
            this.lengths[newrightindex][((Integer)ls.get((int)((int)w[i4][2]))).intValue()] = this.lengths[index][(Integer)ls.get((int)w[i4][2])] + 1;
            this.lengths[index][((Integer)ls.get((int)((int)w[i4][2]))).intValue()] = this.lengths[index][(Integer)ls.get((int)w[i4][2])] + 1;
            this.c[newleftindex] = newc_left[(int)w[i4][2]];
            this.c[newrightindex] = newc_right[(int)w[i4][2]];
            this.fc[newleftindex] = f_left[(int)w[i4][2]];
            this.fc[newrightindex] = f_right[(int)w[i4][2]];
            this.szes[newleftindex] = 0.0;
            this.szes[newrightindex] = 0.0;
            for (j = 0; j < this.n; ++j) {
                int n = newleftindex;
                this.szes[n] = this.szes[n] + Math.pow(0.3333333333333333, 2.0 * (double)this.lengths[newleftindex][j]);
                int n3 = newrightindex;
                this.szes[n3] = this.szes[n3] + Math.pow(0.3333333333333333, 2.0 * (double)this.lengths[newrightindex][j]);
            }
            this.szes[newleftindex] = 0.5 * Math.sqrt(this.szes[newleftindex]);
            this.szes[newrightindex] = 0.5 * Math.sqrt(this.szes[newrightindex]);
        }
        this.szes[index] = 0.0;
        for (int j = 0; j < this.n; ++j) {
            int n = index;
            this.szes[n] = this.szes[n] + Math.pow(0.3333333333333333, 2.0 * (double)this.lengths[index][j]);
        }
        this.szes[index] = 0.5 * Math.sqrt(this.szes[index]);
    }

    private static double gauss2d(double[] mu, double[] sigma, double[] x) {
        double exp = (x[0] - mu[0]) * (x[0] - mu[0]) / (2.0 * sigma[0]) + (x[1] - mu[1]) * (x[1] - mu[1]) / (2.0 * sigma[0]);
        return Math.exp(-exp);
    }
}

