/*
 * Decompiled with CFR 0.152.
 */
package optas.optimizer;

import Jama.CholeskyDecomposition;
import Jama.Matrix;
import cern.colt.list.DoubleArrayList;
import cern.jet.stat.Descriptive;
import jams.JAMS;
import java.util.Arrays;
import optas.core.AbstractFunction;
import optas.core.ObjectiveAchievedException;
import optas.core.SampleLimitException;
import optas.optimizer.Multrnd;
import optas.optimizer.Optimizer;
import optas.optimizer.OptimizerLibrary;
import optas.optimizer.management.BooleanOptimizerParameter;
import optas.optimizer.management.NumericOptimizerParameter;
import optas.optimizer.management.OptimizerDescription;
import optas.optimizer.management.SampleFactory;
import optas.test.LeafRiverExample;
import umontreal.iro.lecuyer.randvar.NormalGen;
import umontreal.iro.lecuyer.rng.MRG32k3a;
import umontreal.iro.lecuyer.rng.RandomPermutation;
import umontreal.iro.lecuyer.rng.RandomStream;
import umontreal.iro.lecuyer.util.Num;

public class DREAM
extends Optimizer {
    private int nChains = -1;
    private int nCR = -1;
    private int DEpairs = -1;
    private int MCMCsteps = -1;
    private double MCMCeps = Double.NaN;
    public boolean transformObjectiveIntoLogLikelihood = true;
    public double sigma = 1.0;
    private double gamma = 0.0;
    private double MCMCPar_n = Double.NaN;
    private double MCMCPar_seq = Double.NaN;
    private double MCMCPar_ndraw = Double.NaN;
    private double MCMCPar_nCR = Double.NaN;
    private double MCMCPar_Gamma = Double.NaN;
    private double MCMCPar_DEpairs = Double.NaN;
    private double MCMCPar_steps = Double.NaN;
    private double MCMCPar_eps = Double.NaN;
    private String MCMCPar_outlierTest = "IQR_test";
    private String Extra_pCR = "Update";
    private String Extra_reduced_sample_collection;
    private double[] ParRange_minn;
    private double[] ParRange_maxn;
    private String Extra_BoundHandling;
    private String Extra_save_in_memory = "Yes";
    private String Extra_DR = "No";
    private double Extra_DRscale;
    private double[][] hist_logp;
    private int int_MCMCPar_DEpairs;
    private int int_MCMCPar_n;
    private int int_MCMCPar_seq;
    private int int_MCMCPar_steps;
    private double[][] x;
    private double[][] X;
    private double[] log_p_CD;
    private double[][] p_CD;
    private double[][][] sequences;
    private double[][][] seq_x_gel;
    private double[][] output_CR;
    private double[] pCR;
    private int Iter;
    private int dim1_seq_gel;
    private int dim2_seq_gel;
    private int dim3_seq_gel;
    private int iloc;
    private int teller;
    private int new_teller;
    private double[][] x_old;
    private double[] p_old;
    private double[] log_p_old;
    private double[][] CR;
    private int[] DEversion;
    private int gen_number;
    private double[][] Table_JumpRate;
    private double[][] x_new;
    private double[][] newgen;
    private int int_MCMCPar_nCR;
    private double[] delta_tot;
    private int counter;
    private double[][] output_AR;
    private double[] accept;
    private int int_MCMCPar_ndraw;
    private double[] lCR_out_AdaptpCR;
    private double[] pCR_out_AdaptpCR;
    private double[] lCR;
    private int aggiorna_outlier;
    private double[][] output_outlier;
    private double[][] output_R_stat;
    RandomStream randomstream;

    public void setNumberOfMarkovChains(int MCMCPar_seq) {
        this.nChains = MCMCPar_seq;
    }

    public int getNumberOfMarkovChains() {
        return this.nChains;
    }

    public void setCrossoverValue(int nCR) {
        this.nCR = nCR;
    }

    public double getCrossoverValue() {
        return this.nCR;
    }

    public void setDEPairs(int DEpairs) {
        this.DEpairs = DEpairs;
    }

    public int getDEPairs() {
        return this.DEpairs;
    }

    public void setMCMCsteps(int MCMC_steps) {
        this.MCMCsteps = MCMC_steps;
    }

    public int getsetMCMCsteps() {
        return this.MCMCsteps;
    }

    public void setMCMCeps(double eps) {
        this.MCMCeps = eps;
    }

    public double getMCMCeps() {
        return this.MCMCeps;
    }

    public void setTransformObjectiveIntoLogLikelihood(boolean transformObjectiveIntoLogLikelihood) {
        this.transformObjectiveIntoLogLikelihood = transformObjectiveIntoLogLikelihood;
    }

    public boolean isTransformObjectiveIntoLogLikelihood() {
        return this.transformObjectiveIntoLogLikelihood;
    }

    public void setSigma(double sigma) {
        this.sigma = sigma;
    }

    public double getSigma() {
        return this.sigma;
    }

    public void setGamma(double gamma) {
        this.gamma = gamma;
    }

    public double getGamma() {
        return this.gamma;
    }

    @Override
    public OptimizerDescription getDescription() {
        OptimizerDescription desc = OptimizerLibrary.getDefaultOptimizerDescription(DREAM.class.getSimpleName(), DREAM.class.getName(), 500, false);
        desc.addParameter(new NumericOptimizerParameter("nChains", JAMS.i18n((String)"number_of_Monte_Carlo_Markov_Chains._May_be_choosen_as_n"), 3.0, 2.0, 100.0));
        desc.addParameter(new NumericOptimizerParameter("nCr", JAMS.i18n((String)"Crossover_values_used_to_generate_proposals_(geometric_series)"), 3.0, 1.0, 100.0));
        desc.addParameter(new NumericOptimizerParameter("DEpairs", JAMS.i18n((String)"Pairs_of_differential_evolution"), 1.0, 1.0, 100.0));
        desc.addParameter(new NumericOptimizerParameter("gamma", JAMS.i18n((String)"Curtosis_parameter"), 0.0, 0.0, 1.0));
        desc.addParameter(new NumericOptimizerParameter("sigma", JAMS.i18n((String)"Uncertainty_Parameter_Of_Objective_Function"), 0.1, 0.0, 1000.0));
        desc.addParameter(new NumericOptimizerParameter("MCMCsteps", JAMS.i18n((String)"number_of_steps_in_sem"), 10.0, 1.0, 1000.0));
        desc.addParameter(new NumericOptimizerParameter("MCMCeps", JAMS.i18n((String)"Random_error_for_ergodicity"), 0.2, 0.0, 10.0));
        desc.addParameter(new BooleanOptimizerParameter("transformObjectiveIntoLogLikelihood", JAMS.i18n((String)"Transform_Objective_Into_Log_Likelihood"), true));
        return desc;
    }

    @Override
    public boolean init() {
        super.init();
        this.MCMCPar_n = Double.NaN;
        this.MCMCPar_seq = Double.NaN;
        this.MCMCPar_ndraw = Double.NaN;
        this.MCMCPar_nCR = Double.NaN;
        this.MCMCPar_Gamma = Double.NaN;
        this.MCMCPar_DEpairs = Double.NaN;
        this.MCMCPar_steps = Double.NaN;
        this.MCMCPar_eps = Double.NaN;
        this.MCMCPar_outlierTest = "IQR_test";
        this.Extra_pCR = "Update";
        this.Extra_reduced_sample_collection = "No";
        this.Extra_BoundHandling = "Reflect";
        this.Extra_save_in_memory = "Yes";
        this.Extra_DR = "No";
        this.Extra_DRscale = 10.0;
        this.hist_logp = null;
        this.int_MCMCPar_DEpairs = -1;
        this.int_MCMCPar_n = -1;
        this.int_MCMCPar_seq = -1;
        this.int_MCMCPar_steps = -1;
        this.x = null;
        this.X = null;
        this.log_p_CD = null;
        this.p_CD = null;
        this.sequences = null;
        this.seq_x_gel = null;
        this.output_CR = null;
        this.pCR = null;
        this.Iter = 0;
        this.dim1_seq_gel = 0;
        this.dim2_seq_gel = 0;
        this.dim3_seq_gel = 0;
        this.iloc = 0;
        this.teller = 0;
        this.new_teller = 0;
        this.x_old = null;
        this.p_old = null;
        this.log_p_old = null;
        this.CR = null;
        this.DEversion = null;
        this.gen_number = 0;
        this.Table_JumpRate = null;
        this.x_new = null;
        this.newgen = null;
        this.int_MCMCPar_nCR = 0;
        this.delta_tot = null;
        this.counter = 0;
        this.output_AR = null;
        this.accept = null;
        this.int_MCMCPar_ndraw = 0;
        this.lCR_out_AdaptpCR = null;
        this.pCR_out_AdaptpCR = null;
        this.lCR = null;
        this.aggiorna_outlier = 0;
        this.output_outlier = null;
        this.output_R_stat = null;
        this.nChains = this.n;
        if (this.nCR == -1) {
            this.nCR = 3;
        }
        if (this.MCMCsteps == -1) {
            this.MCMCsteps = 10;
        }
        if (this.DEpairs == -1) {
            this.DEpairs = 1;
        }
        if (this.nChains < 2 * this.DEpairs + 1) {
            this.nChains = 2 * this.DEpairs + 1;
        }
        if (Double.isNaN(this.MCMCeps)) {
            this.MCMCeps = 0.2;
        }
        this.MCMCPar_nCR = this.nCR;
        this.MCMCPar_steps = this.MCMCsteps;
        this.MCMCPar_seq = this.nChains;
        this.MCMCPar_DEpairs = this.DEpairs;
        this.MCMCPar_eps = this.MCMCeps;
        this.MCMCPar_Gamma = this.gamma;
        this.MCMCPar_n = this.getFunction().getInputDimension();
        this.MCMCPar_ndraw = this.getMaxn();
        this.ParRange_minn = new double[this.n];
        this.ParRange_maxn = new double[this.n];
        for (int i = 0; i < this.n; ++i) {
            this.ParRange_minn[i] = this.getFunction().getRange()[i][0];
            this.ParRange_maxn[i] = this.getFunction().getRange()[i][1];
        }
        this.randomstream = new MRG32k3a();
        this.aggiorna_outlier = 0;
        this.int_MCMCPar_DEpairs = (int)this.MCMCPar_DEpairs;
        this.int_MCMCPar_n = (int)this.MCMCPar_n;
        this.int_MCMCPar_seq = (int)this.MCMCPar_seq;
        this.int_MCMCPar_steps = (int)this.MCMCPar_steps;
        this.int_MCMCPar_nCR = (int)this.MCMCPar_nCR;
        this.int_MCMCPar_ndraw = (int)this.MCMCPar_ndraw;
        this.InitVariables(this.MCMCPar_DEpairs, this.MCMCPar_eps, this.MCMCPar_Gamma, this.MCMCPar_n, this.MCMCPar_nCR, this.MCMCPar_ndraw, this.MCMCPar_seq, this.MCMCPar_steps, this.Extra_BoundHandling, this.Extra_DRscale, this.Extra_reduced_sample_collection);
        return true;
    }

    @Override
    public void procedure() throws SampleLimitException, ObjectiveAchievedException {
        int d2;
        int i;
        this.x = this.LHS(this.ParRange_minn, this.ParRange_maxn, this.int_MCMCPar_seq);
        this.computeDensity(this.x);
        this.X = new double[this.x.length][this.x[0].length + 2];
        for (int row = 0; row < this.x.length; ++row) {
            for (int col = 0; col < this.x[0].length; ++col) {
                this.X[row][col] = this.x[row][col];
                this.X[row][this.x[0].length] = this.p_CD[row][0];
                this.X[row][this.x[0].length + 1] = this.log_p_CD[row];
            }
        }
        if (this.Extra_save_in_memory.equals("Yes")) {
            this.sequences = this.InitSequences(this.X);
        }
        this.output_CR[0][0] = this.Iter;
        for (int ind = 1; ind < this.pCR.length + 1; ++ind) {
            this.output_CR[0][ind] = this.pCR[ind - 1];
        }
        this.delta_tot = new double[this.int_MCMCPar_nCR];
        double[] X_x_histlogp = new double[this.int_MCMCPar_seq];
        for (i = 0; i < this.X.length; ++i) {
            X_x_histlogp[i] = this.X[i][this.int_MCMCPar_n + 1];
        }
        this.hist_logp[0][0] = this.Iter;
        for (i = 1; i < this.int_MCMCPar_seq + 1; ++i) {
            this.hist_logp[0][i] = X_x_histlogp[i - 1];
        }
        this.dim1_seq_gel = this.iloc;
        this.dim2_seq_gel = this.int_MCMCPar_n;
        this.dim3_seq_gel = this.int_MCMCPar_seq;
        this.seq_x_gel = new double[this.dim1_seq_gel][this.dim2_seq_gel][this.dim3_seq_gel];
        for (i = 0; i < this.dim1_seq_gel; ++i) {
            for (int j = 0; j < this.dim2_seq_gel; ++j) {
                for (int z = 0; z < this.dim3_seq_gel; ++z) {
                    this.seq_x_gel[i][j][z] = this.sequences[i][j][z];
                }
            }
        }
        double[] rstat = this.Gelman(this.seq_x_gel);
        this.output_R_stat[0][0] = this.Iter;
        for (int pp = 1; pp < this.output_R_stat[0].length; ++pp) {
            this.output_R_stat[0][pp] = rstat[pp - 1];
        }
        while ((double)this.Iter < this.MCMCPar_ndraw) {
            int iii;
            double v;
            this.gen_number = 0;
            while (this.gen_number < this.int_MCMCPar_steps) {
                int ItExtra = 0;
                ++this.new_teller;
                this.GetLocation(this.X);
                ItExtra = 0;
                this.offde(this.X);
                this.computeDensity(this.x_new);
                double[][] p_xnew1 = this.p_CD;
                double[] log_p_xnew = this.log_p_CD;
                double[] p_xnew = new double[p_xnew1.length];
                for (int k = 0; k < p_xnew1.length; ++k) {
                    p_xnew[k] = p_xnew1[k][0];
                }
                this.metrop(this.x_new, p_xnew, log_p_xnew, this.x_old, this.p_old, this.log_p_old);
                if (this.Extra_save_in_memory.equals("Yes")) {
                    ++this.iloc;
                }
                double[][] newgentraspose = new double[this.newgen[0].length][this.newgen.length];
                for (int row = 0; row < newgentraspose.length; ++row) {
                    for (int col = 0; col < newgentraspose[0].length; ++col) {
                        newgentraspose[row][col] = this.newgen[col][row];
                    }
                }
                for (int d22 = 0; d22 < this.sequences[0].length; ++d22) {
                    for (int d3 = 0; d3 < this.sequences[0][0].length; ++d3) {
                        this.sequences[this.iloc - 1][d22][d3] = newgentraspose[d22][d3];
                    }
                }
                this.X = this.newgen;
                this.newgen = new double[this.x_old.length][this.x_old[0].length + 2];
                if (this.Extra_pCR.equals("Update")) {
                    double[] st = new double[this.int_MCMCPar_n];
                    double[] r1 = new double[this.int_MCMCPar_n];
                    for (int col = 0; col < this.int_MCMCPar_n; ++col) {
                        double[] colonna = new double[this.int_MCMCPar_seq];
                        double somma = 0.0;
                        for (int row = 0; row < this.int_MCMCPar_seq; ++row) {
                            colonna[row] = this.X[row][col];
                            somma += colonna[row];
                        }
                        double media = somma / (double)this.int_MCMCPar_seq;
                        DoubleArrayList arrlis = new DoubleArrayList(colonna);
                        st[col] = Descriptive.sampleVariance(arrlis, media);
                        r1[col] = Math.sqrt(st[col]);
                    }
                    double[] delta_normX = new double[this.x_old.length];
                    double[][] diff2 = new double[this.x_old.length][this.x_old[0].length];
                    for (int row = 0; row < this.x_old.length; ++row) {
                        double sommanor = 0.0;
                        for (int col = 0; col < this.x_old[0].length; ++col) {
                            diff2[row][col] = (this.x_old[row][col] - this.X[row][col]) / r1[col] * ((this.x_old[row][col] - this.X[row][col]) / r1[col]);
                            sommanor += diff2[row][col];
                        }
                        delta_normX[row] = sommanor;
                    }
                    double[] CR_vet = new double[this.int_MCMCPar_seq];
                    for (int jj = 0; jj < this.int_MCMCPar_seq; ++jj) {
                        CR_vet[jj] = this.CR[jj][this.gen_number];
                    }
                    this.delta_tot = this.CalcDelta(this.delta_tot, delta_normX, CR_vet);
                }
                this.hist_logp[this.counter][0] = this.Iter;
                for (int pp = 0; pp < this.int_MCMCPar_seq; ++pp) {
                    this.hist_logp[this.counter][pp + 1] = this.X[pp][this.int_MCMCPar_n + 1];
                }
                this.output_AR[this.counter][0] = this.Iter;
                double summaccept = 0.0;
                for (int y = 0; y < this.accept.length; ++y) {
                    summaccept += this.accept[y];
                }
                this.output_AR[this.counter][1] = 100.0 * summaccept / (double)(this.int_MCMCPar_seq + ItExtra);
                this.Iter = this.Iter + this.int_MCMCPar_seq + ItExtra;
                ++this.counter;
                ++this.gen_number;
            }
            this.output_CR[this.teller][0] = this.Iter;
            for (int y = 1; y < this.pCR.length + 1; ++y) {
                this.output_CR[this.teller][y] = this.pCR[y - 1];
            }
            if (this.teller == 1) {
                ++this.int_MCMCPar_steps;
            }
            if ((double)this.Iter <= (v = (double)((int)(0.1 * (double)this.int_MCMCPar_ndraw)))) {
                if (this.Extra_pCR.equals("Update")) {
                    this.AdaptpCR(this.CR, this.delta_tot, this.lCR);
                    this.pCR = this.pCR_out_AdaptpCR;
                    this.lCR = this.lCR_out_AdaptpCR;
                }
            } else {
                int row;
                double[][] seq_x_MOC = new double[this.sequences[0].length][this.sequences[0][0].length];
                for (int row2 = 0; row2 < seq_x_MOC.length; ++row2) {
                    for (int col = 0; col < seq_x_MOC[0].length; ++col) {
                        seq_x_MOC[row2][col] = this.sequences[this.iloc][row2][col];
                    }
                }
                double[][] hist_logp_x_ROC = new double[this.counter][this.int_MCMCPar_seq + 1];
                for (row = 0; row < hist_logp_x_ROC.length; ++row) {
                    for (int col = 0; col < hist_logp_x_ROC[0].length; ++col) {
                        hist_logp_x_ROC[row][col] = this.hist_logp[row][col];
                    }
                }
                this.RemOutlierChains(this.X, seq_x_MOC, hist_logp_x_ROC, this.Iter, this.output_outlier);
                for (row = 0; row < seq_x_MOC.length; ++row) {
                    for (int col = 0; col < seq_x_MOC[0].length; ++col) {
                        this.sequences[this.iloc][row][col] = seq_x_MOC[row][col];
                    }
                }
                for (row = 0; row < hist_logp_x_ROC.length; ++row) {
                    for (int col = 0; col < hist_logp_x_ROC[0].length; ++col) {
                        this.hist_logp[row][col] = hist_logp_x_ROC[row][col];
                    }
                }
            }
            for (iii = 0; iii < this.pCR.length; ++iii) {
                System.out.print(this.pCR[iii] + " ");
            }
            System.out.println();
            if (this.Extra_pCR.equals("Update")) {
                this.CR = this.GenCR(this.pCR);
                for (iii = 0; iii < this.pCR.length; ++iii) {
                    System.out.print(this.pCR[iii] + " ");
                }
                System.out.println();
            }
            if (this.Extra_save_in_memory.equals("Yes")) {
                int start_loc = Math.max(1, (int)(0.5 * (double)this.iloc + 0.5)) - 1;
                int end_loc = this.iloc;
                double[][][] seq_x_GE = new double[end_loc - start_loc][this.int_MCMCPar_n][this.int_MCMCPar_seq];
                int cnts = 0;
                for (int d1 = start_loc; d1 < end_loc; ++d1) {
                    for (d2 = 0; d2 < this.int_MCMCPar_n; ++d2) {
                        for (int d3 = 0; d3 < this.int_MCMCPar_seq; ++d3) {
                            seq_x_GE[cnts][d2][d3] = this.sequences[d1][d2][d3];
                        }
                    }
                    ++cnts;
                }
                double[] rstat2 = this.Gelman(seq_x_GE);
                this.output_R_stat[this.teller][0] = this.Iter;
                for (int pp = 1; pp < this.output_R_stat[0].length; ++pp) {
                    this.output_R_stat[this.teller][pp] = rstat2[pp - 1];
                }
            }
            System.out.println("teller" + this.teller);
            ++this.teller;
        }
        int[] ii = new int[this.sequences.length];
        int cnt = 0;
        for (int d1 = 0; d1 < this.sequences.length; ++d1) {
            double somma = 0.0;
            for (int d23 = 0; d23 < this.sequences[0].length; ++d23) {
                somma += this.sequences[d1][d23][0];
            }
            if (somma != 0.0) continue;
            ii[cnt] = d1;
            ++cnt;
        }
        if (cnt > 0) {
            int[] i2 = new int[cnt];
            for (int o = 0; o < cnt; ++o) {
                i2[o] = ii[o];
            }
            int iii = i2[0] - 1;
            int d22 = this.sequences[0].length;
            int d33 = this.sequences[0][0].length;
            double[][][] sequences1 = this.sequences;
            this.sequences = new double[iii][d22][d33];
            for (int d1 = 0; d1 < iii; ++d1) {
                for (int d24 = 0; d24 < d22; ++d24) {
                    for (int d3 = 0; d3 < d33; ++d3) {
                        this.sequences[d1][d24][d3] = sequences1[d1][d24][d3];
                    }
                }
            }
        }
        System.out.println("t");
        int[] iiR = new int[this.output_R_stat.length];
        int cntR = 0;
        for (int d1 = 0; d1 < this.output_R_stat.length; ++d1) {
            double somma = 0.0;
            for (d2 = 0; d2 < this.output_R_stat[0].length; ++d2) {
                somma += this.output_R_stat[d1][d2];
            }
            if (somma != 0.0) continue;
            iiR[cntR] = d1;
            ++cntR;
        }
        if (cntR > 0) {
            int[] iR = new int[cntR];
            for (int o = 0; o < cnt; ++o) {
                iR[o] = iiR[o];
            }
            int iii = iR[0] - 1;
            int d22 = this.output_R_stat[0].length;
            double[][] output_R_stat1 = this.output_R_stat;
            this.output_R_stat = new double[iii][d22];
            for (int d1 = 0; d1 < iii; ++d1) {
                for (int d25 = 0; d25 < d22; ++d25) {
                    this.output_R_stat[d1][d25] = output_R_stat1[d1][d25];
                }
            }
        }
        int[] iiAR = new int[this.output_AR.length];
        int cntAR = 0;
        for (int d1 = 0; d1 < this.output_AR.length; ++d1) {
            double somma = 0.0;
            for (int d26 = 0; d26 < this.output_AR[0].length; ++d26) {
                somma += this.output_AR[d1][d26];
            }
            if (somma != 0.0) continue;
            iiAR[cntAR] = d1;
            ++cntAR;
        }
        if (cntAR > 0) {
            int[] iAR = new int[cntAR];
            for (int o = 0; o < cntAR; ++o) {
                iAR[o] = iiAR[o];
            }
            int iii = iAR[0] - 1;
            int d22 = this.output_AR[0].length;
            double[][] output_AR1 = this.output_AR;
            this.output_AR = new double[iii][d22];
            for (int d1 = 0; d1 < iii; ++d1) {
                for (int d27 = 0; d27 < d22; ++d27) {
                    this.output_AR[d1][d27] = output_AR1[d1][d27];
                }
            }
        }
        int[] iiCR = new int[this.output_CR.length];
        int cntCR = 0;
        for (int d1 = 0; d1 < this.output_CR.length; ++d1) {
            double somma = 0.0;
            for (int d28 = 0; d28 < this.output_CR[0].length; ++d28) {
                somma += this.output_CR[d1][d28];
            }
            if (somma != 0.0) continue;
            iiCR[cntCR] = d1;
            ++cntCR;
        }
        if (cntCR > 0) {
            int[] iCR = new int[cntCR];
            for (int o = 0; o < cntCR; ++o) {
                iCR[o] = iiCR[o];
            }
            int iii = iCR[0] - 1;
            int d22 = this.output_CR[0].length;
            double[][] output_CR1 = this.output_CR;
            this.output_CR = new double[iii][d22];
            for (int d1 = 0; d1 < iii; ++d1) {
                for (int d29 = 0; d29 < d22; ++d29) {
                    this.output_CR[d1][d29] = output_CR1[d1][d29];
                }
            }
        }
    }

    public void InitVariables(double MCMCPar_DEpairs, double MCMCPar_eps, double MCMCPar_Gamma, double MCMCPar_n, double MCMCPar_nCR, double MCMCPar_ndraw, double MCMCPar_seq, double MCMCPar_steps, String Extra_BoundHandling, double Extra_DRscale, String Extra_reduced_sample_collection) {
        int nrow_hist_logp = (int)MCMCPar_seq;
        this.hist_logp = new double[this.getMaximumIterationCount()][nrow_hist_logp + 1];
        int Nelem = (int)(MCMCPar_ndraw / MCMCPar_seq + 0.5) + 1;
        this.output_AR = new double[this.getMaximumIterationCount()][2];
        this.output_AR[0][0] = MCMCPar_seq - 1.0;
        this.output_AR[0][1] = MCMCPar_seq - 1.0;
        this.output_outlier = new double[this.getMaximumIterationCount()][this.int_MCMCPar_seq + 1];
        this.output_R_stat = new double[this.getMaximumIterationCount()][this.int_MCMCPar_n + 1];
        if (this.Extra_pCR.equals("Update")) {
            double pCR_value = 1.0 / MCMCPar_nCR;
            int ncol_pCR = (int)MCMCPar_nCR;
            this.pCR = new double[ncol_pCR];
            for (int nc = 0; nc < ncol_pCR; ++nc) {
                this.pCR[nc] = pCR_value;
            }
            this.CR = this.GenCR(this.pCR);
            this.lCR = new double[ncol_pCR];
        }
        this.output_CR = new double[this.getMaximumIterationCount()][this.pCR.length + 1];
        if (this.Extra_save_in_memory.equals("Yes")) {
            int d1_Seq = (int)(1.25 * (double)Nelem + 0.5);
            int d2_Seq = this.int_MCMCPar_n + 2;
            int d3_Seq = this.int_MCMCPar_seq;
            this.sequences = new double[d1_Seq][d2_Seq][d3_Seq];
        }
        this.Table_JumpRate = new double[this.int_MCMCPar_n][this.int_MCMCPar_DEpairs];
        double val = 0.0;
        int conta = 1;
        for (int zz = 0; zz < this.int_MCMCPar_DEpairs; ++zz) {
            conta = 1;
            for (int kk = 0; kk < this.int_MCMCPar_n; ++kk) {
                this.Table_JumpRate[kk][zz] = val = 2.38 / Math.sqrt(2 * (zz + 1) * conta);
                ++conta;
            }
        }
        this.Iter = this.int_MCMCPar_seq;
        this.counter = 1;
        this.iloc = 1;
        this.teller = 1;
        this.new_teller = 1;
        MCMCPar_steps -= 1.0;
        --this.int_MCMCPar_steps;
    }

    public double[][] GenCR(double[] pCR) {
        int row;
        double[][] CRRR = new double[this.int_MCMCPar_seq][this.int_MCMCPar_steps];
        Multrnd mmm = new Multrnd();
        mmm.n = this.int_MCMCPar_seq * this.int_MCMCPar_steps;
        double spcr = 0.0;
        for (row = 0; row < pCR.length; ++row) {
            spcr += pCR[row];
        }
        for (row = 0; row < pCR.length; ++row) {
            pCR[row] = pCR[row] / spcr;
        }
        mmm.p = pCR;
        mmm.m = 1;
        mmm.process();
        double[][] XX = mmm.X;
        double[] LL = new double[XX[0].length];
        int aaa = XX[0].length;
        double[] LL2 = new double[aaa + 1];
        LL2[0] = 0.0;
        for (int i = 0; i < LL.length; ++i) {
            LL[i] = XX[0][i];
            double cum = LL2[i];
            LL2[i + 1] = LL[i] + cum;
        }
        double[] r = new double[this.int_MCMCPar_seq * this.int_MCMCPar_steps];
        RandomPermutation.init((double[])r, (int)(this.int_MCMCPar_seq * this.int_MCMCPar_steps));
        RandomStream rs = this.randomstream;
        RandomPermutation.shuffle((double[])r, (RandomStream)rs);
        Matrix LL3 = new Matrix(r, 1);
        Matrix CCR = new Matrix(LL3.getRowDimension(), LL3.getColumnDimension());
        int int_MCMCPar_nCR = (int)this.MCMCPar_nCR;
        for (int zz = 0; zz < int_MCMCPar_nCR; ++zz) {
            double i_start = LL2[zz] + 1.0;
            double i_end = LL2[zz + 1];
            int int_i_start = (int)i_start;
            int int_i_end = (int)i_end;
            int[] idx = new int[int_i_end - int_i_start + 1];
            int cont = 0;
            for (int row2 = int_i_start - 1; row2 < int_i_end; ++row2) {
                idx[cont] = (int)r[row2];
                ++cont;
            }
            for (int indice = 0; indice < idx.length; ++indice) {
                if ((double)(zz + 1) / this.MCMCPar_nCR == 0.0) {
                    System.out.println(zz + "fermati");
                }
                CCR.set(0, idx[indice] - 1, (double)(zz + 1) / this.MCMCPar_nCR);
            }
        }
        int indice = 0;
        for (int indrow = 0; indrow < this.int_MCMCPar_seq; ++indrow) {
            for (int indcol = 0; indcol < this.int_MCMCPar_steps; ++indcol) {
                CRRR[indrow][indcol] = CCR.get(0, indice + indcol);
            }
            indice += this.int_MCMCPar_steps;
        }
        return CRRR;
    }

    public double[][] GenCRok(double[] pCR) {
        this.CR = new double[this.int_MCMCPar_seq][this.int_MCMCPar_steps];
        Multrnd mmm = new Multrnd();
        mmm.n = this.int_MCMCPar_seq * this.int_MCMCPar_steps;
        mmm.p = pCR;
        mmm.m = 1;
        mmm.process();
        double[][] XX = mmm.X;
        double[][] YY = mmm.Y;
        double[] LL = new double[XX[0].length];
        int aaa = XX[0].length;
        double[] LL2 = new double[aaa + 1];
        LL2[0] = 0.0;
        for (int i = 0; i < LL.length; ++i) {
            LL[i] = XX[0][i];
            double cum = LL2[i];
            LL2[i + 1] = LL[i] + cum;
        }
        double[] r = new double[this.int_MCMCPar_seq * this.int_MCMCPar_steps];
        RandomPermutation.init((double[])r, (int)(this.int_MCMCPar_seq * this.int_MCMCPar_steps));
        RandomStream rs = this.randomstream;
        RandomPermutation.shuffle((double[])r, (RandomStream)rs);
        Matrix LL3 = new Matrix(r, 1);
        Matrix CCR = new Matrix(LL3.getRowDimension(), LL3.getColumnDimension());
        int int_MCMCPar_nCR = (int)this.MCMCPar_nCR;
        for (int zz = 0; zz < int_MCMCPar_nCR; ++zz) {
            double i_start = LL2[zz] + 1.0;
            double i_end = LL2[zz + 1];
            int int_i_start = (int)i_start;
            int int_i_end = (int)i_end;
            int[] idx = new int[int_i_end - int_i_start + 1];
            int cont = 0;
            for (int row = int_i_start - 1; row < int_i_end; ++row) {
                idx[cont] = (int)r[row];
                ++cont;
            }
            for (int indice = 0; indice < idx.length; ++indice) {
                if ((double)(zz + 1) / this.MCMCPar_nCR == 0.0) {
                    System.out.println(zz + "fermati");
                }
                CCR.set(0, idx[indice] - 1, (double)(zz + 1) / this.MCMCPar_nCR);
            }
        }
        int indice = 0;
        for (int indrow = 0; indrow < this.int_MCMCPar_seq; ++indrow) {
            for (int indcol = 0; indcol < this.int_MCMCPar_steps; ++indcol) {
                this.CR[indrow][indcol] = CCR.get(0, indice + indcol);
            }
            indice += this.int_MCMCPar_steps;
        }
        return this.CR;
    }

    public double[][] LHS(double[] xmin, double[] xmax, int nsample) {
        double[] rr = new double[nsample];
        double[][] s = new double[nsample][this.n];
        for (int j = 0; j < this.n; ++j) {
            RandomPermutation.init((double[])rr, (int)nsample);
            RandomPermutation.shuffle((double[])rr, (RandomStream)this.randomstream);
            for (int kk = 0; kk < nsample; ++kk) {
                double P = (rr[kk] - Math.random()) / (double)nsample;
                s[kk][j] = xmin[j] + P * (xmax[j] - xmin[j]);
            }
        }
        return s;
    }

    public double calcLogLikelihood(double y) {
        double alpha1 = 3.0 * (1.0 + this.MCMCPar_Gamma) / 2.0;
        double alpha2 = 3.0 * alpha1;
        double A1 = Math.exp(Num.lnGamma((double)alpha1));
        double A2 = Math.exp(Num.lnGamma((double)alpha2));
        double exp1 = 1.0 / (1.0 + this.MCMCPar_Gamma);
        double MCMCPar_Wb = Math.sqrt(A1) / ((1.0 + this.MCMCPar_Gamma) * Math.pow(A2, 1.5));
        double MCMCPar_Cb = Math.pow(A1 / A2, exp1);
        double sum1 = Math.log(MCMCPar_Wb / this.sigma);
        double val = Math.abs((-4.0 - y) / this.sigma);
        double sum2 = Math.pow(val, 2.0 / (1.0 + this.MCMCPar_Gamma));
        return sum1 - MCMCPar_Cb * sum2;
    }

    private double[][] computeDensity(double[][] x) throws SampleLimitException, ObjectiveAchievedException {
        this.log_p_CD = new double[x.length];
        this.p_CD = new double[this.log_p_CD.length][2];
        for (int ii = 0; ii < x.length; ++ii) {
            SampleFactory.Sample s = this.getSample(x[ii]);
            this.log_p_CD[ii] = s.F()[0];
            if (this.isTransformObjectiveIntoLogLikelihood()) {
                this.log_p_CD[ii] = this.calcLogLikelihood(this.log_p_CD[ii]);
            }
            System.out.println("Testing:" + Arrays.toString(x[ii]) + "\t\tgetting " + this.log_p_CD[ii] + "\t" + s.F()[0]);
            this.p_CD[ii][0] = this.log_p_CD[ii];
            this.p_CD[ii][1] = ii;
        }
        return this.X;
    }

    public double[][][] InitSequences(double[][] X) {
        for (int qq = 0; qq < this.int_MCMCPar_seq; ++qq) {
            for (int dim2seq = 0; dim2seq < this.int_MCMCPar_n + 2; ++dim2seq) {
                this.sequences[0][dim2seq][qq] = X[qq][dim2seq];
            }
        }
        return this.sequences;
    }

    public double[] Gelman2(double[][][] seq) {
        System.out.println();
        double[] Rstat = new double[this.int_MCMCPar_n];
        int n = seq.length;
        int nrY = seq[0].length;
        int m = seq[0][0].length;
        if (n < 10) {
            for (int i = 0; i < Rstat.length; ++i) {
                Rstat[i] = -2.0;
            }
        } else {
            int t;
            int dim1;
            double s;
            int dim2;
            int dim3;
            int row;
            int col;
            double[][] meanSeq_tra = new double[nrY][m];
            double[][] meanSeq = new double[nrY][m];
            for (int dim2seq = 0; dim2seq < nrY; ++dim2seq) {
                for (int dim3seq = 0; dim3seq < m; ++dim3seq) {
                    double somma = 0.0;
                    for (int dim1seq = 0; dim1seq < n; ++dim1seq) {
                        somma += seq[dim1seq][dim2seq][dim3seq];
                    }
                    meanSeq_tra[dim2seq][dim3seq] = somma / (double)n;
                }
            }
            for (int row2 = 0; row2 < meanSeq.length; ++row2) {
                for (int col2 = 0; col2 < meanSeq[0].length; ++col2) {
                    meanSeq[row2][col2] = meanSeq_tra[col2][row2];
                }
            }
            double[] var = new double[nrY];
            double[] B = new double[nrY];
            double[] vetmedia = new double[nrY];
            for (col = 0; col < meanSeq[0].length; ++col) {
                double somma = 0.0;
                for (row = 0; row < meanSeq.length; ++row) {
                    somma += meanSeq[row][col];
                }
                vetmedia[col] = somma / (double)meanSeq.length;
            }
            for (col = 0; col < meanSeq[0].length; ++col) {
                double somma = 0.0;
                for (row = 0; row < meanSeq.length; ++row) {
                    somma += (meanSeq[row][col] - vetmedia[col]) * (meanSeq[row][col] - vetmedia[col]);
                }
                var[col] = somma / ((double)meanSeq.length - 1.0);
                B[col] = var[col] * (double)n;
            }
            double[][] varSeq = new double[m][nrY];
            double[][] sommatemp = new double[m][nrY];
            for (dim3 = 0; dim3 < m; ++dim3) {
                for (dim2 = 0; dim2 < nrY; ++dim2) {
                    s = 0.0;
                    for (dim1 = 0; dim1 < n; ++dim1) {
                        s += seq[dim1][dim2][dim3];
                    }
                    System.out.println();
                    sommatemp[dim2][dim3] = s / (double)n;
                }
            }
            for (dim3 = 0; dim3 < m; ++dim3) {
                for (dim2 = 0; dim2 < nrY; ++dim2) {
                    s = 0.0;
                    for (dim1 = 0; dim1 < n; ++dim1) {
                        s += (seq[dim1][dim2][dim3] - sommatemp[dim3][dim2]) * (seq[dim1][dim2][dim3] - sommatemp[dim3][dim2]);
                    }
                    varSeq[dim2][dim3] = s / (double)(n - 1);
                }
            }
            double[] W = new double[nrY];
            for (int i = 0; i < nrY; ++i) {
                double somma = 0.0;
                for (int j = 0; j < m; ++j) {
                    somma += varSeq[j][i];
                }
                W[i] = somma / (double)m;
            }
            double[] sigma2 = new double[W.length];
            for (t = 0; t < W.length; ++t) {
                sigma2[t] = ((double)n - 1.0) / (double)n * W[t] + B[t] / (double)n;
            }
            for (t = 0; t < W.length; ++t) {
                double ter1 = ((double)m + 1.0) / (double)m * sigma2[t] / W[t] - ((double)n - 1.0) / (double)m / (double)n;
                Rstat[t] = Math.sqrt(ter1);
            }
            System.out.println("ok");
        }
        return Rstat;
    }

    public void GetLocation(double[][] XX) {
        int i;
        this.x_old = new double[this.int_MCMCPar_seq][this.int_MCMCPar_n];
        for (i = 0; i < this.int_MCMCPar_seq; ++i) {
            for (int j = 0; j < this.int_MCMCPar_n; ++j) {
                this.x_old[i][j] = XX[i][j];
            }
        }
        this.p_old = new double[this.int_MCMCPar_seq];
        for (i = 0; i < this.int_MCMCPar_seq; ++i) {
            this.p_old[i] = XX[i][this.int_MCMCPar_n + 1];
        }
        this.log_p_old = new double[this.int_MCMCPar_seq];
        for (i = 0; i < this.int_MCMCPar_seq; ++i) {
            this.log_p_old[i] = XX[i][this.int_MCMCPar_n + 1];
        }
    }

    public void offde2(double[][] XXXX) {
        double[][] eps = new double[this.int_MCMCPar_seq][this.int_MCMCPar_n];
        RandomStream rrs = this.randomstream;
        NormalGen nn = new NormalGen(rrs);
        for (int i = 0; i < this.int_MCMCPar_seq; ++i) {
            for (int j = 0; j < this.int_MCMCPar_n; ++j) {
                eps[i][j] = Math.pow(10.0, -6.0) * nn.nextDouble();
            }
        }
        this.DEStrategy();
        double[][] dummy = new double[this.int_MCMCPar_seq - 1][this.int_MCMCPar_seq];
        int[][] tt = new int[this.int_MCMCPar_seq - 1][this.int_MCMCPar_seq];
        double[] a = new double[this.int_MCMCPar_seq - 1];
        for (int col = 0; col < dummy[0].length; ++col) {
            for (int i = 0; i < a.length; ++i) {
                a[i] = Math.random();
            }
            double temp = 0.0;
            int[] b = new int[this.int_MCMCPar_seq - 1];
            int kkk = 0;
            for (int x = 0; x < b.length; ++x) {
                b[x] = kkk++;
            }
            kkk = 0;
            for (int j = 0; j < a.length; ++j) {
                for (int i = j; i < a.length; ++i) {
                    if (!(a[j] > a[i])) continue;
                    temp = a[j];
                    a[j] = a[i];
                    a[i] = temp;
                    int temp2 = b[j];
                    b[j] = b[i];
                    b[i] = temp2;
                }
            }
            for (int row = 0; row < dummy.length; ++row) {
                dummy[row][col] = a[row];
                tt[row][col] = b[row];
            }
        }
        double[][] D = new double[this.int_MCMCPar_seq][this.int_MCMCPar_n];
        for (int row = 0; row < this.int_MCMCPar_seq; ++row) {
            for (int col = 0; col < this.int_MCMCPar_n; ++col) {
                D[row][col] = Math.random();
            }
        }
        double[][] noise_x = new double[this.int_MCMCPar_seq][this.int_MCMCPar_n];
        for (int row = 0; row < this.int_MCMCPar_seq; ++row) {
            for (int col = 0; col < this.int_MCMCPar_n; ++col) {
                noise_x[row][col] = this.MCMCPar_eps * (2.0 * Math.random() - 1.0);
            }
        }
        double[][] delta_x = new double[this.int_MCMCPar_seq][this.int_MCMCPar_n];
        for (int qq = 0; qq < this.int_MCMCPar_seq; ++qq) {
            double[] delta;
            double JumpRate;
            double m;
            double[] ii = new double[this.int_MCMCPar_seq];
            for (int i = 0; i < this.int_MCMCPar_seq; ++i) {
                ii[i] = 1.0;
            }
            ii[qq] = 0.0;
            int[] idxx = new int[this.int_MCMCPar_seq];
            int cnt = 0;
            for (int i = 0; i < this.int_MCMCPar_seq; ++i) {
                if (!(ii[i] > 0.0)) continue;
                idxx[cnt] = i;
                ++cnt;
            }
            int[] idx = new int[cnt];
            for (int j = 0; j < cnt; ++j) {
                idx[j] = idxx[j];
            }
            int[] vet_tt = new int[2 * this.DEversion[qq]];
            for (int i = 0; i < vet_tt.length; ++i) {
                vet_tt[i] = tt[i][qq];
            }
            int[] rr = new int[vet_tt.length];
            for (int i = 0; i < vet_tt.length; ++i) {
                rr[i] = idx[vet_tt[i]];
            }
            int[] i_temp = new int[this.int_MCMCPar_n];
            int cont = 0;
            for (int l = 0; l < this.int_MCMCPar_n; ++l) {
                if (!(D[qq][l] > 1.0 - this.CR[qq][this.gen_number])) continue;
                i_temp[cont] = l;
                ++cont;
            }
            int[] i = null;
            if (cont == 0) {
                int[] it = new int[this.int_MCMCPar_n];
                RandomPermutation.init((int[])it, (int)this.int_MCMCPar_n);
                MRG32k3a rs = new MRG32k3a();
                RandomPermutation.shuffle((int[])it, (RandomStream)rs);
                i = new int[1];
                i[cont] = it[0] - 1;
            }
            if (cont > 0) {
                i = new int[cont];
                for (int u = 0; u < cont; ++u) {
                    i[u] = i_temp[u];
                }
            }
            int NrDim = i.length;
            double n = Math.random();
            if (n < (m = 0.8)) {
                int col;
                int row;
                JumpRate = this.Table_JumpRate[NrDim - 1][0];
                int index_row_1_end = this.DEversion[qq];
                int index_row_2_start = this.DEversion[qq];
                int index_row_2_end = 2 * this.DEversion[qq];
                int[] rr1 = new int[index_row_1_end];
                int[] rr2 = new int[index_row_2_end - index_row_2_start];
                for (int k = 0; k < index_row_1_end; ++k) {
                    rr1[k] = rr[k];
                }
                int row_cnt = 0;
                for (int k = index_row_2_start; k < index_row_2_end; ++k) {
                    rr2[row_cnt] = rr[k];
                    row_cnt = 1;
                }
                double[][] X1 = new double[rr1.length][this.int_MCMCPar_n];
                double[][] X2 = new double[rr2.length][this.int_MCMCPar_n];
                for (row = 0; row < X1.length; ++row) {
                    for (col = 0; col < X1[0].length; ++col) {
                        X1[row][col] = XXXX[rr1[row]][col];
                    }
                }
                for (row = 0; row < X2.length; ++row) {
                    for (col = 0; col < X2[0].length; ++col) {
                        X2[row][col] = XXXX[rr2[row]][col];
                    }
                }
                delta = new double[X1[0].length];
                for (int col2 = 0; col2 < X1[0].length; ++col2) {
                    double somma = 0.0;
                    for (int row2 = 0; row2 < X1.length; ++row2) {
                        somma += X1[row2][col2] - X2[row2][col2];
                    }
                    delta[col2] = somma;
                }
                for (int contcol = 0; contcol < i.length; ++contcol) {
                    delta_x[qq][i[contcol]] = (1.0 + noise_x[qq][i[contcol]]) * JumpRate * delta[i[contcol]];
                }
            } else {
                JumpRate = 1.0;
                this.CR[qq][this.gen_number] = -1.0;
                delta = new double[this.int_MCMCPar_n];
                for (int col = 0; col < this.int_MCMCPar_n; ++col) {
                    delta[col] = XXXX[rr[0]][col] - XXXX[rr[1]][col];
                }
                for (int contcol = 0; contcol < delta_x[0].length; ++contcol) {
                    delta_x[qq][contcol] = JumpRate * delta[contcol];
                }
            }
            double ssquare = 0.0;
            for (int v = 0; v < delta_x[0].length; ++v) {
                ssquare = delta_x[qq][v] * delta_x[qq][v] + ssquare;
            }
            if (ssquare != 0.0 || this.x_old.length != this.x_old[0].length) continue;
            double[][] mat = new double[this.x_old.length][this.x_old[0].length];
            for (int row = 0; row < mat.length; ++row) {
                for (int col = 0; col < mat[0].length; ++col) {
                    mat[row][col] = this.x_old[row][col];
                }
            }
            double[] arr1 = new double[mat.length];
            double[] arr2 = new double[mat.length];
            double[][] mat_cov = new double[mat.length][mat[0].length];
            for (int col = 0; col < mat[0].length; ++col) {
                for (int row1 = 0; row1 < mat.length; ++row1) {
                    arr1[row1] = mat[row1][col];
                }
                DoubleArrayList arrayuno = new DoubleArrayList(arr1);
                for (int col2 = 0; col2 < mat[0].length; ++col2) {
                    for (int row = 0; row < mat.length; ++row) {
                        arr2[row] = mat[row][col2];
                    }
                    DoubleArrayList arraydue = new DoubleArrayList(arr2);
                    mat_cov[col][col2] = col == col2 ? Descriptive.covariance(arrayuno, arraydue) + Math.pow(10.0, -5.0) : Descriptive.covariance(arrayuno, arraydue);
                }
            }
            Matrix chol = new Matrix(mat_cov);
            CholeskyDecomposition dec = chol.chol();
            RandomStream rrrs = this.randomstream;
            NormalGen nnn = new NormalGen(rrrs);
            double[][] R = new double[this.x_old.length][this.x_old[0].length];
            for (int row = 0; row < R.length; ++row) {
                for (int col = 0; col < R[0].length; ++col) {
                    R[row][col] = 2.38 / Math.sqrt(this.MCMCPar_n) * dec.getL().get(row, col);
                }
            }
            double[] f = new double[this.int_MCMCPar_n];
            for (int row = 0; row < this.int_MCMCPar_n; ++row) {
                f[row] = nnn.nextDouble();
            }
            for (int contcol = 0; contcol < this.int_MCMCPar_n; ++contcol) {
                double somma = 0.0;
                for (int oo = 0; oo < R[0].length; ++oo) {
                    somma += R[contcol][oo] * f[oo];
                }
                delta_x[qq][contcol] = somma;
            }
            System.out.println("Cholewsky decomposition");
        }
        double[][] x_new1 = new double[this.x_old.length][this.x_old[0].length];
        for (int row = 0; row < x_new1.length; ++row) {
            for (int col = 0; col < x_new1[0].length; ++col) {
                x_new1[row][col] = this.x_old[row][col] + delta_x[row][col] + eps[row][col];
            }
        }
        this.x_new = this.ReflectBounds(x_new1, this.ParRange_maxn, this.ParRange_minn);
    }

    public void DEStrategy() {
        int i;
        double[] p_pair = new double[this.int_MCMCPar_DEpairs];
        for (int i2 = 0; i2 < this.int_MCMCPar_DEpairs; ++i2) {
            p_pair[i2] = 1.0 / this.MCMCPar_DEpairs;
        }
        double cumsum = 0.0;
        double[] cump_pair = new double[this.int_MCMCPar_DEpairs + 1];
        cump_pair[0] = 0.0;
        for (int i3 = 0; i3 < this.int_MCMCPar_DEpairs; ++i3) {
            cump_pair[i3 + 1] = p_pair[i3] + cumsum;
            cumsum += cump_pair[i3];
        }
        double[] Z = new double[this.int_MCMCPar_seq];
        for (i = 1; i < this.int_MCMCPar_seq; ++i) {
            Z[i] = Math.random();
        }
        this.DEversion = new int[Z.length];
        for (i = 0; i < Z.length; ++i) {
            int cnt = 0;
            int[] z = new int[cump_pair.length];
            for (int j = 0; j < cump_pair.length; ++j) {
                cnt = 0;
                if (Z[i] > cump_pair[j]) {
                    z[j] = j;
                    cnt = j;
                    continue;
                }
                z[j] = 0;
            }
            this.DEversion[i] = z[cnt] + 1;
        }
    }

    public double[][] ReflectBounds(double[][] neww, double[] ParRange_maxn, double[] ParRange_minn) {
        int col;
        int row;
        double[][] y = neww;
        for (row = 0; row < neww.length; ++row) {
            for (col = 0; col < neww[0].length; ++col) {
                if (y[row][col] < ParRange_minn[col]) {
                    y[row][col] = 2.0 * ParRange_minn[col] - y[row][col];
                }
                if (!(y[row][col] > ParRange_maxn[col])) continue;
                y[row][col] = 2.0 * ParRange_maxn[col] - y[row][col];
            }
        }
        for (row = 0; row < neww.length; ++row) {
            for (col = 0; col < neww[0].length; ++col) {
                if (y[row][col] < ParRange_minn[col]) {
                    y[row][col] = ParRange_minn[col] + Math.random() * (ParRange_maxn[col] - ParRange_minn[col]);
                }
                if (!(y[row][col] > ParRange_maxn[col])) continue;
                y[row][col] = ParRange_minn[col] + Math.random() * (ParRange_maxn[col] - ParRange_minn[col]);
            }
        }
        return y;
    }

    public void metrop(double[][] xxxx, double[] px, double[] logpx, double[][] xold, double[] pxold, double[] logpxold) {
        int NrChains = xxxx.length;
        this.newgen = new double[xold.length][xold[0].length + 2];
        for (int row = 0; row < this.newgen.length; ++row) {
            for (int col = 0; col < xold[0].length; ++col) {
                this.newgen[row][col] = xold[row][col];
            }
            this.newgen[row][xold[0].length] = pxold[row];
            this.newgen[row][xold[0].length + 1] = logpxold[row];
        }
        this.accept = new double[NrChains];
        double[] alpha = new double[px.length];
        for (int row = 0; row < px.length; ++row) {
            double g = Math.exp(px[row] - pxold[row]);
            alpha[row] = Math.min(g, 1.0);
        }
        double[] ZZZ = new double[NrChains];
        for (int row = 0; row < ZZZ.length; ++row) {
            ZZZ[row] = Math.random();
        }
        int[] idxx = new int[px.length];
        int ccc = 0;
        for (int row = 0; row < ZZZ.length; ++row) {
            if (!(alpha[row] > ZZZ[row])) continue;
            idxx[ccc] = row;
            ++ccc;
        }
        int[] idx = new int[ccc];
        for (int c = 0; c < ccc; ++c) {
            idx[c] = idxx[c];
        }
        for (int row = 0; row < idx.length; ++row) {
            for (int col = 0; col < xold[0].length; ++col) {
                this.newgen[idx[row]][col] = xxxx[idx[row]][col];
            }
            this.newgen[idx[row]][xold[0].length] = px[idx[row]];
            this.newgen[idx[row]][xold[0].length + 1] = logpx[idx[row]];
            this.accept[idx[row]] = 1.0;
        }
    }

    public double[] CalcDelta(double[] delta_tot_result_CD, double[] delta_normX_CD, double[] CR_vet_CD) {
        for (int zz = 0; zz < this.int_MCMCPar_nCR; ++zz) {
            int[] idx1 = new int[CR_vet_CD.length];
            int cnt = 0;
            for (int c = 0; c < CR_vet_CD.length; ++c) {
                double h = CR_vet_CD[c];
                double hh = ((double)zz + 1.0) / (double)this.int_MCMCPar_nCR;
                if (h != hh) continue;
                idx1[cnt] = c;
                ++cnt;
            }
            int[] idx = new int[cnt];
            for (int c = 0; c < cnt; ++c) {
                idx[c] = idx1[c];
            }
            double sum_deltanormx = 0.0;
            for (int o = 0; o < idx.length; ++o) {
                sum_deltanormx += delta_normX_CD[idx[o]];
            }
            delta_tot_result_CD[zz] = delta_tot_result_CD[zz] + sum_deltanormx;
        }
        return delta_tot_result_CD;
    }

    public void AdaptpCR(double[][] CR_in, double[] delta_tot_in, double[] lCRold_in) {
        int mmm;
        this.lCR_out_AdaptpCR = new double[lCRold_in.length];
        this.pCR_out_AdaptpCR = new double[this.pCR.length];
        double[] CR_vect = new double[CR_in.length * CR_in[0].length];
        for (int qq = 0; qq < CR_in[0].length; ++qq) {
            for (int ww = 0; ww < CR_in.length; ++ww) {
                CR_vect[ww + qq * CR_in.length] = CR_in[ww][qq];
            }
        }
        for (int zz = 0; zz < this.int_MCMCPar_nCR; ++zz) {
            int lll = 0;
            for (int qq = 0; qq < CR_vect.length; ++qq) {
                double aa = CR_vect[qq];
                double aaa = ((double)zz + 1.0) / (double)this.int_MCMCPar_nCR;
                if (aa != aaa) continue;
                ++lll;
            }
            this.lCR_out_AdaptpCR[zz] = lCRold_in[zz] + (double)lll;
        }
        double sdeltatot = 0.0;
        for (int s = 0; s < delta_tot_in.length; ++s) {
            sdeltatot += delta_tot_in[s];
        }
        double sumpCR = 0.0;
        for (mmm = 0; mmm < this.pCR_out_AdaptpCR.length; ++mmm) {
            this.pCR_out_AdaptpCR[mmm] = (double)this.int_MCMCPar_seq * (delta_tot_in[mmm] / this.lCR_out_AdaptpCR[mmm]) / sdeltatot;
            sumpCR += this.pCR_out_AdaptpCR[mmm];
        }
        for (mmm = 0; mmm < this.pCR_out_AdaptpCR.length; ++mmm) {
            this.pCR_out_AdaptpCR[mmm] = this.pCR_out_AdaptpCR[mmm] / sumpCR;
        }
    }

    public void RemOutlierChains(double[][] Mat_X, double[][] Mat_Sequences, double[][] hist_logp_inROC, int Iter_in_ROC, double[][] output_outlier_in_ROC) {
        int idx_end = hist_logp_inROC.length;
        int idx_start = (int)(0.5 * (double)idx_end + 0.5);
        double[] mean_hist_logp = new double[this.int_MCMCPar_seq];
        int cnt = 0;
        for (int col = 1; col < this.int_MCMCPar_seq + 1; ++col) {
            double somma = 0.0;
            for (int row = idx_start; row < idx_end; ++row) {
                somma += hist_logp_inROC[row][col];
            }
            mean_hist_logp[cnt] = somma / (double)(idx_end - idx_start);
            ++cnt;
        }
        int Nid = 0;
        int[] chain_id = new int[1];
        if (this.MCMCPar_outlierTest.equals("IQR_test")) {
            int u;
            double[] pppp = new double[]{25.0, 75.0};
            double[] rrrrr = this.percetili(mean_hist_logp, pppp);
            double Q1 = rrrrr[1];
            double Q3 = rrrrr[0];
            double IQR = Q1 - Q3;
            double UpperRange = Q3 - 2.0 * IQR;
            int[] chain_id1 = new int[mean_hist_logp.length];
            int cnn = 0;
            for (u = 0; u < mean_hist_logp.length; ++u) {
                if (!(mean_hist_logp[u] < UpperRange)) continue;
                chain_id1[cnn] = u;
                ++cnn;
            }
            chain_id = new int[cnn];
            for (u = 0; u < cnn; ++u) {
                chain_id[u] = chain_id1[u];
            }
            Nid = chain_id.length;
        }
        if (Nid > 0) {
            for (int qq = 0; qq < Nid; ++qq) {
                double max_mean_hist_logp = mean_hist_logp[0];
                for (int u = 1; u < mean_hist_logp.length; ++u) {
                    if (!(mean_hist_logp[u] > max_mean_hist_logp)) continue;
                    max_mean_hist_logp = mean_hist_logp[u];
                }
                int[] r_idx1 = new int[hist_logp_inROC.length];
                int cnn = 0;
                for (int u = 0; u < mean_hist_logp.length; ++u) {
                    if (mean_hist_logp[u] != max_mean_hist_logp) continue;
                    r_idx1[cnn] = u;
                    ++cnn;
                }
                int r_idx = r_idx1[0];
                for (int row = 0; row < hist_logp_inROC.length; ++row) {
                    hist_logp_inROC[row][chain_id[qq]] = hist_logp_inROC[row][r_idx];
                }
                for (int r = 0; r < this.int_MCMCPar_n + 2; ++r) {
                    Mat_Sequences[r][chain_id[qq]] = Mat_X[r_idx][r];
                    Mat_X[chain_id[qq]][r] = Mat_X[r_idx][r];
                }
                output_outlier_in_ROC[this.aggiorna_outlier][0] = this.Iter;
                output_outlier_in_ROC[this.aggiorna_outlier][qq + 1] = chain_id[qq];
                if (output_outlier_in_ROC[this.aggiorna_outlier][qq + 1] > 0.0) {
                    System.out.print("outlier= " + output_outlier_in_ROC[this.aggiorna_outlier][0] + " " + output_outlier_in_ROC[this.aggiorna_outlier][qq + 1]);
                }
                System.out.println();
                this.aggiorna_outlier = 1 + this.aggiorna_outlier;
            }
        }
    }

    public double[] Gelman(double[][][] seq) {
        System.out.println();
        double[] Rstat = new double[this.int_MCMCPar_n];
        int n = seq.length;
        int nrY = seq[0].length;
        int m = seq[0][0].length;
        if (n < 10) {
            for (int i = 0; i < Rstat.length; ++i) {
                Rstat[i] = -2.0;
            }
        } else {
            int t;
            int dim1;
            double s;
            int dim2;
            int dim3;
            int row;
            int col;
            double[][] meanSeq = new double[nrY][m];
            for (int dim2seq = 0; dim2seq < nrY; ++dim2seq) {
                for (int dim3seq = 0; dim3seq < m; ++dim3seq) {
                    double somma = 0.0;
                    for (int dim1seq = 0; dim1seq < n; ++dim1seq) {
                        somma += seq[dim1seq][dim2seq][dim3seq];
                    }
                    meanSeq[dim2seq][dim3seq] = somma / (double)n;
                }
            }
            double[] var = new double[m];
            double[] vetmedia = new double[m];
            double[] B = new double[m];
            for (col = 0; col < meanSeq[0].length; ++col) {
                double somma = 0.0;
                for (row = 0; row < meanSeq.length; ++row) {
                    somma += meanSeq[row][col];
                }
                vetmedia[col] = somma / (double)meanSeq.length;
            }
            for (col = 0; col < meanSeq[0].length; ++col) {
                double somma = 0.0;
                for (row = 0; row < meanSeq.length; ++row) {
                    somma += (meanSeq[row][col] - vetmedia[col]) * (meanSeq[row][col] - vetmedia[col]);
                }
                var[col] = somma / (double)(meanSeq.length - 1);
                B[col] = var[col] * (double)(n + 1);
            }
            double[][] varSeq = new double[m][nrY];
            double[][] sommatemp = new double[m][nrY];
            for (dim3 = 0; dim3 < m; ++dim3) {
                for (dim2 = 0; dim2 < nrY; ++dim2) {
                    s = 0.0;
                    for (dim1 = 0; dim1 < n; ++dim1) {
                        s += seq[dim1][dim2][dim3];
                    }
                    sommatemp[dim3][dim2] = s / (double)n;
                }
            }
            for (dim3 = 0; dim3 < m; ++dim3) {
                for (dim2 = 0; dim2 < nrY; ++dim2) {
                    s = 0.0;
                    for (dim1 = 0; dim1 < n; ++dim1) {
                        s += (seq[dim1][dim2][dim3] - sommatemp[dim3][dim2]) * (seq[dim1][dim2][dim3] - sommatemp[dim3][dim2]);
                    }
                    varSeq[dim3][dim2] = s / ((double)n - 1.0);
                }
            }
            double[] W = new double[nrY];
            for (int i = 0; i < nrY; ++i) {
                double somma = 0.0;
                for (int j = 0; j < m; ++j) {
                    somma += varSeq[j][i];
                }
                W[i] = somma / (double)m;
            }
            double[] sigma2 = new double[W.length];
            for (t = 0; t < W.length; ++t) {
                sigma2[t] = ((double)n - 1.0) / (double)n * W[t] + B[t] / (double)n;
            }
            for (t = 0; t < W.length; ++t) {
                double ter1 = ((double)m + 1.0) / (double)m * sigma2[t] / W[t] - ((double)n - 1.0) / (double)m / (double)n;
                Rstat[t] = Math.sqrt(ter1);
            }
            System.out.println("ok");
        }
        return Rstat;
    }

    public static double[] bubbleSort1(double[] x) {
        int n = x.length;
        for (int pass = 1; pass < n; ++pass) {
            for (int i = 0; i < n - pass; ++i) {
                if (!(x[i] > x[i + 1])) continue;
                double temp = x[i];
                x[i] = x[i + 1];
                x[i + 1] = temp;
            }
        }
        return x;
    }

    public void offde(double[][] XXXX) {
        double[][] eps = new double[this.int_MCMCPar_seq][this.int_MCMCPar_n];
        RandomStream rrs = this.randomstream;
        NormalGen nn = new NormalGen(rrs);
        for (int i = 0; i < this.int_MCMCPar_seq; ++i) {
            for (int j = 0; j < this.int_MCMCPar_n; ++j) {
                eps[i][j] = 1.0E-5 * nn.nextDouble();
            }
        }
        double[][] delta_x = new double[this.int_MCMCPar_seq][this.int_MCMCPar_n];
        if (this.Extra_DR.equals("No")) {
            int col;
            this.DEStrategy();
            double[][] dummy = new double[this.int_MCMCPar_seq - 1][this.int_MCMCPar_seq];
            int[][] tt = new int[this.int_MCMCPar_seq - 1][this.int_MCMCPar_seq];
            double[][] a = new double[this.int_MCMCPar_seq - 1][this.int_MCMCPar_seq];
            for (int row = 0; row < a.length; ++row) {
                for (col = 0; col < a[0].length; ++col) {
                    a[row][col] = Math.random();
                }
            }
            double[] vet_temporaneo = new double[a[0].length];
            for (col = 0; col < dummy[0].length; ++col) {
                for (int i = 0; i < a.length; ++i) {
                    vet_temporaneo[i] = a[i][col];
                }
                double temp = 0.0;
                int[] b = new int[this.int_MCMCPar_seq - 1];
                int kkk = 0;
                for (int x = 0; x < b.length; ++x) {
                    b[x] = kkk++;
                }
                kkk = 0;
                for (int j = 0; j < a.length; ++j) {
                    for (int i = j; i < a.length; ++i) {
                        if (!(vet_temporaneo[j] > vet_temporaneo[i])) continue;
                        temp = vet_temporaneo[j];
                        vet_temporaneo[j] = vet_temporaneo[i];
                        vet_temporaneo[i] = temp;
                        int temp2 = b[j];
                        b[j] = b[i];
                        b[i] = temp2;
                    }
                }
                for (int row = 0; row < dummy.length; ++row) {
                    dummy[row][col] = vet_temporaneo[row];
                    tt[row][col] = b[row];
                }
            }
            double[][] D = new double[this.int_MCMCPar_seq][this.int_MCMCPar_n];
            for (int row = 0; row < this.int_MCMCPar_seq; ++row) {
                for (int col2 = 0; col2 < this.int_MCMCPar_n; ++col2) {
                    D[row][col2] = Math.random();
                }
            }
            double[][] noise_x = new double[this.int_MCMCPar_seq][this.int_MCMCPar_n];
            for (int row = 0; row < this.int_MCMCPar_seq; ++row) {
                for (int col3 = 0; col3 < this.int_MCMCPar_n; ++col3) {
                    noise_x[row][col3] = this.MCMCPar_eps * (2.0 * Math.random() - 1.0);
                }
            }
            delta_x = new double[this.int_MCMCPar_seq][this.int_MCMCPar_n];
            for (int qq = 0; qq < this.int_MCMCPar_seq; ++qq) {
                double[] delta;
                double JumpRate;
                double[] ii = new double[this.int_MCMCPar_seq];
                for (int i = 0; i < this.int_MCMCPar_seq; ++i) {
                    ii[i] = 1.0;
                }
                ii[qq] = 0.0;
                int[] idxx = new int[this.int_MCMCPar_seq];
                int cnt = 0;
                for (int i = 0; i < this.int_MCMCPar_seq; ++i) {
                    if (!(ii[i] > 0.0)) continue;
                    idxx[cnt] = i;
                    ++cnt;
                }
                int[] idx = new int[cnt];
                for (int j = 0; j < cnt; ++j) {
                    idx[j] = idxx[j];
                }
                int[] vet_tt = new int[2 * this.DEversion[qq]];
                for (int i = 0; i < vet_tt.length; ++i) {
                    vet_tt[i] = tt[i][qq];
                }
                int[] rr = new int[vet_tt.length];
                for (int i = 0; i < vet_tt.length; ++i) {
                    rr[i] = idx[vet_tt[i]];
                }
                int[] i_temp = new int[this.int_MCMCPar_n];
                int cont = 0;
                for (int l = 0; l < this.int_MCMCPar_n; ++l) {
                    if (this.CR[qq][this.gen_number] < 0.0) {
                        System.out.println(this.CR[qq][this.gen_number]);
                    }
                    if (!(D[qq][l] > 1.0 - this.CR[qq][this.gen_number])) continue;
                    i_temp[cont] = l;
                    ++cont;
                }
                int[] i = null;
                if (cont == 0) {
                    int[] it = new int[this.int_MCMCPar_n];
                    RandomPermutation.init((int[])it, (int)this.int_MCMCPar_n);
                    RandomStream rs = this.randomstream;
                    RandomPermutation.shuffle((int[])it, (RandomStream)rs);
                    i = new int[1];
                    i[cont] = it[0] - 1;
                } else {
                    i = new int[cont];
                    for (int u = 0; u < cont; ++u) {
                        i[u] = i_temp[u];
                    }
                }
                int NrDim = i.length;
                double n = Math.random();
                double m = 0.8;
                if (n < m) {
                    int col4;
                    int row;
                    JumpRate = this.Table_JumpRate[NrDim - 1][0];
                    int index_row_1_end = this.DEversion[qq];
                    int index_row_2_start = this.DEversion[qq];
                    int index_row_2_end = 2 * this.DEversion[qq];
                    int[] rr1 = new int[index_row_1_end];
                    int[] rr2 = new int[index_row_2_end - index_row_2_start];
                    for (int k = 0; k < index_row_1_end; ++k) {
                        rr1[k] = rr[k];
                    }
                    int row_cnt = 0;
                    for (int k = index_row_2_start; k < index_row_2_end; ++k) {
                        rr2[row_cnt] = rr[k];
                        row_cnt = 1;
                    }
                    double[][] X1 = new double[rr1.length][this.int_MCMCPar_n];
                    double[][] X2 = new double[rr2.length][this.int_MCMCPar_n];
                    for (row = 0; row < X1.length; ++row) {
                        for (col4 = 0; col4 < X1[0].length; ++col4) {
                            X1[row][col4] = XXXX[rr1[row]][col4];
                        }
                    }
                    for (row = 0; row < X2.length; ++row) {
                        for (col4 = 0; col4 < X2[0].length; ++col4) {
                            X2[row][col4] = XXXX[rr2[row]][col4];
                        }
                    }
                    delta = new double[X1[0].length];
                    for (int col5 = 0; col5 < X1[0].length; ++col5) {
                        double somma = 0.0;
                        for (int row2 = 0; row2 < X1.length; ++row2) {
                            somma += X1[row2][col5] - X2[row2][col5];
                        }
                        delta[col5] = somma;
                    }
                    for (int contcol = 0; contcol < i.length; ++contcol) {
                        delta_x[qq][i[contcol]] = (1.0 + noise_x[qq][i[contcol]]) * JumpRate * delta[i[contcol]];
                    }
                } else {
                    JumpRate = 1.0;
                    this.CR[qq][this.gen_number] = -1.0;
                    delta = new double[this.int_MCMCPar_n];
                    for (int col6 = 0; col6 < this.int_MCMCPar_n; ++col6) {
                        delta[col6] = XXXX[rr[0]][col6] - XXXX[rr[1]][col6];
                    }
                    for (int contcol = 0; contcol < delta_x[0].length; ++contcol) {
                        delta_x[qq][contcol] = JumpRate * delta[contcol];
                    }
                }
                double ssquare = 0.0;
                for (int v = 0; v < delta_x[0].length; ++v) {
                    ssquare = delta_x[qq][v] * delta_x[qq][v] + ssquare;
                }
                if (ssquare != 0.0 || this.x_old.length != this.x_old[0].length) continue;
                double[][] mat = new double[this.x_old.length][this.x_old[0].length];
                for (int row = 0; row < mat.length; ++row) {
                    for (int col7 = 0; col7 < mat[0].length; ++col7) {
                        mat[row][col7] = this.x_old[row][col7];
                    }
                }
                double[] arr1 = new double[mat.length];
                double[] arr2 = new double[mat.length];
                double[][] mat_cov = new double[mat.length][mat[0].length];
                for (int col8 = 0; col8 < mat[0].length; ++col8) {
                    for (int row1 = 0; row1 < mat.length; ++row1) {
                        arr1[row1] = mat[row1][col8];
                    }
                    DoubleArrayList arrayuno = new DoubleArrayList(arr1);
                    for (int col2 = 0; col2 < mat[0].length; ++col2) {
                        for (int row = 0; row < mat.length; ++row) {
                            arr2[row] = mat[row][col2];
                        }
                        DoubleArrayList arraydue = new DoubleArrayList(arr2);
                        mat_cov[col8][col2] = col8 == col2 ? Descriptive.covariance(arrayuno, arraydue) + Math.pow(10.0, -5.0) : Descriptive.covariance(arrayuno, arraydue);
                    }
                }
                Matrix chol = new Matrix(mat_cov);
                CholeskyDecomposition dec = chol.chol();
                RandomStream rrrs = this.randomstream;
                NormalGen nnn = new NormalGen(rrrs);
                double[][] R = new double[this.x_old.length][this.x_old[0].length];
                for (int row = 0; row < R.length; ++row) {
                    for (int col9 = 0; col9 < R[0].length; ++col9) {
                        R[row][col9] = 2.38 / Math.sqrt(this.MCMCPar_n) * dec.getL().get(row, col9);
                    }
                }
                double[] f = new double[this.int_MCMCPar_n];
                for (int row = 0; row < this.int_MCMCPar_n; ++row) {
                    f[row] = nnn.nextDouble();
                }
                for (int contcol = 0; contcol < this.int_MCMCPar_n; ++contcol) {
                    double somma = 0.0;
                    for (int oo = 0; oo < R[0].length; ++oo) {
                        somma += R[contcol][oo] * f[oo];
                    }
                    delta_x[qq][contcol] = somma;
                }
                System.out.println("Cholewsky decomposition");
            }
        }
        double[][] x_new1 = new double[this.x_old.length][this.x_old[0].length];
        for (int row = 0; row < x_new1.length; ++row) {
            for (int col = 0; col < x_new1[0].length; ++col) {
                x_new1[row][col] = this.x_old[row][col] + delta_x[row][col] + eps[row][col];
            }
        }
        this.x_new = this.ReflectBounds(x_new1, this.ParRange_maxn, this.ParRange_minn);
    }

    public double[] percetili(double[] vettore, double[] valori) {
        double[] result = new double[valori.length];
        double[] ordinati = DREAM.bubbleSort1(vettore);
        double[] completo = new double[vettore.length];
        for (int i = 0; i < ordinati.length; ++i) {
            completo[i] = 100.0 * ((double)i + 0.5) / (double)vettore.length;
        }
        for (int j = 0; j < valori.length; ++j) {
            double percentile = valori[j];
            for (int i = 0; i < completo.length; ++i) {
                if (!(completo[i] > percentile)) continue;
                result[j] = ordinati[i - 1] + (ordinati[i] - ordinati[i - 1]) / (completo[i] - completo[i - 1]) * (percentile - completo[i - 1]);
            }
        }
        return result;
    }

    public static void main(String[] args) {
        DREAM d = new DREAM();
        d.setFunction((AbstractFunction)LeafRiverExample.getModel());
        d.setCrossoverValue(3);
        d.setDEPairs(1);
        d.setNumberOfMarkovChains(5);
        d.setMCMCsteps(10);
        d.setMCMCeps(0.2);
        d.setTransformObjectiveIntoLogLikelihood(true);
        d.setGamma(0.0);
        d.setSigma(0.01);
        d.setMaxn(5000.0);
        d.setNumberOfMarkovChains(d.getFunction().getInputDimension());
        try {
            d.init();
            d.procedure();
        }
        catch (Exception e) {
            System.out.println(e);
            e.printStackTrace();
        }
    }
}

