/*
 * Decompiled with CFR 0.152.
 */
package optas.optimizer;

import jams.JAMS;
import jams.model.JAMSComponentDescription;
import java.util.ArrayList;
import java.util.Stack;
import optas.core.ObjectiveAchievedException;
import optas.core.SampleLimitException;
import optas.optimizer.Optimizer;
import optas.optimizer.OptimizerLibrary;
import optas.optimizer.management.OptimizerDescription;
import optas.optimizer.management.SampleFactory;

@JAMSComponentDescription(title="Branch and Bound Optimizer", author="Christian Fischer", description="Performs a branch and bound optimization. Advantage: It can be shown, that this method will find the global optimum. Disadvantage: This method usally requires many function evaluations. So it should only be used, if model execution is very fast")
public class BranchAndBound
extends Optimizer {
    double test = 0.0;

    @Override
    public OptimizerDescription getDescription() {
        return OptimizerLibrary.getDefaultOptimizerDescription(BranchAndBound.class.getSimpleName(), BranchAndBound.class.getName(), 500, false);
    }

    @Override
    public boolean init() {
        if (!super.init()) {
            return false;
        }
        this.test = 0.0;
        if (this.x0 != null) {
            this.log(JAMS.i18n((String)"start_value_not_supported_by_branch_and_bound"));
        }
        return true;
    }

    double[] VectorAdd(double[] a, double[] b) {
        double[] sum = new double[a.length];
        for (int i = 0; i < a.length; ++i) {
            sum[i] = a[i] + b[i];
        }
        return sum;
    }

    double[] VectorAdd(double[] a, double b) {
        double[] sum = new double[a.length];
        for (int i = 0; i < a.length; ++i) {
            sum[i] = a[i] + b;
        }
        return sum;
    }

    double[] VectorSub(double[] a, double[] b) {
        double[] sum = new double[a.length];
        for (int i = 0; i < a.length; ++i) {
            sum[i] = a[i] - b[i];
        }
        return sum;
    }

    double[] VectorMul(double[] a, double mul) {
        double[] result = new double[a.length];
        for (int i = 0; i < a.length; ++i) {
            result[i] = a[i] * mul;
        }
        return result;
    }

    double[] VectorMul(double[] a, double[] mul) {
        double[] result = new double[a.length];
        for (int i = 0; i < a.length; ++i) {
            result[i] = a[i] * mul[i];
        }
        return result;
    }

    boolean VectorLessEq(double[] x, double[] y) {
        for (int i = 0; i < x.length; ++i) {
            if (!(x[i] > y[i] - 1.0E-6)) continue;
            return false;
        }
        return true;
    }

    double VectorNorm(double[] v) {
        double sum = 0.0;
        for (int i = 0; i < v.length; ++i) {
            sum += Math.abs(v[i]);
        }
        return sum;
    }

    double VectorNorm2(double[] v) {
        double sum = 0.0;
        for (int i = 0; i < v.length; ++i) {
            sum += v[i] * v[i];
        }
        return Math.sqrt(sum);
    }

    double VectorMaxNorm(double[] v) {
        double sum = 0.0;
        for (int i = 0; i < v.length; ++i) {
            sum = Math.max(Math.abs(v[i]), sum);
        }
        return sum;
    }

    double VectorMin(double[] v) {
        double sum = 0.0;
        for (int i = 0; i < v.length; ++i) {
            sum = Math.min(v[i], sum);
        }
        return sum;
    }

    int getMin(ArrayList<SampleFactory.SampleSO> Q) {
        double min = Double.MAX_VALUE;
        int index = 0;
        for (int i = 0; i < Q.size(); ++i) {
            if (!(Q.get(i).f() < min)) continue;
            min = Q.get(i).f();
            index = i;
        }
        return index;
    }

    public double ApproxL(SampleFactory.SampleSO a, SampleFactory.SampleSO b, HyperCube myCube) throws SampleLimitException, ObjectiveAchievedException {
        this.lowBound = a.x;
        this.upBound = b.x;
        ArrayList<SampleFactory.SampleSO> list = myCube.InCubeSamples;
        if (myCube.parent != null) {
            for (int i = 0; i < myCube.parent.InCubeSamples.size(); ++i) {
                SampleFactory.SampleSO x = myCube.parent.InCubeSamples.get(i);
                if (!this.VectorLessEq(a.x, x.x) || !this.VectorLessEq(x.x, b.x) || list.contains(x)) continue;
                boolean contains = false;
                for (int j = 0; j < list.size(); ++j) {
                    if (!(this.VectorNorm(this.VectorSub(list.get((int)j).x, x.x)) < 1.0E-4)) continue;
                    contains = true;
                    break;
                }
                if (contains) continue;
                myCube.AddCubeSample(x);
            }
        }
        while (list.size() < 3 * this.n + 1) {
            SampleFactory.SampleSO rnd_point = this.getSampleSO(this.randomSampler());
            if (rnd_point.f() < a.f() && rnd_point.f() < b.f()) {
                this.test = a.f() - rnd_point.f() + b.f() - rnd_point.f();
            }
            myCube.AddCubeSample(rnd_point);
        }
        double variance = 0.0;
        double mean = 0.0;
        double sL = 0.0;
        double size = (double)((list.size() - 1) * list.size()) / 2.0;
        for (int i = 0; i < list.size(); ++i) {
            for (int j = i + 1; j < list.size(); ++j) {
                double d = this.VectorNorm2(this.VectorSub(list.get((int)i).x, list.get((int)j).x));
                sL = Math.max(Math.abs((list.get(i).f() - list.get(j).f()) / d), sL);
                mean += sL;
            }
        }
        mean /= size;
        return sL;
    }

    void SaveCubes(ArrayList<HyperCube> cubes, String param_fileName) {
        try {
            String string = param_fileName;
        }
        catch (Exception e) {
            System.out.println(e.toString());
            e.printStackTrace();
        }
    }

    @Override
    protected void procedure() throws SampleLimitException, ObjectiveAchievedException {
        double myR;
        ArrayList<SampleFactory.SampleSO> Q = new ArrayList<SampleFactory.SampleSO>();
        ArrayList<HyperCube> cubes = new ArrayList<HyperCube>();
        int xCount = 0;
        double epsilon1 = 0.1;
        boolean stop = false;
        int k = 1;
        this.log("***************************");
        this.log(JAMS.i18n((String)"_start_optimization_"));
        this.log("***************************");
        SampleFactory.SampleSO a = this.getSampleSO(this.lowBound);
        SampleFactory.SampleSO b = this.getSampleSO(this.upBound);
        Q.add(a);
        Q.add(b);
        double[] xR_tmp = this.VectorMul(this.VectorAdd(this.lowBound, this.upBound), 0.5);
        SampleFactory.SampleSO xR = this.getSampleSO(xR_tmp);
        Q.add(xR);
        int IndexWithMinimum = this.getMin(Q);
        SampleFactory.SampleSO v = Q.get(IndexWithMinimum);
        double gamma = v.f();
        HyperCube R = new HyperCube(a, b, xR, null);
        cubes.add(R);
        double L = R.L;
        double my = myR = Math.max(Math.max(a.f(), b.f()) - this.VectorNorm(this.VectorMul(this.VectorSub(a.x, b.x), L)), xR.f() - this.VectorNorm(this.VectorMul(this.VectorSub(a.x, b.x), L)) / 2.0);
        Stack<HyperCube> queue = new Stack<HyperCube>();
        queue.push(R);
        while (!stop) {
            R = (HyperCube)queue.pop();
            a = R.a;
            b = R.b;
            my = R.highestLowBound;
            if ((double)this.factory.getSize() >= this.getMaxn()) break;
            if (gamma - my < 0.1) {
                // empty if block
            }
            int sel_j = 0;
            double max = 0.0;
            for (int i = 0; i < this.n; ++i) {
                if (!(b.x[i] - a.x[i] > max)) continue;
                max = b.x[i] - a.x[i];
                sel_j = i;
            }
            SampleFactory.SampleSO a1 = a;
            double[] b1_tmp = new double[this.n];
            double[] a2_tmp = new double[this.n];
            SampleFactory.SampleSO b2 = b;
            for (int i = 0; i < this.n; ++i) {
                if (i == sel_j) {
                    b1_tmp[i] = (a.x[i] + b.x[i]) / 2.0;
                    a2_tmp[i] = (a.x[i] + b.x[i]) / 2.0;
                    continue;
                }
                b1_tmp[i] = b.x[i];
                a2_tmp[i] = a.x[i];
            }
            SampleFactory.SampleSO b1 = this.getSampleSO(b1_tmp);
            SampleFactory.SampleSO a2 = this.getSampleSO(a2_tmp);
            double[] xR1_tmp = this.VectorMul(this.VectorAdd(a1.x, b1.x), 0.5);
            double[] xR2_tmp = this.VectorMul(this.VectorAdd(a2.x, b2.x), 0.5);
            SampleFactory.SampleSO xR1 = this.getSampleSO(xR1_tmp);
            SampleFactory.SampleSO xR2 = this.getSampleSO(xR2_tmp);
            HyperCube R1 = new HyperCube(a1, b1, xR1, R);
            double L1 = R1.L;
            double tmp1 = this.test;
            HyperCube R2 = new HyperCube(a2, b2, xR2, R);
            double L2 = R2.L;
            double tmp2 = this.test;
            Q.clear();
            Q.add(v);
            Q.add(b1);
            Q.add(xR1);
            Q.add(a2);
            Q.add(xR2);
            IndexWithMinimum = this.getMin(Q);
            v = Q.get(IndexWithMinimum);
            gamma = v.f();
            if (R1.goodOneFactor < tmp1) {
                R1.goodOneFactor = tmp1;
            }
            if (R2.goodOneFactor < tmp2) {
                R2.goodOneFactor = tmp2;
            }
            cubes.remove(R);
            cubes.add(R1);
            cubes.add(R2);
            my = Double.MAX_VALUE;
            ++xCount;
            if (!queue.empty()) continue;
            boolean candidateFound = false;
            double[] T = new double[]{0.0};
            int[] IndexForT = new int[T.length];
            for (int t = 0; t < T.length; ++t) {
                int best = -1;
                double bestLdiff = 1.0E10;
                for (int i = 0; i < cubes.size(); ++i) {
                    HyperCube c = (HyperCube)cubes.get(i);
                    double Lstar = c.CalculateLForTarget(gamma - T[t]);
                    double Ldiff = c.highestLowBound;
                    if (Ldiff < bestLdiff) {
                        best = i;
                        bestLdiff = Ldiff;
                    }
                    if (xCount % 20 != 19) continue;
                    best = 0;
                    bestLdiff = Ldiff;
                    break;
                }
                IndexForT[t] = best;
            }
            for (int i = 0; i < IndexForT.length; ++i) {
                if (IndexForT[i] == -1) continue;
                for (int j = i + 1; j < IndexForT.length; ++j) {
                    if (IndexForT[i] != IndexForT[j]) continue;
                    IndexForT[j] = -1;
                }
                queue.push((HyperCube)cubes.get(IndexForT[i]));
            }
            ++k;
        }
    }

    public class HyperCube {
        protected SampleFactory.SampleSO a;
        protected SampleFactory.SampleSO b;
        protected SampleFactory.SampleSO midPoint;
        protected double L;
        protected ArrayList<SampleFactory.SampleSO> InCubeSamples;
        public double goodOneFactor;
        protected HyperCube parent;
        protected double highestLowBound;

        HyperCube(SampleFactory.SampleSO a, SampleFactory.SampleSO b, SampleFactory.SampleSO midPoint, HyperCube parent) throws SampleLimitException, ObjectiveAchievedException {
            double minimum;
            this.a = a;
            this.b = b;
            this.midPoint = midPoint;
            this.parent = parent;
            this.InCubeSamples = new ArrayList();
            this.InCubeSamples.add(a);
            this.InCubeSamples.add(b);
            this.InCubeSamples.add(midPoint);
            this.L = BranchAndBound.this.ApproxL(a, b, this);
            if (parent != null) {
                this.highestLowBound = Math.max(Math.max(-1.0E12, Math.max(a.f(), b.f()) - BranchAndBound.this.VectorNorm2(BranchAndBound.this.VectorMul(BranchAndBound.this.VectorSub(b.x, a.x), this.L))), midPoint.f() - BranchAndBound.this.VectorNorm2(BranchAndBound.this.VectorMul(BranchAndBound.this.VectorSub(b.x, a.x), this.L)) / 2.0);
            }
            if (this.highestLowBound > (minimum = Math.min(Math.min(a.f(), b.f()), midPoint.f()))) {
                this.highestLowBound = minimum;
            }
            this.goodOneFactor = midPoint.f() - a.f() + (midPoint.f() - b.f());
        }

        public void AddCubeSample(SampleFactory.SampleSO x) {
            this.InCubeSamples.add(x);
        }

        double CalculateLForTarget(double target) {
            double L_theo1 = (Math.max(this.a.f(), this.b.f()) - target) / BranchAndBound.this.VectorNorm(BranchAndBound.this.VectorSub(this.b.x, this.a.x));
            double L_theo2 = 2.0 * (this.midPoint.f() - target) / BranchAndBound.this.VectorNorm(BranchAndBound.this.VectorSub(this.b.x, this.a.x));
            return Math.min(L_theo1, L_theo2);
        }

        double bound() {
            return this.highestLowBound;
        }

        public String compactDescriptionString() {
            String s = "";
            s = s + this.a.x[0] + "\t";
            s = s + this.a.x[1] + "\t";
            s = s + this.highestLowBound + "\n";
            s = s + this.b.x[0] + "\t";
            s = s + this.a.x[1] + "\t";
            s = s + this.highestLowBound + "\n";
            s = s + this.b.x[0] + "\t";
            s = s + this.b.x[1] + "\t";
            s = s + this.highestLowBound + "\n";
            s = s + this.a.x[0] + "\t";
            s = s + this.b.x[1] + "\t";
            s = s + this.highestLowBound + "\n";
            return s;
        }

        public String toString() {
            return "a:" + this.a.toString() + "\nb:" + this.b.toString() + "\nmidPoint:" + this.midPoint.toString() + "\nbound:" + this.highestLowBound;
        }
    }
}

