/*
 * Decompiled with CFR 0.152.
 */
package optas.io;

import jams.data.Attribute;
import jams.data.DefaultDataFactory;
import jams.data.JAMSEntityCollection;
import jams.data.JAMSString;
import jams.model.JAMSComponent;
import jams.model.JAMSVarDescription;
import jams.model.Model;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;

public class StandardEntityReader
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="HRU parameter file name")
    public JAMSString hruFileName;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description="Collection of hru objects")
    public JAMSEntityCollection hrus;

    public void init() {
        this.hrus.setEntities(StandardEntityReader.readParas(this.getModel().getWorkspaceDirectory().getPath() + "/" + this.hruFileName.getValue(), this.getModel()));
    }

    public static void writeParas(Collection<Attribute.Entity> entityList, String fileName, Model model) {
        Iterator<Attribute.Entity> iter = entityList.iterator();
        Attribute.Entity example = null;
        while (iter.hasNext() && (example = iter.next()) == null) {
        }
        if (example == null) {
            model.getRuntime().sendHalt("writeParas: error no hrus to write");
        }
        try {
            Object[] keys;
            BufferedWriter writer = new BufferedWriter(new FileWriter(fileName));
            writer.write("# reduced hru.par created " + new GregorianCalendar().toString() + "\n");
            Vector<String> attributeNames = new Vector<String>();
            for (Object key : keys = example.getKeys()) {
                attributeNames.add((String)key);
                writer.write((String)key + "\t");
            }
            writer.write("\n");
            writer.write("lower Boundaries not available\n");
            writer.write("upper Boundaries not available\n");
            writer.write("process units not available\n");
            for (Attribute.Entity e : entityList) {
                if (e == null) continue;
                for (int i = 0; i < attributeNames.size(); ++i) {
                    String attribute = (String)attributeNames.get(i);
                    try {
                        writer.write(e.getDouble(attribute) + "\t");
                        continue;
                    }
                    catch (Attribute.Entity.NoSuchAttributeException nsae) {
                        model.getRuntime().sendHalt("announced attribute \"" + (String)attributeNames.get(i) + "\" is not existing!");
                    }
                }
                writer.write("\n");
            }
            writer.flush();
            writer.close();
        }
        catch (IOException ioe) {
            model.getRuntime().handle((Throwable)ioe);
        }
    }

    public static ArrayList<Attribute.Entity> readParas(String fileName, Model model) {
        ArrayList<Attribute.Entity> entityList = new ArrayList<Attribute.Entity>();
        try {
            BufferedReader reader = new BufferedReader(new FileReader(fileName));
            String s = "#";
            while (s.startsWith("#")) {
                s = reader.readLine();
            }
            Vector<String> attributeNames = new Vector<String>();
            StringTokenizer tokenizer = new StringTokenizer(s, "\t");
            while (tokenizer.hasMoreTokens()) {
                String aName = tokenizer.nextToken();
                if (aName.equals("to-reach")) {
                    aName = "to_reach";
                }
                attributeNames.add(aName);
            }
            reader.readLine();
            reader.readLine();
            reader.readLine();
            s = reader.readLine();
            while (s != null && !s.startsWith("#")) {
                Attribute.Entity e = DefaultDataFactory.getDataFactory().createEntity();
                tokenizer = new StringTokenizer(s, "\t");
                for (int i = 0; i < attributeNames.size(); ++i) {
                    String token = tokenizer.nextToken();
                    try {
                        e.setDouble((String)attributeNames.get(i), Double.parseDouble(token));
                        continue;
                    }
                    catch (NumberFormatException nfe) {
                        e.setObject((String)attributeNames.get(i), (Object)token);
                    }
                }
                entityList.add(e);
                s = reader.readLine();
            }
        }
        catch (IOException ioe) {
            model.getRuntime().handle((Throwable)ioe);
        }
        return entityList;
    }
}

