/*
 * Decompiled with CFR 0.152.
 */
package optas.io;

import com.google.common.collect.ImmutableList;
import jams.data.Attribute;
import jams.data.DefaultDataFactory;
import java.io.IOException;
import java.util.ArrayList;
import optas.data.DataCollection;
import optas.data.DataSet;
import optas.data.EfficiencyEnsemble;
import optas.data.Measurement;
import optas.data.SimpleEnsemble;
import optas.data.TimeSerie;
import optas.data.TimeSerieEnsemble;
import ucar.ma2.Array;
import ucar.ma2.Index;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Variable;

public class NetCDFFileReader {
    private NetcdfFile file = null;

    public NetCDFFileReader(String file) throws IOException {
        this.file = NetcdfFile.open((String)file);
    }

    private Attribute.TimeInterval createTimeInterval(long start, long end, int timeUnit, int timeUnitCount) {
        Attribute.TimeInterval interval = DefaultDataFactory.getDataFactory().createTimeInterval();
        interval.setTimeUnit(timeUnit);
        interval.setTimeUnitCount(timeUnitCount);
        Attribute.Calendar startCalendar = DefaultDataFactory.getDataFactory().createCalendar();
        startCalendar.setTimeInMillis(start);
        interval.setStart(startCalendar);
        Attribute.Calendar endCalendar = DefaultDataFactory.getDataFactory().createCalendar();
        endCalendar.setTimeInMillis(end);
        interval.setEnd(endCalendar);
        return interval;
    }

    public DataCollection read() throws IOException, ClassNotFoundException, InstantiationException, IllegalAccessException, DataSet.MismatchException {
        DataCollection collection = new DataCollection();
        collection.setSamplerClass(this.file.findGlobalAttribute("samplerClass").getStringValue());
        ImmutableList variables = this.file.getVariables();
        ArrayList<Integer> modelRuns = new ArrayList<Integer>();
        ArrayList<Variable> datasets = new ArrayList<Variable>();
        for (Variable v : variables) {
            if (v.getFullName().equals("modelRunID")) {
                int length = v.getDimension(0).getLength();
                Array values = v.read();
                for (int i = 0; i < length; ++i) {
                    modelRuns.add(values.getInt(i));
                }
                continue;
            }
            datasets.add(v);
        }
        for (Variable dataset : datasets) {
            Attribute.TimeInterval interval;
            String className = dataset.findAttribute("className").getStringValue();
            Class<?> c = ClassLoader.getSystemClassLoader().loadClass(className);
            if (c.equals(TimeSerieEnsemble.class)) {
                int timeUnit = dataset.findAttribute("timeunit").getNumericValue().intValue();
                int timeUnitCount = dataset.findAttribute("timeunitcount").getNumericValue().intValue();
                long start = Long.valueOf(dataset.findAttribute("start").getStringValue());
                long end = Long.valueOf(dataset.findAttribute("end").getStringValue());
                interval = this.createTimeInterval(start, end, timeUnit, timeUnitCount);
                TimeSerieEnsemble ensemble = new TimeSerieEnsemble(dataset.getFullName(), modelRuns.size(), interval);
                Array array = dataset.read();
                Index index = array.getIndex();
                for (Integer id : modelRuns) {
                    double[] values = new double[(int)interval.getNumberOfTimesteps()];
                    int t = 0;
                    while ((long)t < interval.getNumberOfTimesteps()) {
                        index.set(id.intValue(), t);
                        values[t] = array.getDouble(index);
                        ++t;
                    }
                    ensemble.add(id, values);
                }
                collection.addTimeSeriesEnsemble(ensemble);
                continue;
            }
            if (c.equals(Measurement.class)) {
                int timeUnit = dataset.findAttribute("timeunit").getNumericValue().intValue();
                int timeUnitCount = dataset.findAttribute("timeunitcount").getNumericValue().intValue();
                long start = Long.valueOf(dataset.findAttribute("start").getStringValue());
                long end = Long.valueOf(dataset.findAttribute("end").getStringValue());
                interval = this.createTimeInterval(start, end, timeUnit, timeUnitCount);
                Array array = dataset.read();
                double[] values = new double[(int)interval.getNumberOfTimesteps()];
                int t = 0;
                while ((long)t < interval.getNumberOfTimesteps()) {
                    values[t] = array.getDouble(t);
                    ++t;
                }
                TimeSerie series = new TimeSerie(values, interval, dataset.getFullName(), (DataSet)collection);
                Measurement measurement = new Measurement(series);
                collection.addTimeSerie(measurement);
                continue;
            }
            if (c.equals(SimpleEnsemble.class)) {
                SimpleEnsemble ensemble = new SimpleEnsemble(dataset.getFullName(), modelRuns.size());
                Array values = dataset.read();
                int i = 0;
                for (Integer run : modelRuns) {
                    ensemble.add(run, values.getDouble(i));
                    ++i;
                }
                collection.addEnsemble(ensemble);
                continue;
            }
            if (c.equals(EfficiencyEnsemble.class)) {
                boolean isPositiveBest = Boolean.valueOf(dataset.findAttribute("isPositiveBest").getStringValue());
                EfficiencyEnsemble ensemble = new EfficiencyEnsemble(dataset.getFullName(), modelRuns.size(), isPositiveBest);
                Array values = dataset.read();
                int i = 0;
                for (Integer run : modelRuns) {
                    ensemble.add(run, values.getDouble(i));
                    ++i;
                }
                collection.addEnsemble(ensemble);
                continue;
            }
            throw new UnsupportedOperationException();
        }
        if (this.file.findGlobalAttribute("timeDomainStart") != null) {
            Attribute.Calendar startCal = DefaultDataFactory.getDataFactory().createCalendar();
            long start = Long.valueOf(this.file.findGlobalAttribute("timeDomainStart").getStringValue());
            startCal.setTimeInMillis(start);
            Attribute.Calendar endCal = DefaultDataFactory.getDataFactory().createCalendar();
            long end = Long.valueOf(this.file.findGlobalAttribute("timeDomainEnd").getStringValue());
            endCal.setTimeInMillis(end);
            int timeUnit = Integer.valueOf(this.file.findGlobalAttribute("timeUnit").getStringValue());
            int timeUnitCount = Integer.valueOf(this.file.findGlobalAttribute("timeUnitCount").getStringValue());
            Attribute.TimeInterval interval = DefaultDataFactory.getDataFactory().createTimeInterval();
            interval.setStart(startCal);
            interval.setEnd(endCal);
            interval.setTimeUnit(timeUnit);
            interval.setTimeUnitCount(timeUnitCount);
            collection.setGlobalTimeDomain(interval);
        }
        return collection;
    }

    public void close() throws IOException {
        this.file.close();
    }

    public static void main(String[] args) {
        NetCDFFileReader stream = null;
        try {
            stream = new NetCDFFileReader("/Users/Tilo/Desktop/test2.cdf");
            stream.read();
        }
        catch (ClassNotFoundException ex) {
            ex.printStackTrace();
        }
        catch (InstantiationException ex) {
            ex.printStackTrace();
        }
        catch (IllegalAccessException ex) {
            ex.printStackTrace();
        }
        catch (DataSet.MismatchException ex) {
            ex.printStackTrace();
        }
        catch (IOException ex) {
            System.out.println("Unable to read file!");
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException ex) {
                    System.out.println("Unable to close open file!");
                }
            }
        }
    }
}

