/*
 * Decompiled with CFR 0.152.
 */
package optas.hydro.gui;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Stroke;
import optas.data.SimpleEnsemble;
import optas.data.TimeSerie;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.AxisLocation;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.labels.XYToolTipGenerator;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.StackedXYBarRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.data.time.Day;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.data.xy.CategoryTableXYDataset;
import org.jfree.data.xy.XYDataset;

public class WeightChart {
    JFreeChart weightChart;
    StackedXYBarRenderer weightBarRenderer = new StackedXYBarRenderer(0.33);
    XYLineAndShapeRenderer qualityRenderer = new XYLineAndShapeRenderer();
    SimpleEnsemble[] parameter;

    public WeightChart() {
        TimeSeriesCollection dataset1 = new TimeSeriesCollection();
        this.weightChart = ChartFactory.createTimeSeriesChart((String)"Hydrograph", (String)"time", (String)"weights", (XYDataset)dataset1, (boolean)true, (boolean)true, (boolean)false);
    }

    public JFreeChart getChart() {
        return this.weightChart;
    }

    public XYPlot getXYPlot() {
        return this.weightChart.getXYPlot();
    }

    private TimeSeriesCollection buildQualityDataset(TimeSerie obs, double[] quality) {
        TimeSeriesCollection seriesQuality = new TimeSeriesCollection();
        TimeSeries cvError = new TimeSeries((Comparable)((Object)"CV - Error"));
        for (int i = 0; i < quality.length; ++i) {
            cvError.add((RegularTimePeriod)new Day(obs.getTime(i)), quality[i]);
        }
        seriesQuality.addSeries(cvError);
        return seriesQuality;
    }

    private CategoryTableXYDataset buildCategoryDataset(double[][] weights, SimpleEnsemble[] p, TimeSerie obs, boolean[] enableList, boolean[] showList) {
        int j;
        int i;
        int T = (int)obs.getTimeDomain().getNumberOfTimesteps();
        int n = weights.length;
        double[] sum = new double[T];
        CategoryTableXYDataset tableDataset = new CategoryTableXYDataset();
        double maxSum = 0.0;
        for (i = 0; i < T; ++i) {
            for (j = 0; j < n; ++j) {
                if (!enableList[j]) continue;
                int n2 = i;
                sum[n2] = sum[n2] + weights[j][i];
            }
            maxSum = Math.max(maxSum, sum[i]);
        }
        for (i = 0; i < T; ++i) {
            for (j = 0; j < n; ++j) {
                if (!showList[j]) continue;
                if (weights[j][i] / sum[i] < 0.025 && weights[j][i] / maxSum < 0.025) {
                    tableDataset.add((Number)obs.getTime(i).getTime(), (Number)0, p[j].toString(), false);
                    continue;
                }
                tableDataset.add((Number)obs.getTime(i).getTime(), (Number)(weights[j][i] / sum[i]), p[j].toString(), false);
            }
        }
        tableDataset.setAutoWidth(true);
        return tableDataset;
    }

    public void update(double[][] weights, double[] quality, SimpleEnsemble[] parameter, TimeSerie obs, boolean[] enableList, boolean[] showList, Color[] colorList) {
        int i;
        this.parameter = parameter;
        int dsCount = this.weightChart.getXYPlot().getDatasetCount();
        for (int i2 = 0; i2 < dsCount; ++i2) {
            this.weightChart.getXYPlot().setDataset(i2, null);
        }
        CategoryTableXYDataset dataset = this.buildCategoryDataset(weights, parameter, obs, enableList, showList);
        Color[] list = new Color[enableList.length];
        int index = 0;
        for (i = 0; i < showList.length; ++i) {
            if (!showList[i]) continue;
            list[index++] = colorList[i];
        }
        this.qualityRenderer.setBaseFillPaint((Paint)new Color(255, 255, 255));
        this.qualityRenderer.setBaseLinesVisible(true);
        this.qualityRenderer.setDrawSeriesLineAsPath(true);
        this.qualityRenderer.setBaseOutlinePaint((Paint)new Color(255, 255, 255));
        this.qualityRenderer.setBaseSeriesVisible(true);
        this.qualityRenderer.setDrawOutlines(true);
        this.qualityRenderer.setPaint((Paint)new Color(0, 0, 0));
        this.qualityRenderer.setBaseShapesVisible(false);
        this.qualityRenderer.setStroke((Stroke)new BasicStroke(5.0f));
        if (quality != null) {
            TimeSeriesCollection qualityDataset = this.buildQualityDataset(obs, quality);
            this.weightChart.getXYPlot().setDataset(9, (XYDataset)qualityDataset);
            this.weightChart.getXYPlot().setRenderer(9, (XYItemRenderer)this.qualityRenderer);
            NumberAxis axis2 = new NumberAxis("CV Error");
            axis2.setAutoRangeIncludesZero(false);
            this.weightChart.getXYPlot().setRangeAxis(1, (ValueAxis)axis2);
            this.weightChart.getXYPlot().setRangeAxisLocation(1, AxisLocation.TOP_OR_RIGHT);
            this.weightChart.getXYPlot().mapDatasetToRangeAxis(9, 1);
        }
        this.weightChart.getXYPlot().setDataset(10, (XYDataset)dataset);
        this.weightChart.getXYPlot().setRenderer(10, (XYItemRenderer)this.weightBarRenderer);
        for (i = 0; i < list.length; ++i) {
            this.weightBarRenderer.setSeriesFillPaint(i, (Paint)list[i]);
            this.weightBarRenderer.setSeriesPaint(i, (Paint)list[i]);
        }
        this.weightBarRenderer.setToolTipGenerator(new XYToolTipGenerator(){

            public String generateToolTip(XYDataset xyd, int i, int i1) {
                Number nx = xyd.getX(i, i1);
                Number ny = xyd.getY(i, i1);
                if (WeightChart.this.parameter != null && WeightChart.this.parameter.length > i) {
                    String name = WeightChart.this.parameter[i].getName();
                    return name + ":" + ny;
                }
                return "";
            }
        });
    }
}

