/*
 * Decompiled with CFR 0.152.
 */
package optas.hydro.gui;

import jams.JAMS;
import java.awt.Color;
import java.awt.Paint;
import java.util.ArrayList;
import javax.swing.JPanel;
import optas.data.DataSet;
import optas.data.Efficiency;
import optas.data.EfficiencyEnsemble;
import optas.data.Parameter;
import optas.data.SimpleEnsemble;
import optas.gui.MCAT5.MCAT5Plot;
import optas.hydro.calculations.SlopeCalculations;
import optas.tools.PatchedChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYDotRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;

public class GllobalSensitivityEfficiencyComparison
extends MCAT5Plot {
    XYPlot plot = new XYPlot();
    PatchedChartPanel chartPanel = null;

    public GllobalSensitivityEfficiencyComparison() {
        this.addRequest(new MCAT5Plot.SimpleRequest(JAMS.i18n((String)"Efficiency"), Efficiency.class));
        this.addRequest(new MCAT5Plot.SimpleRequest(JAMS.i18n((String)"PARAMETER"), Parameter.class));
        this.init();
    }

    private void init() {
        XYDotRenderer renderer = new XYDotRenderer();
        renderer.setSeriesPaint(0, (Paint)Color.BLUE);
        renderer.setDotHeight(3);
        renderer.setDotWidth(3);
        this.plot.setRenderer((XYItemRenderer)renderer);
        JFreeChart chart = new JFreeChart((Plot)this.plot);
        chart.setTitle(JAMS.i18n((String)"DOTTY_PLOT"));
        this.chartPanel = new PatchedChartPanel(chart, true);
        this.redraw();
    }

    @Override
    public void refresh() throws MCAT5Plot.NoDataException {
        if (!this.isRequestFulfilled()) {
            return;
        }
        ArrayList<DataSet>[] p = this.getData(new int[]{0, 1});
        EfficiencyEnsemble eff = (EfficiencyEnsemble)p[0].get(0);
        SimpleEnsemble param = (SimpleEnsemble)p[1].get(0);
        this.plot.setDomainAxis((ValueAxis)new NumberAxis(eff.getName()));
        this.plot.setRangeAxis((ValueAxis)new NumberAxis("slope"));
        XYSeries[] dataset = SlopeCalculations.calculateDerivative(eff, this.getDataSource());
        int c = -1;
        for (int i = 0; i < dataset.length; ++i) {
            if (!dataset[i].getDescription().equals(param.getName())) continue;
            c = i;
            break;
        }
        if (c == -1) {
            return;
        }
        this.plot.setDataset(0, (XYDataset)new XYSeriesCollection(dataset[c]));
        if (this.plot.getRangeAxis() != null) {
            this.plot.getRangeAxis().setAutoRange(true);
        }
        if (this.plot.getDomainAxis() != null) {
            this.plot.getDomainAxis().setAutoRange(true);
        }
    }

    @Override
    public JPanel getPanel() {
        return this.chartPanel;
    }
}

