/*
 * Decompiled with CFR 0.152.
 */
package optas.gui.wizard;

import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.JTextField;
import optas.gui.wizard.Parameter;
import optas.optimizer.management.NumericOptimizerParameter;

class NumericFocusListener
implements FocusListener {
    public static final int MODE_LOWERBOUND = 0;
    public static final int MODE_UPPERBOUND = 1;
    public static final int MODE_STARTVALUE = 2;
    public static final int MODE_PARAMETERVALUE = 3;

    NumericFocusListener() {
    }

    @Override
    public void focusLost(FocusEvent e) {
        JTextField src = (JTextField)e.getSource();
        Parameter p = (Parameter)src.getClientProperty("parameter");
        Integer mode = (Integer)src.getClientProperty("mode");
        try {
            double value = Double.parseDouble(src.getText());
            if (mode == 3) {
                // empty if block
            }
            switch (mode) {
                case 0: {
                    p.setLowerBound(Double.parseDouble(src.getText()));
                    break;
                }
                case 1: {
                    p.setUpperBound(Double.parseDouble(src.getText()));
                    break;
                }
                case 2: {
                    p.setStartValue(new double[]{Double.parseDouble(src.getText())});
                    break;
                }
                case 3: {
                    NumericOptimizerParameter p2 = (NumericOptimizerParameter)src.getClientProperty("property");
                    p2.setValue(Double.parseDouble(src.getText()));
                    NumericOptimizerParameter param = (NumericOptimizerParameter)src.getClientProperty("property");
                    if (!(value < param.getLowerBound()) && !(value > param.getUpperBound())) break;
                    throw new NumberFormatException();
                }
            }
        }
        catch (NumberFormatException nfe) {
            switch (mode) {
                case 0: {
                    src.setText(Double.toString(p.getLowerBound()));
                    break;
                }
                case 1: {
                    src.setText(Double.toString(p.getUpperBound()));
                    break;
                }
                case 2: {
                    if (p.getStartValue().length > 0) {
                        src.setText(Double.toString(p.getStartValue()[0]));
                        break;
                    }
                    src.setText("");
                    break;
                }
                case 3: {
                    src.setText(Double.toString(((NumericOptimizerParameter)src.getClientProperty("property")).getValue()));
                }
            }
        }
    }

    @Override
    public void focusGained(FocusEvent e) {
    }
}

