/*
 * Decompiled with CFR 0.152.
 */
package optas.gui.wizard;

import jams.data.Attribute;
import jams.meta.ComponentDescriptor;
import jams.meta.ComponentField;
import jams.meta.ContextAttribute;
import jams.meta.ContextDescriptor;
import jams.meta.ModelDescriptor;
import jams.meta.ModelProperties;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import optas.efficiencies.UniversalEfficiencyCalculator;
import optas.gui.wizard.Attribute;
import optas.gui.wizard.Objective;
import optas.gui.wizard.Parameter;

public class ModelAnalyzer {
    public static final int COLLECT_READATTRIBUTES = 0;
    public static final int COLLECT_WRITEATTTRIBUTES = 1;
    public String error = null;
    ModelDescriptor md;
    SortedSet<Parameter> result = null;

    public ModelAnalyzer(ModelDescriptor md) {
        this.md = md;
    }

    public ModelDescriptor getModelDescriptor() {
        return this.md;
    }

    private HashMap<String, Parameter.Range> getDefaultRangeMap() {
        String[] groupNames;
        HashMap<String, Parameter.Range> map = new HashMap<String, Parameter.Range>();
        for (String groupName : groupNames = this.md.getModelProperties().getAllGroupNames()) {
            ArrayList properties = this.md.getModelProperties().getGroup(groupName).getProperties();
            for (Object o : properties) {
                double upperBound;
                double lowerBound;
                String propertyName;
                String componentName;
                if (!(o instanceof ModelProperties.ModelProperty)) continue;
                ModelProperties.ModelProperty property = (ModelProperties.ModelProperty)o;
                if (property.var != null && property.var.getParent() != null) {
                    componentName = property.var.getParent().getInstanceName();
                    propertyName = property.var.getName();
                    lowerBound = property.lowerBound;
                    upperBound = property.upperBound;
                    map.put(componentName + "." + propertyName, new Parameter.Range(lowerBound, upperBound));
                }
                if (property.attribute == null || property.attribute.getContext() == null) continue;
                componentName = property.attribute.getContext().getInstanceName();
                propertyName = property.attribute.getName();
                lowerBound = property.lowerBound;
                upperBound = property.upperBound;
                map.put(componentName + "." + propertyName, new Parameter.Range(lowerBound, upperBound));
            }
        }
        return map;
    }

    private Set<Attribute> getContextAttributeList(boolean effOnly) {
        HashMap map = this.md.getComponentDescriptors();
        TreeSet<Attribute> list = new TreeSet<Attribute>();
        for (ComponentDescriptor cd : map.values()) {
            for (ComponentField cf : cd.getComponentFields().values()) {
                for (ContextAttribute ca : cf.getContextAttributes()) {
                    boolean consider;
                    if (!Attribute.Double.class.isAssignableFrom(ca.getType())) continue;
                    boolean bl = consider = !effOnly;
                    if (effOnly) {
                        for (ComponentField cf2 : ca.getFields()) {
                            if (!UniversalEfficiencyCalculator.class.isAssignableFrom(cf2.getParent().getClazz()) || !cf2.getName().contains("normalized")) continue;
                            consider = true;
                            break;
                        }
                    }
                    if (!consider) continue;
                    list.add(new Attribute(ca));
                }
            }
        }
        return list;
    }

    private Set<Attribute> getParameterList() {
        HashMap map = this.md.getComponentDescriptors();
        TreeSet<Attribute> list = new TreeSet<Attribute>();
        for (ComponentDescriptor cd : map.values()) {
            for (ComponentField field : cd.getComponentFields().values()) {
                String value = field.getValue();
                if (!Attribute.Double.class.isAssignableFrom(field.getType()) || field.getAccessType() != 0 || value == null) continue;
                list.add(new Attribute(field));
            }
            if (!(cd instanceof ContextDescriptor)) continue;
            ContextDescriptor contextDesc = (ContextDescriptor)cd;
            for (ContextAttribute ca : contextDesc.getStaticAttributes().values()) {
                if (!Attribute.Double.class.isAssignableFrom(ca.getType())) continue;
                list.add(new Attribute(ca));
            }
        }
        return list;
    }

    public SortedSet<Parameter> getParameters() {
        if (this.result != null) {
            return this.result;
        }
        this.result = new TreeSet<Parameter>();
        Set<Attribute> parameterList = this.getParameterList();
        HashMap<String, Parameter.Range> defaultRangeMap = this.getDefaultRangeMap();
        Iterator<Attribute> iter1 = parameterList.iterator();
        while (iter1.hasNext()) {
            ContextAttribute ca;
            Parameter.Range range;
            ComponentField cf;
            Parameter variable = new Parameter(iter1.next());
            if (variable.field instanceof ComponentField && (cf = (ComponentField)variable.field).getParent().isEnabled()) {
                range = defaultRangeMap.get(cf.getParent() + "." + cf.getName());
                if (range != null) {
                    variable.setLowerBound(range.lowerBound);
                    variable.setUpperBound(range.upperBound);
                }
                this.result.add(variable);
            }
            if (!(variable.field instanceof ContextAttribute) || !(ca = (ContextAttribute)variable.field).getContext().isEnabled()) continue;
            range = defaultRangeMap.get(ca.getContext().getInstanceName() + "." + ca.getName());
            if (range != null) {
                variable.setLowerBound(range.lowerBound);
                variable.setUpperBound(range.upperBound);
            }
            this.result.add(variable);
        }
        return this.result;
    }

    public SortedSet<Objective> getAttributesWithWriteAccess() {
        TreeSet<Objective> result = new TreeSet<Objective>();
        Set<Attribute> objectiveList = this.getContextAttributeList(false);
        Iterator<Attribute> iter1 = objectiveList.iterator();
        while (iter1.hasNext()) {
            Objective o = new Objective(iter1.next());
            result.add(new Objective(o));
        }
        return result;
    }

    public SortedSet<Objective> getObjectives() {
        TreeSet<Objective> result = new TreeSet<Objective>();
        Set<Attribute> objectiveList = this.getContextAttributeList(true);
        Iterator<Attribute> iter1 = objectiveList.iterator();
        while (iter1.hasNext()) {
            Objective o = new Objective(iter1.next());
            result.add(new Objective(o));
        }
        return result;
    }
}

