/*
 * Decompiled with CFR 0.152.
 */
package optas.gui.wizard;

import jams.JAMS;
import jams.gui.WorkerDlg;
import jams.gui.tools.GUIState;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Stroke;
import java.util.HashMap;
import java.util.TimeZone;
import javax.swing.SwingUtilities;
import optas.data.TimeFilter;
import optas.data.TimeFilterCollection;
import optas.data.TimeFilterFactory;
import optas.data.TimeSerie;
import optas.tools.PatchedChartPanel;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.AxisLocation;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.StackedXYBarRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.data.Range;
import org.jfree.data.time.Day;
import org.jfree.data.time.Hour;
import org.jfree.data.time.Month;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.data.xy.CategoryTableXYDataset;
import org.jfree.data.xy.XYDataset;

public class HydrographChart {
    static TimeZone GMT_TZ = TimeZone.getTimeZone("GMT");
    static HashMap<Integer, TimeSeries> HydrographBuffer = new HashMap();
    JFreeChart chart;
    TimeSeriesCollection datasetHydrograph = new TimeSeriesCollection();
    TimeSeriesCollection datasetPeaks;
    TimeSeriesCollection datasetRecessionCurves;
    TimeSeriesCollection datasetGroundwater;
    TimeSeriesCollection datasetBaseFlow;
    TimeSeriesCollection datasetMark;
    TimeSerie hydrograph;
    TimeSerie groundwater;
    int peakCount = 0;
    int recessionCount = 0;
    double groundwaterThreshold = 0.0;
    FilterMode filterMode = FilterMode.MULTI_ROW;
    TimeFilterCollection filters = new TimeFilterCollection();
    TimeFilter selectedTimeFilter = null;
    PatchedChartPanel panel = null;

    public HydrographChart() {
        int i;
        this.chart = ChartFactory.createTimeSeriesChart((String)"Hydrograph", (String)"time", (String)"runoff", (XYDataset)this.datasetHydrograph, (boolean)false, (boolean)true, (boolean)false);
        XYLineAndShapeRenderer hydrographRenderer = new XYLineAndShapeRenderer();
        hydrographRenderer.setBaseFillPaint((Paint)new Color(0, 0, 255));
        hydrographRenderer.setBaseLinesVisible(true);
        hydrographRenderer.setDrawSeriesLineAsPath(true);
        hydrographRenderer.setBaseOutlinePaint((Paint)new Color(0, 0, 255));
        hydrographRenderer.setBasePaint((Paint)new Color(0, 0, 255));
        hydrographRenderer.setOutlinePaint((Paint)new Color(0, 0, 255));
        hydrographRenderer.setPaint((Paint)new Color(0, 0, 255));
        hydrographRenderer.setBaseSeriesVisible(true);
        hydrographRenderer.setDrawOutlines(true);
        hydrographRenderer.setBaseShapesVisible(false);
        hydrographRenderer.setStroke((Stroke)new BasicStroke(3.0f));
        this.chart.getXYPlot().setRenderer(0, (XYItemRenderer)hydrographRenderer);
        this.chart.getPlot().setBackgroundPaint((Paint)Color.white);
        this.chart.getXYPlot().setDomainGridlinePaint((Paint)Color.black);
        StackedXYBarRenderer filterRenderer1 = new StackedXYBarRenderer(0.0);
        Color[] list1 = new Color[10];
        for (i = 0; i < 10; ++i) {
            if (i % 4 == 0) {
                list1[i] = Color.red;
                continue;
            }
            if (i % 4 == 1) {
                list1[i] = new Color(1.0f, 1.0f, 1.0f, 0.0f);
                continue;
            }
            if (i % 4 == 2) {
                list1[i] = new Color(0.0f, 1.0f, 0.0f);
                continue;
            }
            if (i % 4 != 3) continue;
            list1[i] = Color.MAGENTA;
        }
        for (i = 0; i < 10; ++i) {
            filterRenderer1.setSeriesFillPaint(i, (Paint)list1[i]);
            filterRenderer1.setSeriesPaint(i, (Paint)list1[i]);
            if (i % 4 != 2) continue;
            filterRenderer1.setSeriesOutlineStroke(i, (Stroke)new BasicStroke(20.0f));
            filterRenderer1.setSeriesStroke(i, (Stroke)new BasicStroke(20.0f));
        }
        filterRenderer1.setBaseSeriesVisible(true);
        filterRenderer1.setOutlinePaint(null);
        filterRenderer1.setStroke((Stroke)new BasicStroke(0.0f));
        filterRenderer1.setShadowVisible(false);
        this.chart.getXYPlot().setRenderer(1, (XYItemRenderer)filterRenderer1);
        this.chart.getXYPlot().mapDatasetToRangeAxis(1, 1);
        NumberAxis axis2 = new NumberAxis("");
        axis2.setRange(new Range(0.0, 1.0));
        axis2.setVisible(false);
        this.chart.getXYPlot().setRangeAxis(1, (ValueAxis)axis2);
        this.chart.getXYPlot().setRangeAxisLocation(1, AxisLocation.TOP_OR_RIGHT);
    }

    private CategoryTableXYDataset buildCategoryDataset(double[][] filter, TimeSerie obs) {
        int n = filter.length;
        if (n == 0) {
            return null;
        }
        int T = filter[0].length;
        CategoryTableXYDataset tableDataset = new CategoryTableXYDataset();
        for (int i = 0; i < T; ++i) {
            for (int j = 0; j < n; ++j) {
                if (filter[j][i] == 0.0) {
                    tableDataset.add((Number)obs.getTime(i).getTime(), (Number)(1.0 / (double)n), Integer.toString(4 * j), false);
                    tableDataset.add((Number)obs.getTime(i).getTime(), (Number)0, Integer.toString(4 * j + 1), false);
                    tableDataset.add((Number)obs.getTime(i).getTime(), (Number)0, Integer.toString(4 * j + 2), false);
                    tableDataset.add((Number)obs.getTime(i).getTime(), (Number)0, Integer.toString(4 * j + 3), false);
                    continue;
                }
                if (filter[j][i] == 1.0) {
                    tableDataset.add((Number)obs.getTime(i).getTime(), (Number)0.0, Integer.toString(4 * j), false);
                    tableDataset.add((Number)obs.getTime(i).getTime(), (Number)(1.0 / (double)n), Integer.toString(4 * j + 1), false);
                    tableDataset.add((Number)obs.getTime(i).getTime(), (Number)0, Integer.toString(4 * j + 2), false);
                    tableDataset.add((Number)obs.getTime(i).getTime(), (Number)0, Integer.toString(4 * j + 3), false);
                    continue;
                }
                if (filter[j][i] == 2.0) {
                    tableDataset.add((Number)obs.getTime(i).getTime(), (Number)0.0, Integer.toString(4 * j), false);
                    tableDataset.add((Number)obs.getTime(i).getTime(), (Number)0.0, Integer.toString(4 * j + 1), false);
                    tableDataset.add((Number)obs.getTime(i).getTime(), (Number)(1.0 / (double)n), Integer.toString(4 * j + 2), false);
                    tableDataset.add((Number)obs.getTime(i).getTime(), (Number)0.0, Integer.toString(4 * j + 3), false);
                    continue;
                }
                tableDataset.add((Number)obs.getTime(i).getTime(), (Number)0.0, Integer.toString(4 * j), false);
                tableDataset.add((Number)obs.getTime(i).getTime(), (Number)0.0, Integer.toString(4 * j + 1), false);
                tableDataset.add((Number)obs.getTime(i).getTime(), (Number)0.0, Integer.toString(4 * j + 2), false);
                tableDataset.add((Number)obs.getTime(i).getTime(), (Number)(1.0 / (double)n), Integer.toString(4 * j + 3), false);
            }
        }
        double width = obs.getTime(1).getTime() - obs.getTime(0).getTime();
        tableDataset.setIntervalWidth(width);
        return tableDataset;
    }

    public void setHydrograph(TimeSerie hydrograph) {
        if (this.hydrograph != hydrograph) {
            this.hydrograph = hydrograph;
            this.update();
        }
    }

    public void clearTimeFilter() {
        this.filters.clear();
        this.selectedTimeFilter = null;
    }

    public void addTimeFilter(TimeFilter filter) {
        this.filters.add(filter);
        this.update();
    }

    public void setTimeFilters(TimeFilterCollection timeFilters) {
        this.setTimeFilters(timeFilters, false);
    }

    public void setTimeFilters(TimeFilterCollection timeFilters, boolean forceUpdate) {
        boolean isTheSame = true;
        if (timeFilters.size() == this.filters.size()) {
            for (int i = 0; i < timeFilters.size(); ++i) {
                if (!timeFilters.get(i).equals(this.filters.get(i))) continue;
                isTheSame = false;
            }
        } else {
            isTheSame = false;
        }
        if (!isTheSame || forceUpdate) {
            this.clearTimeFilter();
            this.addTimeFilters(timeFilters);
        }
    }

    public void addTimeFilters(TimeFilterCollection timeFilters) {
        if (timeFilters.size() == 0) {
            return;
        }
        for (TimeFilter f : timeFilters.get()) {
            this.filters.add(f);
        }
        this.update();
    }

    public void setFilterMode(FilterMode filterMode) {
        this.filterMode = filterMode;
    }

    public FilterMode getFilterMode() {
        return this.filterMode;
    }

    public JFreeChart getChart() {
        return this.chart;
    }

    public PatchedChartPanel getChartPanel() {
        if (this.panel == null) {
            this.panel = new PatchedChartPanel(this.chart, true);
            this.panel.setMinimumDrawWidth(0);
            this.panel.setMinimumDrawHeight(0);
            this.panel.setMaximumDrawWidth(2000);
            this.panel.setMaximumDrawHeight(2000);
        }
        return this.panel;
    }

    public XYPlot getXYPlot() {
        return this.chart.getXYPlot();
    }

    public void setSelectedTimeFilter(TimeFilter f) {
        if (this.selectedTimeFilter == f) {
            return;
        }
        if (this.selectedTimeFilter == null || f == null || f.toString().compareTo(this.selectedTimeFilter.toString()) != 0) {
            this.selectedTimeFilter = f;
            if (f instanceof TimeFilterFactory.RangeTimeFilter) {
                this.update();
            }
        }
    }

    public void update() {
        Runnable r = new Runnable(){

            @Override
            public void run() {
                int i;
                HydrographChart.this.datasetHydrograph.removeAllSeries();
                int dsCount = HydrographChart.this.chart.getXYPlot().getDatasetCount();
                for (int i2 = 0; i2 < dsCount; ++i2) {
                    HydrographChart.this.chart.getXYPlot().setDataset(i2, null);
                }
                if (HydrographChart.this.hydrograph == null) {
                    return;
                }
                long n = HydrographChart.this.hydrograph.getTimeDomain().getNumberOfTimesteps();
                long lastNonFiltered = 0L;
                double[][] filtered = null;
                filtered = HydrographChart.this.filterMode == FilterMode.SINGLE_ROW ? new double[1][(int)n] : new double[HydrographChart.this.filters.size()][(int)n];
                TimeFilter localSelection = null;
                if (HydrographChart.this.selectedTimeFilter instanceof TimeFilterFactory.RangeTimeFilter) {
                    localSelection = HydrographChart.this.selectedTimeFilter;
                }
                TimeFilter combinedFilter = HydrographChart.this.filters.combine();
                TimeFilterCollection filtersWithoutSelection = new TimeFilterCollection();
                for (TimeFilter tf : HydrographChart.this.filters.get()) {
                    if (tf == localSelection) continue;
                    filtersWithoutSelection.add(tf);
                }
                TimeFilter combinedFilter2 = filtersWithoutSelection.combine();
                int hashKey = HydrographChart.this.hydrograph.hashCode();
                TimeSeries seriesHydrograph = HydrographBuffer.get(hashKey);
                if (seriesHydrograph == null) {
                    seriesHydrograph = new TimeSeries((Comparable)((Object)"Hydrograph"));
                    i = 0;
                    while ((long)i < n) {
                        if (HydrographChart.this.hydrograph.getValue(i) == JAMS.getMissingDataValue()) {
                            if (HydrographChart.this.hydrograph.getTimeDomain().getTimeUnit() == 2) {
                                seriesHydrograph.add((RegularTimePeriod)new Month(HydrographChart.this.hydrograph.getTime(i), GMT_TZ), Double.NaN);
                            } else if (HydrographChart.this.hydrograph.getTimeDomain().getTimeUnit() == 6) {
                                seriesHydrograph.add((RegularTimePeriod)new Day(HydrographChart.this.hydrograph.getTime(i), GMT_TZ), Double.NaN);
                            } else if (HydrographChart.this.hydrograph.getTimeDomain().getTimeUnit() == 11) {
                                seriesHydrograph.add((RegularTimePeriod)new Hour(HydrographChart.this.hydrograph.getTime(i), GMT_TZ), Double.NaN);
                            }
                        } else if (HydrographChart.this.hydrograph.getTimeDomain().getTimeUnit() == 2) {
                            seriesHydrograph.add((RegularTimePeriod)new Month(HydrographChart.this.hydrograph.getTime(i), GMT_TZ), HydrographChart.this.hydrograph.getValue(i));
                        } else if (HydrographChart.this.hydrograph.getTimeDomain().getTimeUnit() == 6) {
                            seriesHydrograph.add((RegularTimePeriod)new Day(HydrographChart.this.hydrograph.getTime(i), GMT_TZ), HydrographChart.this.hydrograph.getValue(i));
                        } else if (HydrographChart.this.hydrograph.getTimeDomain().getTimeUnit() == 11) {
                            seriesHydrograph.add((RegularTimePeriod)new Hour(HydrographChart.this.hydrograph.getTime(i), GMT_TZ), HydrographChart.this.hydrograph.getValue(i));
                        }
                        ++i;
                    }
                    HydrographBuffer.put(hashKey, seriesHydrograph);
                }
                i = 0;
                while ((long)i < n) {
                    if (HydrographChart.this.filterMode != FilterMode.SINGLE_ROW) {
                        for (int j = 0; j < HydrographChart.this.filters.size(); ++j) {
                            if (HydrographChart.this.filters.get(j) == null || HydrographChart.this.filters.get(j).isFiltered(HydrographChart.this.hydrograph.getTime(i))) {
                                filtered[j][i] = 1.0;
                                lastNonFiltered = i;
                                continue;
                            }
                            if ((long)i - lastNonFiltered != 1L) continue;
                            filtered[j][i] = 0.0;
                        }
                    } else {
                        filtered[0][i] = 1.0;
                        if (!combinedFilter.isFiltered(HydrographChart.this.hydrograph.getTime(i)) && !combinedFilter2.isFiltered(HydrographChart.this.hydrograph.getTime(i))) {
                            filtered[0][i] = localSelection == null || localSelection.isFiltered(HydrographChart.this.hydrograph.getTime(i)) ? 0.0 : 3.0;
                        } else if (!combinedFilter.isFiltered(HydrographChart.this.hydrograph.getTime(i)) && combinedFilter2.isFiltered(HydrographChart.this.hydrograph.getTime(i))) {
                            filtered[0][i] = 2.0;
                        }
                    }
                    ++i;
                }
                HydrographChart.this.datasetHydrograph.addSeries(seriesHydrograph);
                HydrographChart.this.chart.getXYPlot().setDataset(0, (XYDataset)HydrographChart.this.datasetHydrograph);
                HydrographChart.this.chart.getXYPlot().setDataset(1, (XYDataset)HydrographChart.this.buildCategoryDataset(filtered, HydrographChart.this.hydrograph));
            }
        };
        if (this.hydrograph == null) {
            this.datasetHydrograph.removeAllSeries();
            int dsCount = this.chart.getXYPlot().getDatasetCount();
            for (int i = 0; i < dsCount; ++i) {
                this.chart.getXYPlot().setDataset(i, null);
            }
        } else if (this.panel != null && !this.panel.isShowing()) {
            SwingUtilities.invokeLater(r);
        } else {
            WorkerDlg progress = new WorkerDlg(GUIState.getMainWindow(), "Updating plot");
            progress.setInderminate(true);
            progress.setTask(r);
            progress.execute();
        }
    }

    public static enum FilterMode {
        SINGLE_ROW,
        MULTI_ROW;

    }
}

