/*
 * Decompiled with CFR 0.152.
 */
package optas.gui.MCAT5;

import jams.JAMS;
import jams.data.JAMSCalendar;
import jams.gui.ObserverWorkerDlg;
import jams.gui.WorkerDlg;
import jams.gui.tools.GUIHelper;
import jams.gui.tools.GUIState;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.beans.XMLEncoder;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Observer;
import java.util.Set;
import javax.swing.AbstractCellEditor;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import optas.SA.SobolsMethodTemporal;
import optas.data.DataCollection;
import optas.data.DataSet;
import optas.data.Efficiency;
import optas.data.EfficiencyEnsemble;
import optas.data.Measurement;
import optas.data.Parameter;
import optas.data.SimpleEnsemble;
import optas.data.TimeFilter;
import optas.data.TimeFilterFactory;
import optas.data.TimeSerie;
import optas.data.TimeSerieEnsemble;
import optas.gui.MCAT5.DataRequestPanel;
import optas.gui.MCAT5.DottyPlot;
import optas.gui.MCAT5.GroupConfigurator;
import optas.gui.MCAT5.MCAT5Plot;
import optas.gui.MCAT5.MCAT5Toolbar;
import optas.gui.wizard.HydrographChart;
import optas.hydro.GreedyOptimizationScheme;
import optas.hydro.OptimizationScheme;
import optas.hydro.SimilarityBasedOptimizationScheme;
import optas.hydro.VarianceBasedGreedyOptimizationScheme;
import optas.hydro.gui.WeightChart;
import optas.tools.PatchedChartPanel;
import org.jfree.chart.ChartMouseEvent;
import org.jfree.chart.ChartMouseListener;
import org.jfree.chart.entity.ChartEntity;
import org.jfree.chart.entity.XYItemEntity;
import org.jfree.chart.event.AxisChangeEvent;
import org.jfree.chart.event.AxisChangeListener;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.data.time.TimeSeriesCollection;

public class TemporalSAAnalysisANN
extends MCAT5Plot {
    int MAX_WEIGHTS = 40;
    Color[] standardColorList = TemporalSAAnalysisANN.getDifferentColors(this.MAX_WEIGHTS);
    HydrographChart hydrographChart;
    WeightChart weightChart;
    String[] parameterIDs = null;
    XYLineAndShapeRenderer[] weightRenderer = new XYLineAndShapeRenderer[this.MAX_WEIGHTS];
    JLabel step1Label = new JLabel("Step 1: Data Setup");
    JLabel step2Label = new JLabel("Step 2: Calculate Optimization Scheme");
    JLabel step3Label = new JLabel("Step 3: Export");
    JButton trainNetworkBn = new JButton("Train KN - Network");
    JButton loadNetworkBn = new JButton("Load KN - Network");
    JButton saveNetworkBn = new JButton("Save KN - Network");
    JButton calcGreedy1SchemeBn = new JButton("Greedy (VB)");
    JButton calcGreedy2SchemeBn = new JButton("Greedy (Weights only)");
    JButton calcSimilartySchemeBn = new JButton("Similarity");
    JButton calcOptimalSchemeBn = new JButton("Optimal");
    JButton exportSchemeBn = new JButton("Export Scheme");
    JTable parameterTable = new JTable(new Object[][]{{Boolean.TRUE, Boolean.TRUE, "test", Color.black}}, new String[]{"x", "y", "z", "a"});
    JLabel infoLabel = new JLabel("Dominance:?");
    SimpleEnsemble[] p = null;
    EfficiencyEnsemble e = null;
    TimeSerieEnsemble ts = null;
    Measurement obs = null;
    JPanel mainPanel = null;
    SobolsMethodTemporal tsa = null;
    VarianceBasedGreedyOptimizationScheme varianceGreedyScheme = new VarianceBasedGreedyOptimizationScheme();
    GreedyOptimizationScheme greedyScheme = new GreedyOptimizationScheme();
    SimilarityBasedOptimizationScheme simBasedScheme = new SimilarityBasedOptimizationScheme();
    OptimizationScheme currentScheme = null;
    JFileChooser jfc = new JFileChooser();
    JPanel progressPanel = new JPanel();
    final GroupConfigurator groupConfigurator = new GroupConfigurator();

    public static Color[] getDifferentColors(int n) {
        Color[] cols = new Color[n];
        for (int i = 0; i < n; ++i) {
            cols[i] = Color.getHSBColor((float)(113 * i % n) / (float)n, (float)(223 * i % n) / (float)n, 1.0f);
        }
        return cols;
    }

    public TemporalSAAnalysisANN() {
        this.addRequest(new MCAT5Plot.SimpleRequest(JAMS.i18n((String)"SIMULATED_TIMESERIE"), TimeSerie.class));
        this.addRequest(new MCAT5Plot.SimpleRequest(JAMS.i18n((String)"OBSERVED_TIMESERIE"), Measurement.class));
        this.addRequest(new MCAT5Plot.SimpleRequest(JAMS.i18n((String)"Efficiency"), Efficiency.class));
        this.calcGreedy1SchemeBn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TemporalSAAnalysisANN.this.currentScheme = TemporalSAAnalysisANN.this.varianceGreedyScheme;
                TemporalSAAnalysisANN.this.calcOptimizationScheme(TemporalSAAnalysisANN.this.currentScheme);
                TemporalSAAnalysisANN.this.setButtonEnableState(AnalysisState.Grouped);
            }
        });
        this.calcGreedy2SchemeBn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TemporalSAAnalysisANN.this.currentScheme = TemporalSAAnalysisANN.this.greedyScheme;
                TemporalSAAnalysisANN.this.calcOptimizationScheme(TemporalSAAnalysisANN.this.currentScheme);
                TemporalSAAnalysisANN.this.setButtonEnableState(AnalysisState.Grouped);
            }
        });
        this.calcSimilartySchemeBn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TemporalSAAnalysisANN.this.currentScheme = TemporalSAAnalysisANN.this.simBasedScheme;
                TemporalSAAnalysisANN.this.calcOptimizationScheme(TemporalSAAnalysisANN.this.currentScheme);
                TemporalSAAnalysisANN.this.setButtonEnableState(AnalysisState.Grouped);
            }
        });
        this.trainNetworkBn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WorkerDlg progress = new WorkerDlg(GUIState.getMainWindow(), "Calculating Sensitivity Indicies");
                TemporalSAAnalysisANN.this.tsa.deleteObservers();
                TemporalSAAnalysisANN.this.tsa.addObserver((Observer)new ObserverWorkerDlg(progress));
                progress.setInderminate(true);
                progress.setTask(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            TemporalSAAnalysisANN.this.tsa.calculate();
                            TemporalSAAnalysisANN.this.weightChart.update(TemporalSAAnalysisANN.this.tsa.calculate(), null, TemporalSAAnalysisANN.this.p, TemporalSAAnalysisANN.this.obs, TemporalSAAnalysisANN.this.getEnableList(), TemporalSAAnalysisANN.this.getShowList(), TemporalSAAnalysisANN.this.standardColorList);
                            TemporalSAAnalysisANN.this.setButtonEnableState(AnalysisState.Trained);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            System.out.println(e);
                        }
                    }
                });
                progress.execute();
            }
        });
        this.loadNetworkBn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JFileChooser cfr_ignored_0 = TemporalSAAnalysisANN.this.jfc;
                if (TemporalSAAnalysisANN.this.jfc.showOpenDialog(TemporalSAAnalysisANN.this.mainPanel) == 0) {
                    File f = TemporalSAAnalysisANN.this.jfc.getSelectedFile();
                    TemporalSAAnalysisANN.this.tsa.loadNetworkState(f);
                    for (ActionListener l : (ActionListener[])TemporalSAAnalysisANN.this.trainNetworkBn.getListeners(ActionListener.class)) {
                        l.actionPerformed(null);
                    }
                }
            }
        });
        this.saveNetworkBn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JFileChooser cfr_ignored_0 = TemporalSAAnalysisANN.this.jfc;
                if (TemporalSAAnalysisANN.this.jfc.showSaveDialog(TemporalSAAnalysisANN.this.mainPanel) == 0) {
                    File f = TemporalSAAnalysisANN.this.jfc.getSelectedFile();
                    TemporalSAAnalysisANN.this.tsa.saveNetworkState(f);
                }
            }
        });
        this.exportSchemeBn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TemporalSAAnalysisANN.this.exportOptimizationScheme(TemporalSAAnalysisANN.this.currentScheme);
            }
        });
        this.groupConfigurator.addUpdateListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GroupConfigurator conf = (GroupConfigurator)e.getSource();
                if (e.getActionCommand().equals("update")) {
                    TemporalSAAnalysisANN.this.currentScheme.setSolutionGroups(conf.getGroupConfiguration());
                    int Tdom = TemporalSAAnalysisANN.this.currentScheme.getDominatedTimeSteps(conf.getSelectedGroup()).length;
                    int Ttotal = TemporalSAAnalysisANN.this.ts.getTimesteps();
                    TemporalSAAnalysisANN.this.groupConfigurator.setDominanceInfo((double)Tdom / (double)Ttotal);
                } else {
                    int k = conf.getGroupConfiguration().size();
                    TemporalSAAnalysisANN.this.hydrographChart.clearTimeFilter();
                    for (int j = 0; j < k; ++j) {
                        int[] dominatedTimeSteps = TemporalSAAnalysisANN.this.currentScheme.dominatedTimeStepsForGroup.get(j);
                        Date[] dates = new Date[dominatedTimeSteps.length];
                        for (int i = 0; i < dominatedTimeSteps.length; ++i) {
                            dates[i] = TemporalSAAnalysisANN.this.obs.getTime(dominatedTimeSteps[i]);
                        }
                        TimeFilter f = TimeFilterFactory.getSelectiveTimeFilter(dates);
                        TemporalSAAnalysisANN.this.hydrographChart.addTimeFilter(f);
                    }
                    int Tdom = TemporalSAAnalysisANN.this.currentScheme.getDominatedTimeSteps(conf.getSelectedGroup()).length;
                    int Ttotal = TemporalSAAnalysisANN.this.ts.getTimesteps();
                    TemporalSAAnalysisANN.this.groupConfigurator.setDominanceInfo((double)Tdom / (double)Ttotal);
                }
            }
        });
        this.init();
        this.setButtonEnableState(AnalysisState.Start);
    }

    private void setButtonEnableState(AnalysisState state) {
        switch (state) {
            case Start: {
                this.trainNetworkBn.setEnabled(true);
                this.calcGreedy1SchemeBn.setEnabled(false);
                this.calcGreedy2SchemeBn.setEnabled(false);
                this.calcOptimalSchemeBn.setEnabled(false);
                this.calcSimilartySchemeBn.setEnabled(false);
                this.saveNetworkBn.setEnabled(false);
                this.loadNetworkBn.setEnabled(true);
                this.exportSchemeBn.setEnabled(false);
                break;
            }
            case Trained: {
                this.trainNetworkBn.setEnabled(true);
                this.calcGreedy1SchemeBn.setEnabled(true);
                this.calcGreedy2SchemeBn.setEnabled(true);
                this.calcOptimalSchemeBn.setEnabled(false);
                this.calcSimilartySchemeBn.setEnabled(true);
                this.saveNetworkBn.setEnabled(true);
                this.loadNetworkBn.setEnabled(true);
                this.exportSchemeBn.setEnabled(false);
                break;
            }
            case Grouped: {
                this.trainNetworkBn.setEnabled(true);
                this.calcGreedy1SchemeBn.setEnabled(true);
                this.calcGreedy2SchemeBn.setEnabled(true);
                this.calcOptimalSchemeBn.setEnabled(false);
                this.calcSimilartySchemeBn.setEnabled(true);
                this.saveNetworkBn.setEnabled(true);
                this.loadNetworkBn.setEnabled(true);
                this.exportSchemeBn.setEnabled(true);
                break;
            }
            case Finish: {
                this.trainNetworkBn.setEnabled(true);
                this.calcGreedy1SchemeBn.setEnabled(true);
                this.calcGreedy2SchemeBn.setEnabled(true);
                this.calcOptimalSchemeBn.setEnabled(false);
                this.calcSimilartySchemeBn.setEnabled(true);
                this.saveNetworkBn.setEnabled(true);
                this.loadNetworkBn.setEnabled(true);
                this.exportSchemeBn.setEnabled(true);
            }
        }
    }

    private void init() {
        this.weightChart = new WeightChart();
        this.hydrographChart = new HydrographChart();
        this.hydrographChart.getXYPlot().getDomainAxis().addChangeListener(new AxisChangeListener(){

            public void axisChanged(AxisChangeEvent e) {
                TemporalSAAnalysisANN.this.weightChart.getXYPlot().setDomainAxis(TemporalSAAnalysisANN.this.hydrographChart.getXYPlot().getDomainAxis());
            }
        });
        this.weightChart.getXYPlot().getDomainAxis().addChangeListener(new AxisChangeListener(){

            public void axisChanged(AxisChangeEvent e) {
                TemporalSAAnalysisANN.this.hydrographChart.getXYPlot().setDomainAxis(TemporalSAAnalysisANN.this.weightChart.getXYPlot().getDomainAxis());
            }
        });
        for (int i = 0; i < this.MAX_WEIGHTS; ++i) {
            this.weightRenderer[i] = new XYLineAndShapeRenderer();
            this.weightRenderer[i].setBaseFillPaint((Paint)this.standardColorList[i]);
            this.weightRenderer[i].setBaseLinesVisible(true);
            this.weightRenderer[i].setBaseShapesVisible(false);
            this.weightRenderer[i].setBaseSeriesVisible(true);
            this.weightRenderer[i].setDrawSeriesLineAsPath(true);
            this.weightRenderer[i].setStroke((Stroke)new BasicStroke(1.0f));
        }
        PatchedChartPanel weightChartPanel = new PatchedChartPanel(this.weightChart.getChart(), true);
        weightChartPanel.addChartMouseListener(new ChartMouseListener(){

            public void chartMouseClicked(ChartMouseEvent event) {
                ChartEntity e = event.getEntity();
                if (e != null && e instanceof XYItemEntity) {
                    XYItemEntity xy = (XYItemEntity)e;
                    int index = xy.getSeriesIndex();
                    int data = xy.getItem();
                    System.out.println("index:" + index);
                    System.out.println("data:" + data);
                    DataCollection dc = new DataCollection();
                    dc.addEnsemble(new EfficiencyEnsemble(TemporalSAAnalysisANN.this.ts.get(data), false));
                    for (int i = 0; i < TemporalSAAnalysisANN.this.p.length; ++i) {
                        dc.addEnsemble(TemporalSAAnalysisANN.this.p[i]);
                    }
                    try {
                        DataRequestPanel d = new DataRequestPanel(new DottyPlot(), dc);
                        JFrame plotWindow = MCAT5Toolbar.getDefaultPlotWindow("test");
                        plotWindow.add((Component)d, "Center");
                        plotWindow.setVisible(true);
                    }
                    catch (MCAT5Plot.NoDataException nde) {
                        System.out.println(nde.toString());
                    }
                    TimeSeriesCollection collection = (TimeSeriesCollection)TemporalSAAnalysisANN.this.hydrographChart.getXYPlot().getDataset(index);
                    System.out.println(collection.getSeries(0).getDataItem(data).getPeriod());
                    System.out.println(collection.getSeries(0).getDataItem(data).getValue());
                }
            }

            public void chartMouseMoved(ChartMouseEvent event) {
            }
        });
        PatchedChartPanel hydrographChartPanel = new PatchedChartPanel(this.hydrographChart.getChart(), true);
        JScrollPane parameterTablePane = new JScrollPane(this.parameterTable);
        JPanel sideBar = new JPanel();
        GroupLayout sideLayout = new GroupLayout(sideBar);
        sideLayout.setAutoCreateGaps(true);
        sideLayout.setAutoCreateContainerGaps(true);
        sideBar.setLayout(sideLayout);
        sideLayout.setHorizontalGroup(sideLayout.createParallelGroup().addComponent(parameterTablePane).addComponent(this.infoLabel).addGroup(sideLayout.createParallelGroup().addGroup(sideLayout.createSequentialGroup().addComponent(this.step1Label).addComponent(this.trainNetworkBn).addComponent(this.loadNetworkBn).addComponent(this.saveNetworkBn)).addGroup(sideLayout.createSequentialGroup().addComponent(this.step2Label).addComponent(this.calcGreedy1SchemeBn).addComponent(this.calcGreedy2SchemeBn).addComponent(this.calcOptimalSchemeBn).addComponent(this.calcSimilartySchemeBn)).addGroup(sideLayout.createSequentialGroup().addComponent(this.step3Label).addComponent(this.exportSchemeBn)).addComponent(this.groupConfigurator.getPanel())).addGap(0, 10, Short.MAX_VALUE));
        sideLayout.setVerticalGroup(sideLayout.createSequentialGroup().addComponent(parameterTablePane).addComponent(this.infoLabel).addGroup(sideLayout.createSequentialGroup().addGroup(sideLayout.createParallelGroup().addComponent(this.step1Label).addComponent(this.trainNetworkBn).addComponent(this.loadNetworkBn).addComponent(this.saveNetworkBn)).addGroup(sideLayout.createParallelGroup().addComponent(this.step2Label).addComponent(this.calcGreedy1SchemeBn).addComponent(this.calcGreedy2SchemeBn).addComponent(this.calcOptimalSchemeBn).addComponent(this.calcSimilartySchemeBn)).addGroup(sideLayout.createParallelGroup().addComponent(this.step3Label).addComponent(this.exportSchemeBn)).addComponent(this.groupConfigurator.getPanel())).addGap(0, 10, Short.MAX_VALUE));
        this.mainPanel = new JPanel();
        GroupLayout mainLayout = new GroupLayout(this.mainPanel);
        mainLayout.setAutoCreateGaps(true);
        mainLayout.setAutoCreateContainerGaps(true);
        this.mainPanel.setLayout(mainLayout);
        mainLayout.setHorizontalGroup(mainLayout.createSequentialGroup().addGroup(mainLayout.createParallelGroup().addComponent((Component)((Object)weightChartPanel)).addComponent((Component)((Object)hydrographChartPanel))).addComponent(sideBar));
        mainLayout.setVerticalGroup(mainLayout.createParallelGroup().addGroup(mainLayout.createSequentialGroup().addComponent((Component)((Object)weightChartPanel)).addComponent((Component)((Object)hydrographChartPanel))).addComponent(sideBar));
        this.jfc.setFileFilter(new FileFilter(){

            @Override
            public boolean accept(File f) {
                if (f.isDirectory()) {
                    return true;
                }
                return f.getName().endsWith("enc");
            }

            @Override
            public String getDescription() {
                return "Encog Serialized Artificial Neural Network";
            }
        });
    }

    @Override
    public JPanel getPanel() {
        return this.mainPanel;
    }

    @Override
    public void refresh() throws MCAT5Plot.NoDataException {
        if (!this.isRequestFulfilled()) {
            return;
        }
        ArrayList<DataSet>[] data = this.getData(new int[]{0, 1, 2});
        this.ts = (TimeSerieEnsemble)data[0].get(0);
        this.obs = (Measurement)data[1].get(0);
        this.e = (EfficiencyEnsemble)data[2].get(0);
        Set<String> xSet = this.getDataSource().getDatasets(Parameter.class);
        this.p = new SimpleEnsemble[xSet.size()];
        int counter = 0;
        for (String name : xSet) {
            this.p[counter++] = this.getDataSource().getSimpleEnsemble(name);
        }
        this.parameterTable.setModel(new ParameterTableModel(this.p));
        this.parameterTable.setDefaultEditor(Color.class, new ColorEditor());
        this.parameterTable.getColumnModel().getColumn(3).setCellRenderer(new ColorRenderer(true));
        this.parameterTable.getModel().addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
            }
        });
        this.tsa = new SobolsMethodTemporal(this.p, this.e, this.ts, this.obs);
        this.groupConfigurator.setData(this.p, this.p.length);
        this.hydrographChart.setHydrograph(this.obs);
    }

    private boolean[] getEnableList() {
        ParameterTableModel model = (ParameterTableModel)this.parameterTable.getModel();
        boolean[] parameterActive = new boolean[model.getRowCount()];
        for (int i = 0; i < parameterActive.length; ++i) {
            parameterActive[i] = (Boolean)model.getValueAt(i, 2) == true;
        }
        return parameterActive;
    }

    private boolean[] getShowList() {
        ParameterTableModel model = (ParameterTableModel)this.parameterTable.getModel();
        boolean[] parameterActive = new boolean[model.getRowCount()];
        for (int i = 0; i < parameterActive.length; ++i) {
            parameterActive[i] = (Boolean)model.getValueAt(i, 0) == true;
        }
        return parameterActive;
    }

    private void calcOptimizationScheme(final OptimizationScheme scheme) {
        if (scheme instanceof VarianceBasedGreedyOptimizationScheme) {
            ((VarianceBasedGreedyOptimizationScheme)scheme).setData(this.tsa, this.p, this.e, (TimeSerie)this.obs);
        } else {
            scheme.setData(this.tsa.calculate(), this.p, this.e, this.obs);
        }
        WorkerDlg progress = new WorkerDlg(GUIState.getMainWindow(), "Calculating Optimization Scheme");
        scheme.addObserver((Observer)new ObserverWorkerDlg(progress));
        progress.setInderminate(true);
        progress.setTask(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    GroupConfigurator groupConfigurator = TemporalSAAnalysisANN.this.groupConfigurator;
                    synchronized (groupConfigurator) {
                        TemporalSAAnalysisANN.this.groupConfigurator.setSolutionGroup(scheme.getSolutionGroups());
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    System.out.println(e);
                }
            }
        });
        progress.execute();
    }

    private void exportOptimizationScheme(OptimizationScheme scheme) {
        JFileChooser chooser = GUIHelper.getJFileChooser();
        chooser.setFileFilter(new FileFilter(){

            @Override
            public String getDescription() {
                return "optimization scheme";
            }

            @Override
            public boolean accept(File file) {
                if (file.isDirectory()) {
                    return true;
                }
                return file.getAbsolutePath().endsWith("xml");
            }
        });
        try {
            BeanInfo info = Introspector.getBeanInfo(JAMSCalendar.class);
            PropertyDescriptor[] propertyDescriptors = info.getPropertyDescriptors();
            for (int i = 0; i < propertyDescriptors.length; ++i) {
                PropertyDescriptor pd = propertyDescriptors[i];
                if (pd.getName().equals("milliSeconds") || pd.getName().equals("dateFormat")) continue;
                pd.setValue("transient", Boolean.TRUE);
            }
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        int result = chooser.showSaveDialog(null);
        if (result == 0) {
            try {
                XMLEncoder encoder = new XMLEncoder(new BufferedOutputStream(new FileOutputStream(chooser.getSelectedFile())));
                encoder.close();
            }
            catch (IOException ioe) {
                JOptionPane.showMessageDialog(null, "Optimization scheme was not saved!\n" + ioe.toString());
                return;
            }
        }
    }

    class ParameterTableModel
    extends AbstractTableModel {
        private String[] columnNames = new String[]{"show", "name", "enabled", "color"};
        private Object[][] data = null;

        ParameterTableModel(SimpleEnsemble[] p) {
            this.data = new Object[p.length][3];
            for (int i = 0; i < p.length; ++i) {
                this.data[i][0] = Boolean.TRUE;
                this.data[i][1] = p[i];
                this.data[i][2] = Boolean.TRUE;
            }
        }

        @Override
        public int getColumnCount() {
            return this.columnNames.length;
        }

        @Override
        public int getRowCount() {
            if (this.data != null) {
                return this.data.length;
            }
            return 0;
        }

        @Override
        public String getColumnName(int col) {
            return this.columnNames[col];
        }

        @Override
        public Object getValueAt(int row, int col) {
            if (col == 3) {
                return TemporalSAAnalysisANN.this.standardColorList[row];
            }
            return this.data[row][col];
        }

        public Class getColumnClass(int c) {
            switch (c) {
                case 0: {
                    return Boolean.class;
                }
                case 1: {
                    return String.class;
                }
                case 2: {
                    return Boolean.class;
                }
                case 3: {
                    return Color.class;
                }
            }
            return String.class;
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            switch (col) {
                case 0: {
                    return true;
                }
                case 1: {
                    return false;
                }
                case 2: {
                    return true;
                }
                case 3: {
                    return true;
                }
            }
            return false;
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
            if (col == 2 && !((Boolean)value).booleanValue()) {
                this.setValueAt(Boolean.FALSE, row, 0);
            }
            if (col == 0 && ((Boolean)value).booleanValue()) {
                this.setValueAt(Boolean.TRUE, row, 2);
            }
            if (col == 3) {
                TemporalSAAnalysisANN.this.standardColorList[row] = (Color)value;
            } else {
                this.data[row][col] = value;
            }
            this.fireTableCellUpdated(row, col);
        }
    }

    public class ColorEditor
    extends AbstractCellEditor
    implements TableCellEditor,
    ActionListener {
        Color currentColor;
        JButton button = new JButton();
        JColorChooser colorChooser;
        JDialog dialog;
        protected static final String EDIT = "edit";

        public ColorEditor() {
            this.button.setActionCommand(EDIT);
            this.button.addActionListener(this);
            this.button.setBorderPainted(false);
            this.colorChooser = new JColorChooser();
            this.dialog = JColorChooser.createDialog(this.button, "Pick a Color", true, this.colorChooser, this, null);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (EDIT.equals(e.getActionCommand())) {
                this.button.setBackground(this.currentColor);
                this.colorChooser.setColor(this.currentColor);
                this.dialog.setVisible(true);
                this.fireEditingStopped();
            } else {
                this.currentColor = this.colorChooser.getColor();
            }
        }

        @Override
        public Object getCellEditorValue() {
            return this.currentColor;
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            this.currentColor = (Color)value;
            return this.button;
        }
    }

    public class ColorRenderer
    extends JLabel
    implements TableCellRenderer {
        Border unselectedBorder = null;
        Border selectedBorder = null;
        boolean isBordered = true;

        public ColorRenderer(boolean isBordered) {
            this.isBordered = isBordered;
            this.setOpaque(true);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object color, boolean isSelected, boolean hasFocus, int row, int column) {
            Color newColor = (Color)color;
            this.setBackground(newColor);
            if (this.isBordered) {
                if (isSelected) {
                    if (this.selectedBorder == null) {
                        this.selectedBorder = BorderFactory.createMatteBorder(2, 5, 2, 5, table.getSelectionBackground());
                    }
                    this.setBorder(this.selectedBorder);
                } else {
                    if (this.unselectedBorder == null) {
                        this.unselectedBorder = BorderFactory.createMatteBorder(2, 5, 2, 5, table.getBackground());
                    }
                    this.setBorder(this.unselectedBorder);
                }
            }
            return this;
        }
    }

    static enum AnalysisState {
        Start,
        Trained,
        Grouped,
        Finish;

    }
}

