/*
 * Decompiled with CFR 0.152.
 */
package optas.gui.MCAT5;

import jams.JAMS;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import optas.data.DataCollection;
import optas.data.DataSet;
import optas.data.Efficiency;
import optas.data.EfficiencyEnsemble;
import optas.data.Parameter;
import optas.data.SimpleEnsemble;
import optas.gui.MCAT5.MCAT5Plot;
import optas.regression.Interpolation;
import optas.regression.SimpleInterpolation;
import optas.regression.SimpleNeuralNetwork;
import optas.tools.PatchedChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.XYPlot;

public class ResponseSurface
extends MCAT5Plot {
    XYPlot plot = new XYPlot();
    PatchedChartPanel chartPanel = null;
    JPanel panel = null;
    JPanel mainPanel = null;
    JSlider[] sliders = null;
    SimpleEnsemble[] x;
    EfficiencyEnsemble y;
    final int SliderResolution = 100;
    final int RESOLUTION = 100;
    double[][] map = new double[100][100];
    int param1;
    int param2;
    double paramMin1;
    double paramMax1;
    double paramMin2;
    double paramMax2;
    JTextField paramMin1Field = new JTextField(8);
    JTextField paramMax1Field = new JTextField(8);
    JTextField paramMin2Field = new JTextField(8);
    JTextField paramMax2Field = new JTextField(8);
    double[] point;
    DataCollection dc = null;
    SimpleNeuralNetwork ANN = null;

    public ResponseSurface() {
        this.addRequest(new MCAT5Plot.SimpleRequest(JAMS.i18n((String)"Efficiency"), Efficiency.class));
        this.addRequest(new MCAT5Plot.SimpleRequest(JAMS.i18n((String)"PARAMETER"), Parameter.class, 1, 10));
        this.init();
    }

    private JComponent createAdjustmentPanel(SimpleEnsemble[] p, EfficiencyEnsemble e) {
        JPanel adjustmentPanel = new JPanel(new BorderLayout());
        JScrollPane scrollPane = new JScrollPane(adjustmentPanel);
        JPanel sliderPanel = new JPanel(new GridLayout(p.length, 1));
        for (int i = 0; i < p.length; ++i) {
            JPanel sliderGroup = new JPanel(new FlowLayout());
            sliderGroup.setBorder(BorderFactory.createTitledBorder(p[i].name));
            JSlider slider = new JSlider();
            slider.setBorder(BorderFactory.createTitledBorder("Parameter Space"));
            slider.setMaximum(99);
            slider.setMinimum(0);
            slider.setMajorTickSpacing(50);
            slider.setMinorTickSpacing(50);
            slider.setPaintTicks(true);
            slider.setPaintLabels(true);
            slider.putClientProperty("parameter", p[i]);
            slider.putClientProperty("index", new Integer(i));
            slider.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent evt) {
                    JSlider slider = (JSlider)evt.getSource();
                    double paramMin = ((SimpleEnsemble)slider.getClientProperty("paramter")).getMin();
                    double paramMax = ((SimpleEnsemble)slider.getClientProperty("paramter")).getMax();
                    int index = (Integer)slider.getClientProperty("paramter");
                    ResponseSurface.this.point[index] = (paramMax - paramMin) * (double)slider.getValue() / 100.0 + paramMin;
                }
            });
            sliderGroup.add(slider);
            sliderPanel.add(sliderGroup);
        }
        JComboBox<SimpleEnsemble> parameter1Box = new JComboBox<SimpleEnsemble>(p);
        JComboBox<SimpleEnsemble> parameter2Box = new JComboBox<SimpleEnsemble>(p);
        parameter1Box.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                JComboBox src = (JComboBox)e.getSource();
                SimpleEnsemble p = (SimpleEnsemble)src.getSelectedItem();
                ResponseSurface.this.paramMin1 = p.getMin();
                ResponseSurface.this.paramMax1 = p.getMax();
                ResponseSurface.this.paramMin1Field.setText(Double.toString(ResponseSurface.this.paramMin1));
                ResponseSurface.this.paramMax1Field.setText(Double.toString(ResponseSurface.this.paramMax1));
                ResponseSurface.this.param1 = src.getSelectedIndex();
            }
        });
        parameter2Box.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                JComboBox src = (JComboBox)e.getSource();
                SimpleEnsemble p = (SimpleEnsemble)src.getSelectedItem();
                ResponseSurface.this.paramMin2 = p.getMin();
                ResponseSurface.this.paramMax2 = p.getMax();
                ResponseSurface.this.paramMin2Field.setText(Double.toString(ResponseSurface.this.paramMin2));
                ResponseSurface.this.paramMax2Field.setText(Double.toString(ResponseSurface.this.paramMax2));
                ResponseSurface.this.param2 = src.getSelectedIndex();
            }
        });
        JLabel parameter1Min = new JLabel("min");
        JLabel parameter1Max = new JLabel("max");
        JLabel parameter2Min = new JLabel("min");
        JLabel parameter2Max = new JLabel("max");
        JPanel param1Panel = new JPanel();
        param1Panel.setBorder(BorderFactory.createTitledBorder("Parameter 1"));
        GroupLayout layout1 = new GroupLayout(param1Panel);
        param1Panel.setLayout(layout1);
        layout1.setAutoCreateContainerGaps(true);
        layout1.setAutoCreateGaps(true);
        layout1.setHorizontalGroup(layout1.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(parameter1Box).addGroup(layout1.createSequentialGroup().addComponent(parameter1Min).addComponent(this.paramMin1Field).addComponent(parameter1Max).addComponent(this.paramMax1Field)));
        layout1.setVerticalGroup(layout1.createSequentialGroup().addComponent(parameter1Box).addGroup(layout1.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(parameter1Min).addComponent(this.paramMin1Field).addComponent(parameter1Max).addComponent(this.paramMax1Field)));
        JPanel param2Panel = new JPanel();
        param2Panel.setBorder(BorderFactory.createTitledBorder("Parameter 2"));
        GroupLayout layout2 = new GroupLayout(param2Panel);
        param2Panel.setLayout(layout2);
        layout2.setAutoCreateContainerGaps(true);
        layout2.setAutoCreateGaps(true);
        layout2.setHorizontalGroup(layout2.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(parameter2Box).addGroup(layout2.createSequentialGroup().addComponent(parameter2Min).addComponent(this.paramMin2Field).addComponent(parameter2Max).addComponent(this.paramMax2Field)));
        layout2.setVerticalGroup(layout2.createSequentialGroup().addComponent(parameter2Box).addGroup(layout1.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(parameter2Min).addComponent(this.paramMin2Field).addComponent(parameter2Max).addComponent(this.paramMax2Field)));
        JButton refreshButton = new JButton("Refresh");
        refreshButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    ResponseSurface.this.paramMin1 = Double.parseDouble(ResponseSurface.this.paramMin1Field.getText());
                    ResponseSurface.this.paramMin2 = Double.parseDouble(ResponseSurface.this.paramMin2Field.getText());
                    ResponseSurface.this.paramMax1 = Double.parseDouble(ResponseSurface.this.paramMax1Field.getText());
                    ResponseSurface.this.paramMax2 = Double.parseDouble(ResponseSurface.this.paramMax2Field.getText());
                }
                catch (NumberFormatException nfe) {
                    JOptionPane.showMessageDialog((Component)((Object)ResponseSurface.this.chartPanel), "ParseException");
                    return;
                }
                ResponseSurface.this.redraw();
            }
        });
        GroupLayout layout = new GroupLayout(adjustmentPanel);
        layout.setAutoCreateContainerGaps(true);
        layout.setAutoCreateGaps(true);
        adjustmentPanel.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(sliderPanel).addComponent(param1Panel).addComponent(param2Panel).addComponent(refreshButton));
        layout.setVerticalGroup(layout.createSequentialGroup().addComponent(sliderPanel).addComponent(param1Panel).addComponent(param2Panel).addComponent(refreshButton));
        return scrollPane;
    }

    private void init() {
        JFreeChart chart = new JFreeChart((Plot)this.plot);
        chart.setTitle("Response Surface");
        this.chartPanel = new PatchedChartPanel(chart, true);
        this.chartPanel.setMinimumDrawWidth(0);
        this.chartPanel.setMinimumDrawHeight(0);
        this.chartPanel.setMaximumDrawWidth(2000);
        this.chartPanel.setMaximumDrawHeight(2000);
        this.panel = new JPanel(new BorderLayout());
        this.panel.add((Component)((Object)this.chartPanel), "West");
    }

    @Override
    public void refresh() throws MCAT5Plot.NoDataException {
        int i;
        if (!this.isRequestFulfilled()) {
            return;
        }
        if (this.dc == null) {
            this.dc = this.getDataSource();
            Set<String> xSet = this.getDataSource().getDatasets(Parameter.class);
            ArrayList<DataSet>[] p = this.getData(new int[]{0});
            this.y = (EfficiencyEnsemble)p[1].get(0);
            this.x = new SimpleEnsemble[xSet.size()];
            int counter = 0;
            for (String name : xSet) {
                this.x[counter++] = this.getDataSource().getSimpleEnsemble(name);
            }
            this.mainPanel = new JPanel(new BorderLayout());
            this.mainPanel.add((Component)this.panel, "Center");
            this.mainPanel.add((Component)this.createAdjustmentPanel(this.x, this.y), "East");
            this.ANN = new SimpleNeuralNetwork();
            this.ANN.setxNormalizationMethod(SimpleInterpolation.NormalizationMethod.Linear);
            this.ANN.setyNormalizationMethod(SimpleInterpolation.NormalizationMethod.Linear);
            int n = counter;
            this.ANN.setData(this.x, this.y);
            System.out.println("expected error is: " + this.ANN.estimateCrossValidationError(5, Interpolation.ErrorMethod.E2));
        }
        int n = this.x.length;
        double[] VOI = new double[n];
        for (i = 0; i < n; ++i) {
            VOI[i] = this.point[i];
        }
        i = 0;
        while (true) {
            this.getClass();
            if (i >= 100) break;
            double d = i;
            this.getClass();
            double t1 = d / (double)(100 - 1);
            VOI[this.param1] = this.paramMin1 + t1 * (this.paramMax1 - this.paramMin1);
            int j = 0;
            while (true) {
                this.getClass();
                if (j >= 100) break;
                double d2 = j;
                this.getClass();
                double t2 = d2 / (double)(100 - 1);
                VOI[this.param2] = this.paramMin2 + t2 * (this.paramMax2 - this.paramMin2);
                this.map[i][j] = this.ANN.getInterpolatedValue(VOI)[0];
                ++j;
            }
            ++i;
        }
    }

    @Override
    public JPanel getPanel() {
        return this.panel;
    }
}

