/*
 * Decompiled with CFR 0.152.
 */
package optas.gui.MCAT5;

import jams.JAMS;
import java.awt.Color;
import java.awt.Paint;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.JPanel;
import optas.data.DataSet;
import optas.data.Efficiency;
import optas.data.EfficiencyEnsemble;
import optas.data.Parameter;
import optas.data.SimpleEnsemble;
import optas.gui.MCAT5.MCAT5Plot;
import optas.gui.MCAT5.MCAT5Toolbar;
import optas.tools.PatchedChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;

public class RegionalSensitivityAnalyser2
extends MCAT5Plot {
    XYPlot plot = new XYPlot();
    PatchedChartPanel chartPanel = null;
    final int GROUPS = 10;

    public RegionalSensitivityAnalyser2() {
        this.addRequest(new MCAT5Plot.SimpleRequest(JAMS.i18n((String)"PARAMETER"), Parameter.class));
        this.addRequest(new MCAT5Plot.SimpleRequest(JAMS.i18n((String)"Efficiency"), Efficiency.class, 1, 10));
        this.init();
    }

    private void init() {
        this.plot.setRangeAxis((ValueAxis)new NumberAxis(JAMS.i18n((String)"LIKELIHOOD")));
        JFreeChart chart = new JFreeChart((Plot)this.plot);
        chart.setTitle(JAMS.i18n((String)"REGIONAL_SENSITIVITY_ANALYSIS_II"));
        this.chartPanel = new PatchedChartPanel(chart, true);
        this.chartPanel.setMinimumDrawWidth(0);
        this.chartPanel.setMinimumDrawHeight(0);
        this.chartPanel.setMaximumDrawWidth(2000);
        this.chartPanel.setMaximumDrawHeight(2000);
        chart.getPlot().setBackgroundPaint((Paint)Color.white);
        chart.getXYPlot().setDomainGridlinePaint((Paint)Color.black);
        this.redraw();
    }

    public double[][] sortbyEff(double[] data, double[] likelihood) {
        int n = data.length;
        double[][] tmp_data = new double[n][2];
        for (int i = 0; i < n; ++i) {
            tmp_data[i][0] = data[i];
            tmp_data[i][1] = likelihood[i];
        }
        Arrays.sort(tmp_data, new MCAT5Toolbar.ArrayComparator(1, true));
        return tmp_data;
    }

    @Override
    public void refresh() throws MCAT5Plot.NoDataException {
        int i;
        if (!this.isRequestFulfilled()) {
            return;
        }
        ArrayList<DataSet>[] p = this.getData(new int[]{0, 1});
        SimpleEnsemble param = (SimpleEnsemble)p[0].get(0);
        ArrayList<DataSet> effIn = p[1];
        EfficiencyEnsemble[] eff = new EfficiencyEnsemble[effIn.size()];
        for (int i2 = 0; i2 < effIn.size(); ++i2) {
            eff[i2] = (EfficiencyEnsemble)effIn.get(i2);
        }
        XYLineAndShapeRenderer[] renderer = new XYLineAndShapeRenderer[10];
        for (int i3 = 0; i3 < eff.length; ++i3) {
            renderer[i3] = new XYLineAndShapeRenderer();
            renderer[i3].setBaseShapesVisible(false);
            int c = (int)((double)i3 * 255.0 / (double)eff.length);
            renderer[i3].setSeriesPaint(0, (Paint)new Color(255 - c, 0, c));
            this.plot.setRenderer(i3, (XYItemRenderer)renderer[i3]);
        }
        this.plot.setDomainAxis((ValueAxis)new NumberAxis(param.name));
        int numberOfObjFct = eff.length;
        XYSeries[] dataset = new XYSeries[numberOfObjFct];
        for (i = 0; i < this.plot.getDatasetCount(); ++i) {
            this.plot.setDataset(i, null);
        }
        for (i = 0; i < numberOfObjFct; ++i) {
            int j;
            dataset[i] = new XYSeries((Comparable)((Object)eff[i].name));
            EfficiencyEnsemble likelihood = eff[i].CalculateLikelihood();
            Integer[] sortedIds = likelihood.sort();
            ArrayList[] boxes = new ArrayList[numberOfObjFct];
            for (int j2 = 0; j2 < boxes.length; ++j2) {
                boxes[j2] = new ArrayList();
            }
            double range_min = param.getMin();
            double range_max = param.getMax();
            int index = 0;
            int counter = 0;
            do {
                if ((index = (int)((double)counter / (double)param.getSize() * 10.0)) == 10) {
                    index = 9;
                }
                boxes[i].add(sortedIds[counter]);
                ++counter;
            } while (index == 0);
            double[] box_data = new double[boxes[i].size()];
            for (j = 0; j < boxes[i].size(); ++j) {
                box_data[j] = param.getValue((Integer)boxes[i].get(j));
            }
            Arrays.sort(box_data);
            dataset[i].add(range_min, 0.0);
            for (j = 0; j < box_data.length; ++j) {
                dataset[i].add(box_data[j], (double)j / (double)box_data.length);
            }
            dataset[i].add(range_max, 1.0);
            this.plot.setDataset(i, (XYDataset)new XYSeriesCollection(dataset[i]));
        }
        if (this.plot.getRangeAxis() != null) {
            this.plot.getRangeAxis().setAutoRange(true);
        }
        if (this.plot.getDomainAxis() != null) {
            this.plot.getDomainAxis().setAutoRange(true);
        }
    }

    @Override
    public JPanel getPanel() {
        return this.chartPanel;
    }
}

