/*
 * Decompiled with CFR 0.152.
 */
package optas.gui.MCAT5;

import jams.JAMS;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import optas.data.DataSet;
import optas.data.Efficiency;
import optas.data.EfficiencyEnsemble;
import optas.data.Parameter;
import optas.data.SimpleEnsemble;
import optas.gui.MCAT5.MCAT5Plot;
import optas.tools.PatchedChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.LegendItemSource;
import org.jfree.chart.annotations.XYAnnotation;
import org.jfree.chart.annotations.XYTitleAnnotation;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.block.BlockBorder;
import org.jfree.chart.block.BlockFrame;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.chart.title.LegendTitle;
import org.jfree.chart.title.Title;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;
import org.jfree.ui.RectangleAnchor;
import org.jfree.ui.RectangleEdge;

public class RegionalSensitivityAnalyser
extends MCAT5Plot {
    XYPlot plot = new XYPlot();
    XYLineAndShapeRenderer renderer = new XYLineAndShapeRenderer();
    PatchedChartPanel chartPanel = null;
    JPanel mainPanel = null;
    int GROUPS = 10;
    JCheckBox showOnlyBestAndWorst = new JCheckBox("show only best and worst graph");
    JCheckBox blackAndWhite = new JCheckBox("b/w mode");

    public RegionalSensitivityAnalyser() {
        this.addRequest(new MCAT5Plot.SimpleRequest(JAMS.i18n((String)"PARAMETER"), Parameter.class));
        this.addRequest(new MCAT5Plot.SimpleRequest(JAMS.i18n((String)"Efficiency"), Efficiency.class));
        this.init();
    }

    private void init() {
        JFreeChart chart = new JFreeChart((Plot)this.plot);
        chart.setTitle(JAMS.i18n((String)"REGIONAL_SENSITIVITY_ANALYSIS"));
        this.chartPanel = new PatchedChartPanel(chart, true);
        this.chartPanel.setMinimumDrawWidth(0);
        this.chartPanel.setMinimumDrawHeight(0);
        this.chartPanel.setMaximumDrawWidth(2000);
        this.chartPanel.setMaximumDrawHeight(2000);
        this.plot.setRenderer((XYItemRenderer)this.renderer);
        this.plot.setRangeAxis((ValueAxis)new NumberAxis(JAMS.i18n((String)"cumulative frequency distribution")));
        this.mainPanel = new JPanel();
        GroupLayout layout = new GroupLayout(this.mainPanel);
        this.mainPanel.setLayout(layout);
        LegendTitle lt = new LegendTitle((LegendItemSource)this.plot);
        lt.setItemFont(new Font("Dialog", 0, 14));
        lt.setBackgroundPaint((Paint)new Color(200, 200, 200, 100));
        lt.setFrame((BlockFrame)new BlockBorder((Paint)Color.white));
        lt.setPosition(RectangleEdge.BOTTOM);
        XYTitleAnnotation ta = new XYTitleAnnotation(0.98, 0.02, (Title)lt, RectangleAnchor.BOTTOM_RIGHT);
        ta.setMaxWidth(0.48);
        this.plot.addAnnotation((XYAnnotation)ta);
        this.mainPanel.add((Component)((Object)this.chartPanel), "North");
        JPanel sliderPanel = new JPanel(new BorderLayout());
        sliderPanel.setMaximumSize(new Dimension(300, 100));
        sliderPanel.setPreferredSize(new Dimension(300, 100));
        sliderPanel.setMinimumSize(new Dimension(300, 100));
        JSlider slider = new JSlider();
        slider.setMinimum(1);
        slider.setMaximum(30);
        slider.setValue(this.GROUPS);
        slider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                JSlider slider = (JSlider)e.getSource();
                RegionalSensitivityAnalyser.this.GROUPS = slider.getValue();
                RegionalSensitivityAnalyser.this.redraw();
            }
        });
        sliderPanel.add((Component)new JLabel("number of boxes"), "West");
        sliderPanel.add((Component)slider, "East");
        layout.setHorizontalGroup(layout.createParallelGroup().addComponent((Component)((Object)this.chartPanel)).addGroup(layout.createSequentialGroup().addComponent(this.showOnlyBestAndWorst).addComponent(this.blackAndWhite).addComponent(sliderPanel)));
        layout.setVerticalGroup(layout.createSequentialGroup().addComponent((Component)((Object)this.chartPanel)).addGroup(layout.createParallelGroup().addComponent(this.showOnlyBestAndWorst).addComponent(this.blackAndWhite).addComponent(sliderPanel)));
        this.showOnlyBestAndWorst.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RegionalSensitivityAnalyser.this.redraw();
            }
        });
        this.blackAndWhite.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RegionalSensitivityAnalyser.this.redraw();
            }
        });
        chart.getPlot().setBackgroundPaint((Paint)Color.white);
        chart.removeLegend();
    }

    @Override
    public void refresh() throws MCAT5Plot.NoDataException {
        if (!this.isRequestFulfilled()) {
            return;
        }
        ArrayList<DataSet>[] p = this.getData(new int[]{0, 1});
        SimpleEnsemble param = (SimpleEnsemble)p[0].get(0);
        EfficiencyEnsemble eff = (EfficiencyEnsemble)p[1].get(0);
        if (this.showOnlyBestAndWorst.isSelected()) {
            this.renderer.setSeriesShapesVisible(0, false);
            this.renderer.setSeriesShapesVisible(1, false);
            this.renderer.setSeriesStroke(0, (Stroke)new BasicStroke(3.0f));
            this.renderer.setSeriesVisibleInLegend(0, Boolean.valueOf(true));
            this.renderer.setSeriesStroke(1, (Stroke)new BasicStroke(3.0f));
            this.renderer.setSeriesVisibleInLegend(1, Boolean.valueOf(true));
            if (this.blackAndWhite.isSelected()) {
                this.renderer.setSeriesPaint(0, (Paint)new Color(64, 64, 64));
                this.renderer.setSeriesPaint(1, (Paint)new Color(172, 172, 172));
            } else {
                this.renderer.setSeriesPaint(0, (Paint)new Color(0, 0, 255));
                this.renderer.setSeriesPaint(1, (Paint)new Color(255, 0, 0));
            }
        } else {
            for (int i = 0; i < this.GROUPS; ++i) {
                int c;
                this.renderer.setSeriesShapesVisible(i, false);
                this.renderer.setSeriesVisibleInLegend(i, Boolean.valueOf(false));
                if (i == 0 || i == this.GROUPS - 1) {
                    this.renderer.setSeriesStroke(i, (Stroke)new BasicStroke(5.0f));
                    this.renderer.setSeriesVisibleInLegend(i, Boolean.valueOf(true));
                } else {
                    this.renderer.setSeriesStroke(i, (Stroke)new BasicStroke(1.0f));
                }
                if (this.blackAndWhite.isSelected()) {
                    c = 64 + (int)((double)i * 128.0 / (double)this.GROUPS);
                    this.renderer.setSeriesPaint(i, (Paint)new Color(c, c, c));
                    continue;
                }
                c = (int)((double)i * 255.0 / (double)this.GROUPS);
                this.renderer.setSeriesPaint(i, (Paint)new Color(255 - c, 0, c));
            }
        }
        this.plot.setDomainAxis((ValueAxis)new NumberAxis(param.name));
        XYSeriesCollection series = new XYSeriesCollection();
        ArrayList[] boxes = new ArrayList[this.GROUPS];
        for (int i = 0; i < this.GROUPS; ++i) {
            boxes[i] = new ArrayList();
        }
        EfficiencyEnsemble likelihood = eff.CalculateLikelihood();
        Integer[] sortedIds = likelihood.sort();
        double range_max = param.getMax();
        double range_min = param.getMin();
        for (int i = 0; i < param.getSize(); ++i) {
            int index = (int)((double)i / (double)param.getSize() * (double)boxes.length);
            boxes[index].add(sortedIds[i]);
        }
        XYSeries dataset = null;
        for (int i = 0; i < boxes.length; ++i) {
            int j;
            dataset = i == 0 ? new XYSeries((Comparable)((Object)"worst group")) : (i == boxes.length - 1 ? new XYSeries((Comparable)((Object)"best group")) : new XYSeries((Comparable)Integer.valueOf(i)));
            double[] box_data = new double[boxes[i].size()];
            for (j = 0; j < boxes[i].size(); ++j) {
                box_data[j] = param.getValue((Integer)boxes[i].get(j));
            }
            Arrays.sort(box_data);
            dataset.add(range_min, 0.0);
            for (j = 0; j < box_data.length; ++j) {
                dataset.add(box_data[j], (double)j / (double)box_data.length);
            }
            dataset.add(range_max, 1.0);
            if (this.showOnlyBestAndWorst.isSelected() && i != 0 && i != this.GROUPS - 1) continue;
            series.addSeries(dataset);
        }
        this.plot.setDataset((XYDataset)series);
        if (this.plot.getRangeAxis() != null) {
            this.plot.getRangeAxis().setRange(0.0, 1.0);
        }
        if (this.plot.getDomainAxis() != null) {
            double r = range_max - range_min;
            int l = (int)Math.log(r);
            if (l >= 0) {
                double min = Math.floor(range_min * Math.pow(10.0, l + 1)) / Math.pow(10.0, l + 1);
                double max = Math.ceil(range_max * Math.pow(10.0, l + 1)) / Math.pow(10.0, l + 1) + 1.0E-10;
                this.plot.getDomainAxis().setRange(min, max);
            } else {
                double min = Math.floor(range_min * Math.pow(10.0, -l - 1)) / Math.pow(10.0, -l - 1);
                double max = Math.ceil(range_max * Math.pow(10.0, -l - 1)) / Math.pow(10.0, -l - 1) + 1.0E-10;
                this.plot.getDomainAxis().setRange(min, max);
            }
        }
    }

    @Override
    public JPanel getPanel() {
        return this.mainPanel;
    }
}

