/*
 * Decompiled with CFR 0.152.
 */
package optas.gui.MCAT5;

import jams.JAMS;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Stroke;
import java.util.ArrayList;
import javax.swing.JPanel;
import optas.data.DataSet;
import optas.data.Efficiency;
import optas.data.EfficiencyEnsemble;
import optas.data.Measurement;
import optas.data.TimeSerie;
import optas.data.TimeSerieEnsemble;
import optas.gui.MCAT5.MCAT5Plot;
import optas.tools.PatchedChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.DateAxis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYDifferenceRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.data.time.Day;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.data.xy.XYDataset;

public class ParetoOutputUncertainty
extends MCAT5Plot {
    XYPlot plot1 = new XYPlot();
    PatchedChartPanel chartPanel1 = null;
    String var_name = null;

    public ParetoOutputUncertainty() {
        this.addRequest(new MCAT5Plot.SimpleRequest(JAMS.i18n((String)"SIMULATED_TIMESERIE"), TimeSerie.class));
        this.addRequest(new MCAT5Plot.SimpleRequest(JAMS.i18n((String)"Efficiency"), Efficiency.class, 1, 10));
        this.addRequest(new MCAT5Plot.SimpleRequest(JAMS.i18n((String)"OBSERVED_TIMESERIE"), Measurement.class));
        this.init();
    }

    private void init() {
        this.plot1.setDomainAxis((ValueAxis)new DateAxis(JAMS.i18n((String)"TIME")));
        JFreeChart chart1 = new JFreeChart((Plot)this.plot1);
        chart1.setTitle(JAMS.i18n((String)"PARETO_OUTPUT_UNCERTAINTY"));
        this.chartPanel1 = new PatchedChartPanel(chart1, true);
        this.chartPanel1.setMinimumDrawWidth(0);
        this.chartPanel1.setMinimumDrawHeight(0);
        this.chartPanel1.setMaximumDrawWidth(2000);
        this.chartPanel1.setMaximumDrawHeight(2000);
        XYDifferenceRenderer renderer1 = new XYDifferenceRenderer((Paint)Color.LIGHT_GRAY, (Paint)Color.LIGHT_GRAY, false);
        XYDifferenceRenderer renderer2 = new XYDifferenceRenderer((Paint)Color.CYAN, (Paint)Color.CYAN, false);
        XYLineAndShapeRenderer renderer3 = new XYLineAndShapeRenderer();
        renderer1.setPaint((Paint)Color.LIGHT_GRAY);
        renderer1.setSeriesFillPaint(0, (Paint)Color.LIGHT_GRAY);
        renderer2.setPaint((Paint)Color.CYAN);
        renderer3.setBaseLinesVisible(true);
        renderer3.setBaseShapesVisible(false);
        renderer3.setOutlinePaint((Paint)Color.BLACK);
        renderer3.setPaint((Paint)Color.BLACK);
        renderer3.setStroke((Stroke)new BasicStroke(1.0f));
        this.plot1.setRenderer(0, (XYItemRenderer)renderer3);
        this.plot1.setRenderer(1, (XYItemRenderer)renderer2);
        this.plot1.setRenderer(2, (XYItemRenderer)renderer1);
        chart1.getPlot().setBackgroundPaint((Paint)Color.white);
        chart1.getXYPlot().setDomainGridlinePaint((Paint)Color.black);
        this.redraw();
    }

    boolean isParetoOptimal(double[] eff_actual, EfficiencyEnsemble[] eff_set) {
        int MC_PARAM = eff_set[0].getSize();
        for (int i = 0; i < MC_PARAM; ++i) {
            boolean dominated = true;
            for (int j = 0; j < eff_actual.length; ++j) {
                if (eff_set[j].isPositiveBest()) {
                    if (!(eff_set[j].getValue(eff_set[j].getId(i)) <= eff_actual[j])) continue;
                    dominated = false;
                    break;
                }
                if (!(eff_set[j].getValue(eff_set[j].getId(i)) >= eff_actual[j])) continue;
                dominated = false;
                break;
            }
            if (!dominated) continue;
            return false;
        }
        return true;
    }

    double[][] getMinMaxParetoTS(TimeSerieEnsemble data, EfficiencyEnsemble[] eff) {
        int i;
        double[][] minMaxOptimalTS = new double[2][data.getTimesteps()];
        for (i = 0; i < data.getTimesteps(); ++i) {
            minMaxOptimalTS[0][i] = Double.POSITIVE_INFINITY;
            minMaxOptimalTS[1][i] = Double.NEGATIVE_INFINITY;
        }
        for (i = 0; i < data.getSize(); ++i) {
            double[] actualEffSet = new double[eff.length];
            for (int j = 0; j < eff.length; ++j) {
                actualEffSet[j] = eff[j].getValue(eff[j].getId(i));
            }
            if (!this.isParetoOptimal(actualEffSet, eff)) continue;
            for (int t = 0; t < data.getTimesteps(); ++t) {
                minMaxOptimalTS[0][t] = Math.min(minMaxOptimalTS[0][t], data.get(t, data.getId(i)));
                minMaxOptimalTS[1][t] = Math.max(minMaxOptimalTS[1][t], data.get(t, data.getId(i)));
            }
        }
        return minMaxOptimalTS;
    }

    @Override
    public void refresh() throws MCAT5Plot.NoDataException {
        if (!this.isRequestFulfilled()) {
            return;
        }
        ArrayList<DataSet>[] p = this.getData(new int[]{0, 1, 2});
        TimeSerieEnsemble ts = (TimeSerieEnsemble)p[0].get(0);
        ArrayList<DataSet> dataInEff = p[1];
        Measurement obs = (Measurement)p[2].get(0);
        EfficiencyEnsemble[] eff = new EfficiencyEnsemble[dataInEff.size()];
        for (int i = 0; i < eff.length; ++i) {
            eff[i] = (EfficiencyEnsemble)dataInEff.get(i);
        }
        this.plot1.setRangeAxis((ValueAxis)new NumberAxis(ts.name));
        int time_length = ts.getTimesteps();
        TimeSerie maxTS = ts.getMax();
        TimeSerie minTS = ts.getMin();
        double[][] minMaxOptimalTS = this.getMinMaxParetoTS(ts, eff);
        TimeSeries minTSDataset = new TimeSeries((Comparable)((Object)JAMS.i18n((String)"MINIMAL_VALUE_IN_DATASET")));
        TimeSeries maxTSDataset = new TimeSeries((Comparable)((Object)JAMS.i18n((String)"MAXIMAL_VALUE_IN_DATASET")));
        TimeSeries minTSDataset_pareto = new TimeSeries((Comparable)((Object)JAMS.i18n((String)"MINIMAL_VALUE_IN_PARETO_SET")));
        TimeSeries maxTSDataset_pareto = new TimeSeries((Comparable)((Object)JAMS.i18n((String)"MAXIMAL_VALUE_IN_PARETO_SET")));
        TimeSeries observation = new TimeSeries((Comparable)((Object)obs.name));
        for (int i = 0; i < time_length; ++i) {
            Day d = new Day(ts.getDate(i));
            minTSDataset.add((RegularTimePeriod)d, minTS.getValue(i));
            maxTSDataset.add((RegularTimePeriod)d, maxTS.getValue(i));
            minTSDataset_pareto.add((RegularTimePeriod)d, minMaxOptimalTS[0][i]);
            maxTSDataset_pareto.add((RegularTimePeriod)d, minMaxOptimalTS[1][i]);
            observation.add((RegularTimePeriod)d, obs.getValue(i));
        }
        TimeSeriesCollection dataInterval = new TimeSeriesCollection();
        TimeSeriesCollection dataInterval_pareto = new TimeSeriesCollection();
        dataInterval.addSeries(minTSDataset);
        dataInterval.addSeries(maxTSDataset);
        dataInterval_pareto.addSeries(minTSDataset_pareto);
        dataInterval_pareto.addSeries(maxTSDataset_pareto);
        this.plot1.setDataset(2, (XYDataset)dataInterval);
        this.plot1.setDataset(1, (XYDataset)dataInterval_pareto);
        this.plot1.setDataset(0, (XYDataset)new TimeSeriesCollection(observation));
        if (this.plot1.getRangeAxis() != null) {
            this.plot1.getRangeAxis().setAutoRange(true);
        }
        if (this.plot1.getDomainAxis() != null) {
            this.plot1.getDomainAxis().setAutoRange(true);
        }
    }

    @Override
    public JPanel getPanel() {
        return this.chartPanel1;
    }
}

