/*
 * Decompiled with CFR 0.152.
 */
package optas.gui.MCAT5;

import jams.JAMS;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Observable;
import java.util.Observer;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import optas.SA.UniversalSensitivityAnalyzer;
import optas.data.DataSet;
import optas.data.Efficiency;
import optas.data.EfficiencyEnsemble;
import optas.data.Parameter;
import optas.data.SimpleEnsemble;
import optas.gui.MCAT5.MCAT5Plot;
import optas.regression.SimpleInterpolation;
import optas.tools.TableRowHeader;
import optas.tools.VerticalTableHeaderCellRenderer;

public class ParameterInteractionAnalyser
extends MCAT5Plot {
    JPanel panel = null;
    JLabel sampleCountLabel = new JLabel("Samples in dataset:");
    JTextField sampleCountField = new JTextField(10);
    JLabel regressionErrorLabel = new JLabel("Regression Error:");
    JTextField regressionErrorField = new JTextField(10);
    JLabel sampleCountRegression = new JLabel("Samples drawn from regression:");
    JTextField sampleCountFieldRegression = new JTextField("1000");
    JButton refreshButton = new JButton("Refresh");
    JTable interactionTable = new JTable(new Object[][]{{"xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx", "y", "z", "x", "y", "z"}}, new String[]{"xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx", "1", "1", "1", "1", "1"});
    JCheckBox multiIteration = new JCheckBox("Multiple Iterations");
    TreeSet<Integer> indexSet = new TreeSet();
    UniversalSensitivityAnalyzer uniSA = null;
    TableRowHeader rowHeader;

    public ParameterInteractionAnalyser() {
        this.addRequest(new MCAT5Plot.SimpleRequest(JAMS.i18n((String)"PARAMETER"), Parameter.class));
        this.addRequest(new MCAT5Plot.SimpleRequest(JAMS.i18n((String)"Efficiency"), Efficiency.class));
        this.init();
    }

    private void init() {
        this.panel = new JPanel(new BorderLayout());
        this.refreshButton = new JButton(new AbstractAction("Recalculate Regression"){

            @Override
            public void actionPerformed(ActionEvent e) {
                ParameterInteractionAnalyser.this.redraw();
            }
        });
        JScrollPane interactionTablePane = new JScrollPane(this.interactionTable);
        interactionTablePane.setHorizontalScrollBarPolicy(30);
        interactionTablePane.setVerticalScrollBarPolicy(20);
        this.interactionTable.setBackground(this.panel.getBackground());
        interactionTablePane.setBackground(this.panel.getBackground());
        this.rowHeader = new TableRowHeader(this.interactionTable, interactionTablePane);
        interactionTablePane.setRowHeader(this.rowHeader);
        JPanel centerPanel = new JPanel();
        GroupLayout layout = new GroupLayout(centerPanel);
        centerPanel.setLayout(layout);
        JLabel interactionTableTitle = new JLabel("interaction effects", 0);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup().addComponent(interactionTableTitle).addComponent(interactionTablePane))).addGroup(layout.createSequentialGroup().addComponent(this.sampleCountLabel).addGap(1, 2, 3).addComponent(this.sampleCountField, 50, 75, 100).addGap(5, 10, 15).addComponent(this.sampleCountRegression).addGap(1, 2, 3).addComponent(this.sampleCountFieldRegression, 50, 75, 100)).addGroup(layout.createSequentialGroup().addComponent(this.regressionErrorLabel).addGap(1, 2, 3).addComponent(this.regressionErrorField, 50, 75, 100)).addGroup(layout.createSequentialGroup().addComponent(this.refreshButton).addGap(5, 10, 15).addComponent(this.multiIteration)));
        layout.setVerticalGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup().addGroup(layout.createSequentialGroup().addComponent(interactionTableTitle).addComponent(interactionTablePane))).addGap(5, 10, 15).addGroup(layout.createParallelGroup().addComponent(this.sampleCountLabel, 25, 30, 35).addComponent(this.sampleCountField, 25, 30, 35).addComponent(this.sampleCountRegression, 25, 30, 35).addComponent(this.sampleCountFieldRegression, 25, 30, 35)).addGap(5, 10, 15).addGroup(layout.createParallelGroup().addComponent(this.regressionErrorLabel, 25, 30, 35).addComponent(this.regressionErrorField, 25, 30, 35)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.refreshButton).addComponent(this.multiIteration)));
        this.panel.add(centerPanel);
    }

    @Override
    public JPanel getPanel() {
        return this.panel;
    }

    @Override
    public void refresh() throws MCAT5Plot.NoDataException {
        int i;
        if (!this.isRequestFulfilled()) {
            return;
        }
        Set<String> xSet = this.getDataSource().getDatasets(Parameter.class);
        ArrayList<DataSet>[] p = this.getData(new int[]{0, 1});
        EfficiencyEnsemble p2 = (EfficiencyEnsemble)p[1].get(0);
        Object[] xData = new SimpleEnsemble[xSet.size()];
        int counter = 0;
        for (String name : xSet) {
            xData[counter++] = this.getDataSource().getSimpleEnsemble(name);
        }
        this.indexSet.clear();
        this.uniSA = new UniversalSensitivityAnalyzer();
        this.uniSA.setMethod(UniversalSensitivityAnalyzer.SAMethod.FOSI2);
        this.uniSA.setUsingRegression(true);
        this.uniSA.setParameterNormalizationMethod(SimpleInterpolation.NormalizationMethod.Linear);
        this.uniSA.setObjectiveNormalizationMethod(SimpleInterpolation.NormalizationMethod.Linear);
        this.uniSA.addObserver(new Observer(){

            @Override
            public void update(Observable o, Object arg) {
                ParameterInteractionAnalyser.this.setState(arg.toString());
            }
        });
        int n = counter;
        double sampleSize = 0.0;
        try {
            sampleSize = Double.parseDouble(this.sampleCountFieldRegression.getText());
        }
        catch (NumberFormatException nfe) {
            JOptionPane.showMessageDialog(this.panel, "Please enter a real valued number for sample size!");
            return;
        }
        this.uniSA.setSampleCount((int)sampleSize);
        this.uniSA.setup((SimpleEnsemble[])xData, p2);
        this.regressionErrorField.setText(String.format(Locale.ENGLISH, "%.4f", this.uniSA.calculateError()));
        this.sampleCountField.setText(Integer.toString(p2.getSize()));
        double[][][] sensitivity = null;
        if (this.multiIteration.isSelected()) {
            sensitivity = this.uniSA.getInteractionsUncertainty();
        } else {
            double[][] sens = this.uniSA.getInteractions();
            sensitivity = new double[n][n][3];
            for (i = 0; i < n; ++i) {
                for (int j = 0; j < n; ++j) {
                    sensitivity[i][j][0] = sens[i][j];
                    sensitivity[i][j][1] = sens[i][j];
                    sensitivity[i][j][2] = sens[i][j];
                }
            }
        }
        VerticalTableHeaderCellRenderer headerRenderer = new VerticalTableHeaderCellRenderer();
        this.interactionTable.setModel(new InteractionTableModel((SimpleEnsemble[])xData, sensitivity));
        this.interactionTable.setPreferredSize(new Dimension(xData.length * 100, xData.length * 100));
        for (i = 0; i < n; ++i) {
            this.interactionTable.getColumnModel().getColumn(i).setCellRenderer(new InteractionRenderer(true));
            this.interactionTable.getColumnModel().getColumn(i).setWidth(45);
            this.interactionTable.getColumnModel().getColumn(i).setPreferredWidth(45);
            this.interactionTable.getColumnModel().getColumn(i).setHeaderRenderer(headerRenderer);
        }
        this.rowHeader.setRowHeaderName(xData);
        this.interactionTable.setAutoResizeMode(0);
        this.interactionTable.revalidate();
        this.interactionTable.doLayout();
    }

    class InteractionTableModel
    extends AbstractTableModel {
        private String[] columnNames = new String[]{"enabled", "name"};
        private double[][][] data = null;

        InteractionTableModel(SimpleEnsemble[] p, double[][][] interaction) {
            int n = interaction.length;
            int m = interaction[0].length;
            this.data = new double[n][n][3];
            this.columnNames = new String[m];
            for (int i = 0; i < n; ++i) {
                this.columnNames[i] = p[i].name;
                for (int j = 0; j < m; ++j) {
                    this.data[i][j][0] = interaction[i][j][0];
                    this.data[i][j][1] = interaction[i][j][1];
                    this.data[i][j][2] = interaction[i][j][2];
                }
            }
        }

        @Override
        public int getColumnCount() {
            return this.columnNames.length;
        }

        @Override
        public int getRowCount() {
            if (this.data != null) {
                return this.data.length;
            }
            return 0;
        }

        @Override
        public String getColumnName(int col) {
            return this.columnNames[col];
        }

        @Override
        public Object getValueAt(int row, int col) {
            return String.format(Locale.ENGLISH, "%.3f +- %.3f", this.data[row][col][1], this.data[row][col][2] - this.data[row][col][1]);
        }

        public Class getColumnClass(int c) {
            return String.class;
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return false;
        }
    }

    public class InteractionRenderer
    extends JLabel
    implements TableCellRenderer {
        Border unselectedBorder = null;
        Border selectedBorder = null;
        boolean isBordered = true;

        public InteractionRenderer(boolean isBordered) {
            this.isBordered = isBordered;
            this.setOpaque(true);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object obj, boolean isSelected, boolean hasFocus, int row, int column) {
            String values = (String)obj;
            String[] value = values.split("\\+\\-");
            double mean = Double.parseDouble(value[0]);
            double sigma2 = Double.parseDouble(value[1]);
            double sig = sigma2 / (2.0 * mean);
            Color color = null;
            if (mean <= 0.0) {
                color = Color.WHITE;
            } else if (mean <= 1.0) {
                double red = mean * (double)Color.RED.getRed() + (1.0 - mean) * (double)Color.WHITE.getRed();
                double green = mean * (double)Color.RED.getGreen() + (1.0 - mean) * (double)Color.WHITE.getGreen();
                double blue = mean * (double)Color.RED.getBlue() + (1.0 - mean) * (double)Color.WHITE.getBlue();
                color = new Color((int)red, (int)green, (int)blue);
            } else {
                color = Color.RED;
            }
            if (sig > 0.2) {
                color = Color.YELLOW;
            }
            this.setText(values);
            this.setBackground(color);
            if (this.isBordered) {
                if (isSelected) {
                    if (this.selectedBorder == null) {
                        this.selectedBorder = BorderFactory.createMatteBorder(2, 5, 2, 5, table.getSelectionBackground());
                    }
                    this.setBorder(this.selectedBorder);
                } else {
                    if (this.unselectedBorder == null) {
                        this.unselectedBorder = BorderFactory.createMatteBorder(2, 5, 2, 5, table.getBackground());
                    }
                    this.setBorder(this.unselectedBorder);
                }
            }
            return this;
        }
    }
}

