/*
 * Decompiled with CFR 0.152.
 */
package optas.gui.MCAT5;

import jams.JAMS;
import java.awt.Color;
import java.awt.Paint;
import java.util.ArrayList;
import javax.swing.JPanel;
import optas.data.DataSet;
import optas.data.Efficiency;
import optas.data.EfficiencyEnsemble;
import optas.data.Parameter;
import optas.data.SimpleEnsemble;
import optas.gui.MCAT5.MCAT5Plot;
import optas.tools.PatchedChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYDifferenceRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;

public class NormalisedParameterRangePlot
extends MCAT5Plot {
    XYPlot plot1 = new XYPlot();
    PatchedChartPanel chartPanel1 = null;

    public NormalisedParameterRangePlot() {
        this.addRequest(new MCAT5Plot.SimpleRequest(JAMS.i18n((String)"PARAMETER"), Parameter.class, 1, 10));
        this.addRequest(new MCAT5Plot.SimpleRequest(JAMS.i18n((String)"Efficiency"), Efficiency.class, 1, 10));
        this.init();
    }

    private void init() {
        XYDifferenceRenderer renderer1 = new XYDifferenceRenderer((Paint)Color.LIGHT_GRAY, (Paint)Color.LIGHT_GRAY, false);
        renderer1.setPaint((Paint)Color.BLACK);
        this.plot1.setRenderer(0, (XYItemRenderer)renderer1);
        this.plot1.setDomainAxis((ValueAxis)new NumberAxis(JAMS.i18n((String)"PARAMETER")));
        this.plot1.setRangeAxis((ValueAxis)new NumberAxis(JAMS.i18n((String)"NORMALISED_RANGE")));
        JFreeChart chart1 = new JFreeChart((Plot)this.plot1);
        chart1.setTitle(JAMS.i18n((String)"NORMALISED_PARAMETER_RANGE_PLOT"));
        chart1.removeLegend();
        this.chartPanel1 = new PatchedChartPanel(chart1, true);
        this.chartPanel1.setMinimumDrawWidth(0);
        this.chartPanel1.setMinimumDrawHeight(0);
        this.chartPanel1.setMaximumDrawWidth(2000);
        this.chartPanel1.setMaximumDrawHeight(2000);
        this.redraw();
    }

    boolean isParetoOptimal(double[] eff_actual, EfficiencyEnsemble[] eff_set) {
        int MC_PARAM = eff_set[0].getSize();
        for (int i = 0; i < MC_PARAM; ++i) {
            boolean dominated = true;
            for (int j = 0; j < eff_actual.length; ++j) {
                if (eff_set[j].isPositiveBest()) {
                    if (!(eff_set[j].getValue(eff_set[j].getId(i)) >= eff_actual[j])) continue;
                    dominated = false;
                    break;
                }
                if (!(eff_set[j].getValue(eff_set[j].getId(i)) <= eff_actual[j])) continue;
                dominated = false;
                break;
            }
            if (!dominated) continue;
            return false;
        }
        return true;
    }

    double[][] getMinMaxParetoTS(SimpleEnsemble[] data, EfficiencyEnsemble[] eff) {
        int i;
        double[][] minMaxOptimalTS = new double[2][data.length];
        for (i = 0; i < data.length; ++i) {
            minMaxOptimalTS[0][i] = Double.POSITIVE_INFINITY;
            minMaxOptimalTS[1][i] = Double.NEGATIVE_INFINITY;
        }
        for (i = 0; i < data[0].getSize(); ++i) {
            double[] actualEffSet = new double[eff.length];
            for (int j = 0; j < eff.length; ++j) {
                actualEffSet[j] = eff[j].getValue(eff[j].getId(i));
            }
            if (!this.isParetoOptimal(actualEffSet, eff)) continue;
            for (int t = 0; t < data.length; ++t) {
                minMaxOptimalTS[0][t] = Math.min(minMaxOptimalTS[0][t], data[t].getValue(data[t].getId(i)));
                minMaxOptimalTS[1][t] = Math.max(minMaxOptimalTS[1][t], data[t].getValue(data[t].getId(i)));
            }
        }
        return minMaxOptimalTS;
    }

    @Override
    public void refresh() throws MCAT5Plot.NoDataException {
        int i;
        if (!this.isRequestFulfilled()) {
            return;
        }
        ArrayList<DataSet>[] p = this.getData(new int[]{0, 1});
        ArrayList<DataSet> dataInParam = p[0];
        ArrayList<DataSet> dataInEff = p[1];
        SimpleEnsemble[] params = new SimpleEnsemble[dataInParam.size()];
        EfficiencyEnsemble[] eff = new EfficiencyEnsemble[dataInEff.size()];
        for (i = 0; i < dataInEff.size(); ++i) {
            eff[i] = (EfficiencyEnsemble)dataInEff.get(i);
        }
        for (i = 0; i < dataInParam.size(); ++i) {
            params[i] = (SimpleEnsemble)dataInParam.get(i);
        }
        double[][] minMaxparetoOptimal = this.getMinMaxParetoTS(params, eff);
        XYSeries minTSDataset_pareto = new XYSeries((Comparable)((Object)JAMS.i18n((String)"MINIMAL_PARETO_OPTIMAL_VALUE")));
        XYSeries maxTSDataset_pareto = new XYSeries((Comparable)((Object)JAMS.i18n((String)"MAXIMAL_PARETO_OPTIMAL_VALUE")));
        for (int i2 = 0; i2 < params.length; ++i2) {
            minTSDataset_pareto.add((double)i2, minMaxparetoOptimal[0][i2]);
            maxTSDataset_pareto.add((double)i2, minMaxparetoOptimal[1][i2]);
        }
        XYSeriesCollection dataInterval_pareto = new XYSeriesCollection();
        dataInterval_pareto.addSeries(minTSDataset_pareto);
        dataInterval_pareto.addSeries(maxTSDataset_pareto);
        this.plot1.setDataset(0, (XYDataset)dataInterval_pareto);
        if (this.plot1.getRangeAxis() != null) {
            this.plot1.getRangeAxis().setAutoRange(true);
        }
        if (this.plot1.getDomainAxis() != null) {
            this.plot1.getDomainAxis().setAutoRange(true);
        }
    }

    @Override
    public JPanel getPanel() {
        return this.chartPanel1;
    }
}

