/*
 * Decompiled with CFR 0.152.
 */
package optas.gui.MCAT5;

import jams.JAMS;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.AbstractTableModel;
import optas.data.DataCollection;
import optas.data.DataSet;
import optas.data.Efficiency;
import optas.data.Measurement;
import optas.data.Parameter;
import optas.data.RankingTable;
import optas.data.SimpleEnsemble;
import optas.data.TimeSerie;
import optas.data.TimeSerieEnsemble;
import optas.gui.MCAT5.DataRequestPanel;
import optas.gui.MCAT5.MCAT5Plot;
import optas.optimizer.management.SampleFactory;
import optas.optimizer.management.Statistics;
import optas.tools.ColorRenderer;
import optas.tools.PatchedChartPanel;
import optas.tools.PatchedSpiderWebPlot;
import optas.tools.Tools;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartMouseEvent;
import org.jfree.chart.ChartMouseListener;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.DateAxis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.entity.CategoryItemEntity;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;
import org.jfree.data.time.Day;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.data.xy.XYDataset;

public class MultiObjectiveDecisionSupport
extends MCAT5Plot {
    final int MAX_OBJCOUNT = 100;
    XYPlot hydroChart = new XYPlot();
    PatchedSpiderWebPlot spiderPlot = new PatchedSpiderWebPlot();
    PatchedChartPanel chartPanel1 = null;
    PatchedChartPanel chartPanel2 = null;
    JSlider[] objSliders = new JSlider[100];
    JPanel mainPanel = null;
    JTextField alphaField = new JTextField(5);
    JButton exportDataset = new JButton("Export");
    ArrayList<SampleFactory.Sample> candidates = new ArrayList();
    TimeSerieEnsemble ts = null;
    ArrayList<SampleFactory.Sample> paretoFront = null;
    RankingTable rt = null;
    SimpleEnsemble[] x;
    SimpleEnsemble[] y = null;
    int N;
    int m = 0;
    double alpha = 0.1;
    int selectedId = 0;
    boolean datasetValid = false;
    boolean onAdjustment = false;
    private JTable candidateTable;
    private boolean[] visibleCandidates;

    public MultiObjectiveDecisionSupport() {
        this.addRequest(new MCAT5Plot.SimpleRequest(JAMS.i18n((String)"SIMULATED_TIMESERIE"), TimeSerie.class));
        this.addRequest(new MCAT5Plot.SimpleRequest(JAMS.i18n((String)"Efficiency"), Efficiency.class));
        this.addRequest(new MCAT5Plot.SimpleRequest(JAMS.i18n((String)"OBSERVED_TIMESERIE"), Measurement.class, 0, 1));
        this.init();
    }

    private void init() {
        int i;
        JFreeChart chart1 = ChartFactory.createTimeSeriesChart((String)JAMS.i18n((String)"Visual comparison of hydrographs"), (String)"time", (String)"discharge", null, (boolean)true, (boolean)true, (boolean)false);
        this.hydroChart = chart1.getXYPlot();
        XYLineAndShapeRenderer hydroRenderer1 = new XYLineAndShapeRenderer();
        hydroRenderer1.setBaseLinesVisible(true);
        hydroRenderer1.setBaseShapesVisible(false);
        hydroRenderer1.setSeriesOutlinePaint(0, (Paint)Color.BLUE);
        hydroRenderer1.setSeriesPaint(0, (Paint)Color.BLUE);
        hydroRenderer1.setStroke((Stroke)new BasicStroke(2.0f));
        XYLineAndShapeRenderer hydroRenderer2 = new XYLineAndShapeRenderer();
        hydroRenderer2.setBaseLinesVisible(true);
        hydroRenderer2.setBaseShapesVisible(false);
        hydroRenderer2.setSeriesOutlinePaint(0, (Paint)Color.RED);
        hydroRenderer2.setSeriesPaint(0, (Paint)Color.RED);
        hydroRenderer2.setStroke((Stroke)new BasicStroke(2.0f));
        this.hydroChart.setRenderer(0, (XYItemRenderer)hydroRenderer1);
        this.hydroChart.setRenderer(1, (XYItemRenderer)hydroRenderer2);
        this.hydroChart.getDomainAxis().setLabel(JAMS.i18n((String)"TIME"));
        DateAxis axis = (DateAxis)this.hydroChart.getDomainAxis();
        axis.setDateFormatOverride((DateFormat)new SimpleDateFormat("yyyy-MM-dd"));
        this.hydroChart.setDomainGridlinePaint((Paint)Color.black);
        this.hydroChart.setRangeAxis((ValueAxis)new NumberAxis(JAMS.i18n((String)"OUTPUT")));
        this.spiderPlot.setBaseSeriesOutlineStroke(new BasicStroke(2.0f));
        this.chartPanel1 = new PatchedChartPanel(chart1, true);
        this.chartPanel1.setMinimumDrawWidth(0);
        this.chartPanel1.setMinimumDrawHeight(0);
        this.chartPanel1.setMaximumDrawWidth(2000);
        this.chartPanel1.setMaximumDrawHeight(2000);
        chart1.setTitle(JAMS.i18n((String)"OUTPUT_UNCERTAINTY_PLOT"));
        this.chartPanel1.getChart().getPlot().setBackgroundPaint((Paint)Color.white);
        JFreeChart chart2 = new JFreeChart((Plot)this.spiderPlot);
        chart2.setTitle("Possible solutions");
        chart2.removeLegend();
        this.chartPanel2 = new PatchedChartPanel(chart2, true);
        this.chartPanel2.setMinimumDrawWidth(0);
        this.chartPanel2.setMinimumDrawHeight(0);
        this.chartPanel2.setMaximumDrawWidth(2000);
        this.chartPanel2.setMaximumDrawHeight(2000);
        chart2.setTitle("");
        this.chartPanel2.addChartMouseListener(new ChartMouseListener(){

            public void chartMouseClicked(ChartMouseEvent cme) {
                if (cme.getTrigger().getButton() != 1) {
                    return;
                }
                if (cme.getTrigger().getClickCount() != 1) {
                    return;
                }
                if (cme.getEntity() instanceof CategoryItemEntity) {
                    CategoryItemEntity entity = (CategoryItemEntity)cme.getEntity();
                    SampleFactory.Sample selectedCandidate = null;
                    for (int i = 0; i < MultiObjectiveDecisionSupport.this.candidates.size(); ++i) {
                        if (entity.getRowKey().compareTo("Sample " + i) != 0) continue;
                        selectedCandidate = MultiObjectiveDecisionSupport.this.candidates.get(i);
                        MultiObjectiveDecisionSupport.this.setStandardColors();
                        MultiObjectiveDecisionSupport.this.spiderPlot.setSeriesPaint(i, Color.red);
                        break;
                    }
                    int id = -1;
                    for (int j = 0; j < MultiObjectiveDecisionSupport.this.N; ++j) {
                        boolean equals = true;
                        for (int k = 0; k < MultiObjectiveDecisionSupport.this.m; ++k) {
                            if (selectedCandidate.F()[k] == MultiObjectiveDecisionSupport.this.y[k].getValue(MultiObjectiveDecisionSupport.this.y[k].getId(j))) continue;
                            equals = false;
                        }
                        if (!equals) continue;
                        MultiObjectiveDecisionSupport.this.updateSimulation(j);
                        MultiObjectiveDecisionSupport.this.updateParameterSet(j);
                        break;
                    }
                }
            }

            public void chartMouseMoved(ChartMouseEvent cme) {
            }
        });
        this.alphaField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MultiObjectiveDecisionSupport.this.rt.setAlpha(MultiObjectiveDecisionSupport.this.alpha);
                MultiObjectiveDecisionSupport.this.redraw();
            }
        });
        this.exportDataset.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
            }
        });
        for (int i2 = 0; i2 < 100; ++i2) {
            this.objSliders[i2] = new JSlider();
        }
        this.mainPanel = new JPanel();
        GroupLayout layout = new GroupLayout(this.mainPanel);
        this.mainPanel.setLayout(layout);
        JLabel alphaLabel = new JLabel("alpha: ");
        this.candidateTable = new JTable();
        this.candidateTable.getTableHeader().setReorderingAllowed(false);
        this.candidateTable.setAutoResizeMode(0);
        JScrollPane scrollPane = new JScrollPane(this.candidateTable);
        GroupLayout.ParallelGroup group1 = layout.createParallelGroup();
        group1.addComponent((Component)((Object)this.chartPanel2), 100, 200, 500);
        group1.addComponent(scrollPane, 100, 200, 500);
        GroupLayout.ParallelGroup group3 = layout.createParallelGroup();
        group3.addGroup(layout.createSequentialGroup().addGap(5, 5, 5).addComponent(alphaLabel).addComponent(this.alphaField, 30, 50, 70).addGap(5, 5, 100).addComponent(this.exportDataset));
        for (int i3 = 0; i3 < 100; ++i3) {
            group3.addComponent(this.objSliders[i3], 100, 200, 500);
        }
        GroupLayout.SequentialGroup group2 = layout.createSequentialGroup();
        group2.addComponent((Component)((Object)this.chartPanel2), 200, 350, 500);
        group2.addComponent(scrollPane, 100, 150, 500);
        GroupLayout.SequentialGroup group4 = layout.createSequentialGroup();
        group4.addGroup(layout.createParallelGroup().addComponent(alphaLabel, 15, 20, 25).addComponent(this.alphaField, 15, 20, 25).addComponent(this.exportDataset, 15, 20, 25));
        for (i = 0; i < 100; ++i) {
            group4.addComponent(this.objSliders[i], 30, 50, 80);
        }
        layout.setHorizontalGroup(layout.createSequentialGroup().addGroup(group1).addGroup(group3).addComponent((Component)((Object)this.chartPanel1), 500, 500, 5000));
        layout.setVerticalGroup(layout.createParallelGroup().addGroup(group2).addGroup(group4).addComponent((Component)((Object)this.chartPanel1), 500, 500, 5000).addGap(0, 500, 5000));
        if (this.hydroChart.getRangeAxis() != null) {
            this.hydroChart.getRangeAxis().setAutoRange(true);
        }
        if (this.hydroChart.getDomainAxis() != null) {
            this.hydroChart.getDomainAxis().setAutoRange(true);
        }
        for (i = 0; i < this.objSliders.length; ++i) {
            this.objSliders[i].addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    if (MultiObjectiveDecisionSupport.this.onAdjustment) {
                        return;
                    }
                    MultiObjectiveDecisionSupport.this.onAdjustment = true;
                    JSlider actSlider = (JSlider)e.getSource();
                    int allValues = 0;
                    for (JSlider slider : MultiObjectiveDecisionSupport.this.objSliders) {
                        allValues += slider.getValue();
                    }
                    double[] correction = new double[MultiObjectiveDecisionSupport.this.objSliders.length];
                    for (int i = 0; i < MultiObjectiveDecisionSupport.this.objSliders.length; ++i) {
                        correction[i] = MultiObjectiveDecisionSupport.this.objSliders[i] != actSlider ? (100.0 - (double)allValues) / ((double)MultiObjectiveDecisionSupport.this.objSliders.length - 1.0) : 0.0;
                    }
                    double redistribution = allValues;
                    while (Math.abs(redistribution) > 0.5) {
                        int i;
                        int c = 0;
                        for (i = 0; i < MultiObjectiveDecisionSupport.this.objSliders.length; ++i) {
                            if (correction[i] > 0.0) {
                                if ((double)MultiObjectiveDecisionSupport.this.objSliders[i].getValue() + correction[i] < (double)MultiObjectiveDecisionSupport.this.objSliders[i].getMaximum()) {
                                    MultiObjectiveDecisionSupport.this.objSliders[i].setValue((int)((double)MultiObjectiveDecisionSupport.this.objSliders[i].getValue() + correction[i]));
                                    ++c;
                                    continue;
                                }
                                int n = i;
                                correction[n] = correction[n] + (double)(MultiObjectiveDecisionSupport.this.objSliders[i].getValue() - MultiObjectiveDecisionSupport.this.objSliders[i].getMaximum());
                                MultiObjectiveDecisionSupport.this.objSliders[i].setValue(MultiObjectiveDecisionSupport.this.objSliders[i].getMaximum());
                                continue;
                            }
                            if ((double)MultiObjectiveDecisionSupport.this.objSliders[i].getValue() + correction[i] > (double)MultiObjectiveDecisionSupport.this.objSliders[i].getMinimum()) {
                                MultiObjectiveDecisionSupport.this.objSliders[i].setValue((int)((double)MultiObjectiveDecisionSupport.this.objSliders[i].getValue() + correction[i]));
                                ++c;
                                continue;
                            }
                            int n = i;
                            correction[n] = correction[n] + (double)(MultiObjectiveDecisionSupport.this.objSliders[i].getValue() - MultiObjectiveDecisionSupport.this.objSliders[i].getMinimum());
                            MultiObjectiveDecisionSupport.this.objSliders[i].setValue(MultiObjectiveDecisionSupport.this.objSliders[i].getMinimum());
                        }
                        redistribution = 0.0;
                        for (i = 0; i < MultiObjectiveDecisionSupport.this.m; ++i) {
                            redistribution += correction[i];
                        }
                        for (i = 0; i < MultiObjectiveDecisionSupport.this.m; ++i) {
                            if (MultiObjectiveDecisionSupport.this.objSliders[i] == actSlider) continue;
                            correction[i] = correction[i] != 0.0 ? 0.0 : redistribution / (double)c;
                        }
                    }
                    MultiObjectiveDecisionSupport.this.updateSpiderPlot();
                    MultiObjectiveDecisionSupport.this.onAdjustment = false;
                }
            });
        }
    }

    private void setStandardColors() {
        this.spiderPlot.setSeriesPaint(0, Color.blue);
        this.spiderPlot.setSeriesPaint(1, Color.GREEN);
        this.spiderPlot.setSeriesPaint(2, Color.orange);
        this.spiderPlot.setSeriesPaint(3, Color.magenta);
        this.spiderPlot.setSeriesPaint(4, Color.PINK);
        this.spiderPlot.setSeriesPaint(5, Color.yellow);
        this.spiderPlot.setSeriesPaint(this.m, Color.BLACK);
    }

    private void updateParameterSet(int index) {
        double[] selectedParameterSet = new double[this.x.length];
        String[] parameterName = new String[this.x.length];
        int i = 0;
        for (SimpleEnsemble e : this.x) {
            selectedParameterSet[i] = e.getValue(e.getId(index));
            parameterName[i] = e.getName();
            ++i;
            System.out.println(e.getName() + ":\t" + e.getValue(e.getId(index)));
        }
    }

    private void updateSimulation(int index) {
        if (this.ts == null) {
            return;
        }
        TimeSeries dataset2 = new TimeSeries((Comparable)((Object)JAMS.i18n((String)"Simulation")));
        int T = this.ts.getTimesteps();
        double[] timeseries = this.ts.getValue(this.ts.getId(index));
        for (int i = 0; i < T; ++i) {
            Day d = new Day(this.ts.getDate(i));
            dataset2.add((RegularTimePeriod)d, timeseries[i]);
        }
        TimeSeriesCollection sim_runoff = new TimeSeriesCollection();
        sim_runoff.addSeries(dataset2);
        this.hydroChart.setDataset(1, (XYDataset)sim_runoff);
    }

    @Override
    public void refresh() throws MCAT5Plot.NoDataException {
        if (!this.isRequestFulfilled()) {
            return;
        }
        this.alpha = Tools.readField(this.alphaField, 0.1);
        this.initDataSet();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
        ArrayList<DataSet>[] p = this.getData(new int[]{0, 1, 2});
        this.ts = (TimeSerieEnsemble)p[0].get(0);
        Measurement obs = null;
        if (p[2].size() > 0) {
            obs = (Measurement)p[2].get(0);
        }
        int T = this.ts.getTimesteps();
        if (obs != null) {
            TimeSeries dataset1 = new TimeSeries((Comparable)((Object)JAMS.i18n((String)"Measurement")));
            for (int i = 0; i < T; ++i) {
                Day d = new Day(obs.getTime(i));
                dataset1.add((RegularTimePeriod)d, obs.getValue(i));
            }
            TimeSeriesCollection obs_runoff = new TimeSeriesCollection();
            obs_runoff.addSeries(dataset1);
            this.hydroChart.setDataset(0, (XYDataset)obs_runoff);
        } else {
            this.hydroChart.setDataset(0, null);
        }
        this.updateSimulation(0);
        this.updateSpiderPlot();
    }

    private void initDataSet() {
        Set<String> xSet = this.getDataSource().getDatasets(Parameter.class);
        this.x = new SimpleEnsemble[xSet.size()];
        int counter = 0;
        for (String string : xSet) {
            this.x[counter++] = this.getDataSource().getSimpleEnsemble(string);
        }
        Set<String> ySet = this.getDataSource().getDatasets(Efficiency.class);
        this.y = new SimpleEnsemble[ySet.size()];
        counter = 0;
        for (String name : ySet) {
            this.y[counter++] = this.getDataSource().getSimpleEnsemble(name);
        }
        this.N = this.getDataSource().getSimulationCount();
        this.m = this.y.length;
        DecimalFormat decimalFormat = new DecimalFormat("#.###");
        for (int i = 0; i < 100; ++i) {
            if (i < this.m) {
                this.objSliders[i].setVisible(true);
                this.objSliders[i].setMinimum(0);
                this.objSliders[i].setMaximum(100);
                Hashtable<Integer, JLabel> labelTable = new Hashtable<Integer, JLabel>();
                for (int j = 0; j < 101; j += 25) {
                    double value = (double)j / 100.0;
                    labelTable.put(new Integer(j), new JLabel(decimalFormat.format(value)));
                }
                this.objSliders[i].setLabelTable(labelTable);
                this.objSliders[i].setPaintLabels(true);
                this.objSliders[i].setBorder(BorderFactory.createTitledBorder(this.y[i].getName()));
                continue;
            }
            this.objSliders[i].setVisible(false);
            this.objSliders[i].setPaintLabels(false);
        }
        SampleFactory factory = new SampleFactory();
        this.getDataSource().constructSample(factory);
        Statistics stats = factory.getStatistics();
        this.paretoFront = stats.getParetoFront();
        this.rt = new RankingTable(this.paretoFront);
        this.rt.setAlpha(this.alpha);
        this.rt.computeRankings();
        this.objSliders[0].setValue(0);
        if (this.selectedId == -1) {
            this.selectedId = this.ts.getId(0);
        }
        this.setStandardColors();
        this.datasetValid = true;
    }

    private void updateSpiderPlot() {
        if (!this.datasetValid) {
            return;
        }
        double[] w = new double[100];
        for (int i = 0; i < 100; ++i) {
            w[i] = 0.01 * (double)this.objSliders[i].getValue();
        }
        double bestScore = Double.MAX_VALUE;
        SampleFactory.Sample bestSample = null;
        for (SampleFactory.Sample s : this.paretoFront) {
            double score = 0.0;
            for (int i = 0; i < s.F().length; ++i) {
                score += w[i] * s.F()[i];
            }
            if (!(score < bestScore)) continue;
            bestSample = s;
            bestScore = score;
        }
        this.candidates = new ArrayList();
        this.candidates.addAll(Arrays.asList(this.rt.getCandidates()));
        this.candidates.add(bestSample);
        this.updateCandidateTable();
        this.drawSpiderPlot();
    }

    private void drawSpiderPlot() {
        int i;
        DefaultCategoryDataset categoryDataset = new DefaultCategoryDataset();
        double[] mins = new double[this.y.length];
        double[] maxs = new double[this.y.length];
        for (i = 0; i < this.y.length; ++i) {
            mins[i] = Double.POSITIVE_INFINITY;
            maxs[i] = Double.NEGATIVE_INFINITY;
        }
        for (int sampleNumber = 0; sampleNumber < this.candidates.size(); ++sampleNumber) {
            SampleFactory.Sample sample = this.candidates.get(sampleNumber);
            for (int i2 = 0; i2 < sample.F().length; ++i2) {
                if (this.visibleCandidates[sampleNumber]) {
                    double neff = -sample.F()[i2];
                    mins[i2] = Math.min(mins[i2], neff);
                    maxs[i2] = Math.max(maxs[i2], neff);
                    categoryDataset.addValue(neff, (Comparable)((Object)("Sample " + sampleNumber)), (Comparable)((Object)this.y[i2].name));
                    continue;
                }
                categoryDataset.addValue(Double.NaN, (Comparable)((Object)("Sample " + sampleNumber)), (Comparable)((Object)this.y[i2].name));
            }
        }
        this.spiderPlot.setDataset((CategoryDataset)categoryDataset);
        this.spiderPlot.setDataInverted(true);
        this.spiderPlot.setAxisTickVisible(true);
        this.spiderPlot.setNumberOfTicks(3);
        this.spiderPlot.setWebFilled(false);
        for (i = 0; i < this.y.length; ++i) {
            if (mins[i] > 0.0) {
                this.spiderPlot.setOrigin(i, 0.9 * mins[i]);
            } else {
                this.spiderPlot.setOrigin(i, 1.1 * mins[i]);
            }
            if (maxs[i] > 0.0) {
                this.spiderPlot.setMaxValue(i, 1.1 * maxs[i]);
                continue;
            }
            this.spiderPlot.setMaxValue(i, 0.9 * maxs[i]);
        }
    }

    private void updateCandidateTable() {
        if (this.visibleCandidates == null || this.visibleCandidates.length != this.candidates.size()) {
            this.visibleCandidates = new boolean[this.candidates.size()];
            for (int i = 0; i < this.visibleCandidates.length; ++i) {
                this.visibleCandidates[i] = true;
            }
        }
        this.candidateTable.setModel(new AbstractTableModel(){
            private static final long serialVersionUID = -9062878893282509429L;

            @Override
            public int getRowCount() {
                return MultiObjectiveDecisionSupport.this.candidates.size();
            }

            @Override
            public int getColumnCount() {
                return MultiObjectiveDecisionSupport.this.x.length + 2;
            }

            @Override
            public String getColumnName(int column) {
                switch (column) {
                    case 0: {
                        return "Visible";
                    }
                    case 1: {
                        return "Color";
                    }
                }
                return MultiObjectiveDecisionSupport.this.x[column - 2].name;
            }

            @Override
            public Class<?> getColumnClass(int columnIndex) {
                switch (columnIndex) {
                    case 0: {
                        return Boolean.class;
                    }
                    case 1: {
                        return Color.class;
                    }
                }
                return Double.class;
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return columnIndex == 0;
            }

            @Override
            public Object getValueAt(int rowIndex, int columnIndex) {
                switch (columnIndex) {
                    case 0: {
                        return MultiObjectiveDecisionSupport.this.visibleCandidates[rowIndex];
                    }
                    case 1: {
                        return (Color)MultiObjectiveDecisionSupport.this.spiderPlot.getSeriesPaint(rowIndex);
                    }
                }
                return MultiObjectiveDecisionSupport.this.candidates.get((int)rowIndex).x[columnIndex - 2];
            }

            @Override
            public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
                boolean value;
                ((MultiObjectiveDecisionSupport)MultiObjectiveDecisionSupport.this).visibleCandidates[rowIndex] = value = ((Boolean)aValue).booleanValue();
                MultiObjectiveDecisionSupport.this.drawSpiderPlot();
            }
        });
        this.candidateTable.getColumnModel().getColumn(1).setCellRenderer(new ColorRenderer(true));
    }

    @Override
    public JPanel getPanel() {
        return this.mainPanel;
    }

    public JPanel getPanel1() {
        return this.mainPanel;
    }

    public JPanel getPanel2() {
        return this.chartPanel2;
    }

    public static void main(String[] args) {
        DataCollection dc = DataCollection.createFromFile(new File("E:\\ModelData\\Testgebiete\\J2000\\Gehlberg\\output\\20130824_003244\\2013_08_21_sa_small2.cdat"));
        try {
            DataRequestPanel d = new DataRequestPanel(new MultiObjectiveDecisionSupport(), dc);
            JFrame plotWindow = new JFrame("test");
            plotWindow.setDefaultCloseOperation(2);
            plotWindow.setLayout(new BorderLayout());
            plotWindow.setVisible(true);
            plotWindow.setSize(800, 700);
            plotWindow.add((Component)d, "Center");
        }
        catch (MCAT5Plot.NoDataException noDataException) {
            // empty catch block
        }
    }
}

