/*
 * Decompiled with CFR 0.152.
 */
package optas.gui.MCAT5;

import jams.JAMS;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Comparator;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JToolBar;
import optas.gui.MCAT5.APosterioriPlot;
import optas.gui.MCAT5.BestPredictionPlot;
import optas.gui.MCAT5.ClassPlot;
import optas.gui.MCAT5.DYNIA;
import optas.gui.MCAT5.DataCollectionPanel;
import optas.gui.MCAT5.DataRequestPanel;
import optas.gui.MCAT5.DottyPlot;
import optas.gui.MCAT5.GLUEOutputUncertainty;
import optas.gui.MCAT5.GLUEVariableUncertainty;
import optas.gui.MCAT5.IdentifiabilityPlot;
import optas.gui.MCAT5.MCAT5Plot;
import optas.gui.MCAT5.MultiObjectiveDecisionSupport;
import optas.gui.MCAT5.NormalisedParameterRangePlot;
import optas.gui.MCAT5.ParameterInteractionAnalyser;
import optas.gui.MCAT5.ParetoBoxPlot;
import optas.gui.MCAT5.ParetoOutputUncertainty;
import optas.gui.MCAT5.RegionalSensitivityAnalyser;
import optas.gui.MCAT5.RegionalSensitivityAnalyser2;
import optas.gui.MCAT5.SensitivityToolbox;
import optas.gui.MCAT5.TemporalSensitivityAnalysisGUI;

public class MCAT5Toolbar
extends JToolBar {
    DataCollectionPanel owner;
    ArrayList<PlotDesc> registeredPlots = new ArrayList();

    public static JFrame getDefaultPlotWindow(String title) {
        JFrame plotWindow = new JFrame(title);
        plotWindow.setDefaultCloseOperation(2);
        plotWindow.setLayout(new BorderLayout());
        plotWindow.setVisible(true);
        plotWindow.setSize(800, 700);
        return plotWindow;
    }

    public MCAT5Toolbar(DataCollectionPanel param_owner) {
        this.registeredPlots.add(new PlotDesc(PlotType.Basic, new ImageIcon(this.getClass().getResource("/jams/explorer/resources/images/dottyplot.png")), JAMS.i18n((String)"CREATE_DOTTY_PLOT"), JAMS.i18n((String)"DOTTY_PLOT"), DottyPlot.class));
        this.registeredPlots.add(new PlotDesc(PlotType.Sensitivity, new ImageIcon(this.getClass().getResource("/jams/explorer/resources/images/sensitivity.png")), "Sensitivityanalyzer", JAMS.i18n((String)"Sensitivity_Analysis"), SensitivityToolbox.class));
        this.registeredPlots.add(new PlotDesc(PlotType.Sensitivity, new ImageIcon(this.getClass().getResource("/jams/explorer/resources/images/interaction.png")), "Interaction Effects Analyzer", JAMS.i18n((String)"Interaction_analysis"), ParameterInteractionAnalyser.class));
        this.registeredPlots.add(new PlotDesc(PlotType.Sensitivity, new ImageIcon(this.getClass().getResource("/jams/explorer/resources/images/temporal_sa.png")), JAMS.i18n((String)"Temporal_Sensitivity_Analysis"), JAMS.i18n((String)"Temporal_Sensitivity_Analysis"), TemporalSensitivityAnalysisGUI.class));
        this.registeredPlots.add(new PlotDesc(PlotType.Basic, new ImageIcon(this.getClass().getResource("/jams/explorer/resources/images/aposterioriplot.png")), JAMS.i18n((String)"CREATE_A_POSTERIORI_DISTRIBUTION_PLOT"), JAMS.i18n((String)"A_POSTERIO_PARAMETER_DISTRIBUTION"), APosterioriPlot.class));
        this.registeredPlots.add(new PlotDesc(PlotType.Basic, new ImageIcon(this.getClass().getResource("/jams/explorer/resources/images/identifiabilityplot.png")), JAMS.i18n((String)"IDENTIFIABILITY_PLOT"), JAMS.i18n((String)"IDENTIFIABILITY_PLOT"), IdentifiabilityPlot.class));
        this.registeredPlots.add(new PlotDesc(PlotType.Basic, new ImageIcon(this.getClass().getResource("/jams/explorer/resources/images/bestpredictionplot.png")), JAMS.i18n((String)"BEST_PREDICTION_PLOT"), JAMS.i18n((String)"BEST_PREDICTION_PLOT"), BestPredictionPlot.class));
        this.registeredPlots.add(new PlotDesc(PlotType.Basic, new ImageIcon(this.getClass().getResource("/jams/explorer/resources/images/classplot.png")), JAMS.i18n((String)"CLASS_PLOT"), JAMS.i18n((String)"CLASS_PLOT"), ClassPlot.class));
        this.registeredPlots.add(new PlotDesc(PlotType.Basic, new ImageIcon(this.getClass().getResource("/jams/explorer/resources/images/dyniaplot.png")), JAMS.i18n((String)"DYNIA"), JAMS.i18n((String)"DYNIA"), DYNIA.class));
        this.registeredPlots.add(new PlotDesc(PlotType.Uncertainty, new ImageIcon(this.getClass().getResource("/jams/explorer/resources/images/ParetoOutPlot.png")), JAMS.i18n((String)"PARETO_OUTPUT_UNCERTAINITY"), JAMS.i18n((String)"PARETO_OUTPUT_UNCERTAINITY"), ParetoOutputUncertainty.class));
        this.registeredPlots.add(new PlotDesc(PlotType.Uncertainty, new ImageIcon(this.getClass().getResource("/jams/explorer/resources/images/GLUEOutPlot.png")), JAMS.i18n((String)"GLUE_OUTPUT_UNCERTAINITY"), JAMS.i18n((String)"OUTPUT_UNCERTAINTY_PLOT"), GLUEOutputUncertainty.class));
        this.registeredPlots.add(new PlotDesc(PlotType.Uncertainty, new ImageIcon(this.getClass().getResource("/jams/explorer/resources/images/GLUEVarPlot.png")), JAMS.i18n((String)"GLUE_VARIABLE_UNCERTAINITY"), JAMS.i18n((String)"CUMULATIVE_DENSITY_PLOT"), GLUEVariableUncertainty.class));
        this.registeredPlots.add(new PlotDesc(PlotType.Uncertainty, new ImageIcon(this.getClass().getResource("/jams/explorer/resources/images/normalisedparameter.png")), JAMS.i18n((String)"NORMALIZED_PARAMETER_RANGE_PLOT"), JAMS.i18n((String)"NORMALISED_PARAMETER_RANGE_PLOT"), NormalisedParameterRangePlot.class));
        this.registeredPlots.add(new PlotDesc(PlotType.Uncertainty, new ImageIcon(this.getClass().getResource("/jams/explorer/resources/images/ParetoBoxPlot.png")), JAMS.i18n((String)"PARETO_BOX_PLOT"), JAMS.i18n((String)"PARETO_BOX_PLOT"), ParetoBoxPlot.class));
        this.registeredPlots.add(new PlotDesc(PlotType.Sensitivity, new ImageIcon(this.getClass().getResource("/jams/explorer/resources/images/regionalsensitivity.png")), JAMS.i18n((String)"REGIONAL_SENSITIVITY_ANALYSIS"), JAMS.i18n((String)"REGIONAL_SENSITIVITY_ANALYSIS"), RegionalSensitivityAnalyser.class));
        this.registeredPlots.add(new PlotDesc(PlotType.Sensitivity, new ImageIcon(this.getClass().getResource("/jams/explorer/resources/images/regionalsensitivity2.png")), JAMS.i18n((String)"REGIONAL_SENSITIVITY_ANALYSIS_II"), JAMS.i18n((String)"REGIONAL_SENSITIVITY_ANALYSIS_II"), RegionalSensitivityAnalyser2.class));
        this.registeredPlots.add(new PlotDesc(PlotType.Basic, new ImageIcon(this.getClass().getResource("/jams/explorer/resources/images/regionalsensitivity2.png")), JAMS.i18n((String)"REGIONAL_SENSITIVITY_ANALYSIS_II"), JAMS.i18n((String)"REGIONAL_SENSITIVITY_ANALYSIS_II"), MultiObjectiveDecisionSupport.class));
        JToolBar toolbarBasic = new JToolBar("Basic Tools");
        toolbarBasic.setBorder(BorderFactory.createTitledBorder("Basic-Analysis"));
        JToolBar toolbarSenstivity = new JToolBar("Sensitivity Tools");
        toolbarSenstivity.setBorder(BorderFactory.createTitledBorder("Sensitivity-Analysis"));
        JToolBar toolbarUncertainty = new JToolBar("Uncertainty Tools");
        toolbarUncertainty.setBorder(BorderFactory.createTitledBorder("Uncertainty-Analysis"));
        for (PlotDesc pd : this.registeredPlots) {
            JButton button = new JButton(pd.icon);
            button.setToolTipText(pd.tooltip);
            button.putClientProperty("plotTitle", pd.title);
            button.putClientProperty("plotClass", pd.clazz);
            button.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    Class c = (Class)((JButton)evt.getSource()).getClientProperty("plotClass");
                    MCAT5Plot o = null;
                    try {
                        o = (MCAT5Plot)c.getConstructor(new Class[0]).newInstance(new Object[0]);
                    }
                    catch (Exception e) {
                        System.out.println(e.toString());
                        e.printStackTrace();
                    }
                    try {
                        DataRequestPanel d = new DataRequestPanel(o, MCAT5Toolbar.this.owner.getDataCollection());
                        JFrame plotWindow = MCAT5Toolbar.getDefaultPlotWindow((String)((JButton)evt.getSource()).getClientProperty("plotTitle"));
                        plotWindow.add((Component)d, "Center");
                    }
                    catch (MCAT5Plot.NoDataException nde) {
                        JOptionPane.showMessageDialog(MCAT5Toolbar.this, nde.toString());
                    }
                }
            });
            if (pd.type == PlotType.Sensitivity) {
                toolbarSenstivity.add(button);
                continue;
            }
            if (pd.type == PlotType.Basic) {
                toolbarBasic.add(button);
                continue;
            }
            if (pd.type != PlotType.Uncertainty) continue;
            toolbarUncertainty.add(button);
        }
        this.add(toolbarBasic);
        this.add(toolbarSenstivity);
        this.add(toolbarUncertainty);
        this.owner = param_owner;
        this.setVisible(true);
        this.setFloatable(false);
    }

    private class PlotDesc {
        ImageIcon icon;
        String tooltip;
        String title;
        PlotType type;
        Class clazz;

        PlotDesc(PlotType type, ImageIcon icon, String tooltip, String title, Class clazz) {
            this.type = type;
            this.icon = icon;
            this.tooltip = tooltip;
            this.title = title;
            this.clazz = clazz;
        }
    }

    static enum PlotType {
        Sensitivity,
        Uncertainty,
        Basic;

    }

    public static class ArrayComparator
    implements Comparator {
        private int col = 0;
        private int order = 1;

        public ArrayComparator(int col, boolean decreasing_order) {
            this.col = col;
            this.order = decreasing_order ? -1 : 1;
        }

        public int compare(Object d1, Object d2) {
            double[] b1 = (double[])d1;
            double[] b2 = (double[])d2;
            if (b1[this.col] < b2[this.col]) {
                return -1 * this.order;
            }
            if (b1[this.col] == b2[this.col]) {
                return 0 * this.order;
            }
            return 1 * this.order;
        }
    }
}

