/*
 * Decompiled with CFR 0.152.
 */
package optas.gui.MCAT5;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import optas.data.SimpleEnsemble;
import optas.hydro.ParameterGroup;

public class GroupConfigurator {
    double beta = 0.8;
    double Tmin = 0.2;
    JPanel groupConfigurationPanel;
    JPanel configuration = new JPanel();
    JLabel betaLabel = new JLabel("beta");
    JLabel minDominanceLabel = new JLabel("T_min");
    JTextField betaTextField = new JTextField(Double.toString(this.beta), 5);
    JTextField tMinField = new JTextField(Double.toString(this.Tmin), 5);
    JLabel infoLabel = new JLabel("info");
    JPanel groups = new JPanel();
    JList groupList = new JList();
    JButton addGroup = new JButton("+");
    JButton delGroup = new JButton("-");
    JPanel parameterInGroup = new JPanel();
    JList availableList = new JList();
    JList inGroupList = new JList();
    JButton addParameter = new JButton(">>");
    JButton rmParameter = new JButton("<<");
    JPanel infoPanel = new JPanel();
    JButton updateBn = new JButton("Update");
    ArrayList<ParameterGroup> solutionGroup = new ArrayList();
    Set<ActionListener> listeners = new HashSet<ActionListener>();
    SimpleEnsemble[] p = new SimpleEnsemble[0];
    int n = 0;
    boolean isUpdated = false;

    public GroupConfigurator() {
        this.layout();
        this.init();
    }

    public void setData(SimpleEnsemble[] p, int n) {
        this.p = p;
        this.n = n;
        this.update();
    }

    public void setSolutionGroup(ArrayList<ParameterGroup> solutionGroup) {
        this.solutionGroup = solutionGroup;
        this.update();
    }

    private void layout() {
        this.configuration.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.black), "Configuration"));
        this.groups.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.black), "Groups"));
        this.parameterInGroup.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.black), "Parameter"));
        JScrollPane inGroupListScroll = new JScrollPane(this.inGroupList);
        this.inGroupList.setFixedCellWidth(170);
        this.groupList.setFixedCellWidth(100);
        JScrollPane availableListScroll = new JScrollPane(this.availableList);
        JScrollPane groupListScroll = new JScrollPane(this.groupList);
        GroupLayout tmpLayout = new GroupLayout(this.configuration);
        this.configuration.setLayout(tmpLayout);
        tmpLayout.setHorizontalGroup(tmpLayout.createSequentialGroup().addComponent(this.betaLabel).addComponent(this.betaTextField).addComponent(this.minDominanceLabel).addComponent(this.tMinField));
        tmpLayout.setVerticalGroup(tmpLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.betaLabel).addComponent(this.betaTextField).addComponent(this.minDominanceLabel).addComponent(this.tMinField));
        tmpLayout = new GroupLayout(this.groups);
        this.groups.setLayout(tmpLayout);
        tmpLayout.setHorizontalGroup(tmpLayout.createSequentialGroup().addComponent(groupListScroll).addGroup(tmpLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.addGroup).addComponent(this.delGroup)));
        tmpLayout.setVerticalGroup(tmpLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(groupListScroll).addGroup(tmpLayout.createSequentialGroup().addComponent(this.addGroup).addComponent(this.delGroup)));
        tmpLayout = new GroupLayout(this.parameterInGroup);
        this.parameterInGroup.setLayout(tmpLayout);
        tmpLayout.setHorizontalGroup(tmpLayout.createSequentialGroup().addComponent(availableListScroll).addGroup(tmpLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.addParameter).addComponent(this.rmParameter)).addComponent(inGroupListScroll));
        tmpLayout.setVerticalGroup(tmpLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(availableListScroll).addGroup(tmpLayout.createSequentialGroup().addComponent(this.addParameter).addComponent(this.rmParameter)).addComponent(inGroupListScroll));
        this.infoPanel.setLayout(new BorderLayout());
        this.infoPanel.add((Component)this.infoLabel, "West");
        this.groupConfigurationPanel = new JPanel();
        GroupLayout layout = new GroupLayout(this.groupConfigurationPanel);
        this.groupConfigurationPanel.setLayout(layout);
        layout.setAutoCreateGaps(true);
        layout.setAutoCreateContainerGaps(true);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.configuration).addGroup(layout.createSequentialGroup().addComponent(this.groups).addComponent(this.parameterInGroup)).addComponent(this.infoPanel).addComponent(this.updateBn));
        layout.setVerticalGroup(layout.createSequentialGroup().addComponent(this.configuration).addGroup(layout.createParallelGroup().addComponent(this.groups).addComponent(this.parameterInGroup)).addComponent(this.infoPanel).addComponent(this.updateBn));
    }

    public int getSelectedGroup() {
        return this.groupList.getSelectedIndex();
    }

    public JPanel getPanel() {
        return this.groupConfigurationPanel;
    }

    private void init() {
        this.addGroup.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ParameterGroup newGroup = new ParameterGroup(GroupConfigurator.this.p, GroupConfigurator.this.n);
                newGroup = newGroup.createEmptyGroup();
                GroupConfigurator.this.solutionGroup.add(newGroup);
                GroupConfigurator.this.update();
            }
        });
        this.delGroup.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int index = GroupConfigurator.this.groupList.getSelectedIndex();
                if (index != -1) {
                    GroupConfigurator.this.solutionGroup.remove(index);
                }
                GroupConfigurator.this.update();
            }
        });
        this.addParameter.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int[] groupIndices;
                for (int groupIndex : groupIndices = GroupConfigurator.this.groupList.getSelectedIndices()) {
                    Object[] list;
                    if (groupIndex == -1) {
                        return;
                    }
                    ParameterGroup group = GroupConfigurator.this.solutionGroup.get(groupIndex);
                    for (Object o : list = GroupConfigurator.this.availableList.getSelectedValues()) {
                        if (o == null || !(o instanceof SimpleEnsemble)) continue;
                        SimpleEnsemble pAdd = (SimpleEnsemble)o;
                        for (int i = 0; i < GroupConfigurator.this.n; ++i) {
                            if (GroupConfigurator.this.p[i] != pAdd) continue;
                            group.add(i);
                        }
                    }
                }
                GroupConfigurator.this.update();
            }
        });
        this.rmParameter.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int[] groupIndices;
                for (int groupIndex : groupIndices = GroupConfigurator.this.groupList.getSelectedIndices()) {
                    int[] indices;
                    if (groupIndex == -1) {
                        return;
                    }
                    ParameterGroup group = GroupConfigurator.this.solutionGroup.get(groupIndex);
                    for (int index : indices = GroupConfigurator.this.inGroupList.getSelectedIndices()) {
                        group.remove(index);
                    }
                    GroupConfigurator.this.update();
                }
            }
        });
        this.groupList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                int index = GroupConfigurator.this.groupList.getSelectedIndex();
                if (index == -1) {
                    return;
                }
                ParameterGroup group = GroupConfigurator.this.solutionGroup.get(index);
                DefaultListModel<SimpleEnsemble> inGroupModel = new DefaultListModel<SimpleEnsemble>();
                for (int i = 0; i < group.getSize(); ++i) {
                    inGroupModel.addElement(GroupConfigurator.this.p[group.get(i)]);
                }
                GroupConfigurator.this.inGroupList.setModel(inGroupModel);
                GroupConfigurator.this.fireSelectionChange();
            }
        });
        this.updateBn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GroupConfigurator.this.fireUpdate();
            }
        });
    }

    private void update() {
        int i;
        DefaultListModel<String> groupListModel = new DefaultListModel<String>();
        int counter = 1;
        boolean[] inUse = new boolean[this.n];
        for (ParameterGroup p : this.solutionGroup) {
            groupListModel.addElement("Group" + counter++);
            for (i = 0; i < p.getSize(); ++i) {
                inUse[p.get((int)i)] = true;
            }
        }
        Object o = this.groupList.getSelectedValue();
        this.groupList.setModel(groupListModel);
        this.groupList.setSelectedValue(o, true);
        DefaultListModel<SimpleEnsemble> availableListModel = new DefaultListModel<SimpleEnsemble>();
        for (i = 0; i < this.n; ++i) {
            availableListModel.addElement(this.p[i]);
        }
        this.availableList.setModel(availableListModel);
        this.inGroupList.setModel(new DefaultListModel());
        this.isUpdated = false;
        int index = this.groupList.getSelectedIndex();
        if (index == -1) {
            return;
        }
        ParameterGroup group = this.solutionGroup.get(index);
        DefaultListModel<SimpleEnsemble> inGroupModel = new DefaultListModel<SimpleEnsemble>();
        for (int i2 = 0; i2 < group.getSize(); ++i2) {
            inGroupModel.addElement(this.p[group.get(i2)]);
        }
        this.inGroupList.setModel(inGroupModel);
    }

    public void setDominanceInfo(double value) {
        this.infoLabel.setText("Dominance:" + 100.0 * value + "%");
    }

    public ArrayList<ParameterGroup> getGroupConfiguration() {
        return this.solutionGroup;
    }

    public double getBeta() {
        return this.beta;
    }

    public double getTemporalDominanceThreshold() {
        return this.Tmin;
    }

    public void setBeta(double beta) {
        this.beta = beta;
    }

    public void getTemporalDominanceThreshold(double Tmin) {
        this.Tmin = Tmin;
    }

    public void addUpdateListener(ActionListener listener) {
        this.listeners.add(listener);
    }

    private void fireUpdate() {
        ActionEvent e = new ActionEvent(this, 0, "update");
        for (ActionListener listener : this.listeners) {
            listener.actionPerformed(e);
        }
        this.isUpdated = true;
    }

    private void fireSelectionChange() {
        if (!this.isUpdated) {
            return;
        }
        ActionEvent e = new ActionEvent(this, 0, "select");
        for (ActionListener listener : this.listeners) {
            listener.actionPerformed(e);
        }
    }
}

