/*
 * Decompiled with CFR 0.152.
 */
package optas.gui.MCAT5;

import jams.JAMS;
import java.awt.Color;
import java.awt.Component;
import java.awt.Paint;
import java.util.ArrayList;
import javax.swing.GroupLayout;
import javax.swing.JPanel;
import optas.data.DataSet;
import optas.data.Efficiency;
import optas.data.EfficiencyEnsemble;
import optas.data.SimpleEnsemble;
import optas.data.StateVariable;
import optas.gui.MCAT5.MCAT5Plot;
import optas.tools.PatchedChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.StandardXYBarPainter;
import org.jfree.chart.renderer.xy.XYBarPainter;
import org.jfree.chart.renderer.xy.XYBarRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.data.xy.XYBarDataset;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;

public class GLUEVariableUncertainty
extends MCAT5Plot {
    XYPlot plot1 = new XYPlot();
    XYPlot plot2 = new XYPlot();
    PatchedChartPanel chartPanel1 = null;
    PatchedChartPanel chartPanel2 = null;
    final int GROUPS = 10;

    public GLUEVariableUncertainty() {
        this.addRequest(new MCAT5Plot.SimpleRequest(this, JAMS.i18n((String)"ENSEMBLE_SIMULATED_VARIABLE"), StateVariable.class));
        this.addRequest(new MCAT5Plot.SimpleRequest(this, JAMS.i18n((String)"Efficiency"), Efficiency.class));
        this.init();
    }

    private void init() {
        XYLineAndShapeRenderer renderer1 = new XYLineAndShapeRenderer();
        XYLineAndShapeRenderer renderer3 = new XYLineAndShapeRenderer();
        renderer1.setBaseShapesVisible(false);
        renderer3.setBaseLinesVisible(false);
        this.plot1.setRenderer(0, (XYItemRenderer)renderer1);
        this.plot1.setRenderer(1, (XYItemRenderer)renderer3);
        XYBarRenderer renderer = new XYBarRenderer(0.0);
        renderer.setShadowVisible(false);
        renderer.setBarPainter((XYBarPainter)new StandardXYBarPainter());
        this.plot2.setRenderer((XYItemRenderer)renderer);
        JFreeChart chart1 = new JFreeChart((Plot)this.plot1);
        JFreeChart chart2 = new JFreeChart((Plot)this.plot2);
        chart1.setTitle(JAMS.i18n((String)"CUMULATIVE_DENSITY_PLOT"));
        chart2.setTitle(JAMS.i18n((String)"DENSITY_PLOT"));
        chart2.removeLegend();
        this.chartPanel1 = new PatchedChartPanel(chart1, true);
        this.chartPanel2 = new PatchedChartPanel(chart2, true);
        this.chartPanel1.setMinimumDrawWidth(0);
        this.chartPanel1.setMinimumDrawHeight(0);
        this.chartPanel1.setMaximumDrawWidth(2000);
        this.chartPanel1.setMaximumDrawHeight(2000);
        this.chartPanel2.setMinimumDrawWidth(0);
        this.chartPanel2.setMinimumDrawHeight(0);
        this.chartPanel2.setMaximumDrawWidth(2000);
        this.chartPanel2.setMaximumDrawHeight(2000);
        chart1.getPlot().setBackgroundPaint((Paint)Color.white);
        chart1.getXYPlot().setDomainGridlinePaint((Paint)Color.black);
        chart2.getPlot().setBackgroundPaint((Paint)Color.white);
        chart2.getXYPlot().setDomainGridlinePaint((Paint)Color.black);
        this.redraw();
    }

    @Override
    public void refresh() throws MCAT5Plot.NoDataException {
        int i;
        if (!this.isRequestFulfilled()) {
            return;
        }
        ArrayList<DataSet>[] p = this.getData(new int[]{0, 1});
        SimpleEnsemble var = (SimpleEnsemble)p[0].get(0);
        EfficiencyEnsemble eff = (EfficiencyEnsemble)p[1].get(0);
        this.plot1.setDomainAxis((ValueAxis)new NumberAxis(var.name));
        this.plot1.setRangeAxis((ValueAxis)new NumberAxis(""));
        this.plot2.setDomainAxis((ValueAxis)new NumberAxis(var.name));
        this.plot2.setRangeAxis((ValueAxis)new NumberAxis(""));
        XYSeries dataset1 = new XYSeries((Comparable)((Object)JAMS.i18n((String)"CUMULATIVE_DENSITY")));
        XYSeries dataset2 = new XYSeries((Comparable)((Object)JAMS.i18n((String)"NO_DESCRIPTION")));
        XYSeries dataset3 = new XYSeries((Comparable)((Object)JAMS.i18n((String)"0.95_CONFIDENCE_INTERVAL")));
        double[] bin_sum = new double[10];
        int[] bin_count = new int[10];
        EfficiencyEnsemble likelihood = eff.CalculateLikelihood();
        Integer[] sortedIds = var.sort();
        double sum = 0.0;
        double conf = 0.05;
        int n = var.getSize();
        double lastValue = -1.0E11;
        for (int i2 = 0; i2 < n; ++i2) {
            double newvalue;
            if (sum < conf && sum + likelihood.getValue(sortedIds[i2]) > conf) {
                dataset3.add(var.getValue(sortedIds[i2]), sum);
            }
            if (sum < 1.0 - conf && sum + likelihood.getValue(sortedIds[i2]) > 1.0 - conf) {
                dataset3.add(var.getValue(sortedIds[i2]), sum);
            }
            if (lastValue == (newvalue = var.getValue(sortedIds[i2]))) {
                newvalue += 1.0E-8;
            }
            lastValue = newvalue;
            dataset1.add(newvalue, sum += likelihood.getValue(sortedIds[i2]));
        }
        double min = var.getValue(sortedIds[0]);
        double max = var.getValue(sortedIds[n - 1]);
        for (int j = 0; j < n; ++j) {
            int index = (int)((var.getValue(sortedIds[j]) - min) / (max - min) * 10.0);
            if (index >= 10) {
                index = 9;
            }
            int n2 = index;
            bin_sum[n2] = bin_sum[n2] + likelihood.getValue(sortedIds[j]);
            int n3 = index;
            bin_count[n3] = bin_count[n3] + 1;
        }
        double norm = 0.0;
        for (i = 0; i < 10; ++i) {
            bin_sum[i] = bin_sum[i] / (double)bin_count[i];
            norm += bin_sum[i];
        }
        for (i = 0; i < 10; ++i) {
            bin_sum[i] = bin_sum[i] / norm;
            dataset2.add((double)i / 10.0 * (max - min) + min, bin_sum[i]);
        }
        this.plot1.setDataset(0, (XYDataset)new XYBarDataset((XYDataset)new XYSeriesCollection(dataset1), 0.9 * (max - min) / 10.0));
        this.plot1.setDataset(1, (XYDataset)new XYBarDataset((XYDataset)new XYSeriesCollection(dataset3), 0.9 * (max - min) / 10.0));
        this.plot2.setDataset(0, (XYDataset)new XYBarDataset((XYDataset)new XYSeriesCollection(dataset2), 0.9 * (max - min) / 10.0));
        if (this.plot1.getRangeAxis() != null) {
            this.plot1.getRangeAxis().setAutoRange(true);
        }
        if (this.plot1.getDomainAxis() != null) {
            this.plot1.getDomainAxis().setAutoRange(true);
        }
        if (this.plot2.getRangeAxis() != null) {
            this.plot2.getRangeAxis().setAutoRange(true);
        }
        if (this.plot2.getDomainAxis() != null) {
            this.plot2.getDomainAxis().setAutoRange(true);
        }
    }

    @Override
    public JPanel getPanel() {
        return new JPanel(){
            {
                GroupLayout gl = new GroupLayout(this);
                this.setLayout(gl);
                gl.setHorizontalGroup(gl.createSequentialGroup().addComponent((Component)((Object)GLUEVariableUncertainty.this.chartPanel1)).addComponent((Component)((Object)GLUEVariableUncertainty.this.chartPanel2)));
                gl.setVerticalGroup(gl.createParallelGroup().addComponent((Component)((Object)GLUEVariableUncertainty.this.chartPanel1)).addComponent((Component)((Object)GLUEVariableUncertainty.this.chartPanel2)));
            }
        };
    }

    public JPanel getPanel1() {
        return this.chartPanel1;
    }

    public JPanel getPanel2() {
        return this.chartPanel2;
    }
}

