/*
 * Decompiled with CFR 0.152.
 */
package optas.gui.MCAT5;

import jams.JAMS;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import optas.data.DataSet;
import optas.data.Efficiency;
import optas.data.EfficiencyEnsemble;
import optas.data.Measurement;
import optas.data.TimeSerie;
import optas.data.TimeSerieEnsemble;
import optas.gui.MCAT5.Efficiencies;
import optas.gui.MCAT5.MCAT5Plot;
import optas.tools.PatchedChartPanel;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.DateAxis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYDifferenceRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.data.time.Day;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.data.xy.XYDataset;

public class GLUEOutputUncertainty
extends MCAT5Plot {
    XYPlot plot1 = new XYPlot();
    XYPlot plot2 = new XYPlot();
    PatchedChartPanel chartPanel1 = null;
    PatchedChartPanel chartPanel2 = null;
    JPanel mainPanel = null;
    JTextField thresholdField;
    JTextField percentilField;
    JSlider thresholdSlider;
    JSlider percentileSlider;
    JLabel dataRange;
    JButton exportMeanButton;
    JButton exportMedianButton;
    double threshold = 0.0;
    double percentil = 0.95;
    double minValue;
    double maxValue;
    boolean isShowMean = true;
    boolean isShowMedian = false;
    EfficiencyEnsemble eff = null;
    double dataCount = 0.0;
    String meanString;
    String medianString;
    String lowBound;
    String upBound;
    boolean isCalled1 = false;
    boolean isCalled2 = false;
    boolean showAll = true;

    public GLUEOutputUncertainty() {
        this.addRequest(new MCAT5Plot.SimpleRequest(this, JAMS.i18n((String)"SIMULATED_TIMESERIE"), TimeSerie.class));
        this.addRequest(new MCAT5Plot.SimpleRequest(this, JAMS.i18n((String)"Efficiency"), Efficiency.class));
        this.addRequest(new MCAT5Plot.SimpleRequest(this, JAMS.i18n((String)"OBSERVED_TIMESERIE"), Measurement.class, 0, 1));
        this.init();
    }

    public void setShowMean(boolean isShowMean) {
        this.isShowMean = isShowMean;
        this.redraw();
    }

    public void setShowMedian(boolean isShowMedian) {
        this.isShowMedian = isShowMedian;
        this.redraw();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateThreshold(double threshold) {
        if (this.isCalled1) {
            return;
        }
        try {
            this.isCalled1 = true;
            double tOld = 0.0;
            double rOld = 0.0;
            double r = (threshold - this.minValue) / (this.maxValue - this.minValue);
            double t = threshold;
            if (r < 0.0) {
                r = 0.0;
            }
            if (r > 1.0) {
                r = 1.0;
            }
            try {
                tOld = Double.parseDouble(this.thresholdField.getText());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            rOld = (double)this.thresholdSlider.getValue() / 100.0;
            if (Math.abs(r - rOld) > 0.01) {
                this.thresholdSlider.setValue((int)(r * 100.0));
            }
            if (Math.abs(t - tOld) > 0.01) {
                this.thresholdField.setText(String.format("%.2f", t));
            }
            this.threshold = t;
        }
        finally {
            this.isCalled1 = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateQuantile(double q) {
        if (this.isCalled2) {
            return;
        }
        try {
            this.isCalled2 = true;
            double qOld = 0.0;
            double pOld = 0.0;
            if (q < 0.0) {
                q = 0.0;
            }
            if (q > 1.0) {
                q = 1.0;
            }
            try {
                pOld = Double.parseDouble(this.percentilField.getText());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            qOld = (double)this.percentileSlider.getValue() / 100.0;
            double p = q * 100.0;
            if (Math.abs(p - pOld) > 0.01) {
                this.percentileSlider.setValue((int)p);
            }
            if (Math.abs(q - qOld) > 0.01) {
                this.percentilField.setText(String.format("%.2f", q));
            }
            this.percentil = q;
        }
        finally {
            this.isCalled2 = false;
        }
    }

    private void init() {
        JFreeChart chart1 = ChartFactory.createTimeSeriesChart((String)JAMS.i18n((String)"OUTPUT_UNCERTAINTY_PLOT"), (String)"time", (String)"discharge", null, (boolean)true, (boolean)true, (boolean)false);
        this.plot1 = chart1.getXYPlot();
        chart1.getPlot().setBackgroundPaint((Paint)Color.white);
        chart1.getXYPlot().setDomainGridlinePaint((Paint)Color.black);
        XYDifferenceRenderer renderer1 = new XYDifferenceRenderer((Paint)Color.LIGHT_GRAY, (Paint)Color.LIGHT_GRAY, false);
        XYLineAndShapeRenderer renderer2 = new XYLineAndShapeRenderer();
        XYLineAndShapeRenderer renderer_mean = new XYLineAndShapeRenderer();
        XYLineAndShapeRenderer renderer_median = new XYLineAndShapeRenderer();
        renderer1.setBaseFillPaint((Paint)Color.LIGHT_GRAY);
        renderer1.setPaint((Paint)Color.BLACK);
        renderer2.setBaseLinesVisible(true);
        renderer2.setBaseShapesVisible(false);
        renderer2.setOutlinePaint((Paint)Color.BLUE);
        renderer2.setPaint((Paint)Color.BLUE);
        renderer2.setStroke((Stroke)new BasicStroke(2.0f));
        renderer_mean.setBaseLinesVisible(true);
        renderer_mean.setBaseShapesVisible(false);
        renderer_mean.setOutlinePaint((Paint)Color.RED);
        renderer_mean.setPaint((Paint)Color.RED);
        renderer_mean.setStroke((Stroke)new BasicStroke(0.25f));
        renderer_median.setBaseLinesVisible(true);
        renderer_median.setBaseShapesVisible(false);
        renderer_median.setOutlinePaint((Paint)Color.ORANGE);
        renderer_median.setPaint((Paint)Color.ORANGE);
        renderer_median.setStroke((Stroke)new BasicStroke(1.0f));
        this.plot1.setRenderer(3, (XYItemRenderer)renderer1);
        this.plot1.setRenderer(0, (XYItemRenderer)renderer2);
        this.plot1.setRenderer(1, (XYItemRenderer)renderer_mean);
        this.plot1.setRenderer(2, (XYItemRenderer)renderer_median);
        this.plot1.getDomainAxis().setLabel(JAMS.i18n((String)"TIME"));
        DateAxis axis = (DateAxis)this.plot1.getDomainAxis();
        axis.setDateFormatOverride((DateFormat)new SimpleDateFormat("yyyy-MM-dd"));
        this.plot1.setRangeAxis((ValueAxis)new NumberAxis(JAMS.i18n((String)"OUTPUT")));
        JFreeChart chart2 = new JFreeChart((Plot)this.plot2);
        chart1.setTitle(JAMS.i18n((String)"OUTPUT_UNCERTAINTY_PLOT"));
        chart2.setTitle("");
        chart2.removeLegend();
        this.chartPanel1 = new PatchedChartPanel(chart1, true);
        this.chartPanel1.setMinimumDrawWidth(0);
        this.chartPanel1.setMinimumDrawHeight(0);
        this.chartPanel1.setMaximumDrawWidth(2000);
        this.chartPanel1.setMaximumDrawHeight(2000);
        this.mainPanel = new JPanel(new BorderLayout());
        JPanel panel2 = new JPanel(new FlowLayout());
        this.mainPanel.add((Component)((Object)this.chartPanel1), "North");
        this.thresholdField = new JTextField("0.0", 5);
        this.thresholdSlider = new JSlider(0, 100, 100);
        this.thresholdSlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                JSlider source = (JSlider)e.getSource();
                double t = (double)source.getValue() * 0.01 * (GLUEOutputUncertainty.this.maxValue - GLUEOutputUncertainty.this.minValue) + GLUEOutputUncertainty.this.minValue;
                GLUEOutputUncertainty.this.updateThreshold(t);
                if (!source.getValueIsAdjusting() && !GLUEOutputUncertainty.this.isCalled1) {
                    GLUEOutputUncertainty.this.redraw();
                }
            }
        });
        this.thresholdField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    double t = Double.parseDouble(GLUEOutputUncertainty.this.thresholdField.getText());
                    GLUEOutputUncertainty.this.updateThreshold(t);
                    if (!GLUEOutputUncertainty.this.isCalled1) {
                        GLUEOutputUncertainty.this.redraw();
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        });
        this.percentilField = new JTextField("0.95", 5);
        this.percentileSlider = new JSlider(0, 100, 100);
        this.percentileSlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                JSlider source = (JSlider)e.getSource();
                double t = source.getValue();
                GLUEOutputUncertainty.this.updateQuantile(t / 100.0);
                if (!source.getValueIsAdjusting() && !GLUEOutputUncertainty.this.isCalled2) {
                    GLUEOutputUncertainty.this.redraw();
                }
            }
        });
        this.percentilField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    double q = Double.parseDouble(GLUEOutputUncertainty.this.percentilField.getText());
                    GLUEOutputUncertainty.this.updateQuantile(q);
                    if (!GLUEOutputUncertainty.this.isCalled2) {
                        GLUEOutputUncertainty.this.redraw();
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        });
        this.exportMeanButton = new JButton("copy mean to clipboard");
        this.exportMeanButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StringSelection ss = new StringSelection(GLUEOutputUncertainty.this.meanString);
                Toolkit.getDefaultToolkit().getSystemClipboard().setContents(ss, null);
            }
        });
        this.exportMedianButton = new JButton("copy median to clipboard");
        this.exportMedianButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StringSelection ss = new StringSelection(GLUEOutputUncertainty.this.medianString);
                Toolkit.getDefaultToolkit().getSystemClipboard().setContents(ss, null);
            }
        });
        this.dataRange = new JLabel("range");
        JLabel thresholdLabel = new JLabel("threshold");
        JLabel percentileLabel = new JLabel("quantile");
        JPanel filterPanel = new JPanel();
        filterPanel.setBorder(BorderFactory.createTitledBorder("Filter Settings"));
        GroupLayout layout = new GroupLayout(filterPanel);
        filterPanel.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup().addGroup(layout.createSequentialGroup().addComponent(thresholdLabel).addComponent(this.thresholdSlider).addComponent(this.thresholdField)).addGroup(layout.createSequentialGroup().addComponent(percentileLabel).addComponent(this.percentileSlider).addComponent(this.percentilField)));
        layout.setVerticalGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup().addComponent(thresholdLabel).addComponent(this.thresholdSlider).addComponent(this.thresholdField)).addGroup(layout.createParallelGroup().addComponent(percentileLabel).addComponent(this.percentileSlider).addComponent(this.percentilField)));
        JCheckBox meanBox = new JCheckBox("show mean");
        meanBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GLUEOutputUncertainty.this.setShowMean(((JCheckBox)e.getSource()).isSelected());
            }
        });
        JCheckBox medianBox = new JCheckBox("show median");
        medianBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GLUEOutputUncertainty.this.setShowMedian(((JCheckBox)e.getSource()).isSelected());
            }
        });
        JPanel displayPanel = new JPanel();
        displayPanel.setBorder(BorderFactory.createTitledBorder("Display Settings"));
        layout = new GroupLayout(displayPanel);
        displayPanel.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup().addGroup(layout.createSequentialGroup().addComponent(meanBox).addComponent(this.exportMeanButton)).addGroup(layout.createSequentialGroup().addComponent(medianBox).addComponent(this.exportMedianButton)));
        layout.setVerticalGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup().addComponent(meanBox).addComponent(this.exportMeanButton)).addGroup(layout.createParallelGroup().addComponent(medianBox).addComponent(this.exportMedianButton)));
        meanBox.setSelected(this.isShowMean);
        medianBox.setSelected(this.isShowMedian);
        panel2.add(filterPanel);
        panel2.add(displayPanel);
        JPanel panel3 = new JPanel(new BorderLayout());
        panel3.add((Component)this.dataRange, "South");
        this.dataRange.setAlignmentX(0.5f);
        this.dataRange.setHorizontalAlignment(0);
        panel3.add((Component)panel2, "North");
        this.mainPanel.add((Component)panel3, "South");
        this.redraw();
        if (this.plot1.getRangeAxis() != null) {
            this.plot1.getRangeAxis().setAutoRange(true);
        }
        if (this.plot1.getDomainAxis() != null) {
            this.plot1.getDomainAxis().setAutoRange(true);
        }
    }

    public double[][] sortbyEff(double[] data, double[] likelihood) {
        int n = data.length;
        double[][] tmp_data = new double[n][2];
        for (int i = 0; i < n; ++i) {
            tmp_data[i][0] = data[i];
            tmp_data[i][1] = likelihood[i];
        }
        Arrays.sort(tmp_data, new ArrayComparator(1, true));
        return tmp_data;
    }

    @Override
    public void refresh() throws MCAT5Plot.NoDataException {
        int iter;
        if (!this.isRequestFulfilled()) {
            return;
        }
        this.meanString = "";
        this.medianString = "";
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
        ArrayList<DataSet>[] p = this.getData(new int[]{0, 1, 2});
        TimeSerieEnsemble ts = (TimeSerieEnsemble)p[0].get(0);
        EfficiencyEnsemble eff = (EfficiencyEnsemble)p[1].get(0);
        Measurement obs = null;
        if (p[2].size() > 0) {
            obs = (Measurement)p[2].get(0);
        }
        this.eff = eff;
        this.minValue = eff.getMin();
        this.maxValue = eff.getMax();
        TimeSeries dataset1 = new TimeSeries((Comparable)((Object)JAMS.i18n((String)"LOWER_CONFIDENCE_BOUND")));
        TimeSeries dataset2 = new TimeSeries((Comparable)((Object)JAMS.i18n((String)"UPPER_CONFIDENCE_BOUND")));
        if (obs != null) {
            TimeSeries dataset3 = new TimeSeries((Comparable)((Object)obs.name));
            for (int i = 0; i < obs.getTimesteps(); ++i) {
                Day d = new Day(obs.getTime(i));
                dataset3.add((RegularTimePeriod)d, obs.getValue(i));
            }
            TimeSeriesCollection obs_runoff = new TimeSeriesCollection();
            obs_runoff.addSeries(dataset3);
            this.plot1.setDataset(0, (XYDataset)obs_runoff);
        } else {
            this.plot1.setDataset(0, null);
        }
        TimeSeries dataset4 = new TimeSeries((Comparable)((Object)JAMS.i18n((String)"MEAN")));
        TimeSeries dataset5 = new TimeSeries((Comparable)((Object)JAMS.i18n((String)"MEDIAN")));
        if (this.showAll) {
            TimeSeries[] dataset_full = new TimeSeries[ts.getSize()];
            TimeSeriesCollection ensemble_full = new TimeSeriesCollection();
            for (int i = 0; i < ts.getSize(); ++i) {
                dataset_full[i] = new TimeSeries((Comparable)((Object)("data_" + i)));
                int id = ts.getId(i);
                for (int j = 0; j < ts.getTimesteps(); ++j) {
                    Day d = new Day(ts.getDate(j));
                    dataset_full[i].add((RegularTimePeriod)d, ts.get(j, id));
                }
                ensemble_full.addSeries(dataset_full[i]);
            }
            this.chartPanel1.getChart().removeLegend();
            this.plot1.setDomainGridlinesVisible(false);
            this.plot1.setRangeGridlinesVisible(false);
        }
        double[] low_conf = new double[ts.getTimesteps()];
        double[] high_conf = new double[ts.getTimesteps()];
        double conf = 1.0 - this.percentil;
        double max_diff = 0.0;
        DecimalFormat df = new DecimalFormat("0.00");
        Integer[] sortedIds = eff.sort();
        if (eff.isPositiveBest()) {
            for (iter = 0; iter < sortedIds.length && eff.getValue(sortedIds[iter]) >= this.threshold || iter == 0; ++iter) {
            }
            this.dataRange.setText("<html><body>the data ranges from " + df.format(eff.getValue(sortedIds[sortedIds.length - 1])) + " to " + df.format(eff.getValue(sortedIds[0])) + "<br>" + iter + " datasets are taken into account</body></html>");
        } else {
            while (iter < sortedIds.length && eff.getValue(sortedIds[iter]) <= this.threshold || iter == 0) {
                ++iter;
            }
            this.dataRange.setText("<html><body>the data ranges from " + df.format(eff.getValue(sortedIds[0])) + " to " + df.format(eff.getValue(sortedIds[sortedIds.length - 1])) + "<br>" + iter + " datasets are taken into account</body></html>");
        }
        int limit = iter;
        this.dataCount = limit;
        for (int i = 0; i < ts.getTimesteps(); ++i) {
            double mean = 0.0;
            int counter = 0;
            int index_low = 0;
            int index_high = limit;
            double[] reducedOutputSet = new double[limit];
            for (int j = 0; j < limit; ++j) {
                reducedOutputSet[j] = ts.get(i, sortedIds[j]);
            }
            Arrays.sort(reducedOutputSet);
            double[] likelihood = Efficiencies.CalculateLikelihood(reducedOutputSet);
            double[][] sorted_data = this.sortbyEff(likelihood, reducedOutputSet);
            double sum = 0.0;
            low_conf[i] = sorted_data[0][1];
            high_conf[i] = sorted_data[likelihood.length - 1][1];
            for (int j = 0; j < likelihood.length; ++j) {
                if (sum < conf && sum + sorted_data[j][0] > conf) {
                    low_conf[i] = sorted_data[j][1];
                    index_low = j;
                }
                if (sum < 1.0 - conf && sum + sorted_data[j][0] > 1.0 - conf) {
                    high_conf[i] = sorted_data[j][1];
                    index_high = j;
                }
                if (!((sum += sorted_data[j][0]) > conf) || !(sum < 1.0 - conf)) continue;
                mean += sorted_data[j][1];
                ++counter;
            }
            mean /= (double)counter;
            double median = sorted_data[(int)((double)(index_low + index_high) / 2.0)][1];
            max_diff = Math.max(high_conf[i] - low_conf[i], max_diff);
            if (low_conf[i] > high_conf[i]) {
                double tmp = low_conf[i];
                low_conf[i] = high_conf[i];
                high_conf[i] = tmp;
            }
            Day d = new Day(ts.getDate(i));
            dataset1.add((RegularTimePeriod)d, low_conf[i]);
            dataset2.add((RegularTimePeriod)d, high_conf[i]);
            dataset4.add((RegularTimePeriod)d, mean);
            this.meanString = this.meanString + sdf.format(ts.getDate(i)) + "\t" + mean + "\n";
            this.medianString = this.medianString + sdf.format(ts.getDate(i)) + "\t" + median + "\n";
            System.out.println(sdf.format(ts.getDate(i)) + "\t" + low_conf[i] + "\t" + high_conf[i] + "\t" + mean);
            dataset5.add((RegularTimePeriod)d, median);
        }
        TimeSeriesCollection interval = new TimeSeriesCollection();
        interval.addSeries(dataset1);
        interval.addSeries(dataset2);
        TimeSeriesCollection mean_ensemble = new TimeSeriesCollection();
        mean_ensemble.addSeries(dataset4);
        TimeSeriesCollection median_ensemble = new TimeSeriesCollection();
        median_ensemble.addSeries(dataset5);
        this.plot1.setDataset(3, (XYDataset)interval);
        if (!this.showAll) {
            this.plot1.setDataset(3, (XYDataset)interval);
            if (this.isShowMean) {
                this.plot1.setDataset(1, (XYDataset)mean_ensemble);
            } else {
                this.plot1.setDataset(1, null);
            }
            if (this.isShowMedian) {
                this.plot1.setDataset(2, (XYDataset)median_ensemble);
            } else {
                this.plot1.setDataset(2, null);
            }
        }
    }

    @Override
    public JPanel getPanel() {
        return this.mainPanel;
    }

    public JPanel getPanel1() {
        return this.mainPanel;
    }

    public JPanel getPanel2() {
        return this.chartPanel2;
    }

    public static class ArrayComparator
    implements Comparator {
        private int col = 0;
        private int order = 1;

        public ArrayComparator(int col, boolean decreasing_order) {
            this.col = col;
            this.order = decreasing_order ? -1 : 1;
        }

        public int compare(Object d1, Object d2) {
            double[] b1 = (double[])d1;
            double[] b2 = (double[])d2;
            if (b1[this.col] < b2[this.col]) {
                return -1 * this.order;
            }
            if (b1[this.col] == b2[this.col]) {
                return 0 * this.order;
            }
            return 1 * this.order;
        }
    }
}

