/*
 * Decompiled with CFR 0.152.
 */
package optas.gui.MCAT5;

import jams.JAMS;
import java.awt.Color;
import java.awt.Paint;
import java.util.ArrayList;
import javax.swing.JPanel;
import optas.data.DataSet;
import optas.data.SimpleEnsemble;
import optas.data.StateVariable;
import optas.gui.MCAT5.MCAT5Plot;
import optas.tools.PatchedChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYDotRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;

public class DottyPlot
extends MCAT5Plot {
    protected XYPlot plot = new XYPlot();
    protected PatchedChartPanel chartPanel = null;

    private void init() {
        XYDotRenderer renderer = new XYDotRenderer();
        renderer.setSeriesPaint(0, (Paint)Color.BLUE);
        renderer.setDotHeight(3);
        renderer.setDotWidth(3);
        this.plot.setRenderer((XYItemRenderer)renderer);
        JFreeChart chart = new JFreeChart((Plot)this.plot);
        chart.setTitle(JAMS.i18n((String)"DOTTY_PLOT"));
        this.chartPanel = new PatchedChartPanel(chart, true);
        this.chartPanel.setMinimumDrawWidth(0);
        this.chartPanel.setMinimumDrawHeight(0);
        this.chartPanel.setMaximumDrawWidth(2000);
        this.chartPanel.setMaximumDrawHeight(2000);
        chart.getPlot().setBackgroundPaint((Paint)Color.white);
        chart.getXYPlot().setDomainGridlinePaint((Paint)Color.black);
        this.redraw();
    }

    public DottyPlot() {
        this.addRequest(new MCAT5Plot.SimpleRequest(this, JAMS.i18n((String)"Attribute") + " 1", StateVariable.class));
        this.addRequest(new MCAT5Plot.SimpleRequest(this, JAMS.i18n((String)"Attribute") + " 2", StateVariable.class));
        this.init();
    }

    @Override
    public JPanel getPanel() {
        return this.chartPanel;
    }

    @Override
    public void refresh() throws MCAT5Plot.NoDataException {
        if (!this.isRequestFulfilled()) {
            return;
        }
        ArrayList<DataSet>[] p = this.getData(new int[]{0, 1});
        SimpleEnsemble p1 = (SimpleEnsemble)p[0].get(0);
        SimpleEnsemble p2 = (SimpleEnsemble)p[1].get(0);
        this.plot.setDomainAxis((ValueAxis)new NumberAxis(p1.getName()));
        this.plot.setRangeAxis((ValueAxis)new NumberAxis(p2.getName()));
        XYSeries dataset = new XYSeries((Comparable)((Object)JAMS.i18n((String)"DATA_POINT")));
        int n = p1.getSize();
        for (int i = 0; i < n; ++i) {
            dataset.add(p1.getValue(p1.getId(i)), p2.getValue(p2.getId(i)));
        }
        this.plot.setDataset(0, (XYDataset)new XYSeriesCollection(dataset));
        if (this.plot.getRangeAxis() != null) {
            this.plot.getRangeAxis().setRange(p2.getMin(), p2.getMax());
        }
        if (this.plot.getDomainAxis() != null) {
            this.plot.getDomainAxis().setRange(p1.getMin(), p1.getMax());
        }
    }
}

