/*
 * Decompiled with CFR 0.152.
 */
package optas.gui.MCAT5;

import jams.gui.WorkerDlg;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import optas.data.DataCollection;
import optas.data.DataSet;
import optas.data.Efficiency;
import optas.data.EfficiencyEnsemble;
import optas.gui.MCAT5.MCAT5Plot;
import optas.gui.wizard.ObjectiveConstructorDialog;

public final class DataRequestPanel
extends JPanel {
    MCAT5Plot plot;
    DataCollection data;
    JPanel dataPanel = new JPanel();
    ArrayList<RequestGUI> requests = new ArrayList();

    public DataRequestPanel(MCAT5Plot plot, DataCollection data) throws MCAT5Plot.NoDataException {
        this.plot = plot;
        this.data = data;
        plot.setDataSource(data);
        if (data == null) {
            throw new MCAT5Plot.NoDataException("datacollection not provided!");
        }
        JScrollPane contentScroll = new JScrollPane(plot.getPanel());
        contentScroll.setHorizontalScrollBarPolicy(30);
        contentScroll.setVerticalScrollBarPolicy(20);
        this.setLayout(new BorderLayout());
        this.add((Component)contentScroll, "Center");
        ArrayList<MCAT5Plot.SimpleRequest> request = plot.getRequiredData();
        if (request.isEmpty()) {
            this.updatePlot();
            return;
        }
        for (MCAT5Plot.SimpleRequest r : request) {
            RequestGUI rGUI = new RequestGUI(r);
            this.requests.add(rGUI);
        }
        JScrollPane datasetScroll = new JScrollPane(this.dataPanel);
        this.dataPanel.setLayout(new GridBagLayout());
        this.layouting();
        this.add((Component)datasetScroll, "South");
        this.updatePlot();
    }

    public void layouting() {
        this.dataPanel.removeAll();
        int i = 0;
        for (RequestGUI r : this.requests) {
            for (int j = 0; j < r.boxes.size(); ++j) {
                GridBagConstraints c = new GridBagConstraints();
                c.gridx = 0;
                c.gridy = i;
                c.anchor = 17;
                c.ipadx = 10;
                this.dataPanel.add((Component)new JLabel(r.request.name), c);
                c.gridx = 1;
                if (j == r.boxes.size() - 1) {
                    JButton button;
                    JPanel panel = new JPanel(new BorderLayout());
                    JPanel buttonPanel = new JPanel(new FlowLayout());
                    panel.add((Component)r.boxes.get(j), "West");
                    panel.add((Component)buttonPanel, "East");
                    if (r.boxes.size() < r.request.max) {
                        button = new JButton("+");
                        button.putClientProperty("request", r);
                        button.addActionListener(new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                RequestGUI rGUI = (RequestGUI)((JButton)e.getSource()).getClientProperty("request");
                                rGUI.addBox();
                                SwingUtilities.invokeLater(new Runnable(){

                                    @Override
                                    public void run() {
                                        DataRequestPanel.this.layouting();
                                    }
                                });
                            }
                        });
                        buttonPanel.add(button);
                    }
                    if (r.boxes.size() > r.request.min) {
                        button = new JButton("-");
                        button.putClientProperty("request", r);
                        button.addActionListener(new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                RequestGUI rGUI = (RequestGUI)((JButton)e.getSource()).getClientProperty("request");
                                rGUI.removeLastBox();
                                SwingUtilities.invokeLater(new Runnable(){

                                    @Override
                                    public void run() {
                                        DataRequestPanel.this.layouting();
                                    }
                                });
                            }
                        });
                        buttonPanel.add(button);
                    }
                    this.dataPanel.add((Component)panel, c);
                } else {
                    this.dataPanel.add((Component)r.boxes.get(j), c);
                }
                ++i;
            }
        }
        this.dataPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.black), "Data Configuration"));
        this.invalidate();
        this.updateUI();
    }

    public void updatePlot() {
        Frame parent = JFrame.getFrames().length > 0 ? JFrame.getFrames()[0] : null;
        WorkerDlg progress = new WorkerDlg((Window)parent, "Collecting data");
        progress.setInderminate(true);
        progress.setTask(new Runnable(){

            @Override
            public void run() {
                try {
                    DataRequestPanel.this.plot.reset();
                    for (RequestGUI rGUI : DataRequestPanel.this.requests) {
                        ArrayList<DataSet> list = new ArrayList<DataSet>();
                        for (JComboBox box : rGUI.boxes) {
                            if (box.getSelectedItem() instanceof String) {
                                DataSet e = DataRequestPanel.this.data.getDataSet((String)box.getSelectedItem());
                                list.add(e);
                                continue;
                            }
                            list.add((DataSet)box.getSelectedItem());
                        }
                        DataRequestPanel.this.plot.setData(rGUI.request.name, list);
                    }
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }
        });
        progress.execute();
        progress = null;
        this.plot.redraw();
    }

    public final class RequestGUI {
        MCAT5Plot.SimpleRequest request;
        ArrayList<JComboBox> boxes;

        RequestGUI(MCAT5Plot.SimpleRequest r) throws MCAT5Plot.NoDataException {
            this.request = r;
            this.boxes = new ArrayList();
            while (this.boxes.size() < r.min) {
                if (this.addBox()) continue;
                throw new MCAT5Plot.NoDataException(r);
            }
            if (r.min == 0 && r.max > 0) {
                this.addBox();
            }
        }

        public void removeLastBox() {
            this.boxes.remove(this.boxes.size() - 1);
            DataRequestPanel.this.updatePlot();
        }

        public boolean addBox() {
            JComboBox<String> box = new JComboBox<String>();
            if (DataRequestPanel.this.data.getDatasets(this.request.clazz).isEmpty() && this.request.min > 0) {
                return false;
            }
            for (String d : DataRequestPanel.this.data.getDatasets(this.request.clazz)) {
                box.addItem(d);
            }
            if (this.request.clazz.equals(Efficiency.class) && ObjectiveConstructorDialog.isApplicable(DataRequestPanel.this.data)) {
                box.addItem("User defined");
            }
            box.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (e.getStateChange() != 1) {
                        return;
                    }
                    if (e.getItem().toString().compareTo("User defined") == 0) {
                        ObjectiveConstructorDialog dlg = new ObjectiveConstructorDialog(DataRequestPanel.this.data);
                        dlg.setVisible(true);
                        if (dlg.getApproved()) {
                            EfficiencyEnsemble ensemble = dlg.getResult();
                            JComboBox box = (JComboBox)e.getSource();
                            DataRequestPanel.this.data.addEnsemble(ensemble);
                            box.addItem(ensemble);
                            box.setSelectedItem(box);
                        }
                    }
                    DataRequestPanel.this.updatePlot();
                }
            });
            box.putClientProperty("request", this.request);
            this.boxes.add(box);
            return true;
        }
    }
}

