/*
 * Decompiled with CFR 0.152.
 */
package optas.gui.MCAT5;

import jams.JAMS;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import optas.data.DataSet;
import optas.data.EfficiencyEnsemble;
import optas.data.Measurement;
import optas.data.Parameter;
import optas.data.SimpleEnsemble;
import optas.data.TimeSerie;
import optas.data.TimeSerieEnsemble;
import optas.gui.MCAT5.Efficiencies;
import optas.gui.MCAT5.MCAT5Plot;
import optas.tools.PatchedChartPanel;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.AxisLocation;
import org.jfree.chart.axis.DateAxis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.GrayPaintScale;
import org.jfree.chart.renderer.PaintScale;
import org.jfree.chart.renderer.xy.XYBlockRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.data.Range;
import org.jfree.data.xy.DefaultXYZDataset;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;
import org.jfree.ui.RectangleAnchor;

public class DYNIA
extends MCAT5Plot {
    int window_size = 10;
    XYPlot plot = null;
    PatchedChartPanel chartPanel = null;
    JTextField winsize_box = new JTextField(10);
    final int BOX_COUNT = 10;
    final int BOX_COUNT_INTERNAL = 100;

    public DYNIA() {
        JFreeChart chart1 = ChartFactory.createTimeSeriesChart((String)JAMS.i18n((String)"OUTPUT_UNCERTAINTY_PLOT"), (String)"time", (String)"discharge", null, (boolean)true, (boolean)true, (boolean)false);
        this.plot = chart1.getXYPlot();
        chart1.getPlot().setBackgroundPaint((Paint)Color.white);
        this.addRequest(new MCAT5Plot.SimpleRequest(this, JAMS.i18n((String)"SIMULATED_TIMESERIE"), TimeSerie.class));
        this.addRequest(new MCAT5Plot.SimpleRequest(this, JAMS.i18n((String)"PARAMETER"), Parameter.class));
        this.addRequest(new MCAT5Plot.SimpleRequest(this, JAMS.i18n((String)"OBSERVED_TIMESERIE"), Measurement.class));
        this.init();
    }

    private void init() {
        JFreeChart chart = new JFreeChart((Plot)this.plot);
        chart.setTitle(JAMS.i18n((String)"DYNIA"));
        XYLineAndShapeRenderer renderer = new XYLineAndShapeRenderer();
        renderer.setSeriesPaint(0, (Paint)Color.BLACK);
        renderer.setSeriesPaint(1, (Paint)Color.RED);
        renderer.setSeriesPaint(2, (Paint)Color.RED);
        renderer.setSeriesStroke(1, (Stroke)new BasicStroke(2.0f));
        renderer.setSeriesStroke(2, (Stroke)new BasicStroke(2.0f));
        renderer.setBaseShapesVisible(false);
        this.plot.setRenderer(0, (XYItemRenderer)renderer);
        this.plot.getDomainAxis().setLabel(JAMS.i18n((String)"TIME"));
        this.plot.setRangeAxisLocation(1, AxisLocation.BOTTOM_OR_RIGHT);
        this.winsize_box.setText("10");
        this.winsize_box.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DYNIA.this.redraw();
            }
        });
        JPanel text = new JPanel();
        text.setLayout(new FlowLayout(1));
        text.add(new JLabel(JAMS.i18n((String)"WINDOW_SIZE")));
        text.add(this.winsize_box);
        this.chartPanel = new PatchedChartPanel(chart, true);
        this.chartPanel.setLayout(new BorderLayout());
        this.chartPanel.add(text, "South");
        this.chartPanel.setMinimumDrawWidth(0);
        this.chartPanel.setMinimumDrawHeight(0);
        this.chartPanel.setMaximumDrawWidth(2000);
        this.chartPanel.setMaximumDrawHeight(2000);
        this.redraw();
    }

    private int getWinSize() {
        String input = this.winsize_box.getText();
        try {
            int number = Integer.parseInt(input);
            if (number >= 1) {
                this.window_size = number;
            }
        }
        catch (Exception e) {
            Logger.getLogger(DYNIA.class.getName()).log(Level.SEVERE, null, e);
        }
        return this.window_size;
    }

    @Override
    public void refresh() throws MCAT5Plot.NoDataException {
        if (!this.isRequestFulfilled()) {
            return;
        }
        ArrayList<DataSet>[] p = this.getData(new int[]{0, 1, 2});
        TimeSerieEnsemble ts = (TimeSerieEnsemble)p[0].get(0);
        SimpleEnsemble param = (SimpleEnsemble)p[1].get(0);
        Measurement obs = (Measurement)p[2].get(0);
        this.plot.setRangeAxis((ValueAxis)new NumberAxis(param.name));
        this.plot.setRangeAxis(1, (ValueAxis)new NumberAxis(obs.name));
        DateAxis axis = (DateAxis)this.plot.getDomainAxis();
        axis.setDateFormatOverride((DateFormat)new SimpleDateFormat("yyyy-MM-dd"));
        this.getWinSize();
        XYSeries dataset = new XYSeries((Comparable)((Object)obs.name));
        XYSeries dataset_lowBound = new XYSeries((Comparable)((Object)"Lower Bound"));
        XYSeries dataset_highBound = new XYSeries((Comparable)((Object)"Upper Bound"));
        int n = ts.getSize();
        int T = ts.getTimesteps();
        double maxParam = param.getMax();
        double minParam = param.getMin();
        double[][] pixel_map = new double[3][T * this.BOX_COUNT];
        for (int i = 0; i < T; ++i) {
            EfficiencyEnsemble eff = new EfficiencyEnsemble("E1(window)", n);
            eff.setPositiveBest(true);
            double[] cur_obs = new double[2 * this.window_size + 1];
            double[] cur_sim = new double[2 * this.window_size + 1];
            int counter = 0;
            for (int j = i - this.window_size; j <= i + this.window_size; ++j) {
                cur_obs[counter++] = j < 0 || j >= T ? 0.0 : obs.getValue(j);
            }
            for (int k = 0; k < n; ++k) {
                counter = 0;
                for (int j = i - this.window_size; j <= i + this.window_size; ++j) {
                    cur_sim[counter++] = j < 0 || j >= T ? 0.0 : ts.get(j, ts.getId(k));
                }
                eff.add(new Integer(ts.getId(k)), Efficiencies.CalculateE(cur_obs, cur_sim, 2));
            }
            EfficiencyEnsemble likelihood = eff.CalculateLikelihood();
            Integer[] sortedIds = likelihood.sort();
            int limit = (int)((double)n * 0.1);
            double[] boxes = new double[10];
            double[] internal_boxes = new double[100];
            int low = 0;
            int high = 0;
            for (int j = 0; j < limit; ++j) {
                double best = param.getValue(sortedIds[j]);
                int index = (int)((best - minParam) / (maxParam - minParam) * (double)boxes.length);
                if (index == boxes.length) {
                    index = boxes.length - 1;
                }
                int n2 = index;
                boxes[n2] = boxes[n2] + 1.0 / (double)limit;
                int index2 = (int)((best - minParam) / (maxParam - minParam) * (double)internal_boxes.length);
                if (index2 == internal_boxes.length) {
                    index2 = internal_boxes.length - 1;
                }
                int n3 = index2;
                internal_boxes[n3] = internal_boxes[n3] + 1.0 / (double)limit;
            }
            double high_sum = 0.0;
            for (double low_sum = 0.0; low_sum < 0.05; low_sum += internal_boxes[low++]) {
            }
            while (high_sum < 0.95) {
                high_sum += internal_boxes[high++];
            }
            dataset_lowBound.add((double)obs.getTime(i).getTime(), (double)low / (double)internal_boxes.length * (maxParam - minParam) + minParam);
            dataset_highBound.add((double)obs.getTime(i).getTime(), (double)high / (double)internal_boxes.length * (maxParam - minParam) + minParam);
            for (int j = 0; j < 10; ++j) {
                pixel_map[0][i * 10 + j] = obs.getTime(i).getTime();
                pixel_map[1][i * 10 + j] = minParam + (maxParam - minParam) * (double)j / 10.0;
                pixel_map[2][i * 10 + j] = 1.0 - boxes[j];
            }
        }
        XYBlockRenderer bg_renderer = new XYBlockRenderer();
        bg_renderer.setPaintScale((PaintScale)new GrayPaintScale(0.0, 1.0));
        bg_renderer.setBlockHeight((maxParam - minParam) / 10.0);
        if (obs.getTimeDomain().getTimeUnit() == 6) {
            bg_renderer.setBlockWidth(8.4E7);
        } else if (obs.getTimeDomain().getTimeUnit() == 2) {
            bg_renderer.setBlockWidth(2.604E9);
        } else if (obs.getTimeDomain().getTimeUnit() == 1) {
            bg_renderer.setBlockWidth(3.066E10);
        } else if (obs.getTimeDomain().getTimeUnit() == 11) {
            bg_renderer.setBlockWidth(3600000.0);
        }
        bg_renderer.setBlockAnchor(RectangleAnchor.BOTTOM_LEFT);
        DefaultXYZDataset xyz_dataset = new DefaultXYZDataset();
        xyz_dataset.addSeries((Comparable)Integer.valueOf(0), pixel_map);
        this.plot.setDataset(1, (XYDataset)xyz_dataset);
        this.plot.setRenderer(1, (XYItemRenderer)bg_renderer);
        bg_renderer.setSeriesVisibleInLegend(0, Boolean.valueOf(false));
        double obs_min = obs.getMin();
        double obs_max = obs.getMax();
        for (int i = 0; i < T; ++i) {
            dataset.add((double)obs.getTime(i).getTime(), (obs.getValue(i) - obs_min) / (obs_max - obs_min) * (maxParam - minParam) + minParam);
        }
        XYSeriesCollection collection = new XYSeriesCollection();
        collection.addSeries(dataset);
        collection.addSeries(dataset_lowBound);
        collection.addSeries(dataset_highBound);
        this.plot.setDataset(0, (XYDataset)collection);
        if (this.plot.getRangeAxis() != null) {
            this.plot.getRangeAxis(0).setRange(new Range(minParam, maxParam));
        }
        if (this.plot.getDomainAxis() != null) {
            this.plot.getDomainAxis().setRange(new Range((double)obs.getTime(0).getTime(), (double)obs.getTime(T - 1).getTime()));
        }
        if (this.plot.getRangeAxis(1) != null) {
            this.plot.getRangeAxis(1).setRange(new Range(obs_min, obs_max));
        }
    }

    @Override
    public JPanel getPanel() {
        return this.chartPanel;
    }
}

