/*
 * Decompiled with CFR 0.152.
 */
package optas.gui.MCAT5;

import jams.JAMS;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Paint;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import optas.data.Calculations;
import optas.data.DataSet;
import optas.data.Efficiency;
import optas.data.EfficiencyEnsemble;
import optas.data.Parameter;
import optas.data.SimpleEnsemble;
import optas.gui.MCAT5.MCAT5Plot;
import optas.tools.PatchedChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.StandardXYBarPainter;
import org.jfree.chart.renderer.xy.XYBarPainter;
import org.jfree.chart.renderer.xy.XYBarRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.data.Range;
import org.jfree.data.xy.XYBarDataset;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;

public class APosterioriPlot
extends MCAT5Plot {
    XYPlot plot = new XYPlot();
    PatchedChartPanel chartPanel = null;
    JPanel mainPanel;
    int boxCount = 20;
    JTextField groupCount = new JTextField(2);

    public APosterioriPlot() {
        this.addRequest(new MCAT5Plot.SimpleRequest(this, JAMS.i18n((String)"PARAMETER"), Parameter.class));
        this.addRequest(new MCAT5Plot.SimpleRequest(this, JAMS.i18n((String)"Efficiency"), Efficiency.class));
        this.init();
    }

    private void init() {
        JFreeChart chart = new JFreeChart((Plot)this.plot);
        chart.setTitle(JAMS.i18n((String)"A_POSTERIO_PARAMETER_DISTRIBUTION"));
        this.chartPanel = new PatchedChartPanel(chart, true);
        this.chartPanel.setMinimumDrawWidth(0);
        this.chartPanel.setMinimumDrawHeight(0);
        this.chartPanel.setMaximumDrawWidth(2000);
        this.chartPanel.setMaximumDrawHeight(2000);
        chart.getPlot().setBackgroundPaint((Paint)Color.white);
        JPanel sliderPanel = new JPanel(new FlowLayout(2));
        sliderPanel.setMaximumSize(new Dimension(250, 60));
        sliderPanel.setPreferredSize(new Dimension(250, 60));
        sliderPanel.setMinimumSize(new Dimension(250, 60));
        JSlider slider = new JSlider();
        slider.setMinimum(2);
        slider.setMaximum(30);
        slider.setValue(this.boxCount);
        this.groupCount.setText(Integer.toString(this.boxCount));
        this.groupCount.setEnabled(false);
        slider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                JSlider slider = (JSlider)e.getSource();
                APosterioriPlot.this.boxCount = slider.getValue();
                APosterioriPlot.this.groupCount.setText(Integer.toString(APosterioriPlot.this.boxCount));
                APosterioriPlot.this.redraw();
            }
        });
        sliderPanel.setBorder(BorderFactory.createTitledBorder(JAMS.i18n((String)"number_of_groups")));
        sliderPanel.add(slider);
        sliderPanel.add(this.groupCount);
        this.groupCount.setMaximumSize(new Dimension(60, 60));
        this.mainPanel = new JPanel();
        GroupLayout layout = new GroupLayout(this.mainPanel);
        this.mainPanel.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent((Component)((Object)this.chartPanel)).addComponent(sliderPanel));
        layout.setVerticalGroup(layout.createSequentialGroup().addComponent((Component)((Object)this.chartPanel)).addComponent(sliderPanel));
        this.redraw();
    }

    @Override
    public void refresh() throws MCAT5Plot.NoDataException {
        if (!this.isRequestFulfilled()) {
            return;
        }
        ArrayList<DataSet>[] p = this.getData(new int[]{0, 1});
        SimpleEnsemble p1 = (SimpleEnsemble)p[0].get(0);
        EfficiencyEnsemble p2 = (EfficiencyEnsemble)p[1].get(0);
        double[] boxes = Calculations.calcPostioriDistribution(p1, p2, this.boxCount);
        double[] bounds = Calculations.calcBounds(p1, p2, this.boxCount, 1.25);
        System.out.println("Recommend parameter range:[" + bounds[0] + "<" + bounds[1] + "]");
        this.plot.setDomainAxis((ValueAxis)new NumberAxis(p1.getName()));
        this.plot.setRangeAxis((ValueAxis)new NumberAxis(JAMS.i18n((String)"MEAN_OF_EFFICIENCY")));
        XYSeries dataset = new XYSeries((Comparable)((Object)JAMS.i18n((String)"MEAN_OF_EFFICIENCY")));
        double min = p1.getMin();
        double max = p1.getMax();
        for (int i = 0; i < boxes.length; ++i) {
            dataset.add(min + (max - min) / (double)(boxes.length - 1) * (double)i, boxes[i]);
        }
        this.plot.setDataset(0, (XYDataset)new XYBarDataset((XYDataset)new XYSeriesCollection(dataset), (max - min) / (double)this.boxCount));
        XYBarRenderer renderer = new XYBarRenderer(0.33 / (double)this.boxCount);
        renderer.setShadowVisible(false);
        renderer.setBarPainter((XYBarPainter)new StandardXYBarPainter());
        renderer.setSeriesPaint(0, (Paint)Color.DARK_GRAY);
        this.plot.setRenderer(0, (XYItemRenderer)renderer);
        if (null != this.plot.getRangeAxis()) {
            this.plot.getRangeAxis().setAutoRange(true);
        }
        if (null != this.plot.getDomainAxis()) {
            this.plot.getDomainAxis().setRange(new Range(min, max));
        }
    }

    @Override
    public JPanel getPanel() {
        return this.mainPanel;
    }
}

