/*
 * Decompiled with CFR 0.152.
 */
package optas.efficiencies;

import optas.efficiencies.EfficiencyCalculator;

public class VolumeError
extends EfficiencyCalculator {
    VolumeErrorType v;

    VolumeError(VolumeErrorType v) {
        this.v = v;
    }

    @Override
    public double calc(double[] m, double[] s) {
        double ve = 0.0;
        for (int i = 0; i < m.length; ++i) {
            ve += s[i] - m[i];
        }
        if (this.v == VolumeErrorType.Relative) {
            double sum = 0.0;
            for (int i = 0; i < m.length; ++i) {
                sum += m[i];
            }
            return ve / sum;
        }
        return ve;
    }

    @Override
    public double calcNormative(double[] t1, double[] t2) {
        return Math.abs(this.calc(t1, t2));
    }

    static enum VolumeErrorType {
        Absolute,
        Relative;

    }
}

