/*
 * Decompiled with CFR 0.152.
 */
package optas.efficiencies;

import optas.efficiencies.EfficiencyCalculator;

public class KGEprime
extends EfficiencyCalculator {
    double pow = 2.0;

    @Override
    public double calc(double[] m, double[] s) {
        int i;
        double r = 0.0;
        double beta = 0.0;
        double gamma = 0.0;
        double covs = 0.0;
        double covm = 0.0;
        double vars = 0.0;
        double varm = 0.0;
        double sum = 0.0;
        double avgs = 0.0;
        double avgm = 0.0;
        for (i = 0; i < m.length; ++i) {
            avgm += m[i];
            avgs += s[i];
        }
        avgm /= (double)m.length;
        avgs /= (double)s.length;
        for (i = 0; i < m.length; ++i) {
            sum += (m[i] - avgm) * (s[i] - avgs);
            varm += Math.pow(Math.abs(m[i] - avgm), this.pow);
            vars += Math.pow(Math.abs(s[i] - avgs), this.pow);
        }
        sum /= (double)m.length;
        double sigm = Math.sqrt(varm /= (double)m.length);
        double sigs = Math.sqrt(vars /= (double)s.length);
        covm = sigm / avgm;
        covs = sigs / avgs;
        gamma = covs / covm;
        beta = avgs / avgm;
        r = sum / (sigs * sigm);
        return 1.0 - Math.sqrt(Math.pow(gamma - 1.0, this.pow) + Math.pow(beta - 1.0, this.pow) + Math.pow(r - 1.0, this.pow));
    }

    @Override
    public double calcNormative(double[] t1, double[] t2) {
        return 1.0 - this.calc(t1, t2);
    }
}

