/*
 * Decompiled with CFR 0.152.
 */
package optas.data;

import jams.data.Attribute;
import jams.data.DefaultDataFactory;
import java.io.Serializable;
import java.util.ArrayList;
import optas.data.TimeFilter;
import optas.data.TimeFilterFactory;

public class TimeFilterCollection
implements Serializable {
    ArrayList<TimeFilter> timeFilters = new ArrayList();

    public void clear() {
        this.timeFilters.clear();
    }

    public int size() {
        return this.timeFilters.size();
    }

    public void add(TimeFilter tf) {
        this.timeFilters.add(tf);
    }

    public ArrayList<TimeFilter> get() {
        return this.timeFilters;
    }

    public TimeFilter get(int j) {
        return this.timeFilters.get(j);
    }

    public void set(ArrayList<TimeFilter> filters) {
        this.timeFilters = filters;
    }

    public TimeFilter combine() {
        return TimeFilterFactory.getCombinedTimeFilter(this.timeFilters.toArray(new TimeFilter[0]));
    }

    public void fromTimeIntervals(Attribute.TimeInterval[] intervals) {
        for (Attribute.TimeInterval I : intervals) {
            TimeFilter rtf = TimeFilterFactory.getRangeFilter(I);
            this.add(rtf);
        }
    }

    public void fromTimeIntervals(ArrayList<Attribute.TimeInterval> intervals) {
        for (Attribute.TimeInterval I : intervals) {
            TimeFilter rtf = TimeFilterFactory.getRangeFilter(I);
            this.add(rtf);
        }
    }

    public Attribute.TimeInterval[] toTimeIntervals(Attribute.TimeInterval modelTimeInterval) {
        Attribute.Calendar actStart = null;
        Attribute.Calendar actEnd = null;
        int timeUnitCount = 1;
        int timeUnit = 6;
        if (modelTimeInterval == null) {
            actStart = DefaultDataFactory.getDataFactory().createCalendar();
            actEnd = DefaultDataFactory.getDataFactory().createCalendar();
            actStart.set(10000, 1, 1, 1, 1, 1);
            actEnd.set(-2000, 1, 1, 1, 1, 1);
            for (TimeFilter f : this.timeFilters) {
                TimeFilter filter;
                if (f instanceof TimeFilterFactory.RangeTimeFilter) {
                    filter = (TimeFilterFactory.RangeTimeFilter)f;
                    if (((TimeFilterFactory.RangeTimeFilter)filter).getRange().getStart().getTimeInMillis() < actStart.getTimeInMillis()) {
                        actStart.setTimeInMillis(((TimeFilterFactory.RangeTimeFilter)filter).getRange().getStart().getTimeInMillis());
                    }
                    if (((TimeFilterFactory.RangeTimeFilter)filter).getRange().getEnd().getTimeInMillis() > actEnd.getTimeInMillis()) {
                        actEnd.setTimeInMillis(((TimeFilterFactory.RangeTimeFilter)filter).getRange().getEnd().getTimeInMillis());
                    }
                    if (((TimeFilterFactory.RangeTimeFilter)filter).getRange().getTimeUnit() != timeUnit) {
                        timeUnit = ((TimeFilterFactory.RangeTimeFilter)filter).getRange().getTimeUnit();
                    }
                    if (((TimeFilterFactory.RangeTimeFilter)filter).getRange().getTimeUnitCount() != timeUnitCount) {
                        timeUnitCount = ((TimeFilterFactory.RangeTimeFilter)filter).getRange().getTimeUnitCount();
                    }
                }
                if (f instanceof TimeFilterFactory.YearlyTimeFilter) {
                    int[] years;
                    filter = (TimeFilterFactory.YearlyTimeFilter)f;
                    for (int y : years = ((TimeFilterFactory.YearlyTimeFilter)filter).getYears()) {
                        if (actStart.get(1) > y) {
                            actStart.set(y, 0, 1, 1, 1, 1);
                        }
                        if (actEnd.get(1) >= y) continue;
                        actEnd.set(y, 11, 30, 23, 58, 58);
                    }
                }
                if (!TimeFilterFactory.EventFilter.class.isAssignableFrom(f.getClass())) continue;
                filter = (TimeFilterFactory.EventFilter)f;
                if (actStart.getTimeInMillis() > ((TimeFilterFactory.EventFilter)filter).getFirstDate().getTime()) {
                    actStart.setTime(((TimeFilterFactory.EventFilter)filter).getFirstDate());
                }
                if (actEnd.getTimeInMillis() >= ((TimeFilterFactory.EventFilter)filter).getLastDate().getTime()) continue;
                actEnd.setTime(((TimeFilterFactory.EventFilter)filter).getLastDate());
            }
        } else {
            actStart = modelTimeInterval.getStart();
            actEnd = modelTimeInterval.getEnd();
            timeUnitCount = modelTimeInterval.getTimeUnitCount();
            timeUnit = modelTimeInterval.getTimeUnit();
        }
        Attribute.Calendar actTime = actStart.clone();
        ArrayList<Attribute.TimeInterval> timeIntervals = new ArrayList<Attribute.TimeInterval>();
        TimeFilter combinedFilter = this.combine();
        boolean lastStepFiltered = false;
        Attribute.Calendar lastTimeStep = null;
        while (!actTime.after(actEnd)) {
            boolean actStepFiltered = combinedFilter.isFiltered(actTime.getTime());
            if (!(actStepFiltered && lastStepFiltered || !actStepFiltered || lastStepFiltered || lastTimeStep == null)) {
                Attribute.TimeInterval nextInterval = DefaultDataFactory.getDataFactory().createTimeInterval();
                nextInterval.setValue(actStart.toString() + " " + lastTimeStep.toString() + " " + timeUnit + " " + timeUnitCount);
                timeIntervals.add(nextInterval);
            }
            if (!actStepFiltered) {
                lastTimeStep = actTime;
            }
            if (!actStepFiltered && lastStepFiltered) {
                actStart = actTime.clone();
            }
            lastStepFiltered = actStepFiltered;
            actTime.add(timeUnit, timeUnitCount);
        }
        if (!lastStepFiltered && lastTimeStep != null) {
            Attribute.TimeInterval nextInterval = DefaultDataFactory.getDataFactory().createTimeInterval();
            nextInterval.setValue(actStart.toString() + " " + lastTimeStep.toString() + " " + timeUnit + " " + timeUnitCount);
            timeIntervals.add(nextInterval);
        }
        return timeIntervals.toArray(new Attribute.TimeInterval[0]);
    }
}

