/*
 * Decompiled with CFR 0.152.
 */
package optas.data;

import java.util.Arrays;
import optas.data.Ensemble;

public class SimpleEnsemble
extends Ensemble {
    protected double[] value;
    int currentIndex = 0;

    @Override
    public Ensemble clone() {
        SimpleEnsemble s = new SimpleEnsemble(this.name, this.size);
        for (int i = 0; i < this.size; ++i) {
            s.set(i, this.getId(i));
        }
        s.currentIndex = this.currentIndex;
        s.parent = this.parent;
        s.value = (double[])this.value.clone();
        return s;
    }

    public SimpleEnsemble(Ensemble e) {
        super(e);
        this.value = new double[e.size];
    }

    public SimpleEnsemble(SimpleEnsemble e) {
        super(e);
        this.value = e.value;
    }

    public SimpleEnsemble(String name, int size) {
        super(size);
        this.name = name;
        this.value = new double[size];
    }

    public void add(Integer id, double value) {
        this.set(this.currentIndex, id);
        this.value[this.currentIndex] = value;
        ++this.currentIndex;
    }

    public double getValue(Integer id) {
        return this.value[this.getIndex(id)];
    }

    public void setValue(Integer id, double value) {
        this.value[this.getIndex((Integer)id)] = value;
    }

    public double[] getValues() {
        return Arrays.copyOf(this.value, this.value.length);
    }

    protected void set(int index, Integer id, double value) {
        super.set(index, id);
        this.value[index] = value;
    }

    public int findArgMin() {
        double min = Double.POSITIVE_INFINITY;
        int index = -1;
        for (int i = 0; i < this.size; ++i) {
            if (!(this.value[i] < min)) continue;
            min = this.value[i];
            index = i;
        }
        if (index == -1 && this.value.length > 0) {
            return 0;
        }
        return this.getId(index);
    }

    public int findArgMax() {
        double max = Double.NEGATIVE_INFINITY;
        int index = -1;
        for (int i = 0; i < this.size; ++i) {
            if (!(this.value[i] > max)) continue;
            max = this.value[i];
            index = i;
        }
        if (index == -1 && this.value.length > 0) {
            return 0;
        }
        return this.getId(index);
    }

    public double getMin() {
        return this.getValue(this.findArgMin());
    }

    public double getMax() {
        return this.getValue(this.findArgMax());
    }

    public Integer[] sort() {
        return this.sort(true);
    }

    public Integer[] sort(boolean ascending) {
        Object[] list = new DataIdPair[this.size];
        for (int i = 0; i < list.length; ++i) {
            list[i] = new DataIdPair(this.value[i], this.getId(i));
        }
        Arrays.sort(list);
        Integer[] result = new Integer[this.size];
        if (ascending) {
            for (int i = 0; i < this.size; ++i) {
                result[i] = ((DataIdPair)list[i]).id;
            }
        } else {
            for (int i = 0; i < this.size; ++i) {
                result[i] = ((DataIdPair)list[this.size - i - 1]).id;
            }
        }
        return result;
    }

    @Override
    public void removeId(Integer id) {
        int index = this.getIndex(id);
        super.removeId(id);
        --this.currentIndex;
        this.value[index] = this.value[this.size];
    }

    public void calcPlus(double d) {
        int i = 0;
        while (i < this.size) {
            int n = i++;
            this.value[n] = this.value[n] + d;
        }
    }

    public void calcPlus(SimpleEnsemble d) {
        int i = 0;
        while (i < this.size) {
            int id = this.getId(i);
            int n = i++;
            this.value[n] = this.value[n] + d.getValue(id);
        }
    }

    public void calcMul(double d) {
        int i = 0;
        while (i < this.size) {
            int n = i++;
            this.value[n] = this.value[n] * d;
        }
    }

    public void calcAbs() {
        for (int i = 0; i < this.size; ++i) {
            this.value[i] = Math.abs(this.value[i]);
        }
    }

    class DataIdPair
    implements Comparable {
        double value;
        Integer id;

        public DataIdPair(double value, Integer id) {
            this.value = value;
            this.id = id;
        }

        public int compareTo(Object obj) {
            if (obj instanceof DataIdPair) {
                DataIdPair eip = (DataIdPair)obj;
                if (Double.isNaN(this.value)) {
                    return 1;
                }
                if (Double.isNaN(eip.value)) {
                    return -1;
                }
                if (this.value < eip.value) {
                    return -1;
                }
                if (this.value > eip.value) {
                    return 1;
                }
                return 0;
            }
            return 0;
        }
    }
}

