/*
 * Decompiled with CFR 0.152.
 */
package optas.data;

import jams.data.Attribute;
import jams.data.DefaultDataFactory;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.TreeSet;
import optas.data.Area;
import optas.data.DataSet;
import optas.data.Efficiency;
import optas.data.EfficiencyEnsemble;
import optas.data.Measurement;
import optas.data.Modelrun;
import optas.data.NegativeEfficiency;
import optas.data.Parameter;
import optas.data.PositiveEfficiency;
import optas.data.SimpleDataSet;
import optas.data.SimpleEnsemble;
import optas.data.SpatialDataSet;
import optas.data.TimeFilter;
import optas.data.TimeSerie;
import optas.data.TimeSerieEnsemble;
import optas.optimizer.management.SampleFactory;
import optas.sampler.RandomSampler;

public class DataCollection
extends DataSet
implements Serializable {
    private Map<Integer, Area> spatialDomain = null;
    private Map<Integer, DataSet> spatialDataSets = null;
    Attribute.TimeInterval timeDomain;
    TimeFilter timeFilter;
    HashMap<Integer, Boolean> idFilter = new HashMap();
    HashMap<Integer, Modelrun> set = new HashMap();
    HashMap<String, DataSet> globalDatasets = new HashMap();
    HashMap<String, Class> datasets;
    String samplerClass;
    boolean isBusy = false;
    transient Set<DatasetChangeListener> listener = new HashSet<DatasetChangeListener>();
    SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm");
    SimpleDateFormat sdf2 = new SimpleDateFormat("yyyyMMdd_HHmmss");
    HashMap<File, String> dirFileMap = new HashMap();
    HashMap<File, ArrayList<Integer>> idsSavedInDump = new HashMap();
    static final long serialVersionUID = 3078644694169015704L;

    public DataCollection() {
        this.datasets = new HashMap();
    }

    public void addChangeListener(DatasetChangeListener dcl) {
        if (this.listener == null) {
            this.listener = new HashSet<DatasetChangeListener>();
        }
        this.listener.add(dcl);
    }

    public void fireChangeEvent(DatasetChangeEvent dce) {
        if (this.isBusy) {
            return;
        }
        if (this.listener == null) {
            return;
        }
        for (DatasetChangeListener dcl : this.listener) {
            dcl.datasetChanged(dce);
        }
    }

    public void setSamplerClass(String typeId) {
        this.samplerClass = typeId;
    }

    public String getSamplerClass() {
        if (this.samplerClass == null) {
            return RandomSampler.class.toString();
        }
        return this.samplerClass;
    }

    private void filterID(Integer id) {
        this.idFilter.put(id, Boolean.TRUE);
    }

    public void removeDataset(String name) {
        this.datasets.remove(name);
        this.globalDatasets.remove(name);
        for (Integer i : this.set.keySet()) {
            this.set.get(i).removeDataset(name);
        }
    }

    public void renameDataset(String oldname, String newname) {
        Class clazz = this.datasets.get(oldname);
        this.datasets.remove(oldname);
        this.datasets.put(newname, clazz);
        DataSet globalDataset = this.globalDatasets.get(oldname);
        if (globalDataset != null) {
            this.globalDatasets.put(newname, globalDataset);
            this.globalDatasets.remove(oldname);
        }
        for (Modelrun r : this.set.values()) {
            DataSet modelrun_dataset;
            if (oldname.equals(r.name)) {
                r.name = newname;
            }
            if ((modelrun_dataset = r.getDataset(oldname)) == null) continue;
            modelrun_dataset.name = newname;
        }
    }

    public boolean filter(String e, double low, double high, boolean inverse) {
        if (!e.equals("ID")) {
            Integer[] ids;
            DataSet ensemble = this.getDataSet(e);
            SimpleEnsemble effEnsemble = null;
            if (ensemble == null) {
                return false;
            }
            if (!(ensemble instanceof SimpleEnsemble)) {
                return false;
            }
            effEnsemble = (SimpleEnsemble)ensemble;
            for (Integer id : ids = effEnsemble.getIds()) {
                double value = effEnsemble.getValue(id);
                if (!inverse) {
                    if (!(value < low) && !(value > high)) continue;
                    this.filterID(id);
                    continue;
                }
                if (!(value >= low) || !(value <= high)) continue;
                this.filterID(id);
            }
        } else {
            Integer[] ids;
            for (Integer id : ids = this.getModelrunIds()) {
                if (!inverse) {
                    if (!((double)id.intValue() < low) && !((double)id.intValue() > high)) continue;
                    this.filterID(id);
                    continue;
                }
                if (!((double)id.intValue() >= low) || !((double)id.intValue() <= high)) continue;
                this.filterID(id);
            }
        }
        return true;
    }

    public boolean filterPercentil(String e, double low, double high, boolean inverse) {
        DataSet ensemble = this.getDataSet(e);
        SimpleEnsemble effEnsemble = null;
        if (ensemble == null) {
            return false;
        }
        if (!(ensemble instanceof SimpleEnsemble)) {
            return false;
        }
        effEnsemble = (SimpleEnsemble)ensemble;
        Integer[] ids = effEnsemble.sort();
        if (!inverse) {
            int i = 0;
            while ((double)i < (double)ids.length * low) {
                this.filterID(ids[i]);
                ++i;
            }
            i = ids.length - 1;
            while ((double)i > high * (double)ids.length) {
                this.filterID(ids[i]);
                --i;
            }
        } else {
            for (int i = (int)((double)ids.length * low); i < (int)(high * (double)ids.length); ++i) {
                this.filterID(ids[i]);
            }
        }
        return true;
    }

    public void commitFilter() {
        for (Integer id : this.idFilter.keySet()) {
            this.removeModelRun(id);
        }
        this.idFilter.clear();
    }

    private void filterTimeDomain(TimeFilter f, String s) {
        if (Measurement.class.isAssignableFrom(this.getDatasetClass(s))) {
            Measurement m = (Measurement)this.getDataSet(s);
            if (this.timeFilter != null) {
                m.removeTimeFilter(this.timeFilter);
            }
            m.addTimeFilter(f);
        }
    }

    public void filterTimeDomain(TimeFilter f) {
        Set<String> set = this.getDatasets(Measurement.class);
        for (String s : set) {
            this.filterTimeDomain(f, s);
        }
        this.timeFilter = f;
    }

    public void clearTimeDomainFilter() {
        Set<String> set = this.getDatasets(Measurement.class);
        for (String s : set) {
            if (!Measurement.class.isAssignableFrom(this.getDatasetClass(s))) continue;
            Measurement m = (Measurement)this.getDataSet(s);
            if (this.timeFilter == null) continue;
            m.removeTimeFilter(this.timeFilter);
        }
        this.timeFilter = null;
    }

    public void clearIDFilter() {
        this.idFilter.clear();
    }

    public boolean unifyDataCollections(DataCollection dc) {
        this.isBusy = true;
        Integer[] srcIdList = dc.getModelrunIds();
        Integer[] dstIdList = this.getModelrunIds();
        HashSet<Integer> srcIdSet = new HashSet<Integer>();
        HashSet<Integer> dstIdSet = new HashSet<Integer>();
        HashSet<Integer> commonIds = new HashSet<Integer>();
        HashSet<Integer> newIds = new HashSet<Integer>();
        dstIdSet.addAll(Arrays.asList(dstIdList));
        srcIdSet.addAll(Arrays.asList(srcIdList));
        commonIds.addAll(srcIdSet);
        commonIds.retainAll(dstIdSet);
        newIds.addAll(srcIdSet);
        newIds.removeAll(commonIds);
        for (Integer id : commonIds) {
            Modelrun srcR = dc.set.get(id);
            Modelrun dstR = this.set.get(id);
            Iterator<DataSet> iter = srcR.getDatasets();
            while (iter.hasNext()) {
                DataSet d = iter.next();
                if (dstR.getDataset(d.name) != null) continue;
                try {
                    dstR.addDataSet(d);
                    if (this.datasets.containsKey(d.name)) continue;
                    this.datasets.put(d.name, d.getClass());
                }
                catch (DataSet.MismatchException me) {
                    me.printStackTrace();
                    return false;
                }
            }
        }
        for (Integer id : newIds) {
            Modelrun dstR = dc.set.get(id);
            try {
                this.addModelRun(dstR);
            }
            catch (DataSet.MismatchException me) {
                me.printStackTrace();
                return false;
            }
        }
        for (String datasetName : dc.globalDatasets.keySet()) {
            if (this.globalDatasets.containsKey(datasetName)) continue;
            DataSet d = dc.globalDatasets.get(datasetName);
            this.globalDatasets.put(datasetName, d);
            this.datasets.put(datasetName, d.getClass());
        }
        this.isBusy = false;
        this.fireChangeEvent(new DatasetChangeEvent(this, this));
        return true;
    }

    public void mergeDataCollections(DataCollection dc) {
        this.isBusy = true;
        Object[] ids = dc.getModelrunIds();
        int lastID = this.getSimulationCount();
        int offset = 0;
        Arrays.sort(ids);
        for (int i = 0; i < ids.length; ++i) {
            Modelrun r = dc.set.get(ids[i]);
            Integer newID = new Integer(i + lastID + offset);
            while (this.set.containsKey(newID)) {
                ++offset;
                Integer n = newID;
                Integer n2 = newID = Integer.valueOf(newID + 1);
            }
            r.changeId(newID);
            try {
                this.addModelRun(r);
                continue;
            }
            catch (DataSet.MismatchException me) {
                me.printStackTrace();
            }
        }
        for (String datasetName : dc.globalDatasets.keySet()) {
            if (this.globalDatasets.containsKey(datasetName)) continue;
            DataSet d = dc.globalDatasets.get(datasetName);
            this.globalDatasets.put(datasetName, d);
            this.datasets.put(datasetName, d.getClass());
        }
        this.isBusy = false;
        this.fireChangeEvent(new DatasetChangeEvent(this, this));
    }

    public Integer[] getModelrunIds() {
        TreeSet<Integer> filteredSet = new TreeSet<Integer>();
        filteredSet.addAll(this.set.keySet());
        filteredSet.removeAll(this.idFilter.keySet());
        return filteredSet.toArray(new Integer[filteredSet.size()]);
    }

    private void registerDatasets(Modelrun r) {
        Iterator<DataSet> iter = r.getDatasets();
        while (iter.hasNext()) {
            DataSet d = iter.next();
            if (this.datasets.containsKey(d.name)) continue;
            this.datasets.put(d.name, d.getClass());
        }
    }

    public Integer createArea(double latitude, double longitude, double elevation) {
        if (this.spatialDomain == null) {
            this.spatialDomain = new HashMap<Integer, Area>();
            Area area = new Area(latitude, longitude, elevation);
            Integer areaID2 = 0;
            this.spatialDomain.put(areaID2, area);
            return areaID2;
        }
        Integer areaID = -1;
        for (Integer id : this.spatialDomain.keySet()) {
            double currentLatitude = this.spatialDomain.get(id).getLatitude();
            double currentLongitude = this.spatialDomain.get(id).getLongitude();
            double currentElevation = this.spatialDomain.get(id).getElevation();
            if (currentLatitude != latitude || currentLongitude != longitude || currentElevation != elevation) continue;
            areaID = id;
        }
        if (areaID == -1) {
            for (Integer id : this.spatialDataSets.keySet()) {
                if (areaID >= id) continue;
                areaID = id;
            }
            Integer areaID2 = areaID;
            Integer n = areaID = Integer.valueOf(areaID + 1);
            Area area = new Area(latitude, longitude, elevation);
            this.spatialDataSets.put(areaID, area);
        }
        return areaID;
    }

    public void addSpatialDataSet(Integer areaID, DataSet set) {
        if (this.spatialDataSets == null) {
            this.spatialDataSets = new HashMap<Integer, DataSet>();
        }
        this.spatialDataSets.put(areaID, set);
    }

    public void addEnsemble(SimpleEnsemble ensemble) {
        this.addEnsemble(ensemble, null);
    }

    public void addEnsemble(SimpleEnsemble ensemble, Integer areaID) {
        this.isBusy = true;
        Integer[] srcIdList = ensemble.getIds();
        Integer[] dstIdList = this.getModelrunIds();
        HashSet<Integer> srcIdSet = new HashSet<Integer>();
        HashSet<Integer> dstIdSet = new HashSet<Integer>();
        HashSet<Integer> commonIds = new HashSet<Integer>();
        HashSet<Integer> newIds = new HashSet<Integer>();
        dstIdSet.addAll(Arrays.asList(dstIdList));
        srcIdSet.addAll(Arrays.asList(srcIdList));
        commonIds.addAll(srcIdSet);
        commonIds.retainAll(dstIdSet);
        newIds.addAll(srcIdSet);
        newIds.removeAll(commonIds);
        for (Integer id : commonIds) {
            double srcR = ensemble.getValue(id);
            Modelrun dstR = this.set.get(id);
            try {
                if (ensemble instanceof EfficiencyEnsemble) {
                    dstR.addDataSet(areaID, new Efficiency(new SimpleDataSet(srcR, ensemble.name, this), ((EfficiencyEnsemble)ensemble).isPostiveBest));
                    continue;
                }
                dstR.addDataSet(areaID, new SimpleDataSet(srcR, ensemble.name, this));
            }
            catch (DataSet.MismatchException me) {
                me.printStackTrace();
            }
        }
        for (Integer id : newIds) {
            Modelrun dstR = new Modelrun(id, null);
            double srcR = ensemble.getValue(id);
            try {
                if (ensemble instanceof EfficiencyEnsemble) {
                    dstR.addDataSet(areaID, new Efficiency(new SimpleDataSet(srcR, ensemble.name, this), ((EfficiencyEnsemble)ensemble).isPostiveBest));
                } else {
                    dstR.addDataSet(areaID, new SimpleDataSet(srcR, ensemble.name, this));
                }
                this.addModelRun(dstR);
            }
            catch (DataSet.MismatchException me) {
                me.printStackTrace();
            }
        }
        if (ensemble instanceof EfficiencyEnsemble) {
            if (((EfficiencyEnsemble)ensemble).isPostiveBest) {
                this.datasets.put(ensemble.name, PositiveEfficiency.class);
            } else {
                this.datasets.put(ensemble.name, NegativeEfficiency.class);
            }
        } else {
            this.datasets.put(ensemble.name, Parameter.class);
        }
        this.isBusy = false;
        this.fireChangeEvent(new DatasetChangeEvent(this, this));
    }

    public void addTimeSeriesEnsemble(TimeSerieEnsemble ensemble) throws DataSet.MismatchException {
        this.addTimeSeriesEnsemble(null, ensemble);
    }

    public void addTimeSeriesEnsemble(Integer areaID, TimeSerieEnsemble ensemble) throws DataSet.MismatchException {
        TimeSerie series;
        double[] values;
        this.isBusy = true;
        Integer[] ensembleIDArray = ensemble.getIds();
        Integer[] collectionIDArray = this.getModelrunIds();
        HashSet<Integer> ensembleIDSet = new HashSet<Integer>(Arrays.asList(ensembleIDArray));
        HashSet<Integer> collectionIDSet = new HashSet<Integer>(Arrays.asList(collectionIDArray));
        HashSet<Integer> existingIDSet = new HashSet<Integer>(collectionIDSet);
        existingIDSet.retainAll(ensembleIDSet);
        HashSet<Integer> newIDSet = new HashSet<Integer>(ensembleIDSet);
        newIDSet.removeAll(existingIDSet);
        for (Integer id : existingIDSet) {
            values = ensemble.getValue(id);
            series = new TimeSerie(values, ensemble.getTimeInterval(), ensemble.getName(), null);
            this.set.get(id).addDataSet(areaID, series);
            this.datasets.put(series.name, series.getClass());
        }
        for (Integer id : newIDSet) {
            values = ensemble.getValue(id);
            series = new TimeSerie(values, ensemble.getTimeInterval(), ensemble.getName(), null);
            Modelrun run = new Modelrun(id, series.getTimeDomain());
            run.addDataSet(areaID, series);
            this.addModelRun(run);
            this.datasets.put(series.name, series.getClass());
        }
        this.isBusy = false;
        this.fireChangeEvent(new DatasetChangeEvent(this, this));
    }

    public void setGlobalTimeDomain(Attribute.TimeInterval interval) {
        if (this.timeDomain == null) {
            this.timeDomain = DefaultDataFactory.getDataFactory().createTimeInterval();
        }
        this.timeDomain.setStart(interval.getStart().clone());
        this.timeDomain.setEnd(interval.getEnd().clone());
        this.timeDomain.setTimeUnit(interval.getTimeUnit());
        this.timeDomain.setTimeUnitCount(interval.getTimeUnitCount());
    }

    public void updateTimeDomain() {
        if (this.timeDomain == null) {
            this.timeDomain = DefaultDataFactory.getDataFactory().createTimeInterval();
        }
        this.timeDomain.getStart().set(1000, 1, 1, 1, 1, 1);
        this.timeDomain.getEnd().set(10000, 1, 1, 1, 1, 1);
        Set<String> datasets = this.getDatasets(TimeSerie.class);
        for (String dataset : datasets) {
            Attribute.TimeInterval t = ((TimeSerie)this.getDataSet(dataset)).getTimeDomain();
            if (t == null) continue;
            if (this.timeDomain.getStart().after(t.getStart())) {
                this.timeDomain.setStart(t.getStart().clone());
            }
            if (!this.timeDomain.getEnd().before(t.getEnd())) continue;
            this.timeDomain.setEnd(t.getEnd().clone());
        }
    }

    public void addTimeSerie(TimeSerie s) {
        this.globalDatasets.put(s.name, s);
        this.datasets.put(s.name, s.getClass());
        s.parent = this;
        this.fireChangeEvent(new DatasetChangeEvent(this, this));
    }

    public void addModelRun(Modelrun run) throws DataSet.MismatchException {
        this.addModelRun(null, run);
    }

    public void addModelRun(Integer areaID, Modelrun run) throws DataSet.MismatchException {
        Modelrun r;
        if (run.getTimeDomain() != null && this.timeDomain == null) {
            this.timeDomain = run.getTimeDomain();
        }
        if ((r = this.set.get(run.getId())) == null) {
            run.parent = this;
            this.set.put(run.getId(), run);
        } else {
            Iterator<DataSet> iter = run.getDatasets();
            while (iter.hasNext()) {
                r.addDataSet(iter.next());
            }
        }
        this.registerDatasets(run);
        this.fireChangeEvent(new DatasetChangeEvent(this, this));
    }

    public void removeModelRun(Integer id) {
        this.set.remove(id);
    }

    public int getSimulationCount() {
        return this.getModelrunIds().length;
    }

    public Set<String> getDatasets() {
        TreeSet<String> result = new TreeSet<String>();
        result.addAll(this.datasets.keySet());
        return result;
    }

    public Set<String> getDatasets(Class clazz) {
        return this.getDatasets(clazz, false);
    }

    public Set<String> getDatasets(Class clazz, boolean exactMatch) {
        TreeSet<String> sets = new TreeSet<String>();
        for (String setname : this.datasets.keySet()) {
            if (clazz.getName().contains("TimeSerie")) {
                if (!clazz.equals(this.getDatasetClass(setname))) continue;
                sets.add(setname);
                continue;
            }
            if ((exactMatch || !clazz.isAssignableFrom(this.getDatasetClass(setname))) && (!exactMatch || clazz != this.getDatasetClass(setname))) continue;
            sets.add(setname);
        }
        return sets;
    }

    public Class getDatasetClass(String name) {
        return this.datasets.get(name);
    }

    public DataSet getDataSet(String dataset) {
        if (this.getDatasetClass(dataset) == null) {
            return null;
        }
        if (this.getDatasetClass(dataset).equals(TimeSerie.class)) {
            return this.getTimeserieEnsemble(dataset);
        }
        if (this.getDatasetClass(dataset).equals(Measurement.class)) {
            return this.globalDatasets.get(dataset);
        }
        SimpleEnsemble e = this.getSimpleEnsemble(dataset);
        if (NegativeEfficiency.class.isAssignableFrom(this.getDatasetClass(dataset))) {
            return new EfficiencyEnsemble(e, false);
        }
        if (PositiveEfficiency.class.isAssignableFrom(this.getDatasetClass(dataset))) {
            return new EfficiencyEnsemble(e, true);
        }
        return e;
    }

    public DataSet getDataSetForAreaID(Integer id) {
        return this.spatialDataSets.get(id);
    }

    public SimpleEnsemble getSimpleEnsemble(String dataset) {
        double[] value = new double[this.set.keySet().size()];
        Integer[] id = new Integer[this.set.keySet().size()];
        int c = 0;
        TreeSet<Integer> sortedKeySet = new TreeSet<Integer>();
        sortedKeySet.addAll(Arrays.asList(this.getModelrunIds()));
        for (Integer s : sortedKeySet) {
            Modelrun r = this.set.get(s);
            DataSet d = r.getDataset(dataset);
            if (d == null || !(d instanceof SimpleDataSet)) continue;
            SimpleDataSet sd = (SimpleDataSet)d;
            value[c] = sd.getValue();
            id[c] = s;
            ++c;
        }
        SimpleEnsemble se = new SimpleEnsemble(dataset, c);
        for (int i = 0; i < c; ++i) {
            se.add(id[i], value[i]);
        }
        return se;
    }

    public TimeSerieEnsemble getTimeserieEnsemble(String dataset) {
        TimeSerie sd;
        DataSet d;
        Modelrun r;
        TreeSet<Integer> sortedKeySet = new TreeSet<Integer>();
        sortedKeySet.addAll(Arrays.asList(this.getModelrunIds()));
        double[][] value = new double[sortedKeySet.size()][];
        Integer[] id = new Integer[sortedKeySet.size()];
        int c = 0;
        Attribute.TimeInterval unifiedTimeInterval = DefaultDataFactory.getDataFactory().createTimeInterval();
        Attribute.Calendar c1 = DefaultDataFactory.getDataFactory().createCalendar();
        Attribute.Calendar c2 = DefaultDataFactory.getDataFactory().createCalendar();
        long startTime = Long.MIN_VALUE;
        long endTime = Long.MAX_VALUE;
        int timeUnit = 0;
        int timeUnitCount = 0;
        for (Integer s : sortedKeySet) {
            r = this.set.get(s);
            d = r.getDataset(dataset);
            if (d == null || !(d instanceof TimeSerie)) continue;
            sd = (TimeSerie)d;
            if (sd.getTimeDomain().getTimeUnit() != timeUnit || sd.getTimeDomain().getTimeUnitCount() != timeUnitCount) {
                timeUnit = sd.getTimeDomain().getTimeUnit();
                timeUnitCount = sd.getTimeDomain().getTimeUnitCount();
            }
            if (sd.getTimeDomain().getStart().getTimeInMillis() > startTime) {
                startTime = sd.getTimeDomain().getStart().getTimeInMillis();
            }
            if (sd.getTimeDomain().getStart().getTimeInMillis() >= endTime) continue;
            endTime = sd.getTimeDomain().getEnd().getTimeInMillis();
        }
        c1.setTimeInMillis(startTime);
        c2.setTimeInMillis(endTime);
        unifiedTimeInterval.setStart(c1);
        unifiedTimeInterval.setEnd(c2);
        unifiedTimeInterval.setTimeUnit(timeUnit);
        unifiedTimeInterval.setTimeUnitCount(timeUnitCount);
        for (Integer s : sortedKeySet) {
            r = this.set.get(s);
            d = r.getDataset(dataset);
            if (d == null || !(d instanceof TimeSerie)) continue;
            sd = (TimeSerie)d;
            value[c] = new double[(int)unifiedTimeInterval.getNumberOfTimesteps()];
            Attribute.Calendar time = unifiedTimeInterval.getStart().clone();
            long offset = sd.getTimeDomain().getStartOffset(unifiedTimeInterval);
            if (offset < 0L) {
                System.out.println("critical error, this should never happen");
                offset = 0L;
            }
            int i = 0;
            while (time.before(unifiedTimeInterval.getEnd())) {
                value[c][i] = sd.getValue(i);
                time.add(sd.getTimeDomain().getTimeUnit(), 1);
                ++i;
            }
            id[c] = s;
            ++c;
        }
        TimeSerieEnsemble se = new TimeSerieEnsemble(dataset, c, unifiedTimeInterval);
        for (int i = 0; i < c; ++i) {
            se.add(id[i], value[i]);
        }
        if (this.timeFilter != null) {
            se.addTimeFilter(this.timeFilter);
        }
        return se;
    }

    public Set<Class> getDataSetTypes() {
        HashSet<Class> types = new HashSet<Class>();
        for (String dataSetNames : this.datasets.keySet()) {
            Class c = this.datasets.get(dataSetNames);
            if (types.isEmpty()) {
                types.add(c);
                continue;
            }
            if (types.contains(c)) continue;
            types.add(c);
        }
        return types;
    }

    public Attribute.TimeInterval getTimeDomain() {
        if (this.timeDomain == null) {
            this.updateTimeDomain();
            if (this.timeDomain == null) {
                return null;
            }
        }
        Attribute.TimeInterval t = DefaultDataFactory.getDataFactory().createTimeInterval();
        t.setStart(this.timeDomain.getStart().clone());
        t.setEnd(this.timeDomain.getEnd().clone());
        return t;
    }

    public SpatialDataSet getSpatialDomainForModelRunID(Integer modelRunID) {
        return this.set.get(modelRunID).getSpatialDataSet();
    }

    public DataCollection clone() {
        return DataCollection.createFromByteArray(this.toByteArrayStream());
    }

    private static DataCollection createFromByteArray(byte[] array) {
        try {
            ByteArrayInputStream fis = new ByteArrayInputStream(array);
            ObjectInputStream ois = new ObjectInputStream(fis);
            DataCollection dc = (DataCollection)ois.readObject();
            ois.close();
            return dc;
        }
        catch (IOException ioe) {
            System.out.println(ioe.toString());
        }
        catch (ClassNotFoundException cnfe) {
            System.out.println(cnfe.toString());
        }
        return null;
    }

    private byte[] toByteArrayStream() {
        try {
            ByteArrayOutputStream fos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(fos);
            oos.writeObject(this);
            oos.close();
            fos.close();
            return fos.toByteArray();
        }
        catch (IOException ioe) {
            System.out.println(ioe.toString());
            return null;
        }
    }

    public static DataCollection createFromFile(File file) {
        try {
            FileInputStream fis = new FileInputStream(file);
            ObjectInputStream ois = new ObjectInputStream(fis);
            DataCollection dc = (DataCollection)ois.readObject();
            ois.close();
            fis.close();
            return dc;
        }
        catch (IOException ioe) {
            System.out.println(ioe.toString());
        }
        catch (ClassNotFoundException cnfe) {
            System.out.println(cnfe.toString());
        }
        return null;
    }

    public void save(File file) {
        try {
            FileOutputStream fos = new FileOutputStream(file);
            ObjectOutputStream oos = new ObjectOutputStream(fos);
            oos.writeObject(this);
            oos.close();
            fos.close();
        }
        catch (IOException ioe) {
            System.out.println(ioe);
        }
    }

    private void dumpTSEnsemble(File file, ArrayList<TimeSerieEnsemble> list, boolean createNewFile) throws IOException {
        if (list.isEmpty()) {
            return;
        }
        this.sdf.setTimeZone(TimeZone.getTimeZone("GMT"));
        TimeSerieEnsemble[] array = list.toArray(new TimeSerieEnsemble[list.size()]);
        int N = array[0].size;
        int T = array[0].getTimesteps();
        BufferedWriter write = new BufferedWriter(new FileWriter(file, !createNewFile));
        if (createNewFile) {
            write.write("@context\n");
            write.write("jams.components.core.TemporalContext\tdump\t" + T + "\n");
            write.write("@ancestors\n");
            write.write("optas.optimizer.generic\tsampler\t" + N + "\n");
            write.write("@filters\n");
            write.write("@attributes\n");
            String attrString = "ID";
            String types = "JAMSInteger";
            for (TimeSerieEnsemble s : list) {
                attrString = attrString + "\t" + s.getName();
                types = types + "\tJAMSDouble";
            }
            write.write(attrString + "\n");
            write.write("@types\n");
            write.write(types + "\n");
            write.write("@data\n");
        }
        Object[] ids = array[0].getIds();
        Arrays.sort(ids);
        for (int i = 0; i < N; ++i) {
            int id = (Integer)ids[i];
            write.write("sampler\t" + id + "\n");
            write.write("@start\n");
            for (int t = 0; t < T; ++t) {
                Date date = array[0].getDate(t);
                String entry = this.sdf.format(date);
                for (int j = 0; j < array.length; ++j) {
                    entry = entry + "\t" + array[j].get(t, id);
                }
                write.write(entry + "\n");
            }
            write.write("@end\n");
        }
        write.close();
    }

    public void constructSample(SampleFactory f) {
        ArrayList<SimpleEnsemble> simpleEnsembles = new ArrayList<SimpleEnsemble>();
        ArrayList<EfficiencyEnsemble> effEnsembles = new ArrayList<EfficiencyEnsemble>();
        for (String s : this.getDatasets()) {
            DataSet d = this.getDataSet(s);
            if (d instanceof EfficiencyEnsemble) {
                effEnsembles.add((EfficiencyEnsemble)d);
                continue;
            }
            if (!(d instanceof SimpleEnsemble)) continue;
            simpleEnsembles.add((SimpleEnsemble)d);
        }
        int n = simpleEnsembles.size();
        int m = effEnsembles.size();
        if (n == 0 || m == 0) {
            return;
        }
        int N = this.getSimulationCount();
        for (int i = 0; i < N; ++i) {
            int j;
            int id = ((SimpleEnsemble)simpleEnsembles.get(0)).getId(i);
            double[] x = new double[n];
            double[] y = new double[m];
            for (j = 0; j < n; ++j) {
                x[j] = ((SimpleEnsemble)simpleEnsembles.get(j)).getValue(id);
            }
            for (j = 0; j < m; ++j) {
                y[j] = ((EfficiencyEnsemble)effEnsembles.get((int)j)).isPostiveBest ? -((EfficiencyEnsemble)effEnsembles.get(j)).getValue(id) : ((EfficiencyEnsemble)effEnsembles.get(j)).getValue(id);
            }
            f.getSample(x, y);
        }
    }

    private void dumpSimpleEnsemble(File file, ArrayList<SimpleEnsemble> list, boolean createNewFile, boolean append) throws IOException {
        if (list.isEmpty()) {
            return;
        }
        int N = list.get(0).getSize();
        BufferedWriter write = new BufferedWriter(new FileWriter(file, !createNewFile));
        if (createNewFile) {
            write.write("@context\n");
            write.write("dumping.context\tdump\t" + N + "\n");
            write.write("@ancestors\n");
            write.write("@filters\n");
            write.write("@attributes\n");
            String attrString = "ID";
            String types = "JAMSInteger";
            for (SimpleEnsemble s : list) {
                attrString = attrString + "\t" + s.getName();
                types = types + "\tJAMSDouble";
            }
            write.write(attrString + "\n");
            write.write("@types\n");
            write.write(types + "\n");
            write.write("@data\n");
            write.write("@start\n");
        }
        SimpleEnsemble[] array = list.toArray(new SimpleEnsemble[list.size()]);
        Object[] ids = array[0].getIds();
        Arrays.sort(ids);
        for (int i = 0; i < N; ++i) {
            int id = (Integer)ids[i];
            String entry = "" + id;
            for (int j = 0; j < array.length; ++j) {
                entry = entry + "\t" + array[j].getValue(id);
            }
            write.write(entry + "\n");
        }
        if (createNewFile && !append) {
            write.write("@end");
        }
        write.close();
    }

    public void dump(File directory, boolean append) {
        ArrayList<SimpleEnsemble> simpleEnsembles = new ArrayList<SimpleEnsemble>();
        ArrayList<TimeSerieEnsemble> tsEnsembles = new ArrayList<TimeSerieEnsemble>();
        ArrayList<Measurement> msEnsembles = new ArrayList<Measurement>();
        boolean createNewFile = !append || this.dirFileMap.get(directory) == null;
        ArrayList<Object> savedIds = null;
        String dateString = this.sdf2.format(new Date());
        if (append && !createNewFile) {
            dateString = this.dirFileMap.get(directory);
            savedIds = this.idsSavedInDump.get(directory);
            this.clearIDFilter();
            for (Integer n : savedIds) {
                this.filterID(n);
            }
        } else if (append) {
            this.dirFileMap.put(directory, dateString);
            savedIds = new ArrayList();
            this.idsSavedInDump.put(directory, savedIds);
        }
        for (String string : this.getDatasets()) {
            DataSet d = this.getDataSet(string);
            if (d instanceof SimpleEnsemble) {
                simpleEnsembles.add((SimpleEnsemble)d);
                continue;
            }
            if (d instanceof TimeSerieEnsemble) {
                tsEnsembles.add((TimeSerieEnsemble)d);
                continue;
            }
            if (!(d instanceof Measurement)) continue;
            msEnsembles.add((Measurement)d);
        }
        try {
            this.dumpSimpleEnsemble(new File(directory.getAbsolutePath() + "/scalar_" + dateString + ".dat"), simpleEnsembles, createNewFile, append);
            this.dumpTSEnsemble(new File(directory.getAbsolutePath() + "/timeseries_" + dateString + ".dat"), tsEnsembles, createNewFile);
        }
        catch (IOException ioe) {
            System.err.println(ioe);
            ioe.printStackTrace();
        }
        if (savedIds != null) {
            savedIds.addAll(Arrays.asList(this.getModelrunIds()));
            this.clearIDFilter();
        }
    }

    public static void main(String[] args) {
    }

    public class StringLexOrder
    implements Comparator {
        public int compare(Object o1, Object o2) {
            String s1 = (String)o1;
            String s2 = (String)o2;
            if (s1.length() < s2.length()) {
                return -1;
            }
            if (s1.length() > s2.length()) {
                return 1;
            }
            return s1.compareTo(s2);
        }
    }

    public static interface DatasetChangeListener
    extends Serializable {
        public void datasetChanged(DatasetChangeEvent var1);
    }

    public class DatasetChangeEvent
    implements Serializable {
        Serializable source;
        DataSet target;

        public DatasetChangeEvent(Serializable src, DataSet target) {
            this.source = src;
            this.target = target;
        }
    }
}

